/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.TunnelBuildReplyMessage;
import net.i2p.router.tunnel.BuildMessageGenerator;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildReplyHandler {
    public static int[] decrypt(I2PAppContext ctx, TunnelBuildReplyMessage reply, TunnelCreatorConfig cfg, List<Integer> recordOrder) {
        Log log = ctx.logManager().getLog(BuildReplyHandler.class);
        if (reply.getRecordCount() != recordOrder.size()) {
            log.error("Corrupted build reply, expected " + recordOrder.size() + " records, got " + reply.getRecordCount());
            return null;
        }
        int[] rv = new int[reply.getRecordCount()];
        for (int i = 0; i < rv.length; ++i) {
            int hop = recordOrder.get(i);
            if (BuildMessageGenerator.isBlank(cfg, hop)) {
                if (log.shouldLog(10)) {
                    log.debug(reply.getUniqueId() + ": no need to decrypt record " + i + "/" + hop + ", as its out of range: " + cfg);
                }
                rv[i] = 0;
                continue;
            }
            int ok = BuildReplyHandler.decryptRecord(ctx, reply, cfg, i, hop);
            if (ok == -1) {
                if (log.shouldLog(30)) {
                    log.warn(reply.getUniqueId() + ": decrypt record " + i + "/" + hop + " was not ok: " + cfg);
                }
                return null;
            }
            if (log.shouldLog(10)) {
                log.debug(reply.getUniqueId() + ": decrypt record " + i + "/" + hop + " was ok: " + ok + " for " + cfg);
            }
            rv[i] = ok;
        }
        return rv;
    }

    private static int decryptRecord(I2PAppContext ctx, TunnelBuildReplyMessage reply, TunnelCreatorConfig cfg, int recordNum, int hop) {
        Log log = ctx.logManager().getLog(BuildReplyHandler.class);
        if (BuildMessageGenerator.isBlank(cfg, hop)) {
            if (log.shouldLog(10)) {
                log.debug(reply.getUniqueId() + ": Record " + recordNum + "/" + hop + " is fake, so consider it valid...");
            }
            return 0;
        }
        ByteArray rec = reply.getRecord(recordNum);
        int off = rec.getOffset();
        int start = cfg.getLength() - 1;
        if (cfg.isInbound()) {
            --start;
        }
        for (int j = start; j >= hop; --j) {
            HopConfig hopConfig = cfg.getConfig(j);
            SessionKey replyKey = hopConfig.getReplyKey();
            byte[] replyIV = hopConfig.getReplyIV().getData();
            int replyIVOff = hopConfig.getReplyIV().getOffset();
            if (log.shouldLog(10)) {
                log.debug(reply.getUniqueId() + ": Decrypting record " + recordNum + "/" + hop + "/" + j + " with replyKey " + replyKey.toBase64() + "/" + Base64.encode((byte[])replyIV, (int)replyIVOff, (int)16) + ": " + cfg);
            }
            if (log.shouldLog(10)) {
                log.debug(reply.getUniqueId() + ": before decrypt(" + off + "-" + (off + rec.getValid()) + "): " + Base64.encode((byte[])rec.getData(), (int)off, (int)rec.getValid()));
            }
            if (log.shouldLog(10)) {
                log.debug(reply.getUniqueId() + ": Full reply rec: offset=" + off + ", sz=" + rec.getData().length + "/" + rec.getValid() + ", data=" + Base64.encode((byte[])rec.getData(), (int)off, (int)528));
            }
            ctx.aes().decrypt(rec.getData(), off, rec.getData(), off, replyKey, replyIV, replyIVOff, 528);
            if (!log.shouldLog(10)) continue;
            log.debug(reply.getUniqueId() + ": after decrypt: " + Base64.encode((byte[])rec.getData(), (int)off, (int)rec.getValid()));
        }
        Hash h = ctx.sha().calculateHash(rec.getData(), off + 32, 496);
        if (!DataHelper.eq((byte[])h.getData(), (int)0, (byte[])rec.getData(), (int)off, (int)32)) {
            if (log.shouldLog(10)) {
                log.debug(reply.getUniqueId() + ": Failed verification on " + recordNum + "/" + hop + ": " + h.toBase64() + " calculated, " + Base64.encode((byte[])rec.getData(), (int)off, (int)32) + " expected\n" + "Record: " + Base64.encode((byte[])rec.getData(), (int)(off + 32), (int)496));
            }
            return -1;
        }
        int rv = (int)DataHelper.fromLong((byte[])rec.getData(), (int)(off + 528 - 1), (int)1);
        if (log.shouldLog(10)) {
            log.debug(reply.getUniqueId() + ": Verified: " + rv + " for record " + recordNum + "/" + hop);
        }
        return rv;
    }
}

