/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.udp.DummyThrottle;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.InboundMessageFragments;
import net.i2p.router.transport.udp.IntroductionManager;
import net.i2p.router.transport.udp.MessageQueue;
import net.i2p.router.transport.udp.OutboundMessageFragments;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.OutboundRefiller;
import net.i2p.router.transport.udp.PacketHandler;
import net.i2p.router.transport.udp.PacketPusher;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerTestManager;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.TimedWeightedPriorityMessageQueue;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPEndpoint;
import net.i2p.router.transport.udp.UDPFlooder;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;
import net.i2p.util.Translate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPTransport
extends TransportImpl
implements TimedWeightedPriorityMessageQueue.FailedListener {
    private final Log _log;
    private UDPEndpoint _endpoint;
    private final Map<Hash, PeerState> _peersByIdent;
    private final Map<RemoteHostId, PeerState> _peersByRemoteHost;
    private PacketHandler _handler;
    private EstablishmentManager _establisher;
    private final MessageQueue _outboundMessages;
    private OutboundMessageFragments _fragments;
    private final OutboundMessageFragments.ActiveThrottle _activeThrottle;
    private OutboundRefiller _refiller;
    private PacketPusher _pusher;
    private InboundMessageFragments _inboundFragments;
    private UDPFlooder _flooder;
    private PeerTestManager _testManager;
    private final IntroductionManager _introManager;
    private ExpirePeerEvent _expireEvent;
    private PeerTestEvent _testEvent;
    private short _reachabilityStatus;
    private long _reachabilityStatusLastUpdated;
    private long _introducersSelectedOn;
    private long _lastInboundReceivedOn;
    private boolean _needsRebuild;
    private RouterAddress _externalAddress;
    private int _externalListenPort;
    private InetAddress _externalListenHost;
    private SessionKey _introKey;
    private final Set<RemoteHostId> _dropList;
    private int _expireTimeout;
    private Hash _lastFrom;
    private byte[] _lastOurIP;
    private int _lastOurPort;
    private static final int DROPLIST_PERIOD = 600000;
    private static final int MAX_DROPLIST_SIZE = 256;
    public static final String STYLE = "SSU";
    public static final String PROP_INTERNAL_PORT = "i2np.udp.internalPort";
    public static final int DEFAULT_INTERNAL_PORT = 8887;
    private static final int MIN_EXTERNAL_PORT = 1024;
    public static final String PROP_EXTERNAL_HOST = "i2np.udp.host";
    public static final String PROP_EXTERNAL_PORT = "i2np.udp.port";
    public static final String PROP_PREFER_UDP = "i2np.udp.preferred";
    private static final String DEFAULT_PREFER_UDP = "false";
    public static final String PROP_FIXED_PORT = "i2np.udp.fixedPort";
    private static final String DEFAULT_FIXED_PORT = "true";
    public static final String PROP_SOURCES = "i2np.udp.addressSources";
    public static final String DEFAULT_SOURCES = "local,upnp,ssu";
    public static final String PROP_IP = "i2np.lastIP";
    public static final String PROP_IP_CHANGE = "i2np.lastIPChange";
    public static final String PROP_LAPTOP_MODE = "i2np.laptopMode";
    public static final String PROP_FORCE_INTRODUCERS = "i2np.udp.forceIntroducers";
    public static final String PROP_ALLOW_DIRECT = "i2np.udp.allowDirect";
    public static final String PROP_BIND_INTERFACE = "i2np.udp.bindInterface";
    public static final int PUBLIC_RELAY_COUNT = 3;
    private static final boolean USE_PRIORITY = false;
    private static final int[] PRIORITY_LIMITS = new int[]{100, 200, 300, 400, 500, 1000};
    private static final int[] PRIORITY_WEIGHT = new int[]{1, 1, 1, 1, 1, 2};
    private static final boolean SHOULD_FLOOD_PEERS = false;
    private static final int MAX_CONSECUTIVE_FAILED = 5;
    public static final int DEFAULT_COST = 5;
    private static final int TEST_FREQUENCY = 780000;
    public static final long[] RATES = new long[]{600000L};
    private static final int[] BID_VALUES = new int[]{15, 20, 50, 65, 80, 95, 100, 115, 999999};
    private static final int FAST_PREFERRED_BID = 0;
    private static final int SLOW_PREFERRED_BID = 1;
    private static final int FAST_BID = 2;
    private static final int SLOW_BID = 3;
    private static final int SLOWEST_BID = 4;
    private static final int SLOWEST_COST_BID = 5;
    private static final int NEAR_CAPACITY_BID = 6;
    private static final int NEAR_CAPACITY_COST_BID = 7;
    private static final int TRANSIENT_FAIL_BID = 8;
    private final TransportBid[] _cachedBid;
    private static final int ALLOW_IP_CHANGE_INTERVAL = 120000;
    private static final int MIN_PEERS = 3;
    private static final int MIN_INTRODUCER_POOL = 5;
    public static final int EXPIRE_TIMEOUT = 1800000;
    private static final int MAX_IDLE_TIME = 1800000;
    private static final int MIN_EXPIRE_TIMEOUT = 600000;
    private static final int DROP_INACTIVITY_TIME = 60000;
    private static UDPTransport __instance;
    private static final int FLAG_ALPHA = 0;
    private static final int FLAG_IDLE_IN = 1;
    private static final int FLAG_IDLE_OUT = 2;
    private static final int FLAG_RATE_IN = 3;
    private static final int FLAG_RATE_OUT = 4;
    private static final int FLAG_SKEW = 5;
    private static final int FLAG_CWND = 6;
    private static final int FLAG_SSTHRESH = 7;
    private static final int FLAG_RTT = 8;
    private static final int FLAG_DEV = 9;
    private static final int FLAG_RTO = 10;
    private static final int FLAG_MTU = 11;
    private static final int FLAG_SEND = 12;
    private static final int FLAG_RECV = 13;
    private static final int FLAG_RESEND = 14;
    private static final int FLAG_DUP = 15;
    private static final int FLAG_UPTIME = 16;
    private static final DecimalFormat _fmt;
    private static final DecimalFormat _pctFmt;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";
    private static final long STATUS_GRACE_PERIOD = 300000L;
    private long _statusLastCalled;
    private short _lastStatus = (short)4;
    private static final String PROP_REACHABILITY_STATUS_OVERRIDE = "i2np.udp.status";
    private static final String PROP_SHOULD_TEST = "i2np.udp.shouldTest";

    public UDPTransport(RouterContext ctx) {
        super(ctx);
        this._context = ctx;
        this._log = ctx.logManager().getLog(UDPTransport.class);
        this._peersByIdent = new ConcurrentHashMap<Hash, PeerState>(128);
        this._peersByRemoteHost = new ConcurrentHashMap<RemoteHostId, PeerState>(128);
        this._dropList = new ConcurrentHashSet(2);
        this._endpoint = null;
        DummyThrottle mq = new DummyThrottle();
        this._outboundMessages = null;
        this._activeThrottle = mq;
        this._cachedBid = new SharedBid[BID_VALUES.length];
        for (int i = 0; i < BID_VALUES.length; ++i) {
            this._cachedBid[i] = new SharedBid(BID_VALUES[i]);
        }
        this._fragments = new OutboundMessageFragments(this._context, this, this._activeThrottle);
        this._inboundFragments = new InboundMessageFragments(this._context, this._fragments, this);
        this._expireTimeout = 1800000;
        this._expireEvent = new ExpirePeerEvent();
        this._testEvent = new PeerTestEvent();
        this._reachabilityStatus = (short)4;
        this._introManager = new IntroductionManager(this._context, this);
        this._introducersSelectedOn = -1L;
        this._lastInboundReceivedOn = -1L;
        this._needsRebuild = true;
        this._context.statManager().createRateStat("udp.alreadyConnected", "What is the lifetime of a reestablished session", "udp", RATES);
        this._context.statManager().createRateStat("udp.droppedPeer", "How long ago did we receive from a dropped peer (duration == session lifetime", "udp", RATES);
        this._context.statManager().createRateStat("udp.droppedPeerInactive", "How long ago did we receive from a dropped peer (duration == session lifetime)", "udp", RATES);
        this._context.statManager().createRateStat("udp.statusOK", "How many times the peer test returned OK", "udp", RATES);
        this._context.statManager().createRateStat("udp.statusDifferent", "How many times the peer test returned different IP/ports", "udp", RATES);
        this._context.statManager().createRateStat("udp.statusReject", "How many times the peer test returned reject unsolicited", "udp", RATES);
        this._context.statManager().createRateStat("udp.statusUnknown", "How many times the peer test returned an unknown result", "udp", RATES);
        this._context.statManager().createRateStat("udp.addressTestInsteadOfUpdate", "How many times we fire off a peer test of ourselves instead of adjusting our own reachable address?", "udp", RATES);
        this._context.statManager().createRateStat("udp.addressUpdated", "How many times we adjust our own reachable IP address", "udp", RATES);
        this._context.statManager().createRateStat("udp.proactiveReestablish", "How long a session was idle for when we proactively reestablished it", "udp", RATES);
        this._context.statManager().createRateStat("udp.dropPeerDroplist", "How many peers currently have their packets dropped outright when a new peer is added to the list?", "udp", RATES);
        this._context.statManager().createRateStat("udp.dropPeerConsecutiveFailures", "How many consecutive failed sends to a peer did we attempt before giving up and reestablishing a new session (lifetime is inactivity perood)", "udp", RATES);
        __instance = this;
    }

    public void startup() {
        int newPort;
        if (this._fragments != null) {
            this._fragments.shutdown();
        }
        if (this._pusher != null) {
            this._pusher.shutdown();
        }
        if (this._handler != null) {
            this._handler.shutdown();
        }
        if (this._endpoint != null) {
            this._endpoint.shutdown();
        }
        if (this._establisher != null) {
            this._establisher.shutdown();
        }
        if (this._refiller != null) {
            this._refiller.shutdown();
        }
        if (this._inboundFragments != null) {
            this._inboundFragments.shutdown();
        }
        if (this._flooder != null) {
            this._flooder.shutdown();
        }
        this._introManager.reset();
        this._introKey = new SessionKey(new byte[32]);
        System.arraycopy(this._context.routerHash().getData(), 0, this._introKey.getData(), 0, 32);
        this.rebuildExternalAddress();
        String bindTo = this._context.getProperty(PROP_BIND_INTERFACE);
        InetAddress bindToAddr = null;
        if (bindTo != null) {
            try {
                bindToAddr = InetAddress.getByName(bindTo);
            }
            catch (UnknownHostException uhe) {
                this._log.log(50, "Invalid SSU bind interface specified [" + bindTo + "]", (Throwable)uhe);
                this.setReachabilityStatus((short)3);
                return;
            }
        }
        int oldIPort = this._context.getProperty(PROP_INTERNAL_PORT, -1);
        int oldEPort = this._context.getProperty(PROP_EXTERNAL_PORT, -1);
        int port = this._externalListenPort <= 0 ? (oldIPort > 0 ? oldIPort : oldEPort) : this._externalListenPort;
        if (this._log.shouldLog(20)) {
            this._log.info("Binding to the port: " + port);
        }
        if (this._endpoint == null) {
            this._endpoint = new UDPEndpoint(this._context, this, port, bindToAddr);
        } else {
            this._endpoint.setListenPort(port);
        }
        if (this._establisher == null) {
            this._establisher = new EstablishmentManager(this._context, this);
        }
        if (this._testManager == null) {
            this._testManager = new PeerTestManager(this._context, this);
        }
        if (this._handler == null) {
            this._handler = new PacketHandler(this._context, this, this._endpoint, this._establisher, this._inboundFragments, this._testManager, this._introManager);
        }
        this._endpoint.startup();
        this._externalListenPort = newPort = this._endpoint.getListenPort();
        if (newPort <= 0) {
            this._log.log(50, "Unable to open UDP port");
            this.setReachabilityStatus((short)3);
            return;
        }
        if (newPort != port || newPort != oldIPort || newPort != oldEPort) {
            this._context.router().setConfigSetting(PROP_INTERNAL_PORT, newPort + "");
            this._context.router().setConfigSetting(PROP_EXTERNAL_PORT, newPort + "");
            this._context.router().saveConfig();
        }
        this._establisher.startup();
        this._handler.startup();
        this._fragments.startup();
        this._inboundFragments.startup();
        this._pusher = new PacketPusher(this._context, this._fragments, this._endpoint.getSender());
        this._pusher.startup();
        this._expireEvent.setIsAlive(true);
        this._testEvent.setIsAlive(true);
        SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this._testEvent, 10000L);
    }

    public void shutdown() {
        if (this._endpoint != null) {
            this._endpoint.shutdown();
        }
        if (this._flooder != null) {
            this._flooder.shutdown();
        }
        if (this._refiller != null) {
            this._refiller.shutdown();
        }
        if (this._handler != null) {
            this._handler.shutdown();
        }
        if (this._fragments != null) {
            this._fragments.shutdown();
        }
        if (this._pusher != null) {
            this._pusher.shutdown();
        }
        if (this._establisher != null) {
            this._establisher.shutdown();
        }
        if (this._inboundFragments != null) {
            this._inboundFragments.shutdown();
        }
        this._expireEvent.setIsAlive(false);
        this._testEvent.setIsAlive(false);
    }

    public SessionKey getIntroKey() {
        return this._introKey;
    }

    public int getLocalPort() {
        return this._externalListenPort;
    }

    public InetAddress getLocalAddress() {
        return this._externalListenHost;
    }

    public int getExternalPort() {
        return this._externalListenPort;
    }

    @Override
    public int getRequestedPort() {
        if (this._externalListenPort > 0) {
            return this._externalListenPort;
        }
        return this._context.getProperty(PROP_INTERNAL_PORT, -1);
    }

    void inboundConnectionReceived() {
        this._lastInboundReceivedOn = System.currentTimeMillis();
    }

    @Override
    public void externalAddressReceived(String source, byte[] ip, int port) {
        String s = RemoteHostId.toString(ip);
        if (this._log.shouldLog(30)) {
            this._log.warn("Received address: " + s + " port: " + port + " from: " + source);
        }
        if (this.explicitAddressSpecified()) {
            return;
        }
        String sources = this._context.getProperty(PROP_SOURCES, DEFAULT_SOURCES);
        if (!sources.contains(source)) {
            return;
        }
        boolean changed = this.changeAddress(ip, port);
        if (changed && source.equals("local")) {
            this.setReachabilityStatus((short)0);
        }
    }

    @Override
    public void forwardPortStatus(int port, boolean success, String reason) {
        if (this._log.shouldLog(30)) {
            if (success) {
                this._log.warn("UPnP has opened the SSU port: " + port);
            } else {
                this._log.warn("UPnP has failed to open the SSU port: " + port + " reason: " + reason);
            }
        }
        if (success && this._externalListenHost != null) {
            this.setReachabilityStatus((short)0);
        }
    }

    void externalAddressReceived(Hash from, byte[] ourIP, int ourPort) {
        boolean inboundRecent;
        boolean isValid = this.isValid(ourIP) && (ourPort >= 1024 || ourPort == this._externalListenPort || this._externalListenPort <= 0);
        boolean explicitSpecified = this.explicitAddressSpecified();
        boolean bl = inboundRecent = this._lastInboundReceivedOn + 120000L > System.currentTimeMillis();
        if (this._log.shouldLog(20)) {
            this._log.info("External address received: " + RemoteHostId.toString(ourIP) + ":" + ourPort + " from " + from.toBase64() + ", isValid? " + isValid + ", explicitSpecified? " + explicitSpecified + ", receivedInboundRecent? " + inboundRecent + " status " + this._reachabilityStatus);
        }
        if (explicitSpecified) {
            return;
        }
        String sources = this._context.getProperty(PROP_SOURCES, DEFAULT_SOURCES);
        if (!sources.contains("ssu")) {
            return;
        }
        if (!isValid) {
            if (this._log.shouldLog(40)) {
                this._log.error("The router " + from.toBase64() + " told us we have an invalid IP - " + RemoteHostId.toString(ourIP) + " port " + ourPort + ".  Lets throw tomatoes at them");
            }
            this.markUnreachable(from);
            return;
        }
        if (inboundRecent && this._externalListenPort > 0 && this._externalListenHost != null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Ignoring IP address suggestion, since we have received an inbound con recently");
            }
        } else if (from.equals((Object)this._lastFrom) || !UDPTransport.eq(this._lastOurIP, this._lastOurPort, ourIP, ourPort)) {
            this._lastFrom = from;
            this._lastOurIP = ourIP;
            this._lastOurPort = ourPort;
            if (this._log.shouldLog(30)) {
                this._log.warn("The router " + from.toBase64() + " told us we have a new IP - " + RemoteHostId.toString(ourIP) + " port " + ourPort + ".  Wait until somebody else tells us the same thing.");
            }
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn(from.toBase64() + " and " + this._lastFrom.toBase64() + " agree we have a new IP - " + RemoteHostId.toString(ourIP) + " port " + ourPort + ".  Changing address.");
            }
            this._lastFrom = from;
            this._lastOurIP = ourIP;
            this._lastOurPort = ourPort;
            this.changeAddress(ourIP, ourPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean changeAddress(byte[] ourIP, int ourPort) {
        boolean fixedPort = this.getIsPortFixed();
        boolean updated = false;
        boolean fireTest = false;
        if (this._log.shouldLog(30)) {
            this._log.warn("Change address? status = " + this._reachabilityStatus + " diff = " + (this._context.clock().now() - this._reachabilityStatusLastUpdated) + " old = " + this._externalListenHost + ':' + this._externalListenPort + " new = " + RemoteHostId.toString(ourIP) + ':' + ourPort);
        }
        UDPTransport uDPTransport = this;
        synchronized (uDPTransport) {
            block21: {
                if (this._externalListenHost == null || !UDPTransport.eq(this._externalListenHost.getAddress(), this._externalListenPort, ourIP, ourPort)) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Trying to change our external address...");
                    }
                    try {
                        this._externalListenHost = InetAddress.getByAddress(ourIP);
                        if (ourPort >= 1024 && !fixedPort) {
                            this._externalListenPort = ourPort;
                        }
                        if (this._externalListenPort > 0) {
                            this.rebuildExternalAddress();
                            this.replaceAddress(this._externalAddress);
                            updated = true;
                        }
                        break block21;
                    }
                    catch (UnknownHostException uhe) {
                        this._externalListenHost = null;
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Error trying to change our external address", (Throwable)uhe);
                        }
                        break block21;
                    }
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("Same address as the current one");
                }
            }
        }
        if (fireTest) {
            this._context.statManager().addRateData("udp.addressTestInsteadOfUpdate", 1L, 0L);
        } else if (updated) {
            this._context.statManager().addRateData("udp.addressUpdated", 1L, 0L);
            if (!fixedPort) {
                this._context.router().setConfigSetting(PROP_EXTERNAL_PORT, ourPort + "");
            }
            this._context.commSystem().queueLookup(ourIP);
            String oldIP = this._context.getProperty(PROP_IP);
            if (!this._externalListenHost.getHostAddress().equals(oldIP)) {
                long lastChanged = 0L;
                long now = this._context.clock().now();
                String lcs = this._context.getProperty(PROP_IP_CHANGE);
                if (lcs != null) {
                    try {
                        lastChanged = Long.parseLong(lcs);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                this._context.router().setConfigSetting(PROP_IP, this._externalListenHost.getHostAddress());
                this._context.router().setConfigSetting(PROP_IP_CHANGE, "" + now);
                this._context.router().saveConfig();
                if (oldIP != null && System.getProperty("wrapper.version") != null && Boolean.valueOf(this._context.getProperty(PROP_LAPTOP_MODE)).booleanValue() && now - lastChanged > 600000L && this._context.router().getUptime() < 600000L) {
                    this._log.log(50, "IP changed, restarting with a new identity and port");
                    this._context.router().killKeys();
                    this._context.router().shutdown(4);
                }
            }
            this._context.router().rebuildRouterInfo();
        }
        this._testEvent.forceRun();
        SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this._testEvent, 5000L);
        return updated;
    }

    private static final boolean eq(byte[] laddr, int lport, byte[] raddr, int rport) {
        return rport == lport && DataHelper.eq((byte[])laddr, (byte[])raddr);
    }

    public final boolean isValid(byte[] addr) {
        if (addr == null) {
            return false;
        }
        if (addr.length < 4) {
            return false;
        }
        if (UDPTransport.isPubliclyRoutable(addr)) {
            return true;
        }
        return Boolean.valueOf(this._context.getProperty("i2np.udp.allowLocal"));
    }

    private boolean getIsPortFixed() {
        return DEFAULT_FIXED_PORT.equals(this._context.getProperty(PROP_FIXED_PORT, DEFAULT_FIXED_PORT));
    }

    PeerState getPeerState(RemoteHostId hostInfo) {
        return this._peersByRemoteHost.get(hostInfo);
    }

    public PeerState getPeerState(Hash remotePeer) {
        return this._peersByIdent.get(remotePeer);
    }

    public PeerState getPeerState(long relayTag) {
        return this._introManager.get(relayTag);
    }

    boolean addRemotePeerState(PeerState peer) {
        if (this._log.shouldLog(20)) {
            this._log.info("Add remote peer state: " + peer);
        }
        Hash remotePeer = peer.getRemotePeer();
        long oldEstablishedOn = -1L;
        PeerState oldPeer = null;
        if (remotePeer != null && (oldPeer = this._peersByIdent.put(remotePeer, peer)) != null && oldPeer != peer) {
            peer.loadFrom(oldPeer);
            oldEstablishedOn = oldPeer.getKeyEstablishedTime();
        }
        if (oldPeer != null) {
            oldPeer.dropOutbound();
            this._introManager.remove(oldPeer);
            this._expireEvent.remove(oldPeer);
        }
        oldPeer = null;
        RemoteHostId remoteId = peer.getRemoteHostId();
        if (remoteId == null) {
            return false;
        }
        oldPeer = this._peersByRemoteHost.put(remoteId, peer);
        if (oldPeer != null && oldPeer != peer) {
            peer.loadFrom(oldPeer);
            oldEstablishedOn = oldPeer.getKeyEstablishedTime();
        }
        if (oldPeer != null) {
            oldPeer.dropOutbound();
            this._introManager.remove(oldPeer);
            this._expireEvent.remove(oldPeer);
        }
        if (oldPeer != null && this._log.shouldLog(30)) {
            this._log.warn("Peer already connected: old=" + oldPeer + " new=" + peer, (Throwable)new Exception("dup"));
        }
        this._activeThrottle.unchoke(peer.getRemotePeer());
        this.markReachable(peer.getRemotePeer(), peer.isInbound());
        this._expireEvent.add(peer);
        this._introManager.add(peer);
        if (oldEstablishedOn > 0L) {
            this._context.statManager().addRateData("udp.alreadyConnected", oldEstablishedOn, 0L);
        }
        if (this.needsRebuild()) {
            this.rebuildExternalAddress();
        }
        if (this.getReachabilityStatus() != 0) {
            this._testEvent.forceRun();
            SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this._testEvent, 0L);
        }
        return true;
    }

    @Override
    public void messageReceived(I2NPMessage inMsg, RouterIdentity remoteIdent, Hash remoteIdentHash, long msToReceive, int bytesReceived) {
        if (inMsg.getType() == 1) {
            DatabaseStoreMessage dsm = (DatabaseStoreMessage)inMsg;
            if (dsm.getRouterInfo() != null && dsm.getRouterInfo().getNetworkId() != 2) {
                Hash peerHash = dsm.getRouterInfo().getIdentity().calculateHash();
                PeerState peer = this.getPeerState(peerHash);
                if (peer != null) {
                    RemoteHostId remote = peer.getRemoteHostId();
                    this._dropList.add(remote);
                    this._context.statManager().addRateData("udp.dropPeerDroplist", 1L, 0L);
                    SimpleScheduler.getInstance().addEvent((SimpleTimer.TimedEvent)new RemoveDropList(remote), 600000L);
                }
                this.markUnreachable(peerHash);
                this._context.shitlist().shitlistRouter(peerHash, "Part of the wrong network, version = " + dsm.getRouterInfo().getOption("router.version"));
                this.dropPeer(peerHash, false, "wrong network");
                if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping the peer " + peerHash.toBase64() + " because they are in the wrong net: " + dsm.getRouterInfo());
                }
                return;
            }
            if (dsm.getRouterInfo() != null) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Received an RI from the same net");
                }
            } else if (this._log.shouldLog(20)) {
                this._log.info("Received a leaseSet: " + dsm);
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Received another message: " + inMsg.getClass().getName());
        }
        PeerState peer = this.getPeerState(remoteIdentHash);
        super.messageReceived(inMsg, remoteIdent, remoteIdentHash, msToReceive, bytesReceived);
        if (peer != null) {
            peer.expireInboundMessages();
        }
    }

    boolean isInDropList(RemoteHostId peer) {
        return this._dropList.contains(peer);
    }

    void dropPeer(Hash peer, boolean shouldShitlist, String why) {
        PeerState state = this.getPeerState(peer);
        if (state != null) {
            this.dropPeer(state, shouldShitlist, why);
        }
    }

    void dropPeer(PeerState peer, boolean shouldShitlist, String why) {
        RemoteHostId remoteId;
        if (this._log.shouldLog(30)) {
            long now = this._context.clock().now();
            StringBuilder buf = new StringBuilder(4096);
            long timeSinceSend = now - peer.getLastSendTime();
            long timeSinceRecv = now - peer.getLastReceiveTime();
            long timeSinceAck = now - peer.getLastACKSend();
            long timeSinceSendOK = now - peer.getLastSendFullyTime();
            int consec = peer.getConsecutiveFailedSends();
            buf.append("Dropping remote peer: ").append(peer.toString()).append(" shitlist? ").append(shouldShitlist);
            buf.append(" lifetime: ").append(now - peer.getKeyEstablishedTime());
            buf.append(" time since send/fully/recv/ack: ").append(timeSinceSend).append(" / ");
            buf.append(timeSinceSendOK).append(" / ");
            buf.append(timeSinceRecv).append(" / ").append(timeSinceAck);
            buf.append(" consec failures: ").append(consec);
            if (why != null) {
                buf.append(" cause: ").append(why);
            }
            this._log.warn(buf.toString(), (Throwable)new Exception("Dropped by"));
        }
        peer.dropOutbound();
        peer.expireInboundMessages();
        this._introManager.remove(peer);
        this._fragments.dropPeer(peer);
        PeerState altByIdent = null;
        PeerState altByHost = null;
        if (peer.getRemotePeer() != null) {
            this.dropPeerCapacities(peer);
            if (shouldShitlist) {
                this.markUnreachable(peer.getRemotePeer());
            }
            long now = this._context.clock().now();
            this._context.statManager().addRateData("udp.droppedPeer", now - peer.getLastReceiveTime(), now - peer.getKeyEstablishedTime());
            altByIdent = this._peersByIdent.remove(peer.getRemotePeer());
        }
        if ((remoteId = peer.getRemoteHostId()) != null) {
            altByHost = this._peersByRemoteHost.remove(remoteId);
        }
        this._activeThrottle.unchoke(peer.getRemotePeer());
        this._expireEvent.remove(peer);
        if (this.needsRebuild()) {
            this.rebuildExternalAddress();
        }
        if (altByIdent != null && peer != altByIdent) {
            this.dropPeer(altByIdent, shouldShitlist, "recurse");
        }
        if (altByHost != null && peer != altByHost) {
            this.dropPeer(altByHost, shouldShitlist, "recurse");
        }
    }

    private boolean needsRebuild() {
        RouterAddress addr;
        UDPAddress ua;
        boolean rv;
        if (this._needsRebuild) {
            return true;
        }
        if (this._context.router().isHidden()) {
            return false;
        }
        if (this.introducersRequired()) {
            RouterAddress addr2 = this._externalAddress;
            UDPAddress ua2 = new UDPAddress(addr2);
            int valid = 0;
            Hash peerHash = new Hash();
            for (int i = 0; i < ua2.getIntroducerCount(); ++i) {
                peerHash.setData(ua2.getIntroducerKey(i));
                PeerState peer = this.getPeerState(peerHash);
                if (peer == null) continue;
                ++valid;
            }
            if (valid >= 3) {
                if (this._introducersSelectedOn < this._context.clock().now() - 600000L) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Our introducers are valid, but havent changed in a while, so lets rechoose");
                    }
                    return true;
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("Our introducers are valid and haven't changed in a while");
                }
                return false;
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Need more introducers (have " + valid + " need " + 3 + ')');
            }
            return true;
        }
        boolean bl = rv = this._externalListenHost == null || this._externalListenPort <= 0;
        if (!rv && (ua = new UDPAddress(addr = this._externalAddress)).getIntroducerCount() > 0) {
            rv = true;
        }
        if (this._log.shouldLog(20)) {
            if (rv) {
                this._log.info("Need to initialize our direct SSU info (" + this._externalListenHost + ":" + this._externalListenPort + ")");
            } else {
                addr = this._externalAddress;
                ua = new UDPAddress(addr);
                if (ua.getPort() <= 0 || ua.getHost() == null) {
                    this._log.info("Our direct SSU info is initialized, but not used in our address yet");
                    rv = true;
                } else {
                    this._log.info("Our direct SSU info is initialized");
                }
            }
        }
        return rv;
    }

    private void dropPeerCapacities(PeerState peer) {
    }

    int send(UDPPacket packet) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending packet " + packet);
        }
        return this._endpoint.send(packet);
    }

    @Override
    public TransportBid bid(RouterInfo toAddress, long dataSize) {
        if (dataSize > 32768L) {
            return null;
        }
        Hash to = toAddress.getIdentity().calculateHash();
        PeerState peer = this.getPeerState(to);
        if (peer != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("bidding on a message to an established peer: " + peer);
            }
            if (this.preferUDP()) {
                return this._cachedBid[0];
            }
            return this._cachedBid[2];
        }
        if (this._reachabilityStatus == 3) {
            this.markUnreachable(to);
            return null;
        }
        RouterAddress addr = toAddress.getTargetAddress(STYLE);
        if (addr == null) {
            this.markUnreachable(to);
            return null;
        }
        UDPAddress ua = new UDPAddress(addr);
        if (ua == null) {
            this.markUnreachable(to);
            return null;
        }
        if (ua.getIntroducerCount() <= 0) {
            InetAddress ia = ua.getHostAddress();
            if (ua.getPort() <= 0 || ia == null || !UDPTransport.isPubliclyRoutable(ia.getAddress())) {
                this.markUnreachable(to);
                return null;
            }
        }
        if (!this.allowConnection()) {
            return this._cachedBid[8];
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("bidding on a message to an unestablished peer: " + to.toBase64());
        }
        int count = this._peersByIdent.size();
        if (this.alwaysPreferUDP() || count < 3 || this.introducersRequired() && this._introManager.introducerCount() < 5) {
            return this._cachedBid[1];
        }
        if (this.preferUDP()) {
            return this._cachedBid[3];
        }
        if (this.haveCapacity()) {
            if (addr.getCost() > 5) {
                return this._cachedBid[5];
            }
            return this._cachedBid[4];
        }
        if (addr.getCost() > 5) {
            return this._cachedBid[7];
        }
        return this._cachedBid[6];
    }

    private boolean preferUDP() {
        String pref = this._context.getProperty(PROP_PREFER_UDP, DEFAULT_PREFER_UDP);
        return pref != null && !DEFAULT_PREFER_UDP.equals(pref);
    }

    private boolean alwaysPreferUDP() {
        String pref = this._context.getProperty(PROP_PREFER_UDP, DEFAULT_PREFER_UDP);
        return pref != null && "always".equals(pref);
    }

    @Override
    public String getStyle() {
        return STYLE;
    }

    @Override
    public void send(OutNetMessage msg) {
        if (msg == null) {
            return;
        }
        if (msg.getTarget() == null) {
            return;
        }
        if (msg.getTarget().getIdentity() == null) {
            return;
        }
        msg.timestamp("sending on UDP transport");
        Hash to = msg.getTarget().getIdentity().calculateHash();
        PeerState peer = this.getPeerState(to);
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending to " + (to != null ? to.toBase64() : ""));
        }
        if (peer != null) {
            long lastSend = peer.getLastSendFullyTime();
            long lastRecv = peer.getLastReceiveTime();
            long now = this._context.clock().now();
            int inboundActive = peer.expireInboundMessages();
            if (lastSend > 0L && lastRecv > 0L && now - lastSend > 1800000L && now - lastRecv > 1800000L && peer.getConsecutiveFailedSends() > 0 && inboundActive <= 0) {
                this.dropPeer(peer, false, "proactive reconnection");
                msg.timestamp("peer is really idle, dropping con and reestablishing");
                if (this._log.shouldLog(10)) {
                    this._log.debug("Proactive reestablish to " + to.toBase64());
                }
                this._establisher.establish(msg);
                this._context.statManager().addRateData("udp.proactiveReestablish", now - lastSend, now - peer.getKeyEstablishedTime());
                return;
            }
            msg.timestamp("enqueueing for an already established peer");
            if (this._log.shouldLog(10)) {
                this._log.debug("Add to fragments for " + to.toBase64());
            }
            this._fragments.add(msg);
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Establish new connection to " + to.toBase64());
            }
            msg.timestamp("establishing a new connection");
            this._establisher.establish(msg);
        }
    }

    void send(I2NPMessage msg, PeerState peer) {
        OutboundMessageState state;
        boolean ok;
        if (this._log.shouldLog(10)) {
            this._log.debug("Injecting a data message to a new peer: " + peer);
        }
        if (ok = (state = new OutboundMessageState(this._context)).initialize(msg, peer)) {
            this._fragments.add(state);
        }
    }

    @Override
    protected void outboundMessageReady() {
        throw new UnsupportedOperationException("Not used for UDP");
    }

    @Override
    public RouterAddress startListening() {
        this.startup();
        return this._externalAddress;
    }

    @Override
    public void stopListening() {
        this.shutdown();
        this._externalAddress = null;
        this.replaceAddress(null);
    }

    private boolean explicitAddressSpecified() {
        String h = this._context.getProperty(PROP_EXTERNAL_HOST);
        return h != null && h.length() > 0;
    }

    @Override
    public RouterAddress updateAddress() {
        this.rebuildExternalAddress(false);
        return this.getCurrentAddress();
    }

    void rebuildExternalAddress() {
        this.rebuildExternalAddress(true);
    }

    void rebuildExternalAddress(boolean allowRebuildRouterInfo) {
        this._externalListenPort = this._context.getProperty(PROP_EXTERNAL_PORT, -1);
        if (this.explicitAddressSpecified()) {
            try {
                String host = this._context.getProperty(PROP_EXTERNAL_HOST);
                this._externalListenHost = InetAddress.getByName(host);
            }
            catch (UnknownHostException uhe) {
                this._externalListenHost = null;
            }
        }
        if (this._context.router().isHidden()) {
            return;
        }
        Properties options = new Properties();
        boolean directIncluded = false;
        if (this.allowDirectUDP() && this._externalListenPort > 0 && this._externalListenHost != null && this.isValid(this._externalListenHost.getAddress())) {
            options.setProperty("port", String.valueOf(this._externalListenPort));
            options.setProperty("host", this._externalListenHost.getHostAddress());
            directIncluded = true;
        }
        boolean introducersRequired = this.introducersRequired();
        boolean introducersIncluded = false;
        if (introducersRequired || !directIncluded) {
            int found = this._introManager.pickInbound(options, 3);
            if (found > 0) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Picked peers: " + found);
                }
                this._introducersSelectedOn = this._context.clock().now();
                introducersIncluded = true;
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Need introducers but we don't know any");
            }
        }
        if (introducersRequired) {
            options.setProperty("caps", "B");
        } else {
            options.setProperty("caps", "BC");
        }
        if (directIncluded || introducersIncluded) {
            if (this._introKey != null) {
                options.setProperty("key", this._introKey.toBase64());
            }
            RouterAddress addr = new RouterAddress();
            if (!this.haveCapacity()) {
                addr.setCost(6);
            } else {
                addr.setCost(5);
            }
            addr.setExpiration(null);
            addr.setTransportStyle(STYLE);
            addr.setOptions(options);
            boolean wantsRebuild = false;
            if (this._externalAddress == null || !this._externalAddress.equals((Object)addr)) {
                wantsRebuild = true;
            }
            RouterAddress oldAddress = this._externalAddress;
            this._externalAddress = addr;
            if (this._log.shouldLog(20)) {
                this._log.info("Address rebuilt: " + addr);
            }
            this.replaceAddress(addr, oldAddress);
            if (allowRebuildRouterInfo && wantsRebuild) {
                this._context.router().rebuildRouterInfo();
            }
            this._needsRebuild = false;
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn("Wanted to rebuild my SSU address, but couldn't specify either the direct or indirect info (needs introducers? " + introducersRequired + ")", (Throwable)new Exception("source"));
            }
            this._needsRebuild = true;
        }
    }

    @Override
    protected void replaceAddress(RouterAddress address) {
        super.replaceAddress(address);
        this._context.commSystem().notifyReplaceAddress(address);
    }

    protected void replaceAddress(RouterAddress address, RouterAddress oldAddress) {
        this.replaceAddress(address);
        if (oldAddress != null) {
            UDPAddress old = new UDPAddress(oldAddress);
            InetAddress oldHost = old.getHostAddress();
            UDPAddress newAddr = new UDPAddress(address);
            InetAddress newHost = newAddr.getHostAddress();
            if (old.getPort() > 0 && oldHost != null && this.isValid(oldHost.getAddress()) && newAddr.getPort() > 0 && newHost != null && this.isValid(newHost.getAddress()) && (old.getPort() != newAddr.getPort() || !oldHost.equals(newHost)) && DEFAULT_FIXED_PORT.equalsIgnoreCase(this._context.getProperty("router.dynamicKeys", DEFAULT_PREFER_UDP))) {
                if (this._log.shouldLog(40)) {
                    this._log.error("SSU address updated. new address: " + newAddr.getHostAddress() + ":" + newAddr.getPort() + ", old address: " + old.getHostAddress() + ":" + old.getPort());
                }
                this._context.router().shutdown(4);
            }
        }
    }

    public boolean introducersRequired() {
        short status = this.getReachabilityStatus();
        switch (status) {
            case 1: 
            case 2: {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Require introducers, because our status is " + status);
                }
                return true;
            }
        }
        if (!this.allowDirectUDP()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Require introducers, because we do not allow direct UDP connections");
            }
            return true;
        }
        return false;
    }

    private boolean allowDirectUDP() {
        String allowDirect = this._context.getProperty(PROP_ALLOW_DIRECT);
        return allowDirect == null || Boolean.valueOf(allowDirect) != false;
    }

    String getPacketHandlerStatus() {
        PacketHandler handler = this._handler;
        if (handler != null) {
            return handler.getHandlerStatus();
        }
        return "";
    }

    public void failed(OutboundMessageState msg) {
        this.failed(msg, true);
    }

    void failed(OutboundMessageState msg, boolean allowPeerFailure) {
        if (msg == null) {
            return;
        }
        int consecutive = 0;
        OutNetMessage m = msg.getMessage();
        if (allowPeerFailure && msg.getPeer() != null && (msg.getMaxSends() >= 10 || msg.isExpired())) {
            consecutive = msg.getPeer().incrementConsecutiveFailedSends();
            if (this._log.shouldLog(20)) {
                this._log.info("Consecutive failure #" + consecutive + " on " + msg.toString() + " to " + msg.getPeer());
            }
            if (this._context.clock().now() - msg.getPeer().getLastSendFullyTime() > 60000L && consecutive >= 5) {
                this._context.statManager().addRateData("udp.dropPeerConsecutiveFailures", (long)consecutive, msg.getPeer().getInactivityTime());
                this.dropPeer(msg.getPeer(), false, "too many failures");
            }
        }
        this.noteSend(msg, false);
        if (m != null) {
            super.afterSend(m, false);
        }
    }

    private void noteSend(OutboundMessageState msg, boolean successful) {
        if (!this._context.messageHistory().getDoLog()) {
            return;
        }
        int pushCount = msg.getPushCount();
        int sends = msg.getMaxSends();
        boolean expired = msg.isExpired();
        OutNetMessage m = msg.getMessage();
        PeerState p = msg.getPeer();
        StringBuilder buf = new StringBuilder(64);
        buf.append(" lifetime: ").append(msg.getLifetime());
        buf.append(" sends: ").append(sends);
        buf.append(" pushes: ").append(pushCount);
        buf.append(" expired? ").append(expired);
        buf.append(" unacked: ").append(msg.getUnackedSize());
        if (p != null && !successful) {
            buf.append(" consec_failed: ").append(p.getConsecutiveFailedSends());
            long timeSinceSend = this._context.clock().now() - p.getLastSendFullyTime();
            buf.append(" lastFullSend: ").append(timeSinceSend);
            long timeSinceRecv = this._context.clock().now() - p.getLastReceiveTime();
            buf.append(" lastRecv: ").append(timeSinceRecv);
            buf.append(" xfer: ").append(p.getSendBps()).append("/").append(p.getReceiveBps());
            buf.append(" mtu: ").append(p.getMTU());
            buf.append(" rto: ").append(p.getRTO());
            buf.append(" sent: ").append(p.getMessagesSent()).append("/").append(p.getPacketsTransmitted());
            buf.append(" recv: ").append(p.getMessagesReceived()).append("/").append(p.getPacketsReceived());
            buf.append(" uptime: ").append(this._context.clock().now() - p.getKeyEstablishedTime());
        }
        if (m != null && p != null) {
            this._context.messageHistory().sendMessage(m.getMessageType(), msg.getMessageId(), m.getExpiration(), p.getRemotePeer(), successful, buf.toString());
        } else {
            this._context.messageHistory().sendMessage("establish", msg.getMessageId(), -1L, p != null ? p.getRemotePeer() : null, successful, buf.toString());
        }
    }

    @Override
    public void failed(OutNetMessage msg, String reason) {
        if (msg == null) {
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Sending message failed: " + msg, (Throwable)new Exception("failed from"));
        }
        if (!this._context.messageHistory().getDoLog()) {
            this._context.messageHistory().sendMessage(msg.getMessageType(), msg.getMessageId(), msg.getExpiration(), msg.getTarget().getIdentity().calculateHash(), false, reason);
        }
        super.afterSend(msg, false);
    }

    public void succeeded(OutboundMessageState msg) {
        if (msg == null) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending message succeeded: " + msg);
        }
        this.noteSend(msg, true);
        OutNetMessage m = msg.getMessage();
        if (m != null) {
            super.afterSend(m, true);
        }
    }

    @Override
    public int countPeers() {
        return this._peersByIdent.size();
    }

    @Override
    public int countActivePeers() {
        long now = this._context.clock().now();
        int active = 0;
        int inactive = 0;
        for (PeerState peer : this._peersByIdent.values()) {
            if (now - peer.getLastReceiveTime() > 300000L) {
                ++inactive;
                continue;
            }
            ++active;
        }
        return active;
    }

    @Override
    public int countActiveSendPeers() {
        long now = this._context.clock().now();
        int active = 0;
        int inactive = 0;
        for (PeerState peer : this._peersByIdent.values()) {
            if (now - peer.getLastSendFullyTime() > 60000L) {
                ++inactive;
                continue;
            }
            ++active;
        }
        return active;
    }

    @Override
    public boolean isEstablished(Hash dest) {
        return this.getPeerState(dest) != null;
    }

    public boolean allowConnection() {
        return this._peersByIdent.size() < this.getMaxConnections();
    }

    @Override
    public Vector<Long> getClockSkews() {
        Vector<Long> skews = new Vector<Long>();
        Vector<PeerState> peers = new Vector<PeerState>();
        peers.addAll(this._peersByIdent.values());
        boolean includeEverybody = this._context.router().getUptime() < 600000L || peers.size() < 10;
        long now = this._context.clock().now();
        for (PeerState peer : peers) {
            if (!includeEverybody && now - peer.getLastReceiveTime() > 900000L) continue;
            skews.addElement(peer.getClockSkew() / 1000L);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("UDP transport returning " + skews.size() + " peer clock skews.");
        }
        return skews;
    }

    public static final UDPTransport _instance() {
        return __instance;
    }

    public List<Hash> _getActivePeers() {
        ArrayList<Hash> peers = new ArrayList<Hash>(128);
        peers.addAll(this._peersByIdent.keySet());
        long now = this._context.clock().now();
        Iterator iter = peers.iterator();
        while (iter.hasNext()) {
            Hash peer = (Hash)iter.next();
            PeerState state = this.getPeerState(peer);
            if (now - state.getLastReceiveTime() <= 300000L) continue;
            iter.remove();
        }
        return peers;
    }

    private Comparator getComparator(int sortFlags) {
        Comparator rv = null;
        switch (Math.abs(sortFlags)) {
            case 1: {
                rv = IdleInComparator.instance();
                break;
            }
            case 2: {
                rv = IdleOutComparator.instance();
                break;
            }
            case 3: {
                rv = RateInComparator.instance();
                break;
            }
            case 4: {
                rv = RateOutComparator.instance();
                break;
            }
            case 16: {
                rv = UptimeComparator.instance();
                break;
            }
            case 5: {
                rv = SkewComparator.instance();
                break;
            }
            case 6: {
                rv = CwndComparator.instance();
                break;
            }
            case 7: {
                rv = SsthreshComparator.instance();
                break;
            }
            case 8: {
                rv = RTTComparator.instance();
                break;
            }
            case 9: {
                rv = DevComparator.instance();
                break;
            }
            case 10: {
                rv = RTOComparator.instance();
                break;
            }
            case 11: {
                rv = MTUComparator.instance();
                break;
            }
            case 12: {
                rv = SendCountComparator.instance();
                break;
            }
            case 13: {
                rv = RecvCountComparator.instance();
                break;
            }
            case 14: {
                rv = ResendComparator.instance();
                break;
            }
            case 15: {
                rv = DupComparator.instance();
                break;
            }
            default: {
                rv = AlphaComparator.instance();
            }
        }
        if (sortFlags < 0) {
            rv = new InverseComparator(rv);
        }
        return rv;
    }

    private static void appendSortLinks(StringBuilder buf, String urlBase, int sortFlags, String descr, int ascending) {
        if (ascending == 0) {
            buf.append(" <a href=\"").append(urlBase).append("?sort=0#udpcon\" title=\"").append(descr).append("\"><img src=\"/themes/console/images/inbound.png\" alt=\"V\"></a>");
        } else if (sortFlags == ascending) {
            buf.append(" <a href=\"").append(urlBase).append("?sort=").append(0 - ascending);
            buf.append("#udpcon\" title=\"").append(descr).append("\"><img src=\"/themes/console/images/inbound.png\" alt=\"V\"></a><b><img src=\"/themes/console/images/outbound.png\" alt=\"^\"></b>");
        } else if (sortFlags == 0 - ascending) {
            buf.append(" <b><img src=\"/themes/console/images/inbound.png\" alt=\"V\"></b><a href=\"").append(urlBase).append("?sort=").append(ascending);
            buf.append("#udpcon\" title=\"").append(descr).append("\"><img src=\"/themes/console/images/outbound.png\" alt=\"^\"></a>");
        } else {
            buf.append(" <a href=\"").append(urlBase).append("?sort=").append(0 - ascending);
            buf.append("#udpcon\" title=\"").append(descr).append("\"><img src=\"/themes/console/images/inbound.png\" alt=\"V\"></a><a href=\"").append(urlBase).append("?sort=").append(ascending);
            buf.append("#udpcon\" title=\"").append(descr).append("\"><img src=\"/themes/console/images/outbound.png\" alt=\"^\"></a>");
        }
    }

    public void renderStatusHTML(Writer out, int sortFlags) throws IOException {
    }

    @Override
    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        TreeSet<PeerState> peers = new TreeSet<PeerState>(this.getComparator(sortFlags));
        peers.addAll(this._peersByIdent.values());
        long offsetTotal = 0L;
        int bpsIn = 0;
        int bpsOut = 0;
        long uptimeMsTotal = 0L;
        long cwinTotal = 0L;
        long rttTotal = 0L;
        long rtoTotal = 0L;
        long sendTotal = 0L;
        long recvTotal = 0L;
        long resentTotal = 0L;
        long dupRecvTotal = 0L;
        int numPeers = 0;
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3 id=\"udpcon\">").append(this._("UDP connections")).append(": ").append(peers.size());
        buf.append(". ").append(this._("Limit")).append(": ").append(this.getMaxConnections());
        buf.append(". ").append(this._("Timeout")).append(": ").append(DataHelper.formatDuration((long)this._expireTimeout));
        buf.append(".</h3>\n");
        buf.append("<table>\n");
        buf.append("<tr><th class=\"smallhead\" nowrap><a href=\"#def.peer\">").append(this._("Peer")).append("</a><br>");
        if (sortFlags != 0) {
            UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by peer hash"), 0);
        }
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.dir\" title=\"").append(this._("Direction/Introduction")).append("\">").append(this._("Dir")).append("</a></th><th class=\"smallhead\" nowrap><a href=\"#def.idle\">").append(this._("Idle")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by idle inbound"), 1);
        buf.append(" / ");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by idle outbound"), 2);
        buf.append("</th>");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.rate\">").append(this._("In/Out")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by inbound rate"), 3);
        buf.append(" / ");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by outbound rate"), 4);
        buf.append("</th>\n");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.up\">").append(this._("Up")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by connection uptime"), 16);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.skew\">").append(this._("Skew")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by clock skew"), 5);
        buf.append("</th>\n");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.cwnd\">CWND</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by congestion window"), 6);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.ssthresh\">SST</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by slow start threshold"), 7);
        buf.append("</th>\n");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.rtt\">RTT</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by round trip time"), 8);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.dev\">").append(this._("Dev")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by round trip time deviation"), 9);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.rto\">RTO</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by retransmission timeout"), 10);
        buf.append("</th>\n");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.mtu\">MTU</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by outbound maximum transmit unit"), 11);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.send\">").append(this._("TX")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by packets sent"), 12);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.recv\">").append(this._("RX")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by packets received"), 13);
        buf.append("</th>\n");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.resent\">").append(this._("Dup TX")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by packets retransmitted"), 14);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.dupRecv\">").append(this._("Dup RX")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by packets received more than once"), 15);
        buf.append("</th></tr>\n");
        out.write(buf.toString());
        buf.setLength(0);
        long now = this._context.clock().now();
        for (PeerState peer : peers) {
            int cfs;
            if (now - peer.getLastReceiveTime() > 3600000L) continue;
            buf.append("<tr><td class=\"cells\" align=\"left\" nowrap>");
            buf.append(this._context.commSystem().renderPeerHTML(peer.getRemotePeer()));
            buf.append("</td><td class=\"cells\" nowrap align=\"left\">");
            if (peer.isInbound()) {
                buf.append("<img src=\"/themes/console/images/inbound.png\" alt=\"Inbound\" title=\"").append(this._("Inbound")).append("\">");
            } else {
                buf.append("<img src=\"/themes/console/images/outbound.png\" alt=\"Outbound\" title=\"").append(this._("Outbound")).append("\">");
            }
            if (peer.getWeRelayToThemAs() > 0L) {
                buf.append("&nbsp;&nbsp;<img src=\"/themes/console/images/outbound.png\" height=\"8\" width=\"12\" alt=\"^\" title=\"").append(this._("We offered to introduce them")).append("\">");
            }
            if (peer.getTheyRelayToUsAs() > 0L) {
                buf.append("&nbsp;&nbsp;<img src=\"/themes/console/images/inbound.png\" height=\"8\" width=\"12\" alt=\"V\" title=\"").append(this._("They offered to introduce us")).append("\">");
            }
            boolean appended = false;
            if (this._activeThrottle.isChoked(peer.getRemotePeer())) {
                buf.append("<br><i>").append(this._("Choked")).append("</i>");
                appended = true;
            }
            if ((cfs = peer.getConsecutiveFailedSends()) > 0) {
                if (!appended) {
                    buf.append("<br>");
                }
                buf.append(" <i>");
                if (cfs == 1) {
                    buf.append(this._("1 fail"));
                } else {
                    buf.append(this._("{0} fails", cfs));
                }
                buf.append("</i>");
                appended = true;
            }
            if (this._context.shitlist().isShitlisted(peer.getRemotePeer(), STYLE)) {
                if (!appended) {
                    buf.append("<br>");
                }
                buf.append(" <i>").append(this._("Banned")).append("</i>");
                appended = true;
            }
            buf.append("</td>");
            long idleIn = (now - peer.getLastReceiveTime()) / 1000L;
            long idleOut = (now - peer.getLastSendTime()) / 1000L;
            if (idleIn < 0L) {
                idleIn = 0L;
            }
            if (idleOut < 0L) {
                idleOut = 0L;
            }
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(idleIn);
            buf.append("s / ");
            buf.append(idleOut);
            buf.append("s</td>");
            int recvBps = idleIn > 2L ? 0 : peer.getReceiveBps();
            int sendBps = idleOut > 2L ? 0 : peer.getSendBps();
            buf.append("<td class=\"cells\" align=\"right\" nowrap>");
            buf.append(UDPTransport.formatKBps(recvBps));
            buf.append(" / ");
            buf.append(UDPTransport.formatKBps(sendBps));
            buf.append("</td>");
            long uptime = now - peer.getKeyEstablishedTime();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(DataHelper.formatDuration((long)uptime));
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(peer.getClockSkew() / 1000L);
            buf.append("s</td>");
            offsetTotal += peer.getClockSkew();
            long sendWindow = peer.getSendWindowBytes();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(sendWindow / 1024L);
            buf.append("K");
            buf.append(" / ").append(peer.getConcurrentSends());
            buf.append(" / ").append(peer.getConcurrentSendWindow());
            buf.append(" / ").append(peer.getConsecutiveSendRejections());
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(peer.getSlowStartThreshold() / 1024);
            buf.append("K</td>");
            int rtt = peer.getRTT();
            int rto = peer.getRTO();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(rtt);
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(peer.getRTTDeviation());
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(rto);
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(peer.getMTU()).append(" / ").append(peer.getReceiveMTU());
            buf.append("</td>");
            long sent = peer.getPacketsTransmitted();
            long recv = peer.getPacketsReceived();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(sent);
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(recv);
            buf.append("</td>");
            long resent = peer.getPacketsRetransmitted();
            long dupRecv = peer.getPacketsReceivedDuplicate();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(resent);
            buf.append("</td>");
            double recvDupPct = (double)peer.getPacketsReceivedDuplicate() / (double)peer.getPacketsReceived();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(dupRecv);
            buf.append("</td>");
            buf.append("</tr>\n");
            out.write(buf.toString());
            buf.setLength(0);
            bpsIn += recvBps;
            bpsOut += sendBps;
            uptimeMsTotal += uptime;
            cwinTotal += sendWindow;
            rttTotal += (long)rtt;
            rtoTotal += (long)rto;
            sendTotal += sent;
            recvTotal += recv;
            resentTotal += resent;
            dupRecvTotal += dupRecv;
            ++numPeers;
        }
        buf.append("<tr class=\"tablefooter\"> <td colspan=\"3\" align=\"left\"><b>").append(this._("SUMMARY")).append("</b></td><td align=\"center\" nowrap><b>");
        buf.append(UDPTransport.formatKBps(bpsIn)).append(" / ").append(UDPTransport.formatKBps(bpsOut));
        buf.append("</b></td><td align=\"center\"><b>").append(numPeers > 0 ? DataHelper.formatDuration((long)(uptimeMsTotal / (long)numPeers)) : "0s");
        buf.append("</b></td><td align=\"center\"><b>").append(numPeers > 0 ? DataHelper.formatDuration((long)(offsetTotal / (long)numPeers)) : "0ms").append("</b></td>\n<td align=\"center\"><b>");
        buf.append(numPeers > 0 ? cwinTotal / (long)(numPeers * 1024) + "K" : "0K");
        buf.append("</b></td><td>&nbsp;</td>\n<td align=\"center\"><b>");
        buf.append(numPeers > 0 ? rttTotal / (long)numPeers : 0L);
        buf.append("</b></td><td>&nbsp;</td> <td align=\"center\"><b>");
        buf.append(numPeers > 0 ? rtoTotal / (long)numPeers : 0L);
        buf.append("</b></td><td>&nbsp;</td> <td align=\"center\"><b>");
        buf.append(sendTotal).append("</b></td> <td align=\"center\"><b>").append(recvTotal).append("</b></td>\n<td align=\"center\"><b>").append(resentTotal);
        buf.append("</b></td><td align=\"center\"><b>").append(dupRecvTotal).append("</b></td>\n</tr></table>\n");
        out.write(buf.toString());
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String formatKBps(int bps) {
        DecimalFormat decimalFormat = _fmt;
        synchronized (decimalFormat) {
            return _fmt.format((float)bps / 1024.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String formatPct(double pct) {
        DecimalFormat decimalFormat = _pctFmt;
        synchronized (decimalFormat) {
            return _pctFmt.format(pct);
        }
    }

    private final String _(String s) {
        return Translate.getString((String)s, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    private final String _(String s, Object o) {
        return Translate.getString((String)s, (Object)o, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    void setReachabilityStatus(short status) {
        short old = this._reachabilityStatus;
        long now = this._context.clock().now();
        switch (status) {
            case 0: {
                this._context.statManager().addRateData("udp.statusOK", 1L, 0L);
                this._reachabilityStatus = status;
                this._reachabilityStatusLastUpdated = now;
                break;
            }
            case 1: {
                this._context.statManager().addRateData("udp.statusDifferent", 1L, 0L);
                this._reachabilityStatus = status;
                this._reachabilityStatusLastUpdated = now;
                break;
            }
            case 2: {
                this._context.statManager().addRateData("udp.statusReject", 1L, 0L);
            }
            case 3: {
                this._reachabilityStatus = status;
                this._reachabilityStatusLastUpdated = now;
                break;
            }
            default: {
                this._context.statManager().addRateData("udp.statusUnknown", 1L, 0L);
            }
        }
        this._statusLastCalled = now;
        this._lastStatus = status;
        if (status != old && status != 4) {
            if (this._log.shouldLog(20)) {
                this._log.info("Old status: " + old + " New status: " + status + " from: ", (Throwable)new Exception("traceback"));
            }
            this.rebuildExternalAddress();
        }
    }

    @Override
    public short getReachabilityStatus() {
        String override = this._context.getProperty(PROP_REACHABILITY_STATUS_OVERRIDE);
        if (override == null) {
            return this._reachabilityStatus;
        }
        if ("ok".equals(override)) {
            return 0;
        }
        if ("err-reject".equals(override)) {
            return 2;
        }
        if ("err-different".equals(override)) {
            return 1;
        }
        return this._reachabilityStatus;
    }

    @Override
    public void recheckReachability() {
        this._testEvent.runTest();
    }

    PeerState pickTestPeer(RemoteHostId dontInclude) {
        ArrayList<PeerState> peers = new ArrayList<PeerState>(this._peersByIdent.values());
        Collections.shuffle(peers, (Random)this._context.random());
        for (int i = 0; i < peers.size(); ++i) {
            RouterAddress addr;
            RouterInfo peerInfo;
            PeerState peer = (PeerState)peers.get(i);
            if (dontInclude != null && dontInclude.equals(peer.getRemoteHostId()) || (peerInfo = this._context.netDb().lookupRouterInfoLocally(peer.getRemotePeer())) == null || (addr = peerInfo.getTargetAddress(STYLE)) == null) continue;
            return peer;
        }
        return null;
    }

    private boolean shouldTest() {
        return !this._context.router().isHidden();
    }

    static {
        _fmt = new DecimalFormat("#,##0.00");
        _pctFmt = new DecimalFormat("#0.0%");
    }

    private class PeerTestEvent
    implements SimpleTimer.TimedEvent {
        private boolean _alive;
        private long _lastTested;
        private boolean _forceRun;

        private PeerTestEvent() {
        }

        public void timeReached() {
            if (UDPTransport.this.shouldTest()) {
                long now = UDPTransport.this._context.clock().now();
                if (this._forceRun || now - this._lastTested >= 780000L) {
                    this.runTest();
                }
            }
            if (this._alive) {
                long delay = 390000 + UDPTransport.this._context.random().nextInt(780000);
                if (delay <= 0L) {
                    throw new RuntimeException("wtf, delay is " + delay);
                }
                SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this, delay);
            }
        }

        private void runTest() {
            PeerState bob = UDPTransport.this.pickTestPeer(null);
            if (bob != null) {
                if (UDPTransport.this._log.shouldLog(20)) {
                    UDPTransport.this._log.info("Running periodic test with bob = " + bob);
                }
                UDPTransport.this._testManager.runTest(bob.getRemoteIPAddress(), bob.getRemotePort(), bob.getCurrentCipherKey(), bob.getCurrentMACKey());
                this._lastTested = UDPTransport.this._context.clock().now();
                this._forceRun = false;
                return;
            }
            if (UDPTransport.this._log.shouldLog(30)) {
                UDPTransport.this._log.warn("Unable to run a periodic test, as there are no peers with the capacity required");
            }
            this._forceRun = false;
        }

        void forceRun() {
            this._forceRun = true;
        }

        public void setIsAlive(boolean isAlive) {
            this._alive = isAlive;
            if (isAlive) {
                long delay = UDPTransport.this._context.random().nextInt(1560000);
                SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this, delay);
            } else {
                SimpleTimer.getInstance().removeEvent((SimpleTimer.TimedEvent)this);
            }
        }
    }

    private class ExpirePeerEvent
    implements SimpleTimer.TimedEvent {
        private final Set<PeerState> _expirePeers = new ConcurrentHashSet(128);
        private final List<PeerState> _expireBuffer = new ArrayList<PeerState>();
        private boolean _alive;

        public void timeReached() {
            if (UDPTransport.this.haveCapacity()) {
                UDPTransport.this._expireTimeout = Math.min(UDPTransport.this._expireTimeout + 15000, 1800000);
            } else {
                UDPTransport.this._expireTimeout = Math.max(UDPTransport.this._expireTimeout - 45000, 600000);
            }
            long shortInactivityCutoff = UDPTransport.this._context.clock().now() - (long)UDPTransport.this._expireTimeout;
            long longInactivityCutoff = UDPTransport.this._context.clock().now() - 1800000L;
            long pingCutoff = UDPTransport.this._context.clock().now() - 0x6DDD00L;
            this._expireBuffer.clear();
            Iterator<PeerState> iter = this._expirePeers.iterator();
            while (iter.hasNext()) {
                PeerState peer = iter.next();
                long inactivityCutoff = peer.getWeRelayToThemAs() > 0L || peer.getIntroducerTime() > pingCutoff ? longInactivityCutoff : shortInactivityCutoff;
                if (peer.getLastReceiveTime() >= inactivityCutoff || peer.getLastSendTime() >= inactivityCutoff) continue;
                this._expireBuffer.add(peer);
                iter.remove();
            }
            for (int i = 0; i < this._expireBuffer.size(); ++i) {
                UDPTransport.this.dropPeer(this._expireBuffer.get(i), false, "idle too long");
            }
            this._expireBuffer.clear();
            if (this._alive) {
                SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this, 30000L);
            }
        }

        public void add(PeerState peer) {
            this._expirePeers.add(peer);
        }

        public void remove(PeerState peer) {
            this._expirePeers.remove(peer);
        }

        public void setIsAlive(boolean isAlive) {
            this._alive = isAlive;
            if (isAlive) {
                SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this, 30000L);
            } else {
                SimpleTimer.getInstance().removeEvent((SimpleTimer.TimedEvent)this);
                this._expirePeers.clear();
            }
        }
    }

    private class SharedBid
    extends TransportBid {
        public SharedBid(int ms) {
            this.setLatencyMs(ms);
        }

        public Transport getTransport() {
            return UDPTransport.this;
        }

        public String toString() {
            return "UDP bid @ " + this.getLatencyMs();
        }
    }

    private static class InverseComparator
    implements Comparator {
        private Comparator _comp;

        public InverseComparator(Comparator comp) {
            this._comp = comp;
        }

        public int compare(Object lhs, Object rhs) {
            return -1 * this._comp.compare(lhs, rhs);
        }
    }

    private static class PeerComparator
    implements Comparator {
        private PeerComparator() {
        }

        public int compare(Object lhs, Object rhs) {
            if (lhs == null || rhs == null || !(lhs instanceof PeerState) || !(rhs instanceof PeerState)) {
                throw new IllegalArgumentException("rhs = " + rhs + " lhs = " + lhs);
            }
            return this.compare((PeerState)lhs, (PeerState)rhs);
        }

        protected int compare(PeerState l, PeerState r) {
            return l.getRemotePeer().toBase64().compareTo(r.getRemotePeer().toBase64());
        }
    }

    private static class DupComparator
    extends PeerComparator {
        private static final DupComparator _instance = new DupComparator();

        private DupComparator() {
        }

        public static final DupComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getPacketsReceivedDuplicate() - r.getPacketsReceivedDuplicate();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class ResendComparator
    extends PeerComparator {
        private static final ResendComparator _instance = new ResendComparator();

        private ResendComparator() {
        }

        public static final ResendComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getPacketsRetransmitted() - r.getPacketsRetransmitted();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class RecvCountComparator
    extends PeerComparator {
        private static final RecvCountComparator _instance = new RecvCountComparator();

        private RecvCountComparator() {
        }

        public static final RecvCountComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getPacketsReceived() - r.getPacketsReceived();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class SendCountComparator
    extends PeerComparator {
        private static final SendCountComparator _instance = new SendCountComparator();

        private SendCountComparator() {
        }

        public static final SendCountComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getPacketsTransmitted() - r.getPacketsTransmitted();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class MTUComparator
    extends PeerComparator {
        private static final MTUComparator _instance = new MTUComparator();

        private MTUComparator() {
        }

        public static final MTUComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getMTU() - r.getMTU();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class RTOComparator
    extends PeerComparator {
        private static final RTOComparator _instance = new RTOComparator();

        private RTOComparator() {
        }

        public static final RTOComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getRTO() - r.getRTO();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class DevComparator
    extends PeerComparator {
        private static final DevComparator _instance = new DevComparator();

        private DevComparator() {
        }

        public static final DevComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getRTTDeviation() - r.getRTTDeviation();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class RTTComparator
    extends PeerComparator {
        private static final RTTComparator _instance = new RTTComparator();

        private RTTComparator() {
        }

        public static final RTTComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getRTT() - r.getRTT();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class SsthreshComparator
    extends PeerComparator {
        private static final SsthreshComparator _instance = new SsthreshComparator();

        private SsthreshComparator() {
        }

        public static final SsthreshComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getSlowStartThreshold() - r.getSlowStartThreshold();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class CwndComparator
    extends PeerComparator {
        private static final CwndComparator _instance = new CwndComparator();

        private CwndComparator() {
        }

        public static final CwndComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getSendWindowBytes() - r.getSendWindowBytes();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class SkewComparator
    extends PeerComparator {
        private static final SkewComparator _instance = new SkewComparator();

        private SkewComparator() {
        }

        public static final SkewComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = Math.abs(l.getClockSkew()) - Math.abs(r.getClockSkew());
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class UptimeComparator
    extends PeerComparator {
        private static final UptimeComparator _instance = new UptimeComparator();

        private UptimeComparator() {
        }

        public static final UptimeComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = r.getKeyEstablishedTime() - l.getKeyEstablishedTime();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class RateOutComparator
    extends PeerComparator {
        private static final RateOutComparator _instance = new RateOutComparator();

        private RateOutComparator() {
        }

        public static final RateOutComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getSendBps() - r.getSendBps();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class RateInComparator
    extends PeerComparator {
        private static final RateInComparator _instance = new RateInComparator();

        private RateInComparator() {
        }

        public static final RateInComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getReceiveBps() - r.getReceiveBps();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class IdleOutComparator
    extends PeerComparator {
        private static final IdleOutComparator _instance = new IdleOutComparator();

        private IdleOutComparator() {
        }

        public static final IdleOutComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = r.getLastSendTime() - l.getLastSendTime();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class IdleInComparator
    extends PeerComparator {
        private static final IdleInComparator _instance = new IdleInComparator();

        private IdleInComparator() {
        }

        public static final IdleInComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = r.getLastReceiveTime() - l.getLastReceiveTime();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class AlphaComparator
    extends PeerComparator {
        private static final AlphaComparator _instance = new AlphaComparator();

        private AlphaComparator() {
        }

        public static final AlphaComparator instance() {
            return _instance;
        }
    }

    private class RemoveDropList
    implements SimpleTimer.TimedEvent {
        private RemoteHostId _peer;

        public RemoveDropList(RemoteHostId peer) {
            this._peer = peer;
        }

        public void timeReached() {
            UDPTransport.this._dropList.remove(this._peer);
        }
    }
}

