/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Log;

class UDPPacket {
    private I2PAppContext _context;
    private static Log _log;
    private volatile DatagramPacket _packet;
    private volatile short _priority;
    private volatile long _initializeTime;
    private volatile long _expiration;
    private byte[] _data;
    private byte[] _validateBuf;
    private byte[] _ivBuf;
    private volatile int _markedType;
    private volatile RemoteHostId _remoteHost;
    private volatile boolean _released;
    private volatile Exception _releasedBy;
    private volatile Exception _acquiredBy;
    private long _enqueueTime;
    private long _receivedTime;
    private long _beforeValidate;
    private long _afterValidate;
    private long _beforeReceiveFragments;
    private long _afterHandlingTime;
    private int _validateCount;
    private static final Queue<UDPPacket> _packetCache;
    private static final boolean CACHE = true;
    private static final int CACHE_SIZE = 64;
    static final int MAX_PACKET_SIZE = 2048;
    public static final int IV_SIZE = 16;
    public static final int MAC_SIZE = 16;
    public static final int PAYLOAD_TYPE_SESSION_REQUEST = 0;
    public static final int PAYLOAD_TYPE_SESSION_CREATED = 1;
    public static final int PAYLOAD_TYPE_SESSION_CONFIRMED = 2;
    public static final int PAYLOAD_TYPE_RELAY_REQUEST = 3;
    public static final int PAYLOAD_TYPE_RELAY_RESPONSE = 4;
    public static final int PAYLOAD_TYPE_RELAY_INTRO = 5;
    public static final int PAYLOAD_TYPE_DATA = 6;
    public static final int PAYLOAD_TYPE_TEST = 7;
    public static final int PAYLOAD_TYPE_SESSION_DESTROY = 8;
    public static final byte DATA_FLAG_EXPLICIT_ACK = -128;
    public static final byte DATA_FLAG_ACK_BITFIELDS = 64;
    public static final byte DATA_FLAG_ECN = 16;
    public static final byte DATA_FLAG_WANT_ACKS = 8;
    public static final byte DATA_FLAG_WANT_REPLY = 4;
    public static final byte DATA_FLAG_EXTENDED = 2;
    public static final byte BITFIELD_CONTINUATION = -128;
    private static final int MAX_VALIDATE_SIZE = 2048;
    private int _messageType;
    private int _fragmentCount;

    private UDPPacket(I2PAppContext ctx, boolean inbound) {
        ctx.statManager().createRateStat("udp.fetchRemoteSlow", "How long it takes to grab the remote ip info", "udp", UDPTransport.RATES);
        this._data = new byte[2048];
        this._packet = new DatagramPacket(this._data, 2048);
        this._validateBuf = new byte[2048];
        this._ivBuf = new byte[16];
        this.init(ctx, inbound);
    }

    private void init(I2PAppContext ctx, boolean inbound) {
        this._context = ctx;
        Arrays.fill(this._data, (byte)0);
        this._packet.setData(this._data);
        this._initializeTime = this._context.clock().now();
        this._markedType = -1;
        this._validateCount = 0;
        this._remoteHost = null;
        this._released = false;
    }

    public void writeData(byte[] src, int offset, int len) {
        this.verifyNotReleased();
        System.arraycopy(src, offset, this._data, 0, len);
        this._packet.setLength(len);
        this.resetBegin();
    }

    public DatagramPacket getPacket() {
        this.verifyNotReleased();
        return this._packet;
    }

    public short getPriority() {
        this.verifyNotReleased();
        return this._priority;
    }

    public long getExpiration() {
        this.verifyNotReleased();
        return this._expiration;
    }

    public long getBegin() {
        this.verifyNotReleased();
        return this._initializeTime;
    }

    public long getLifetime() {
        this.verifyNotReleased();
        return this._context.clock().now() - this._initializeTime;
    }

    public void resetBegin() {
        this._initializeTime = this._context.clock().now();
    }

    public void markType(int type) {
        this.verifyNotReleased();
        this._markedType = type;
    }

    public int getMarkedType() {
        this.verifyNotReleased();
        return this._markedType;
    }

    int getMessageType() {
        return this._messageType;
    }

    void setMessageType(int type) {
        this._messageType = type;
    }

    int getFragmentCount() {
        return this._fragmentCount;
    }

    void setFragmentCount(int count) {
        this._fragmentCount = count;
    }

    RemoteHostId getRemoteHost() {
        if (this._remoteHost == null) {
            long before = System.currentTimeMillis();
            InetAddress addr = this._packet.getAddress();
            byte[] ip = addr.getAddress();
            int port = this._packet.getPort();
            this._remoteHost = new RemoteHostId(ip, port);
            long timeToFetch = System.currentTimeMillis() - before;
            if (timeToFetch > 50L) {
                this._context.statManager().addRateData("udp.fetchRemoteSlow", timeToFetch, this.getLifetime());
            }
        }
        return this._remoteHost;
    }

    public boolean validate(SessionKey macKey) {
        this.verifyNotReleased();
        this._beforeValidate = this._context.clock().now();
        boolean eq = false;
        Arrays.fill(this._validateBuf, (byte)0);
        int payloadLength = this._packet.getLength() - 16 - 16;
        if (payloadLength > 0) {
            int off = 0;
            System.arraycopy(this._data, this._packet.getOffset() + 16 + 16, this._validateBuf, off, payloadLength);
            System.arraycopy(this._data, this._packet.getOffset() + 16, this._validateBuf, off += payloadLength, 16);
            DataHelper.toLong((byte[])this._validateBuf, (int)(off += 16), (int)2, (long)(payloadLength ^ 0));
            eq = this._context.hmac().verify(macKey, this._validateBuf, 0, off += 2, this._data, this._packet.getOffset(), 16);
        } else if (_log.shouldLog(30)) {
            _log.warn("Payload length is " + payloadLength);
        }
        this._afterValidate = this._context.clock().now();
        ++this._validateCount;
        return eq;
    }

    public void decrypt(SessionKey cipherKey) {
        this.verifyNotReleased();
        Arrays.fill(this._ivBuf, (byte)0);
        System.arraycopy(this._data, 16, this._ivBuf, 0, 16);
        int len = this._packet.getLength();
        this._context.aes().decrypt(this._data, this._packet.getOffset() + 16 + 16, this._data, this._packet.getOffset() + 16 + 16, cipherKey, this._ivBuf, len - 16 - 16);
    }

    void enqueue() {
        this._enqueueTime = this._context.clock().now();
    }

    void received() {
        this._receivedTime = this._context.clock().now();
    }

    void beforeReceiveFragments() {
        this._beforeReceiveFragments = this._context.clock().now();
    }

    void afterHandling() {
        this._afterHandlingTime = this._context.clock().now();
    }

    long getTimeSinceEnqueue() {
        return this._enqueueTime > 0L ? this._context.clock().now() - this._enqueueTime : 0L;
    }

    long getTimeSinceReceived() {
        return this._receivedTime > 0L ? this._context.clock().now() - this._receivedTime : 0L;
    }

    long getTimeSinceReceiveFragments() {
        return this._beforeReceiveFragments > 0L ? this._context.clock().now() - this._beforeReceiveFragments : 0L;
    }

    long getTimeSinceHandling() {
        return this._afterHandlingTime > 0L ? this._context.clock().now() - this._afterHandlingTime : 0L;
    }

    long getEnqueueTime() {
        return this._enqueueTime;
    }

    long getReceivedTime() {
        return this._receivedTime;
    }

    long getBeforeValidate() {
        return this._beforeValidate;
    }

    long getAfterValidate() {
        return this._afterValidate;
    }

    int getValidateCount() {
        return this._validateCount;
    }

    public String toString() {
        this.verifyNotReleased();
        StringBuilder buf = new StringBuilder(256);
        buf.append(this._packet.getLength());
        buf.append(" byte packet with ");
        buf.append(this._packet.getAddress().getHostAddress()).append(":");
        buf.append(this._packet.getPort());
        buf.append(" id=").append(System.identityHashCode(this));
        buf.append(" sinceEnqueued=").append(this._enqueueTime > 0L ? this._context.clock().now() - this._enqueueTime : -1L);
        buf.append(" sinceReceived=").append(this._receivedTime > 0L ? this._context.clock().now() - this._receivedTime : -1L);
        buf.append(" beforeReceiveFragments=").append(this._beforeReceiveFragments > 0L ? this._context.clock().now() - this._beforeReceiveFragments : -1L);
        buf.append(" sinceHandled=").append(this._afterHandlingTime > 0L ? this._context.clock().now() - this._afterHandlingTime : -1L);
        return buf.toString();
    }

    public static UDPPacket acquire(I2PAppContext ctx, boolean inbound) {
        UDPPacket rv = null;
        rv = _packetCache.poll();
        if (rv != null) {
            rv.init(ctx, inbound);
        }
        if (rv == null) {
            rv = new UDPPacket(ctx, inbound);
        }
        return rv;
    }

    public void release() {
        this.verifyNotReleased();
        this._released = true;
        _packetCache.offer(this);
    }

    private void verifyNotReleased() {
    }

    static {
        _packetCache = new LinkedBlockingQueue<UDPPacket>(64);
        _log = I2PAppContext.getGlobalContext().logManager().getLog(UDPPacket.class);
    }
}

