/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.ArrayList;
import java.util.List;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Log;

class OutboundMessageFragments {
    private RouterContext _context;
    private Log _log;
    private UDPTransport _transport;
    private final List<PeerState> _activePeers;
    private boolean _alive;
    private int _nextPeer;
    private PacketBuilder _builder;
    static final int MAX_VOLLEYS = 10;
    private long _lastCycleTime = System.currentTimeMillis();

    public OutboundMessageFragments(RouterContext ctx, UDPTransport transport, ActiveThrottle throttle) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(OutboundMessageFragments.class);
        this._transport = transport;
        this._activePeers = new ArrayList<PeerState>(256);
        this._nextPeer = 0;
        this._builder = new PacketBuilder(ctx, transport);
        this._alive = true;
        this._context.statManager().createRateStat("udp.sendVolleyTime", "Long it takes to send a full volley", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendConfirmTime", "How long it takes to send a message and get the ACK", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendConfirmFragments", "How many fragments are included in a fully ACKed message", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendConfirmVolley", "How many times did fragments need to be sent before ACK", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendFailed", "How many sends a failed message was pushed", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendAggressiveFailed", "How many volleys was a packet sent before we gave up", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.outboundActiveCount", "How many messages are in the peer's active pool", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendRejected", "What volley are we on when the peer was throttled (time == message lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.partialACKReceived", "How many fragments were partially ACKed (time == message lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendSparse", "How many fragments were partially ACKed and hence not resent (time == message lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPiggyback", "How many acks were piggybacked on a data packet (time == message lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPiggybackPartial", "How many partial acks were piggybacked on a data packet (time == message lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.packetsRetransmitted", "Lifetime of packets during their retransmission (period == packets transmitted, lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.peerPacketsRetransmitted", "How many packets have been retransmitted to the peer (lifetime) when a burst of packets are retransmitted (period == packets transmitted, lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.blockedRetransmissions", "How packets have been transmitted to the peer when we blocked a retransmission to them?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendCycleTime", "How long it takes to cycle through all of the active messages?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendCycleTimeSlow", "How long it takes to cycle through all of the active messages, when its going slowly?", "udp", UDPTransport.RATES);
    }

    public void startup() {
        this._alive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this._alive = false;
        List<PeerState> list = this._activePeers;
        synchronized (list) {
            this._activePeers.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropPeer(PeerState peer) {
        if (this._log.shouldLog(20)) {
            this._log.info("Dropping peer " + peer.getRemotePeer().toBase64());
        }
        peer.dropOutbound();
        List<PeerState> list = this._activePeers;
        synchronized (list) {
            this._activePeers.remove(peer);
            this._activePeers.notifyAll();
        }
    }

    public boolean waitForMoreAllowed() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(OutNetMessage msg) {
        I2NPMessage msgBody = msg.getMessage();
        RouterInfo target = msg.getTarget();
        if (msgBody == null || target == null) {
            return;
        }
        OutboundMessageState state = new OutboundMessageState(this._context);
        boolean ok = state.initialize(msg, msgBody);
        if (ok) {
            PeerState peer = this._transport.getPeerState(target.getIdentity().calculateHash());
            if (peer == null) {
                this._transport.failed(msg, "Peer disconnected quickly");
                state.releaseResources();
                return;
            }
            int active = peer.add(state);
            List<PeerState> list = this._activePeers;
            synchronized (list) {
                if (!this._activePeers.contains(peer)) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Add a new message to a new peer " + peer.getRemotePeer().toBase64());
                    }
                    this._activePeers.add(peer);
                } else if (this._log.shouldLog(10)) {
                    this._log.debug("Add a new message to an existing peer " + peer.getRemotePeer().toBase64());
                }
                this._activePeers.notifyAll();
            }
            this._context.statManager().addRateData("udp.outboundActiveCount", (long)active, 0L);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Error initializing " + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(OutboundMessageState state) {
        PeerState peer = state.getPeer();
        if (peer == null) {
            throw new RuntimeException("wtf, null peer for " + state);
        }
        int active = peer.add(state);
        List<PeerState> list = this._activePeers;
        synchronized (list) {
            if (!this._activePeers.contains(peer)) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Add a new message to a new peer " + peer.getRemotePeer().toBase64());
                }
                this._activePeers.add(peer);
            } else if (this._log.shouldLog(10)) {
                this._log.debug("Add a new message to an existing peer " + peer.getRemotePeer().toBase64());
            }
            if (this._activePeers.size() == 1) {
                this._lastCycleTime = System.currentTimeMillis();
            }
            this._activePeers.notifyAll();
        }
        this._context.statManager().addRateData("udp.outboundActiveCount", (long)active, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishMessages() {
        int rv = 0;
        ArrayList<PeerState> peers = null;
        List<PeerState> list = this._activePeers;
        synchronized (list) {
            peers = new ArrayList<PeerState>(this._activePeers.size());
            for (int i = 0; i < this._activePeers.size(); ++i) {
                PeerState state = this._activePeers.get(i);
                if (state.getOutboundMessageCount() <= 0) {
                    this._activePeers.remove(i);
                    --i;
                    continue;
                }
                peers.add(state);
            }
            this._activePeers.notifyAll();
        }
        for (int i = 0; i < peers.size(); ++i) {
            PeerState state = (PeerState)peers.get(i);
            int remaining = state.finishMessages();
            if (remaining <= 0 && this._log.shouldLog(10)) {
                this._log.debug("No more pending messages for " + state.getRemotePeer().toBase64());
            }
            rv += remaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UDPPacket[] getNextVolley() {
        PeerState peer = null;
        OutboundMessageState state = null;
        while (this._alive && state == null) {
            long now = this._context.clock().now();
            int nextSendDelay = -1;
            this.finishMessages();
            try {
                List<PeerState> list = this._activePeers;
                synchronized (list) {
                    for (int i = 0; i < this._activePeers.size(); ++i) {
                        int cur = (i + this._nextPeer) % this._activePeers.size();
                        if (cur == 0) {
                            long ts = System.currentTimeMillis();
                            long cycleTime = ts - this._lastCycleTime;
                            this._context.statManager().addRateData("udp.sendCycleTime", cycleTime, (long)this._activePeers.size());
                            if (cycleTime > 1000L) {
                                this._context.statManager().addRateData("udp.sendCycleTimeSlow", cycleTime, (long)this._activePeers.size());
                            }
                        }
                        if ((state = (peer = this._activePeers.get(i)).allocateSend()) != null) {
                            this._nextPeer = i + 1;
                            break;
                        }
                        int delay = peer.getNextDelay();
                        if (nextSendDelay <= 0 || delay < nextSendDelay) {
                            nextSendDelay = delay;
                        }
                        peer = null;
                        state = null;
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Done looping, next peer we are sending for: " + (peer != null ? peer.getRemotePeer().toBase64() : "none"));
                    }
                    if (state == null) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("wait for " + nextSendDelay);
                        }
                        if (nextSendDelay > 0) {
                            this._activePeers.wait(nextSendDelay);
                        } else {
                            this._activePeers.wait(1000L);
                        }
                    } else if (this._log.shouldLog(10)) {
                        this._log.debug("dont wait: alive=" + this._alive + " state = " + state);
                    }
                }
            }
            catch (InterruptedException ie) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Woken up while waiting");
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending " + state);
        }
        UDPPacket[] packets = this.preparePackets(state, peer);
        if (state != null && state.getMessage() != null) {
            int valid = 0;
            for (int i = 0; packets != null && i < packets.length; ++i) {
                if (packets[i] == null) continue;
                ++valid;
            }
        }
        return packets;
    }

    private UDPPacket[] preparePackets(OutboundMessageState state, PeerState peer) {
        if (state != null && peer != null) {
            int fragments = state.getFragmentCount();
            if (fragments < 0) {
                return null;
            }
            List<Long> msgIds = peer.getCurrentFullACKs();
            if (msgIds == null) {
                msgIds = new ArrayList<Long>();
            }
            ArrayList<ACKBitfield> partialACKBitfields = new ArrayList<ACKBitfield>();
            peer.fetchPartialACKs(partialACKBitfields);
            int piggybackedPartialACK = partialACKBitfields.size();
            ArrayList<Long> remaining = new ArrayList<Long>(msgIds);
            int sparseCount = 0;
            UDPPacket[] rv = new UDPPacket[fragments];
            for (int i = 0; i < fragments; ++i) {
                if (state.needsSending(i)) {
                    try {
                        rv[i] = this._builder.buildPacket(state, i, peer, remaining, partialACKBitfields);
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        this._log.log(50, "Corrupt trying to build a packet - please tell jrandom: " + partialACKBitfields + " / " + remaining + " / " + msgIds);
                        ++sparseCount;
                        continue;
                    }
                    if (rv[i] == null) {
                        ++sparseCount;
                        continue;
                    }
                    rv[i].setFragmentCount(fragments);
                    OutNetMessage msg = state.getMessage();
                    if (msg != null) {
                        rv[i].setMessageType(msg.getMessageTypeId());
                        continue;
                    }
                    rv[i].setMessageType(-1);
                    continue;
                }
                ++sparseCount;
            }
            if (sparseCount > 0) {
                remaining.clear();
            }
            int piggybackedAck = 0;
            if (msgIds.size() != remaining.size()) {
                for (int i = 0; i < msgIds.size(); ++i) {
                    Long id = msgIds.get(i);
                    if (remaining.contains(id)) continue;
                    peer.removeACKMessage(id);
                    ++piggybackedAck;
                }
            }
            if (sparseCount > 0) {
                this._context.statManager().addRateData("udp.sendSparse", (long)sparseCount, state.getLifetime());
            }
            if (piggybackedAck > 0) {
                this._context.statManager().addRateData("udp.sendPiggyback", (long)piggybackedAck, state.getLifetime());
            }
            if (piggybackedPartialACK - partialACKBitfields.size() > 0) {
                this._context.statManager().addRateData("udp.sendPiggybackPartial", (long)(piggybackedPartialACK - partialACKBitfields.size()), state.getLifetime());
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Building packet for " + state + " to " + peer + " with sparse count: " + sparseCount);
            }
            peer.packetsTransmitted(fragments - sparseCount);
            if (state.getPushCount() > 1) {
                int toSend = fragments - sparseCount;
                peer.messageRetransmitted(toSend);
                this._context.statManager().addRateData("udp.peerPacketsRetransmitted", peer.getPacketsRetransmitted(), peer.getPacketsTransmitted());
                this._context.statManager().addRateData("udp.packetsRetransmitted", state.getLifetime(), peer.getPacketsTransmitted());
                if (this._log.shouldLog(20)) {
                    this._log.info("Retransmitting " + state + " to " + peer);
                }
                this._context.statManager().addRateData("udp.sendVolleyTime", state.getLifetime(), (long)toSend);
            }
            return rv;
        }
        return null;
    }

    public int acked(long messageId, Hash ackedBy) {
        PeerState peer = this._transport.getPeerState(ackedBy);
        if (peer != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("acked [" + messageId + "] by " + ackedBy.toBase64());
            }
            return peer.acked(messageId);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("acked [" + messageId + "] by an unknown remote peer?  " + ackedBy.toBase64());
        }
        return 0;
    }

    public void acked(ACKBitfield bitfield, Hash ackedBy) {
        PeerState peer = this._transport.getPeerState(ackedBy);
        if (peer != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("partial acked [" + bitfield + "] by " + ackedBy.toBase64());
            }
            peer.acked(bitfield);
        } else if (this._log.shouldLog(10)) {
            this._log.debug("partial acked [" + bitfield + "] by an unknown remote peer?  " + ackedBy.toBase64());
        }
    }

    public static interface ActiveThrottle {
        public void choke(Hash var1);

        public void unchoke(Hash var1);

        public boolean isChoked(Hash var1);
    }
}

