/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.crypto.DHSessionKeyBuilder;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.RouterIdentity;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.util.Log;

class OutboundEstablishState {
    private final RouterContext _context;
    private final Log _log;
    private byte[] _sentX;
    private byte[] _bobIP;
    private int _bobPort;
    private DHSessionKeyBuilder _keyBuilder;
    private byte[] _receivedY;
    private byte[] _aliceIP;
    private int _alicePort;
    private long _receivedRelayTag;
    private long _receivedSignedOnTime;
    private SessionKey _sessionKey;
    private SessionKey _macKey;
    private Signature _receivedSignature;
    private byte[] _receivedEncryptedSignature;
    private byte[] _receivedIV;
    private long _sentSignedOnTime;
    private Signature _sentSignature;
    private final long _establishBegin;
    private long _lastSend;
    private long _nextSend;
    private RemoteHostId _remoteHostId;
    private final RouterIdentity _remotePeer;
    private SessionKey _introKey;
    private final Queue<OutNetMessage> _queuedMessages;
    private int _currentState;
    private long _introductionNonce;
    private final UDPAddress _remoteAddress;
    private boolean _complete;
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_REQUEST_SENT = 1;
    public static final int STATE_CREATED_RECEIVED = 2;
    public static final int STATE_CONFIRMED_PARTIALLY = 3;
    public static final int STATE_CONFIRMED_COMPLETELY = 4;
    public static final int STATE_PENDING_INTRO = 5;

    public OutboundEstablishState(RouterContext ctx, InetAddress remoteHost, int remotePort, RouterIdentity remotePeer, SessionKey introKey, UDPAddress addr) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(OutboundEstablishState.class);
        if (remoteHost != null && remotePort > 0) {
            this._bobIP = remoteHost.getAddress();
            this._bobPort = remotePort;
            this._remoteHostId = new RemoteHostId(this._bobIP, this._bobPort);
        } else {
            this._bobIP = null;
            this._bobPort = -1;
            this._remoteHostId = new RemoteHostId(remotePeer.calculateHash().getData());
        }
        this._remotePeer = remotePeer;
        this._introKey = introKey;
        this._keyBuilder = null;
        this._queuedMessages = new LinkedBlockingQueue<OutNetMessage>();
        this._currentState = 0;
        this._establishBegin = ctx.clock().now();
        this._remoteAddress = addr;
        this._introductionNonce = -1L;
        this._complete = false;
        this.prepareSessionRequest();
        if (addr != null && addr.getIntroducerCount() > 0) {
            if (this._log.shouldLog(10)) {
                this._log.debug("new outbound establish to " + remotePeer.calculateHash().toBase64() + ", with address: " + addr);
            }
            this._currentState = 5;
        }
    }

    public synchronized int getState() {
        return this._currentState;
    }

    public synchronized boolean complete() {
        boolean already = this._complete;
        this._complete = true;
        return already;
    }

    public UDPAddress getRemoteAddress() {
        return this._remoteAddress;
    }

    public void setIntroNonce(long nonce) {
        this._introductionNonce = nonce;
    }

    public long getIntroNonce() {
        return this._introductionNonce;
    }

    public void addMessage(OutNetMessage msg) {
        if (!this._queuedMessages.contains(msg)) {
            this._queuedMessages.offer(msg);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("attempt to add duplicate msg to queue: " + msg);
        }
    }

    public OutNetMessage getNextQueuedMessage() {
        return this._queuedMessages.poll();
    }

    public RouterIdentity getRemoteIdentity() {
        return this._remotePeer;
    }

    public SessionKey getIntroKey() {
        return this._introKey;
    }

    private void prepareSessionRequest() {
        this._keyBuilder = new DHSessionKeyBuilder();
        byte[] X = this._keyBuilder.getMyPublicValue().toByteArray();
        if (this._sentX == null) {
            this._sentX = new byte[256];
        }
        if (X.length == 257) {
            System.arraycopy(X, 1, this._sentX, 0, this._sentX.length);
        } else if (X.length == 256) {
            System.arraycopy(X, 0, this._sentX, 0, this._sentX.length);
        } else {
            System.arraycopy(X, 0, this._sentX, this._sentX.length - X.length, X.length);
        }
    }

    public byte[] getSentX() {
        return this._sentX;
    }

    public synchronized byte[] getSentIP() {
        return this._bobIP;
    }

    public synchronized int getSentPort() {
        return this._bobPort;
    }

    public synchronized void receiveSessionCreated(UDPPacketReader.SessionCreatedReader reader) {
        if (this._receivedY != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Session created already received, ignoring");
            }
            return;
        }
        this._receivedY = new byte[256];
        reader.readY(this._receivedY, 0);
        if (this._aliceIP == null) {
            this._aliceIP = new byte[reader.readIPSize()];
        }
        reader.readIP(this._aliceIP, 0);
        this._alicePort = reader.readPort();
        this._receivedRelayTag = reader.readRelayTag();
        this._receivedSignedOnTime = reader.readSignedOnTime();
        this._receivedEncryptedSignature = new byte[48];
        reader.readEncryptedSignature(this._receivedEncryptedSignature, 0);
        this._receivedIV = new byte[16];
        reader.readIV(this._receivedIV, 0);
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive session created:\neSig: " + Base64.encode((byte[])this._receivedEncryptedSignature) + "\nreceivedIV: " + Base64.encode((byte[])this._receivedIV) + "\nAliceIP: " + Base64.encode((byte[])this._aliceIP) + " RelayTag: " + this._receivedRelayTag + " SignedOn: " + this._receivedSignedOnTime + "\nthis: " + this.toString());
        }
        if (this._currentState == 0 || this._currentState == 1) {
            this._currentState = 2;
        }
        this.packetReceived();
    }

    public synchronized boolean validateSessionCreated() {
        if (this._receivedSignature != null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Session created already validated");
            }
            return true;
        }
        boolean valid = true;
        try {
            this.generateSessionKey();
        }
        catch (DHSessionKeyBuilder.InvalidPublicParameterException ippe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Peer " + this.getRemoteHostId() + " sent us an invalid DH parameter (or were spoofed)", (Throwable)ippe);
            }
            valid = false;
        }
        if (valid) {
            this.decryptSignature();
        }
        if (valid && this.verifySessionCreated()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Session created passed validation");
            }
            return true;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Session created failed validation, clearing state for " + this._remoteHostId.toString());
        }
        this.fail();
        return false;
    }

    public synchronized void fail() {
        this._receivedY = null;
        this._aliceIP = null;
        this._receivedRelayTag = 0L;
        this._receivedSignedOnTime = -1L;
        this._receivedEncryptedSignature = null;
        this._receivedIV = null;
        this._receivedSignature = null;
        if (this._currentState == 0 || this._currentState == 1 || this._currentState == 2) {
            this._currentState = 1;
        }
        this._nextSend = this._context.clock().now();
    }

    private void generateSessionKey() throws DHSessionKeyBuilder.InvalidPublicParameterException {
        if (this._sessionKey != null) {
            return;
        }
        this._keyBuilder.setPeerPublicValue(this._receivedY);
        this._sessionKey = this._keyBuilder.getSessionKey();
        ByteArray extra = this._keyBuilder.getExtraBytes();
        this._macKey = new SessionKey(new byte[32]);
        System.arraycopy(extra.getData(), 0, this._macKey.getData(), 0, 32);
        if (this._log.shouldLog(10)) {
            this._log.debug("Established outbound keys.  cipher: " + Base64.encode((byte[])this._sessionKey.getData()) + " mac: " + Base64.encode((byte[])this._macKey.getData()));
        }
    }

    private void decryptSignature() {
        if (this._receivedEncryptedSignature == null) {
            throw new NullPointerException("encrypted signature is null! this=" + this.toString());
        }
        if (this._sessionKey == null) {
            throw new NullPointerException("SessionKey is null!");
        }
        if (this._receivedIV == null) {
            throw new NullPointerException("IV is null!");
        }
        this._context.aes().decrypt(this._receivedEncryptedSignature, 0, this._receivedEncryptedSignature, 0, this._sessionKey, this._receivedIV, this._receivedEncryptedSignature.length);
        byte[] signatureBytes = new byte[40];
        System.arraycopy(this._receivedEncryptedSignature, 0, signatureBytes, 0, 40);
        this._receivedSignature = new Signature(signatureBytes);
        if (this._log.shouldLog(10)) {
            this._log.debug("Decrypted received signature: \n" + Base64.encode((byte[])signatureBytes));
        }
    }

    private boolean verifySessionCreated() {
        byte[] signed = new byte[512 + this._aliceIP.length + 2 + this._bobIP.length + 2 + 4 + 4];
        int off = 0;
        System.arraycopy(this._sentX, 0, signed, off, this._sentX.length);
        System.arraycopy(this._receivedY, 0, signed, off += this._sentX.length, this._receivedY.length);
        System.arraycopy(this._aliceIP, 0, signed, off += this._receivedY.length, this._aliceIP.length);
        DataHelper.toLong((byte[])signed, (int)(off += this._aliceIP.length), (int)2, (long)this._alicePort);
        System.arraycopy(this._bobIP, 0, signed, off += 2, this._bobIP.length);
        DataHelper.toLong((byte[])signed, (int)(off += this._bobIP.length), (int)2, (long)this._bobPort);
        DataHelper.toLong((byte[])signed, (int)(off += 2), (int)4, (long)this._receivedRelayTag);
        DataHelper.toLong((byte[])signed, (int)(off += 4), (int)4, (long)this._receivedSignedOnTime);
        boolean valid = this._context.dsa().verifySignature(this._receivedSignature, signed, this._remotePeer.getSigningPublicKey());
        if (!valid || this._log.shouldLog(10)) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("Signed sessionCreated:");
            buf.append(" AliceIP: ").append(Base64.encode((byte[])this._aliceIP));
            buf.append(" AlicePort: ").append(this._alicePort);
            buf.append(" BobIP: ").append(Base64.encode((byte[])this._bobIP));
            buf.append(" BobPort: ").append(this._bobPort);
            buf.append(" RelayTag: ").append(this._receivedRelayTag);
            buf.append(" SignedOn: ").append(this._receivedSignedOnTime);
            buf.append(" signature: ").append(Base64.encode((byte[])this._receivedSignature.getData()));
            if (valid) {
                this._log.debug(buf.toString());
            } else if (this._log.shouldLog(30)) {
                this._log.warn("INVALID: " + buf.toString());
            }
        }
        return valid;
    }

    public synchronized SessionKey getCipherKey() {
        return this._sessionKey;
    }

    public synchronized SessionKey getMACKey() {
        return this._macKey;
    }

    public synchronized long getReceivedRelayTag() {
        return this._receivedRelayTag;
    }

    public synchronized long getSentSignedOnTime() {
        return this._sentSignedOnTime;
    }

    public synchronized long getReceivedSignedOnTime() {
        return this._receivedSignedOnTime;
    }

    public synchronized byte[] getReceivedIP() {
        return this._aliceIP;
    }

    public synchronized int getReceivedPort() {
        return this._alicePort;
    }

    public synchronized void prepareSessionConfirmed() {
        if (this._sentSignedOnTime > 0L) {
            return;
        }
        byte[] signed = new byte[512 + this._aliceIP.length + 2 + this._bobIP.length + 2 + 4 + 4];
        this._sentSignedOnTime = this._context.clock().now() / 1000L;
        int off = 0;
        System.arraycopy(this._sentX, 0, signed, off, this._sentX.length);
        System.arraycopy(this._receivedY, 0, signed, off += this._sentX.length, this._receivedY.length);
        System.arraycopy(this._aliceIP, 0, signed, off += this._receivedY.length, this._aliceIP.length);
        DataHelper.toLong((byte[])signed, (int)(off += this._aliceIP.length), (int)2, (long)this._alicePort);
        System.arraycopy(this._bobIP, 0, signed, off += 2, this._bobIP.length);
        DataHelper.toLong((byte[])signed, (int)(off += this._bobIP.length), (int)2, (long)this._bobPort);
        DataHelper.toLong((byte[])signed, (int)(off += 2), (int)4, (long)this._receivedRelayTag);
        DataHelper.toLong((byte[])signed, (int)(off += 4), (int)4, (long)this._sentSignedOnTime);
        this._sentSignature = this._context.dsa().sign(signed, this._context.keyManager().getSigningPrivateKey());
    }

    public synchronized Signature getSentSignature() {
        return this._sentSignature;
    }

    public synchronized void confirmedPacketsSent() {
        this._lastSend = this._context.clock().now();
        this._nextSend = this._lastSend + 1000L;
        if (this._log.shouldLog(10)) {
            this._log.debug("Send confirm packets, nextSend = 1s");
        }
        if (this._currentState == 0 || this._currentState == 1 || this._currentState == 2) {
            this._currentState = 3;
        }
    }

    public synchronized void requestSent() {
        this._lastSend = this._context.clock().now();
        this._nextSend = this._lastSend + 1000L;
        if (this._log.shouldLog(10)) {
            this._log.debug("Send a request packet, nextSend = 1s");
        }
        if (this._currentState == 0) {
            this._currentState = 1;
        }
    }

    public synchronized void introSent() {
        this._lastSend = this._context.clock().now();
        this._nextSend = this._lastSend + 1000L;
        if (this._currentState == 0) {
            this._currentState = 5;
        }
    }

    public synchronized void introductionFailed() {
        this._nextSend = this._context.clock().now();
    }

    public synchronized void introduced(InetAddress bob, byte[] bobIP, int bobPort) {
        if (this._currentState != 5) {
            return;
        }
        this._nextSend = this._context.clock().now() + 500L;
        if (this._currentState == 5) {
            this._currentState = 0;
        }
        this._bobIP = bobIP;
        this._bobPort = bobPort;
        this._remoteHostId = new RemoteHostId(bobIP, bobPort);
        if (this._log.shouldLog(20)) {
            this._log.info("Introduced to " + this._remoteHostId + ", now lets get on with establishing");
        }
    }

    public long getLifetime() {
        return this._context.clock().now() - this._establishBegin;
    }

    public long getEstablishBeginTime() {
        return this._establishBegin;
    }

    public synchronized long getNextSendTime() {
        return this._nextSend;
    }

    public synchronized void setNextSendTime(long when) {
        this._nextSend = when;
        if (this._log.shouldLog(10)) {
            this._log.debug("Explicit nextSend=" + (this._nextSend - this._context.clock().now()), (Throwable)new Exception("Set by"));
        }
    }

    RemoteHostId getRemoteHostId() {
        return this._remoteHostId;
    }

    public synchronized void dataReceived() {
        this.packetReceived();
        this._currentState = 4;
    }

    private void packetReceived() {
        this._nextSend = this._context.clock().now();
        if (this._log.shouldLog(10)) {
            this._log.debug("Got a packet, nextSend == now");
        }
    }
}

