/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.InboundMessageState;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class MessageReceiver {
    private RouterContext _context;
    private Log _log;
    private UDPTransport _transport;
    private final BlockingQueue<InboundMessageState> _completeMessages;
    private boolean _alive;
    private static final int THREADS = 5;
    private static final long POISON_IMS = -99999999999L;

    public MessageReceiver(RouterContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(MessageReceiver.class);
        this._transport = transport;
        this._completeMessages = new LinkedBlockingQueue<InboundMessageState>();
        this._context.statManager().createRateStat("udp.inboundExpired", "How many messages were expired before reception?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.inboundRemaining", "How many messages were remaining when a message is pulled off the complete queue?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.inboundReady", "How many messages were ready when a message is added to the complete queue?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.inboundReadTime", "How long it takes to parse in the completed fragments into a message?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.inboundReceiveProcessTime", "How long it takes to add the message to the transport?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.inboundLag", "How long the olded ready message has been sitting on the queue (period is the queue size)?", "udp", UDPTransport.RATES);
        this._alive = true;
    }

    public void startup() {
        this._alive = true;
        for (int i = 0; i < 5; ++i) {
            I2PThread t = new I2PThread((Runnable)new Runner(), "UDP message receiver " + i + '/' + 5, true);
            t.start();
        }
    }

    public void shutdown() {
        int i;
        this._alive = false;
        this._completeMessages.clear();
        for (i = 0; i < 5; ++i) {
            InboundMessageState ims = new InboundMessageState(this._context, -99999999999L, null);
            this._completeMessages.offer(ims);
        }
        for (i = 1; i <= 5 && !this._completeMessages.isEmpty(); ++i) {
            try {
                Thread.sleep(i * 50);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._completeMessages.clear();
    }

    public void receiveMessage(InboundMessageState state) {
        if (this._alive) {
            this._completeMessages.offer(state);
        }
    }

    public void loop(I2NPMessageHandler handler) {
        InboundMessageState message = null;
        ByteArray buf = new ByteArray(new byte[65536]);
        while (this._alive) {
            long afterRead;
            long before;
            int remaining;
            block12: {
                int expired = 0;
                long expiredLifetime = 0L;
                remaining = 0;
                try {
                    while (message == null) {
                        message = this._completeMessages.take();
                        if (message != null && message.getMessageId() == -99999999999L) {
                            message = null;
                            break;
                        }
                        if (message == null || !message.isExpired()) continue;
                        expiredLifetime += message.getLifetime();
                        message = null;
                        ++expired;
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (expired > 0) {
                    this._context.statManager().addRateData("udp.inboundExpired", (long)expired, expiredLifetime);
                }
                if (message == null) continue;
                before = System.currentTimeMillis();
                if (remaining > 0) {
                    this._context.statManager().addRateData("udp.inboundRemaining", (long)remaining, 0L);
                }
                int size = message.getCompleteSize();
                if (this._log.shouldLog(20)) {
                    this._log.info("Full message received (" + message.getMessageId() + ") after " + message.getLifetime());
                }
                afterRead = -1L;
                try {
                    I2NPMessage msg = this.readMessage(buf, message, handler);
                    afterRead = System.currentTimeMillis();
                    if (msg == null) break block12;
                    this._transport.messageReceived(msg, null, message.getFrom(), message.getLifetime(), size);
                }
                catch (RuntimeException re) {
                    this._log.error("b0rked receiving a message.. wazza huzza hmm?", (Throwable)re);
                    continue;
                }
            }
            message = null;
            long after = System.currentTimeMillis();
            if (afterRead - before > 100L) {
                this._context.statManager().addRateData("udp.inboundReadTime", afterRead - before, (long)remaining);
            }
            if (after - afterRead <= 100L) continue;
            this._context.statManager().addRateData("udp.inboundReceiveProcessTime", after - afterRead, (long)remaining);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private I2NPMessage readMessage(ByteArray buf, InboundMessageState state, I2NPMessageHandler handler) {
        try {
            ByteArray[] fragments = state.getFragments();
            int numFragments = state.getFragmentCount();
            int off = 0;
            for (int i = 0; i < numFragments; ++i) {
                System.arraycopy(fragments[i].getData(), 0, buf.getData(), off, fragments[i].getValid());
                if (this._log.shouldLog(10)) {
                    this._log.debug("Raw fragment[" + i + "] for " + state.getMessageId() + ": " + Base64.encode((byte[])fragments[i].getData(), (int)0, (int)fragments[i].getValid()) + " (valid: " + fragments[i].getValid() + " raw: " + Base64.encode((byte[])fragments[i].getData()) + ")");
                }
                off += fragments[i].getValid();
            }
            if (off != state.getCompleteSize()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Hmm, offset of the fragments = " + off + " while the state says " + state.getCompleteSize());
                }
                I2NPMessage i = null;
                return i;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Raw byte array for " + state.getMessageId() + ": " + Base64.encode((byte[])buf.getData(), (int)0, (int)state.getCompleteSize()));
            }
            I2NPMessage m = I2NPMessageImpl.fromRawByteArray(this._context, buf.getData(), 0, state.getCompleteSize(), handler);
            m.setUniqueId(state.getMessageId());
            I2NPMessage i2NPMessage = m;
            return i2NPMessage;
        }
        catch (I2NPMessageException ime) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Message invalid: " + state, (Throwable)((Object)ime));
            }
            this._context.messageHistory().droppedInboundMessage(state.getMessageId(), state.getFrom(), "error: " + ime.toString() + ": " + state.toString());
            I2NPMessage i2NPMessage = null;
            return i2NPMessage;
        }
        catch (Exception e) {
            this._log.log(50, "Error dealing with a message: " + state, (Throwable)e);
            this._context.messageHistory().droppedInboundMessage(state.getMessageId(), state.getFrom(), "error: " + e.toString() + ": " + state.toString());
            I2NPMessage i2NPMessage = null;
            return i2NPMessage;
        }
        finally {
            state.releaseResources();
        }
    }

    private class Runner
    implements Runnable {
        private I2NPMessageHandler _handler;

        public Runner() {
            this._handler = new I2NPMessageHandler(MessageReceiver.this._context);
        }

        public void run() {
            MessageReceiver.this.loop(this._handler);
        }
    }
}

