/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;

class InboundMessageState {
    private RouterContext _context;
    private Log _log;
    private long _messageId;
    private Hash _from;
    private ByteArray[] _fragments;
    private int _lastFragment;
    private long _receiveBegin;
    private int _completeSize;
    private boolean _released;
    private static final long MAX_RECEIVE_TIME = 10000L;
    public static final int MAX_FRAGMENTS = 64;
    private static final ByteCache _fragmentCache = ByteCache.getInstance((int)64, (int)2048);

    public InboundMessageState(RouterContext ctx, long messageId, Hash from) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(InboundMessageState.class);
        this._messageId = messageId;
        this._from = from;
        this._fragments = new ByteArray[64];
        this._lastFragment = -1;
        this._completeSize = -1;
        this._receiveBegin = ctx.clock().now();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean receiveFragment(UDPPacketReader.DataReader data, int dataFragment) {
        int fragmentNum = data.readMessageFragmentNum(dataFragment);
        if (fragmentNum < 0 || fragmentNum > this._fragments.length) {
            this._log.warn("Invalid fragment " + fragmentNum + "/" + this._fragments.length);
            return false;
        }
        if (this._fragments[fragmentNum] == null) {
            ByteArray message = _fragmentCache.acquire();
            try {
                data.readMessageFragment(dataFragment, message.getData(), 0);
                int size = data.readMessageFragmentSize(dataFragment);
                message.setValid(size);
                this._fragments[fragmentNum] = message;
                boolean isLast = data.readMessageIsLast(dataFragment);
                if (isLast) {
                    this._lastFragment = fragmentNum;
                }
                if (!this._log.shouldLog(10)) return true;
                this._log.debug("New fragment " + fragmentNum + " for message " + this._messageId + ", size=" + size + ", isLast=" + isLast + ", data=" + Base64.encode((byte[])message.getData(), (int)0, (int)size));
                return true;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                this._log.warn("Corrupt SSU fragment " + fragmentNum, (Throwable)aioobe);
                return false;
            }
        } else {
            if (!this._log.shouldLog(10)) return true;
            this._log.debug("Received fragment " + fragmentNum + " for message " + this._messageId + " again, old size=" + this._fragments[fragmentNum].getValid() + " and new size=" + data.readMessageFragmentSize(dataFragment));
        }
        return true;
    }

    public boolean isComplete() {
        if (this._lastFragment < 0) {
            return false;
        }
        for (int i = 0; i <= this._lastFragment; ++i) {
            if (this._fragments[i] != null) continue;
            return false;
        }
        return true;
    }

    public boolean isExpired() {
        return this._context.clock().now() > this._receiveBegin + 10000L;
    }

    public long getLifetime() {
        return this._context.clock().now() - this._receiveBegin;
    }

    public Hash getFrom() {
        return this._from;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public int getCompleteSize() {
        if (this._completeSize < 0) {
            int size = 0;
            for (int i = 0; i <= this._lastFragment; ++i) {
                size += this._fragments[i].getValid();
            }
            this._completeSize = size;
        }
        return this._completeSize;
    }

    public ACKBitfield createACKBitfield() {
        return new PartialBitfield(this._messageId, this._fragments);
    }

    public void releaseResources() {
        if (this._fragments != null) {
            for (int i = 0; i < this._fragments.length; ++i) {
                _fragmentCache.release(this._fragments[i]);
            }
        }
        this._released = true;
    }

    public ByteArray[] getFragments() {
        if (this._released) {
            RuntimeException e = new RuntimeException("Use after free: " + this.toString());
            this._log.error("SSU IMS", (Throwable)e);
            throw e;
        }
        return this._fragments;
    }

    public int getFragmentCount() {
        return this._lastFragment + 1;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("IB Message: ").append(this._messageId);
        if (this.isComplete()) {
            buf.append(" completely received with ");
            buf.append(this.getCompleteSize()).append(" bytes");
        } else {
            for (int i = 0; this._fragments != null && i < this._fragments.length; ++i) {
                buf.append(" fragment ").append(i);
                if (this._fragments[i] != null) {
                    buf.append(": known at size ").append(this._fragments[i].getValid());
                    continue;
                }
                buf.append(": unknown");
            }
        }
        buf.append(" lifetime: ").append(this.getLifetime());
        return buf.toString();
    }

    private static final class PartialBitfield
    implements ACKBitfield {
        private long _bitfieldMessageId;
        private boolean[] _fragmentsReceived;

        public PartialBitfield(long messageId, Object[] data) {
            this._bitfieldMessageId = messageId;
            for (int i = data.length - 1; i >= 0; --i) {
                if (data[i] == null) continue;
                if (this._fragmentsReceived == null) {
                    this._fragmentsReceived = new boolean[i + 1];
                }
                this._fragmentsReceived[i] = true;
            }
            if (this._fragmentsReceived == null) {
                this._fragmentsReceived = new boolean[0];
            }
        }

        public int fragmentCount() {
            return this._fragmentsReceived.length;
        }

        public long getMessageId() {
            return this._bitfieldMessageId;
        }

        public boolean received(int fragmentNum) {
            if (fragmentNum < 0 || fragmentNum >= this._fragmentsReceived.length) {
                return false;
            }
            return this._fragmentsReceived[fragmentNum];
        }

        public boolean receivedComplete() {
            return false;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("Partial ACK of ");
            buf.append(this._bitfieldMessageId);
            buf.append(" with ACKs for: ");
            for (int i = 0; i < this._fragmentsReceived.length; ++i) {
                if (!this._fragmentsReceived[i]) continue;
                buf.append(i).append(" ");
            }
            return buf.toString();
        }
    }
}

