/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.ACKSender;
import net.i2p.router.transport.udp.InboundMessageState;
import net.i2p.router.transport.udp.MessageReceiver;
import net.i2p.router.transport.udp.OutboundMessageFragments;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.DecayingBloomFilter;
import net.i2p.util.DecayingHashSet;
import net.i2p.util.Log;

class InboundMessageFragments {
    private RouterContext _context;
    private Log _log;
    private DecayingBloomFilter _recentlyCompletedMessages;
    private OutboundMessageFragments _outbound;
    private UDPTransport _transport;
    private ACKSender _ackSender;
    private MessageReceiver _messageReceiver;
    private boolean _alive;
    private static final int DECAY_PERIOD = 10000;

    public InboundMessageFragments(RouterContext ctx, OutboundMessageFragments outbound, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(InboundMessageFragments.class);
        this._outbound = outbound;
        this._transport = transport;
        this._ackSender = new ACKSender(this._context, this._transport);
        this._messageReceiver = new MessageReceiver(this._context, this._transport);
        this._context.statManager().createRateStat("udp.receivedCompleteTime", "How long it takes to receive a full message", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivedCompleteFragments", "How many fragments go in a fully received message", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivedACKs", "How many messages were ACKed at a time", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.ignoreRecentDuplicate", "Take note that we received a packet for a recently completed message", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveMessagePeriod", "How long it takes to pull the message fragments out of a packet", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveACKPeriod", "How long it takes to pull the ACKs out of a packet", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePiggyback", "How many acks were included in a packet with data fragments (time == # data fragments)", "udp", UDPTransport.RATES);
    }

    public void startup() {
        this._alive = true;
        this._recentlyCompletedMessages = new DecayingHashSet((I2PAppContext)this._context, 10000, 4, "UDPIMF");
        this._ackSender.startup();
        this._messageReceiver.startup();
    }

    public void shutdown() {
        this._alive = false;
        if (this._recentlyCompletedMessages != null) {
            this._recentlyCompletedMessages.stopDecaying();
        }
        this._recentlyCompletedMessages = null;
        this._ackSender.shutdown();
        this._messageReceiver.shutdown();
    }

    public boolean isAlive() {
        return this._alive;
    }

    public void receiveData(PeerState from, UDPPacketReader.DataReader data) {
        long beforeMsgs = this._context.clock().now();
        int fragmentsIncluded = this.receiveMessages(from, data);
        long afterMsgs = this._context.clock().now();
        int acksIncluded = this.receiveACKs(from, data);
        long afterACKs = this._context.clock().now();
        from.packetReceived(data.getPacketSize());
        this._context.statManager().addRateData("udp.receiveMessagePeriod", afterMsgs - beforeMsgs, afterACKs - beforeMsgs);
        this._context.statManager().addRateData("udp.receiveACKPeriod", afterACKs - afterMsgs, afterACKs - beforeMsgs);
        if (fragmentsIncluded > 0 && acksIncluded > 0) {
            this._context.statManager().addRateData("udp.receivePiggyback", (long)acksIncluded, (long)fragmentsIncluded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receiveMessages(PeerState from, UDPPacketReader.DataReader data) {
        int fragments = data.readFragmentCount();
        if (fragments <= 0) {
            return fragments;
        }
        Hash fromPeer = from.getRemotePeer();
        Map<Long, InboundMessageState> messages = from.getInboundMessages();
        for (int i = 0; i < fragments; ++i) {
            long mid = data.readMessageId(i);
            Long messageId = new Long(mid);
            if (this._recentlyCompletedMessages.isKnown(mid)) {
                this._context.statManager().addRateData("udp.ignoreRecentDuplicate", 1L, 0L);
                from.messageFullyReceived(messageId, -1);
                this._ackSender.ackPeer(from);
                if (this._log.shouldLog(20)) {
                    this._log.info("Message received is a dup: " + mid + " dups: " + this._recentlyCompletedMessages.getCurrentDuplicateCount() + " out of " + this._recentlyCompletedMessages.getInsertedCount());
                }
                this._context.messageHistory().droppedInboundMessage(mid, from.getRemotePeer(), "dup");
                continue;
            }
            int size = data.readMessageFragmentSize(i);
            InboundMessageState state = null;
            boolean messageComplete = false;
            boolean messageExpired = false;
            boolean fragmentOK = false;
            boolean partialACK = false;
            Map<Long, InboundMessageState> map = messages;
            synchronized (map) {
                state = messages.get(messageId);
                if (state == null) {
                    state = new InboundMessageState(this._context, mid, fromPeer);
                    messages.put(messageId, state);
                }
                fragmentOK = state.receiveFragment(data, i);
                if (state.isComplete()) {
                    messageComplete = true;
                    messages.remove(messageId);
                } else if (state.isExpired()) {
                    messageExpired = true;
                    messages.remove(messageId);
                } else {
                    partialACK = true;
                }
            }
            if (messageComplete) {
                this._recentlyCompletedMessages.add(mid);
                this._messageReceiver.receiveMessage(state);
                from.messageFullyReceived(messageId, state.getCompleteSize());
                this._ackSender.ackPeer(from);
                if (this._log.shouldLog(20)) {
                    this._log.info("Message received completely!  " + state);
                }
                this._context.statManager().addRateData("udp.receivedCompleteTime", state.getLifetime(), state.getLifetime());
                if (state.getFragmentCount() > 0) {
                    this._context.statManager().addRateData("udp.receivedCompleteFragments", (long)state.getFragmentCount(), state.getLifetime());
                }
            } else if (messageExpired) {
                state.releaseResources();
                if (this._log.shouldLog(30)) {
                    this._log.warn("Message expired while only being partially read: " + state);
                }
                this._context.messageHistory().droppedInboundMessage(state.getMessageId(), state.getFrom(), "expired hile partially read: " + state.toString());
            } else if (partialACK) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Queueing up a partial ACK for peer: " + from + " for " + state);
                }
                from.messagePartiallyReceived();
                this._ackSender.ackPeer(from);
            }
            if (!fragmentOK) break;
        }
        from.expireInboundMessages();
        return fragments;
    }

    private int receiveACKs(PeerState from, UDPPacketReader.DataReader data) {
        ACKBitfield[] bitfields;
        int rv = 0;
        if (data.readACKsIncluded()) {
            int fragments = 0;
            int ackCount = data.readACKCount();
            if (ackCount > 0) {
                rv += ackCount;
                this._context.statManager().addRateData("udp.receivedACKs", (long)ackCount, 0L);
                for (int i = 0; i < ackCount; ++i) {
                    long id = data.readACK(i);
                    if (this._log.shouldLog(20)) {
                        this._log.info("Full ACK of message " + id + " received!");
                    }
                    fragments += this._outbound.acked(id, from.getRemotePeer());
                }
            } else {
                this._log.error("Received ACKs with no acks?! " + data);
            }
        }
        if (data.readACKBitfieldsIncluded() && (bitfields = data.readACKBitfields()) != null) {
            rv += bitfields.length;
            for (int i = 0; i < bitfields.length; ++i) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Partial ACK received: " + bitfields[i]);
                }
                this._outbound.acked(bitfields[i], from.getRemotePeer());
            }
        }
        if (data.readECN()) {
            from.ECNReceived();
        } else {
            from.dataReceived();
        }
        return rv;
    }
}

