/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.Adler32;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.ntcp.EstablishState;
import net.i2p.router.transport.ntcp.NTCPAddress;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

public class NTCPConnection
implements FIFOBandwidthLimiter.CompleteListener {
    private RouterContext _context;
    private Log _log;
    private SocketChannel _chan;
    private SelectionKey _conKey;
    private final LinkedBlockingQueue<ByteBuffer> _readBufs;
    private final LinkedBlockingQueue<ByteBuffer> _writeBufs;
    private final Set<FIFOBandwidthLimiter.Request> _bwRequests;
    private boolean _established;
    private long _establishedOn;
    private EstablishState _establishState;
    private NTCPTransport _transport;
    private boolean _isInbound;
    private boolean _closed;
    private NTCPAddress _remAddr;
    private RouterIdentity _remotePeer;
    private long _clockSkew;
    private final LinkedBlockingQueue<OutNetMessage> _outbound;
    private OutNetMessage _currentOutbound;
    private SessionKey _sessionKey;
    private byte[] _curReadBlock;
    private int _curReadBlockIndex;
    private byte[] _decryptBlockBuf;
    private byte[] _prevReadBlock;
    private byte[] _prevWriteEnd;
    private ReadState _curReadState;
    private long _messagesRead;
    private long _messagesWritten;
    private long _lastSendTime;
    private long _lastReceiveTime;
    private long _created;
    private long _nextMetaTime;
    private final byte[] _meta = new byte[16];
    private boolean _sendingMeta;
    private int _consecutiveBacklog;
    private long _nextInfoTime;
    private static final int META_FREQUENCY = 600000;
    private static final int INFO_FREQUENCY = 5400000;
    public static final int BUFFER_SIZE = 16384;
    public static final int MAX_MSG_SIZE = 16378;
    private static final boolean FAST_LARGE = true;
    private static final int MIN_PREP_BUFS = 5;
    private static int NUM_PREP_BUFS = 5;
    private static int __liveBufs = 0;
    private static int __consecutiveExtra;
    private static final List _bufs;
    private long _bytesReceived;
    private long _bytesSent;
    private long _lastBytesReceived;
    private long _lastBytesSent;
    private long _lastRateUpdated;
    private float _sendBps;
    private float _recvBps;
    private float _sendBps15s;
    private float _recvBps15s;
    private static final int MAX_HANDLERS = 4;
    private static final LinkedBlockingQueue<I2NPMessageHandler> _i2npHandlers;
    private static final int MAX_DATA_READ_BUFS = 16;
    private static final LinkedBlockingQueue<DataBuf> _dataReadBufs;

    public NTCPConnection(RouterContext ctx, NTCPTransport transport, SocketChannel chan, SelectionKey key) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._lastSendTime = this._created = System.currentTimeMillis();
        this._lastReceiveTime = this._created;
        this._transport = transport;
        this._chan = chan;
        this._readBufs = new LinkedBlockingQueue();
        this._writeBufs = new LinkedBlockingQueue();
        this._bwRequests = new ConcurrentHashSet(2);
        this._outbound = new LinkedBlockingQueue();
        this._established = false;
        this._isInbound = true;
        this._closed = false;
        this._decryptBlockBuf = new byte[16];
        this._curReadBlock = new byte[16];
        this._prevReadBlock = new byte[16];
        this._curReadState = new ReadState();
        this._establishState = new EstablishState(ctx, transport, this);
        this._conKey = key;
        this._conKey.attach(this);
        this._sendingMeta = false;
        this._consecutiveBacklog = 0;
        transport.establishing(this);
    }

    public NTCPConnection(RouterContext ctx, NTCPTransport transport, RouterIdentity remotePeer, NTCPAddress remAddr) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._lastSendTime = this._created = System.currentTimeMillis();
        this._lastReceiveTime = this._created;
        this._transport = transport;
        this._remAddr = remAddr;
        this._readBufs = new LinkedBlockingQueue();
        this._writeBufs = new LinkedBlockingQueue();
        this._bwRequests = new ConcurrentHashSet(2);
        this._outbound = new LinkedBlockingQueue();
        this._established = false;
        this._isInbound = false;
        this._closed = false;
        this._decryptBlockBuf = new byte[16];
        this._curReadBlock = new byte[16];
        this._prevReadBlock = new byte[16];
        this._curReadState = new ReadState();
        this._remotePeer = remotePeer;
        this._sendingMeta = false;
        this._consecutiveBacklog = 0;
        transport.establishing(this);
    }

    public SocketChannel getChannel() {
        return this._chan;
    }

    public SelectionKey getKey() {
        return this._conKey;
    }

    public void setChannel(SocketChannel chan) {
        this._chan = chan;
    }

    public void setKey(SelectionKey key) {
        this._conKey = key;
    }

    public boolean isInbound() {
        return this._isInbound;
    }

    public boolean isEstablished() {
        return this._established;
    }

    public EstablishState getEstablishState() {
        return this._establishState;
    }

    public NTCPAddress getRemoteAddress() {
        return this._remAddr;
    }

    public RouterIdentity getRemotePeer() {
        return this._remotePeer;
    }

    public void setRemotePeer(RouterIdentity ident) {
        this._remotePeer = ident;
    }

    public void finishInboundEstablishment(SessionKey key, long clockSkew, byte[] prevWriteEnd, byte[] prevReadEnd) {
        this._sessionKey = key;
        this._clockSkew = clockSkew;
        this._prevWriteEnd = prevWriteEnd;
        System.arraycopy(prevReadEnd, prevReadEnd.length - 16, this._prevReadBlock, 0, this._prevReadBlock.length);
        if (this._log.shouldLog(10)) {
            this._log.debug("Inbound established, prevWriteEnd: " + Base64.encode((byte[])prevWriteEnd) + " prevReadEnd: " + Base64.encode((byte[])prevReadEnd));
        }
        this._established = true;
        this._establishedOn = System.currentTimeMillis();
        this._transport.inboundEstablished(this);
        this._establishState = null;
        this._nextMetaTime = System.currentTimeMillis() + (long)this._context.random().nextInt(600000);
        this._nextInfoTime = System.currentTimeMillis() + 2700000L + (long)this._context.random().nextInt(5400000);
    }

    public long getClockSkew() {
        return this._clockSkew;
    }

    public long getUptime() {
        if (!this._established) {
            return this.getTimeSinceCreated();
        }
        return System.currentTimeMillis() - this._establishedOn;
    }

    public long getMessagesSent() {
        return this._messagesWritten;
    }

    public long getMessagesReceived() {
        return this._messagesRead;
    }

    public long getOutboundQueueSize() {
        int queued = this._outbound.size();
        if (this._currentOutbound != null) {
            ++queued;
        }
        return queued;
    }

    public long getTimeSinceSend() {
        return System.currentTimeMillis() - this._lastSendTime;
    }

    public long getTimeSinceReceive() {
        return System.currentTimeMillis() - this._lastReceiveTime;
    }

    public long getTimeSinceCreated() {
        return System.currentTimeMillis() - this._created;
    }

    public int getConsecutiveBacklog() {
        return this._consecutiveBacklog;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean allowRequeue) {
        Object buf;
        OutNetMessage msg;
        if (this._log.shouldLog(20)) {
            this._log.info("Closing connection " + this.toString(), (Throwable)new Exception("cause"));
        }
        this._closed = true;
        if (this._chan != null) {
            try {
                this._chan.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (this._conKey != null) {
            this._conKey.cancel();
        }
        this._establishState = null;
        this._transport.removeCon(this);
        this._transport.getReader().connectionClosed(this);
        this._transport.getWriter().connectionClosed(this);
        Iterator<FIFOBandwidthLimiter.Request> iter = this._bwRequests.iterator();
        while (iter.hasNext()) {
            iter.next().abort();
        }
        this._bwRequests.clear();
        while ((msg = this._outbound.poll()) != null) {
            buf = msg.releasePreparationBuffer();
            if (buf != null) {
                this.releaseBuf((PrepBuffer)buf);
            }
            this._transport.afterSend(msg, false, allowRequeue, msg.getLifetime());
        }
        msg = this._currentOutbound;
        if (msg != null) {
            buf = msg.releasePreparationBuffer();
            if (buf != null) {
                this.releaseBuf((PrepBuffer)buf);
            }
            this._transport.afterSend(msg, false, allowRequeue, msg.getLifetime());
        }
    }

    public void send(OutNetMessage msg) {
        if (this.tooBacklogged()) {
            boolean allowRequeue = false;
            boolean successful = false;
            ++this._consecutiveBacklog;
            this._transport.afterSend(msg, successful, allowRequeue, msg.getLifetime());
            if (this._consecutiveBacklog > 10) {
                boolean wantsWrite = false;
                try {
                    wantsWrite = (this._conKey.interestOps() & 4) != 0;
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this._log.shouldLog(30)) {
                    int blocks = this._writeBufs.size();
                    this._log.warn("Too backlogged for too long (" + this._consecutiveBacklog + " messages for " + DataHelper.formatDuration((long)this.queueTime()) + ", sched? " + wantsWrite + ", blocks: " + blocks + ") sending to " + this._remotePeer.calculateHash().toBase64());
                }
                this._context.statManager().addRateData("ntcp.closeOnBacklog", this.getUptime(), this.getUptime());
                this.close();
            }
            this._context.statManager().addRateData("ntcp.dontSendOnBacklog", (long)this._consecutiveBacklog, msg.getLifetime());
            return;
        }
        this._consecutiveBacklog = 0;
        int enqueued = 0;
        this.bufferedPrepare(msg);
        boolean noOutbound = false;
        this._outbound.offer(msg);
        enqueued = this._outbound.size();
        msg.setQueueSize(enqueued);
        boolean bl = noOutbound = this._currentOutbound == null;
        if (this._log.shouldLog(10)) {
            this._log.debug("messages enqueued on " + this.toString() + ": " + enqueued + " new one: " + msg.getMessageId() + " of " + msg.getMessageType());
        }
        if (this._established && noOutbound) {
            this._transport.getWriter().wantsWrite(this, "enqueued");
        }
    }

    private long queueTime() {
        OutNetMessage msg = this._currentOutbound;
        if (msg == null && (msg = this._outbound.peek()) == null) {
            return 0L;
        }
        return msg.getSendTime();
    }

    public boolean tooBacklogged() {
        boolean currentOutboundSet;
        long queueTime = this.queueTime();
        if (queueTime <= 0L) {
            return false;
        }
        boolean bl = currentOutboundSet = this._currentOutbound != null;
        if (this.getUptime() < 10000L) {
            return false;
        }
        if (queueTime > 5000L) {
            int size = this._outbound.size();
            if (this._log.shouldLog(30)) {
                int writeBufs = this._writeBufs.size();
                try {
                    this._log.warn("Too backlogged: queue time " + queueTime + " and the size is " + size + ", wantsWrite? " + (0 != (this._conKey.interestOps() & 4)) + ", currentOut set? " + currentOutboundSet + ", writeBufs: " + writeBufs + " on " + this.toString());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this._context.statManager().addRateData("ntcp.sendBacklogTime", queueTime, (long)size);
            return true;
        }
        return false;
    }

    public void enqueueInfoMessage() {
        OutNetMessage infoMsg = new OutNetMessage(this._context);
        infoMsg.setExpiration(this._context.clock().now() + 10000L);
        DatabaseStoreMessage dsm = new DatabaseStoreMessage(this._context);
        dsm.setKey(this._context.routerHash());
        dsm.setRouterInfo(this._context.router().getRouterInfo());
        infoMsg.setMessage(dsm);
        infoMsg.setPriority(100);
        RouterInfo target = this._context.netDb().lookupRouterInfoLocally(this._remotePeer.calculateHash());
        if (target != null) {
            infoMsg.setTarget(target);
            infoMsg.beginSend();
            this._context.statManager().addRateData("ntcp.infoMessageEnqueued", 1L, 0L);
            this.send(infoMsg);
        } else if (this._isInbound) {
            // empty if block
        }
    }

    public void finishOutboundEstablishment(SessionKey key, long clockSkew, byte[] prevWriteEnd, byte[] prevReadEnd) {
        if (this._log.shouldLog(10)) {
            this._log.debug("outbound established (key=" + key + " skew=" + clockSkew + " prevWriteEnd=" + Base64.encode((byte[])prevWriteEnd) + ")");
        }
        this._sessionKey = key;
        this._clockSkew = clockSkew;
        this._prevWriteEnd = prevWriteEnd;
        System.arraycopy(prevReadEnd, prevReadEnd.length - 16, this._prevReadBlock, 0, this._prevReadBlock.length);
        if (this._log.shouldLog(10)) {
            this._log.debug("Outbound established, prevWriteEnd: " + Base64.encode((byte[])prevWriteEnd) + " prevReadEnd: " + Base64.encode((byte[])prevReadEnd));
        }
        this._established = true;
        this._establishedOn = System.currentTimeMillis();
        this._establishState = null;
        this._transport.markReachable(this.getRemotePeer().calculateHash(), false);
        boolean msgs = !this._outbound.isEmpty();
        this._nextMetaTime = System.currentTimeMillis() + (long)this._context.random().nextInt(600000);
        this._nextInfoTime = System.currentTimeMillis() + 2700000L + (long)this._context.random().nextInt(5400000);
        if (msgs) {
            this._transport.getWriter().wantsWrite(this, "outbound established");
        }
    }

    synchronized void prepareNextWrite() {
        this.prepareNextWriteFast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void prepareNextWriteFast() {
        if (this._log.shouldLog(10)) {
            this._log.debug("prepare next write w/ isInbound? " + this._isInbound + " established? " + this._established);
        }
        if (!this._isInbound && !this._established) {
            if (this._establishState == null) {
                this._establishState = new EstablishState(this._context, this._transport, this);
                this._establishState.prepareOutbound();
            } else if (this._log.shouldLog(10)) {
                this._log.debug("prepare next write, but we have already prepared the first outbound and we are not yet established..." + this.toString());
            }
            return;
        }
        if (this._nextMetaTime <= System.currentTimeMillis()) {
            this.sendMeta();
            this._nextMetaTime = System.currentTimeMillis() + 600000L + (long)this._context.random().nextInt(600000);
        }
        OutNetMessage msg = null;
        LinkedBlockingQueue<OutNetMessage> linkedBlockingQueue = this._outbound;
        synchronized (linkedBlockingQueue) {
            if (this._currentOutbound != null) {
                if (this._log.shouldLog(20)) {
                    this._log.info("attempt for multiple outbound messages with " + System.identityHashCode(this._currentOutbound) + " already waiting and " + this._outbound.size() + " queued");
                }
                return;
            }
            if (this.queueTime() > 3000L) {
                msg = this._outbound.poll();
                if (msg == null) {
                    return;
                }
            } else {
                boolean removed;
                int slot = 0;
                Iterator<OutNetMessage> it = this._outbound.iterator();
                for (int i = 0; it.hasNext() && i < 75; ++i) {
                    OutNetMessage mmsg = it.next();
                    if (msg != null && mmsg.getPriority() <= msg.getPriority()) continue;
                    msg = mmsg;
                    slot = i;
                }
                if (msg == null) {
                    return;
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("Type " + msg.getMessage().getType() + " pri " + msg.getPriority() + " slot " + slot);
                }
                if (!(removed = this._outbound.remove(msg)) && this._log.shouldLog(30)) {
                    this._log.warn("Already removed??? " + msg.getMessage().getType());
                }
            }
            this._currentOutbound = msg;
        }
        msg.beginTransmission();
        long begin = System.currentTimeMillis();
        PrepBuffer buf = (PrepBuffer)msg.releasePreparationBuffer();
        if (buf == null) {
            throw new RuntimeException("buf is null for " + msg);
        }
        this._context.aes().encrypt(buf.unencrypted, 0, buf.encrypted, 0, this._sessionKey, this._prevWriteEnd, 0, buf.unencryptedLength);
        System.arraycopy(buf.encrypted, buf.encrypted.length - 16, this._prevWriteEnd, 0, this._prevWriteEnd.length);
        long encryptedTime = System.currentTimeMillis();
        this._transport.getPumper().wantsWrite(this, buf.encrypted);
        long wantsTime = System.currentTimeMillis();
        this.releaseBuf(buf);
        long releaseTime = System.currentTimeMillis();
        if (this._log.shouldLog(10)) {
            this._log.debug("prepared outbound " + System.identityHashCode(msg) + " encrypted=" + (encryptedTime - begin) + " wantsWrite=" + (wantsTime - encryptedTime) + " releaseBuf=" + (releaseTime - wantsTime));
        }
        if (this._nextInfoTime <= System.currentTimeMillis()) {
            this.enqueueInfoMessage();
            this._nextInfoTime = System.currentTimeMillis() + 2700000L + (long)this._context.random().nextInt(5400000);
        }
    }

    private void bufferedPrepare(OutNetMessage msg) {
        msg.beginPrepare();
        long begin = System.currentTimeMillis();
        PrepBuffer buf = this.acquireBuf();
        long alloc = System.currentTimeMillis();
        I2NPMessage m = msg.getMessage();
        int sz = buf.baseLength = m.toByteArray(buf.base);
        int min = 2 + sz + 4;
        int rem = min % 16;
        int padding = 0;
        if (rem > 0) {
            padding = 16 - rem;
        }
        buf.padLength = padding;
        buf.unencryptedLength = min + padding;
        DataHelper.toLong((byte[])buf.unencrypted, (int)0, (int)2, (long)sz);
        System.arraycopy(buf.base, 0, buf.unencrypted, 2, buf.baseLength);
        if (padding > 0) {
            this._context.random().nextBytes(buf.pad);
        }
        System.arraycopy(buf.pad, 0, buf.unencrypted, 2 + sz, buf.padLength);
        long serialized = System.currentTimeMillis();
        buf.crc.update(buf.unencrypted, 0, buf.unencryptedLength - 4);
        long val = buf.crc.getValue();
        if (this._log.shouldLog(10)) {
            this._log.debug("Outbound message " + this._messagesWritten + " has crc " + val + " sz=" + sz + " rem=" + rem + " padding=" + padding);
        }
        DataHelper.toLong((byte[])buf.unencrypted, (int)(buf.unencryptedLength - 4), (int)4, (long)val);
        buf.encrypted = new byte[buf.unencryptedLength];
        long crced = System.currentTimeMillis();
        msg.prepared(buf);
        if (this._log.shouldLog(10)) {
            this._log.debug("Buffered prepare took " + (crced - begin) + ", alloc=" + (alloc - begin) + " serialize=" + (serialized - alloc) + " crc=" + (crced - serialized));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrepBuffer acquireBuf() {
        List list = _bufs;
        synchronized (list) {
            if (!_bufs.isEmpty()) {
                PrepBuffer b = (PrepBuffer)_bufs.remove(0);
                b.acquired();
                return b;
            }
        }
        PrepBuffer b = new PrepBuffer();
        b.init();
        NUM_PREP_BUFS = ++__liveBufs;
        if (this._log.shouldLog(10)) {
            this._log.debug("creating a new prep buffer with " + __liveBufs + " live");
        }
        this._context.statManager().addRateData("ntcp.prepBufCache", (long)NUM_PREP_BUFS, 0L);
        b.acquired();
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBuf(PrepBuffer buf) {
        buf.init();
        long lifetime = buf.lifetime();
        int extra = 0;
        boolean cached = false;
        List list = _bufs;
        synchronized (list) {
            if (_bufs.size() < NUM_PREP_BUFS) {
                extra = _bufs.size();
                _bufs.add(buf);
                cached = true;
                if (extra > 5 && ++__consecutiveExtra >= 20) {
                    NUM_PREP_BUFS = Math.max(NUM_PREP_BUFS - 1, 5);
                    __consecutiveExtra = 0;
                }
            } else {
                buf.unencrypted = null;
                buf.base = null;
                buf.pad = null;
                buf.crc = null;
                --__liveBufs;
            }
        }
        if (cached && this._log.shouldLog(10)) {
            this._log.debug("releasing cached buffer with " + __liveBufs + " live after " + lifetime);
        }
    }

    public void outboundConnected() {
        this._conKey.interestOps(1);
        this._transport.getWriter().wantsWrite(this, "outbound connected");
    }

    public void complete(FIFOBandwidthLimiter.Request req) {
        this.removeRequest(req);
        ByteBuffer buf = (ByteBuffer)req.attachment();
        if (req.getTotalInboundRequested() > 0) {
            this._context.statManager().addRateData("ntcp.throttledReadComplete", System.currentTimeMillis() - req.getRequestTime(), 0L);
            this.recv(buf);
            this._transport.getPumper().wantsRead(this);
        } else if (req.getTotalOutboundRequested() > 0) {
            this._context.statManager().addRateData("ntcp.throttledWriteComplete", System.currentTimeMillis() - req.getRequestTime(), 0L);
            this.write(buf);
        }
    }

    private void removeRequest(FIFOBandwidthLimiter.Request req) {
        this._bwRequests.remove(req);
    }

    private void addRequest(FIFOBandwidthLimiter.Request req) {
        this._bwRequests.add(req);
    }

    public void queuedRecv(ByteBuffer buf, FIFOBandwidthLimiter.Request req) {
        this.addRequest(req);
        req.attach(buf);
        req.setCompleteListener(this);
    }

    public void queuedWrite(ByteBuffer buf, FIFOBandwidthLimiter.Request req) {
        this.addRequest(req);
        req.attach(buf);
        req.setCompleteListener(this);
    }

    public void recv(ByteBuffer buf) {
        this._bytesReceived += (long)buf.remaining();
        this._readBufs.offer(buf);
        this._transport.getReader().wantsRead(this);
        this.updateStats();
    }

    public void write(ByteBuffer buf) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Before write(buf)");
        }
        this._writeBufs.offer(buf);
        if (this._log.shouldLog(10)) {
            this._log.debug("After write(buf)");
        }
        this._transport.getPumper().wantsWrite(this);
    }

    public ByteBuffer getNextReadBuf() {
        return this._readBufs.poll();
    }

    public void removeReadBuf(ByteBuffer buf) {
        this._readBufs.remove(buf);
    }

    public int getWriteBufCount() {
        return this._writeBufs.size();
    }

    public ByteBuffer getNextWriteBuf() {
        return this._writeBufs.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriteBuf(ByteBuffer buf) {
        boolean msgs;
        this._bytesSent += (long)buf.capacity();
        OutNetMessage msg = null;
        boolean bufsRemain = false;
        boolean clearMessage = false;
        if (this._sendingMeta && buf.capacity() == this._meta.length) {
            this._sendingMeta = false;
        } else {
            clearMessage = true;
        }
        this._writeBufs.remove(buf);
        boolean bl = bufsRemain = !this._writeBufs.isEmpty();
        if (clearMessage) {
            LinkedBlockingQueue<OutNetMessage> linkedBlockingQueue = this._outbound;
            synchronized (linkedBlockingQueue) {
                if (this._currentOutbound != null) {
                    msg = this._currentOutbound;
                }
                this._currentOutbound = null;
            }
            if (msg != null) {
                this._lastSendTime = System.currentTimeMillis();
                this._context.statManager().addRateData("ntcp.sendTime", msg.getSendTime(), msg.getSendTime());
                this._context.statManager().addRateData("ntcp.transmitTime", msg.getTransmissionTime(), msg.getTransmissionTime());
                this._context.statManager().addRateData("ntcp.sendQueueSize", (long)msg.getQueueSize(), msg.getLifetime());
                if (this._log.shouldLog(20)) {
                    this._log.info("I2NP message " + this._messagesWritten + "/" + msg.getMessageId() + " sent after " + msg.getSendTime() + "/" + msg.getTransmissionTime() + "/" + msg.getPreparationTime() + "/" + msg.getLifetime() + " queued after " + msg.getQueueSize() + " with " + buf.capacity() + " bytes (uid=" + System.identityHashCode(msg) + " on " + this.toString() + ")");
                }
                ++this._messagesWritten;
                this._transport.sendComplete(msg);
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("I2NP meta message sent completely");
        }
        boolean bl2 = msgs = !this._outbound.isEmpty() || this._currentOutbound != null;
        if (msgs) {
            this._transport.getWriter().wantsWrite(this, "write completed");
        }
        if (bufsRemain) {
            this._transport.getPumper().wantsWrite(this);
        }
        this.updateStats();
    }

    public float getSendRate() {
        return this._sendBps15s;
    }

    public float getRecvRate() {
        return this._recvBps15s;
    }

    private void updateStats() {
        long now = System.currentTimeMillis();
        long time = now - this._lastRateUpdated;
        if (time >= 1000L) {
            long totS = this._bytesSent;
            long totR = this._bytesReceived;
            long sent = totS - this._lastBytesSent;
            long recv = totR - this._lastBytesReceived;
            this._lastBytesSent = totS;
            this._lastBytesReceived = totR;
            this._lastRateUpdated = now;
            this._sendBps = 0.9f * this._sendBps + 0.1f * ((float)sent * 1000.0f) / (float)time;
            this._recvBps = 0.9f * this._recvBps + 0.1f * ((float)recv * 1000.0f) / (float)time;
            this._sendBps15s = 0.955f * this._sendBps15s + 0.045f * ((float)sent * 1000.0f) / (float)time;
            this._recvBps15s = 0.955f * this._recvBps15s + 0.045f * ((float)recv * 1000.0f) / (float)time;
            if (this._log.shouldLog(10)) {
                this._log.debug("Rates updated to " + this._sendBps + "/" + this._recvBps + "Bps in/out (" + this._sendBps15s + "/" + this._recvBps15s + "Bps in/out 15s) after " + sent + "/" + recv + " in " + time);
            }
        }
    }

    synchronized void recvEncryptedI2NP(ByteBuffer buf) {
        while (buf.hasRemaining() && !this._closed) {
            int want = Math.min(buf.remaining(), this._curReadBlock.length - this._curReadBlockIndex);
            if (want > 0) {
                buf.get(this._curReadBlock, this._curReadBlockIndex, want);
                this._curReadBlockIndex += want;
            }
            if (this._curReadBlockIndex < this._curReadBlock.length) continue;
            this._context.aes().decryptBlock(this._curReadBlock, 0, this._sessionKey, this._decryptBlockBuf, 0);
            DataHelper.xor((byte[])this._decryptBlockBuf, (int)0, (byte[])this._prevReadBlock, (int)0, (byte[])this._decryptBlockBuf, (int)0, (int)this._decryptBlockBuf.length);
            boolean ok = this.recvUnencryptedI2NP();
            if (!ok) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Read buffer " + System.identityHashCode(buf) + " contained corrupt data");
                }
                this._context.statManager().addRateData("ntcp.corruptDecryptedI2NP", 1L, this.getUptime());
                return;
            }
            byte[] swap = this._prevReadBlock;
            this._prevReadBlock = this._curReadBlock;
            this._curReadBlock = swap;
            this._curReadBlockIndex = 0;
        }
    }

    private boolean recvUnencryptedI2NP() {
        this._curReadState.receiveBlock(this._decryptBlockBuf);
        if (this._curReadState.getSize() > 16384) {
            if (this._log.shouldLog(40)) {
                this._log.error("I2NP message too big - size: " + this._curReadState.getSize() + " Dropping " + this.toString());
            }
            this._context.statManager().addRateData("ntcp.corruptTooLargeI2NP", (long)this._curReadState.getSize(), this.getUptime());
            this.close();
            return false;
        }
        return true;
    }

    private void readMeta(byte[] unencrypted) {
        long ourTs = this._context.clock().now() / 1000L;
        long ts = DataHelper.fromLong((byte[])unencrypted, (int)2, (int)4);
        Adler32 crc = new Adler32();
        crc.update(unencrypted, 0, unencrypted.length - 4);
        long expected = crc.getValue();
        long read = DataHelper.fromLong((byte[])unencrypted, (int)(unencrypted.length - 4), (int)4);
        if (read != expected) {
            if (this._log.shouldLog(30)) {
                this._log.warn("I2NP metadata message had a bad CRC value");
            }
            this._context.statManager().addRateData("ntcp.corruptMetaCRC", 1L, this.getUptime());
            this.close();
            return;
        }
        long newSkew = ourTs - ts;
        if (Math.abs(newSkew * 1000L) > 60000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Peer's skew jumped too far (from " + this._clockSkew + " s to " + newSkew + " s): " + this.toString());
            }
            this._context.statManager().addRateData("ntcp.corruptSkew", newSkew, this.getUptime());
            this.close();
            return;
        }
        this._context.statManager().addRateData("ntcp.receiveMeta", newSkew, this.getUptime());
        if (this._log.shouldLog(10)) {
            this._log.debug("Received NTCP metadata, old skew of " + this._clockSkew + " s, new skew of " + newSkew + "s.");
        }
        this._clockSkew = newSkew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMeta() {
        byte[] encrypted = new byte[this._meta.length];
        byte[] byArray = this._meta;
        synchronized (this._meta) {
            this._context.random().nextBytes(this._meta);
            DataHelper.toLong((byte[])this._meta, (int)0, (int)2, (long)0L);
            DataHelper.toLong((byte[])this._meta, (int)2, (int)4, (long)(this._context.clock().now() / 1000L));
            Adler32 crc = new Adler32();
            crc.update(this._meta, 0, this._meta.length - 4);
            DataHelper.toLong((byte[])this._meta, (int)(this._meta.length - 4), (int)4, (long)crc.getValue());
            this._context.aes().encrypt(this._meta, 0, encrypted, 0, this._sessionKey, this._prevWriteEnd, 0, this._meta.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            System.arraycopy(encrypted, encrypted.length - 16, this._prevWriteEnd, 0, this._prevWriteEnd.length);
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending NTCP metadata");
            }
            this._sendingMeta = true;
            this._transport.getPumper().wantsWrite(this, encrypted);
            return;
        }
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != NTCPConnection.class) {
            return false;
        }
        return obj == this;
    }

    private static final I2NPMessageHandler acquireHandler(RouterContext ctx) {
        I2NPMessageHandler rv = _i2npHandlers.poll();
        if (rv == null) {
            rv = new I2NPMessageHandler(ctx);
        }
        return rv;
    }

    private static void releaseHandler(I2NPMessageHandler handler) {
        _i2npHandlers.offer(handler);
    }

    public long getReadTime() {
        return this._curReadState.getReadTime();
    }

    private static DataBuf acquireReadBuf() {
        DataBuf rv = _dataReadBufs.poll();
        if (rv != null) {
            return rv;
        }
        return new DataBuf();
    }

    private static void releaseReadBuf(DataBuf buf) {
        buf.bais.reset();
        _dataReadBufs.offer(buf);
    }

    public String toString() {
        return "NTCP Connection to " + (this._remotePeer == null ? "unknown " : this._remotePeer.calculateHash().toBase64().substring(0, 6)) + " inbound? " + this._isInbound + " established? " + this._established + " created " + DataHelper.formatDuration((long)this.getTimeSinceCreated()) + " ago";
    }

    static {
        _bufs = new ArrayList(NUM_PREP_BUFS);
        _i2npHandlers = new LinkedBlockingQueue(4);
        _dataReadBufs = new LinkedBlockingQueue(16);
    }

    private class ReadState {
        private int _size;
        private DataBuf _dataBuf;
        private int _nextWrite;
        private long _expectedCrc;
        private Adler32 _crc = new Adler32();
        private long _stateBegin;
        private int _blocks;

        public ReadState() {
            this.init();
        }

        private void init() {
            this._size = -1;
            this._nextWrite = 0;
            this._expectedCrc = -1L;
            this._stateBegin = -1L;
            this._blocks = -1;
            this._crc.reset();
            if (this._dataBuf != null) {
                NTCPConnection.releaseReadBuf(this._dataBuf);
            }
            this._dataBuf = null;
        }

        public int getSize() {
            return this._size;
        }

        public void receiveBlock(byte[] buf) {
            if (this._size == -1) {
                this.receiveInitial(buf);
            } else {
                this.receiveSubsequent(buf);
            }
        }

        public long getReadTime() {
            long now = System.currentTimeMillis();
            long readTime = now - this._stateBegin;
            if (readTime >= now) {
                return -1L;
            }
            return readTime;
        }

        private void receiveInitial(byte[] buf) {
            this._stateBegin = System.currentTimeMillis();
            this._size = (int)DataHelper.fromLong((byte[])buf, (int)0, (int)2);
            if (this._size == 0) {
                NTCPConnection.this.readMeta(buf);
                this.init();
                return;
            }
            this._dataBuf = NTCPConnection.acquireReadBuf();
            System.arraycopy(buf, 2, this._dataBuf.data, 0, buf.length - 2);
            this._nextWrite += buf.length - 2;
            this._crc.update(buf);
            ++this._blocks;
            if (NTCPConnection.this._log.shouldLog(10)) {
                NTCPConnection.this._log.debug("new I2NP message with size: " + this._size + " for message " + NTCPConnection.this._messagesRead);
            }
        }

        private void receiveSubsequent(byte[] buf) {
            ++this._blocks;
            int remaining = this._size - this._nextWrite;
            int blockUsed = Math.min(buf.length, remaining);
            if (remaining > 0) {
                System.arraycopy(buf, 0, this._dataBuf.data, this._nextWrite, blockUsed);
                this._nextWrite += blockUsed;
                remaining -= blockUsed;
            }
            if (remaining <= 0 && buf.length - blockUsed < 4) {
                if (NTCPConnection.this._log.shouldLog(10)) {
                    NTCPConnection.this._log.debug("crc wraparound required on block " + this._blocks + " in message " + NTCPConnection.this._messagesRead);
                }
                this._crc.update(buf);
                return;
            }
            if (remaining <= 0) {
                this.receiveLastBlock(buf);
            } else {
                this._crc.update(buf);
            }
        }

        private void receiveLastBlock(byte[] buf) {
            this._expectedCrc = DataHelper.fromLong((byte[])buf, (int)(buf.length - 4), (int)4);
            this._crc.update(buf, 0, buf.length - 4);
            long val = this._crc.getValue();
            if (NTCPConnection.this._log.shouldLog(10)) {
                NTCPConnection.this._log.debug("CRC value computed: " + val + " expected: " + this._expectedCrc + " size: " + this._size);
            }
            if (val == this._expectedCrc) {
                try {
                    I2NPMessageHandler h = NTCPConnection.acquireHandler(NTCPConnection.this._context);
                    I2NPMessage read = h.readMessage(this._dataBuf.bais);
                    long timeToRecv = System.currentTimeMillis() - this._stateBegin;
                    NTCPConnection.releaseHandler(h);
                    if (NTCPConnection.this._log.shouldLog(20)) {
                        NTCPConnection.this._log.info("I2NP message " + NTCPConnection.this._messagesRead + "/" + (read != null ? read.getUniqueId() : 0L) + " received after " + timeToRecv + " with " + this._size + "/" + this._blocks * 16 + " bytes on " + NTCPConnection.this.toString());
                    }
                    NTCPConnection.this._context.statManager().addRateData("ntcp.receiveTime", timeToRecv, timeToRecv);
                    NTCPConnection.this._context.statManager().addRateData("ntcp.receiveSize", (long)this._size, timeToRecv);
                    if (read != null) {
                        NTCPConnection.this._transport.messageReceived(read, NTCPConnection.this._remotePeer, null, timeToRecv, this._size);
                        if (NTCPConnection.this._messagesRead <= 0L) {
                            NTCPConnection.this.enqueueInfoMessage();
                        }
                        NTCPConnection.this._lastReceiveTime = System.currentTimeMillis();
                        NTCPConnection.this._messagesRead++;
                    }
                    this.init();
                }
                catch (IOException ioe) {
                    if (NTCPConnection.this._log.shouldLog(30)) {
                        NTCPConnection.this._log.warn("Error parsing I2NP message", (Throwable)ioe);
                    }
                    NTCPConnection.this._context.statManager().addRateData("ntcp.corruptI2NPIOE", 1L, NTCPConnection.this.getUptime());
                    NTCPConnection.this.close();
                    return;
                }
                catch (I2NPMessageException ime) {
                    if (NTCPConnection.this._log.shouldLog(30)) {
                        NTCPConnection.this._log.warn("Error parsing I2NP message", (Throwable)((Object)ime));
                    }
                    NTCPConnection.this._context.statManager().addRateData("ntcp.corruptI2NPIME", 1L, NTCPConnection.this.getUptime());
                    NTCPConnection.this.close();
                    return;
                }
            } else {
                if (NTCPConnection.this._log.shouldLog(40)) {
                    NTCPConnection.this._log.error("CRC incorrect for message " + NTCPConnection.this._messagesRead + " (calc=" + val + " expected=" + this._expectedCrc + ") size=" + this._size + " blocks " + this._blocks);
                }
                NTCPConnection.this._context.statManager().addRateData("ntcp.corruptI2NPCRC", 1L, NTCPConnection.this.getUptime());
                NTCPConnection.this.close();
                return;
            }
        }
    }

    private static class DataBuf {
        byte[] data = new byte[16384];
        ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
    }

    private static class PrepBuffer {
        byte[] unencrypted = new byte[16384];
        int unencryptedLength;
        byte[] base = new byte[16384];
        int baseLength;
        byte[] pad = new byte[16];
        int padLength;
        Adler32 crc = new Adler32();
        byte[] encrypted;
        private long acquiredOn;

        PrepBuffer() {
        }

        private void init() {
            this.unencryptedLength = 0;
            this.baseLength = 0;
            this.padLength = 0;
            this.encrypted = null;
            this.crc.reset();
        }

        public void acquired() {
            this.acquiredOn = System.currentTimeMillis();
        }

        public long lifetime() {
            return System.currentTimeMillis() - this.acquiredOn;
        }
    }
}

