/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.net.InetAddress;
import java.util.Properties;
import net.i2p.data.DataHelper;
import net.i2p.data.RouterAddress;
import net.i2p.router.transport.TransportImpl;
import net.i2p.util.Log;

public class NTCPAddress {
    private static final Log _log = new Log(NTCPAddress.class);
    private int _port;
    private String _host;
    public static final String PROP_PORT = "port";
    public static final String PROP_HOST = "host";
    public static final int DEFAULT_COST = 10;

    public NTCPAddress(String host, int port) {
        if (host != null) {
            this._host = host.trim();
        }
        this._port = port;
    }

    public NTCPAddress() {
        this._host = null;
        this._port = -1;
    }

    public NTCPAddress(RouterAddress addr) {
        if (addr == null) {
            this._host = null;
            this._port = -1;
            return;
        }
        String host = addr.getOptions().getProperty(PROP_HOST);
        if (host == null) {
            this._host = null;
            this._port = -1;
        } else {
            this._host = host.trim();
            String port = addr.getOptions().getProperty(PROP_PORT);
            if (port != null && port.trim().length() > 0 && !"null".equals(port)) {
                try {
                    this._port = Integer.parseInt(port.trim());
                }
                catch (NumberFormatException nfe) {
                    _log.error("Invalid port [" + port + "]", (Throwable)nfe);
                    this._port = -1;
                }
            } else {
                this._port = -1;
            }
        }
    }

    public RouterAddress toRouterAddress() {
        if (this._host == null || this._port <= 0) {
            return null;
        }
        RouterAddress addr = new RouterAddress();
        addr.setCost(10);
        addr.setExpiration(null);
        Properties props = new Properties();
        props.setProperty(PROP_HOST, this._host);
        props.setProperty(PROP_PORT, "" + this._port);
        addr.setOptions(props);
        addr.setTransportStyle("NTCP");
        return addr;
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public boolean isPubliclyRoutable() {
        return NTCPAddress.isPubliclyRoutable(this._host);
    }

    public static boolean isPubliclyRoutable(String host) {
        if (host == null) {
            return false;
        }
        try {
            InetAddress addr = InetAddress.getByName(host);
            byte[] quad = addr.getAddress();
            return TransportImpl.isPubliclyRoutable(quad);
        }
        catch (Throwable t) {
            if (_log.shouldLog(30)) {
                _log.warn("Error checking routability", t);
            }
            return false;
        }
    }

    public String toString() {
        return this._host + ":" + this._port;
    }

    public int hashCode() {
        int rv = 0;
        rv += this._port;
        if (this._host != null) {
            rv += this._host.trim().hashCode();
        }
        return rv;
    }

    public boolean equals(Object val) {
        if (val != null && val instanceof NTCPAddress) {
            String ourHost;
            NTCPAddress addr = (NTCPAddress)val;
            String hostname = null;
            if (addr.getHost() != null) {
                hostname = addr.getHost().trim();
            }
            if ((ourHost = this.getHost()) != null) {
                ourHost = ourHost.trim();
            }
            return DataHelper.eq((Object)hostname, (Object)ourHost) && this.getPort() == addr.getPort();
        }
        return false;
    }

    public boolean equals(RouterAddress addr) {
        if (addr == null) {
            return false;
        }
        Properties opts = addr.getOptions();
        if (opts == null) {
            return false;
        }
        return this._host.equals(opts.getProperty(PROP_HOST)) && Integer.toString(this._port).equals(opts.getProperty(PROP_PORT));
    }
}

