/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.Map;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.TransportManager;
import net.i2p.router.transport.UPnP;
import net.i2p.util.Log;
import org.cybergarage.util.Debug;
import org.freenetproject.DetectedIP;
import org.freenetproject.ForwardPort;
import org.freenetproject.ForwardPortCallback;
import org.freenetproject.ForwardPortStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UPnPManager {
    private Log _log;
    private RouterContext _context;
    private UPnP _upnp;
    private UPnPCallback _upnpCallback;
    private volatile boolean _isRunning;
    private InetAddress _detectedAddress;
    private TransportManager _manager;
    private static final String PROP_HTTP_PORT = "i2np.upnp.HTTPPort";
    private static final int DEFAULT_HTTP_PORT = 7652;
    private static final String PROP_SSDP_PORT = "i2np.upnp.SSDPPort";
    private static final int DEFAULT_SSDP_PORT = 7653;

    public UPnPManager(RouterContext context, TransportManager manager) {
        this._context = context;
        this._manager = manager;
        this._log = this._context.logManager().getLog(UPnPManager.class);
        org.cybergarage.upnp.UPnP.setEnable(9);
        Debug.initialize(context);
        this._upnp = new UPnP(context);
        this._upnp.setHTTPPort(this._context.getProperty(PROP_HTTP_PORT, 7652));
        this._upnp.setSSDPPort(this._context.getProperty(PROP_SSDP_PORT, 7653));
        this._upnpCallback = new UPnPCallback();
        this._isRunning = false;
    }

    public synchronized void start() {
        if (!this._isRunning) {
            this._isRunning = this._upnp.runPlugin();
        }
        if (!this._isRunning) {
            this._log.error("UPnP start failed - port conflict?");
        }
    }

    public synchronized void stop() {
        if (this._log.shouldLog(10)) {
            this._log.debug("UPnP Stop");
        }
        if (this._isRunning) {
            this._upnp.terminate();
        }
        this._isRunning = false;
        this._detectedAddress = null;
    }

    public void update(Map<String, Integer> ports) {
        if (this._log.shouldLog(10)) {
            this._log.debug("UPnP Update:");
        }
        if (!this._isRunning) {
            return;
        }
        HashSet<ForwardPort> forwards = new HashSet<ForwardPort>(ports.size());
        for (String style : ports.keySet()) {
            int port = ports.get(style);
            int protocol = -1;
            if ("SSU".equals(style)) {
                protocol = 17;
            } else {
                if (!"NTCP".equals(style)) continue;
                protocol = 6;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Adding: " + style + " " + port);
            }
            ForwardPort fp = new ForwardPort(style, false, protocol, port);
            forwards.add(fp);
        }
        this._upnp.onChangePublicPorts(forwards, this._upnpCallback);
    }

    public String renderStatusHTML() {
        if (!this._isRunning) {
            return "<h3><a name=\"upnp\"></a>UPnP is not enabled</h3>\n";
        }
        return this._upnp.renderStatusHTML();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UPnPCallback
    implements ForwardPortCallback {
        private UPnPCallback() {
        }

        @Override
        public void portForwardStatus(Map<ForwardPort, ForwardPortStatus> statuses) {
            if (UPnPManager.this._log.shouldLog(10)) {
                UPnPManager.this._log.debug("UPnP Callback:");
            }
            DetectedIP[] ips = UPnPManager.this._upnp.getAddress();
            Object detected = null;
            if (ips != null) {
                for (DetectedIP ip : ips) {
                    if (!TransportImpl.isPubliclyRoutable(ip.publicAddress.getAddress())) continue;
                    if (UPnPManager.this._log.shouldLog(10)) {
                        UPnPManager.this._log.debug("External address: " + ip.publicAddress + " type: " + ip.natType);
                    }
                    if (!ip.publicAddress.equals(UPnPManager.this._detectedAddress)) {
                        UPnPManager.this._detectedAddress = ip.publicAddress;
                        UPnPManager.this._manager.externalAddressReceived("upnp", UPnPManager.this._detectedAddress.getAddress(), 0);
                    }
                    break;
                }
            } else if (UPnPManager.this._log.shouldLog(10)) {
                UPnPManager.this._log.debug("No external address returned");
            }
            for (ForwardPort fp : statuses.keySet()) {
                String style;
                ForwardPortStatus fps = statuses.get(fp);
                if (UPnPManager.this._log.shouldLog(10)) {
                    UPnPManager.this._log.debug(fp.name + " " + fp.protocol + " " + fp.portNumber + " status: " + fps.status + " reason: " + fps.reasonString + " ext port: " + fps.externalPort);
                }
                if (fp.protocol == 17) {
                    style = "SSU";
                } else {
                    if (fp.protocol != 6) continue;
                    style = "NTCP";
                }
                boolean success = fps.status >= 1;
                UPnPManager.this._manager.forwardPortStatus(style, fp.portNumber, success, fps.reasonString);
            }
        }
    }
}

