/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.router.transport.TransportImpl;
import net.i2p.util.Log;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.ArgumentList;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.ServiceList;
import org.cybergarage.upnp.device.DeviceChangeListener;
import org.cybergarage.upnp.event.EventListener;
import org.freenetproject.DetectedIP;
import org.freenetproject.ForwardPort;
import org.freenetproject.ForwardPortCallback;
import org.freenetproject.ForwardPortStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UPnP
extends ControlPoint
implements DeviceChangeListener,
EventListener {
    private Log _log;
    private I2PAppContext _context;
    private static final String ROUTER_DEVICE = "urn:schemas-upnp-org:device:InternetGatewayDevice:1";
    private static final String WAN_DEVICE = "urn:schemas-upnp-org:device:WANDevice:1";
    private static final String WANCON_DEVICE = "urn:schemas-upnp-org:device:WANConnectionDevice:1";
    private static final String WAN_IP_CONNECTION = "urn:schemas-upnp-org:service:WANIPConnection:1";
    private static final String WAN_PPP_CONNECTION = "urn:schemas-upnp-org:service:WANPPPConnection:1";
    private Device _router;
    private Service _service;
    private boolean isDisabled = false;
    private final Object lock = new Object();
    private volatile boolean thinksWeAreDoubleNatted = false;
    private Set<ForwardPort> portsToForward;
    private Set<ForwardPort> portsForwarded;
    private ForwardPortCallback forwardCallback;
    private String _lastAction;
    private Service _lastService;
    private ArgumentList _lastArgumentList;
    private final Object toStringLock = new Object();
    private static int __id = 0;

    public UPnP(I2PAppContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(UPnP.class);
        this.portsForwarded = new HashSet<ForwardPort>();
        this.addDeviceChangeListener(this);
    }

    public boolean runPlugin() {
        return super.start();
    }

    public void terminate() {
        this.unregisterPortMappings();
        super.stop();
        this._router = null;
        this._service = null;
    }

    public DetectedIP[] getAddress() {
        this._log.info("UP&P.getAddress() is called \\o/");
        if (this.isDisabled) {
            this._log.warn("Plugin has been disabled previously, ignoring request.");
            return null;
        }
        if (!this.isNATPresent()) {
            this._log.warn("No UP&P device found, detection of the external ip address using the plugin has failed");
            return null;
        }
        DetectedIP result = null;
        String natAddress = this.getNATAddress();
        if (natAddress == null || natAddress.length() <= 0) {
            this._log.warn("No external address returned");
            return null;
        }
        try {
            InetAddress detectedIP = InetAddress.getByName(natAddress);
            short status = 1;
            this.thinksWeAreDoubleNatted = !TransportImpl.isPubliclyRoutable(detectedIP.getAddress());
            this._log.warn("NATAddress: \"" + natAddress + "\" detectedIP: " + detectedIP + " double? " + this.thinksWeAreDoubleNatted);
            if (this.portsForwarded.size() > 1 && !this.thinksWeAreDoubleNatted) {
                status = 2;
            }
            result = new DetectedIP(detectedIP, status);
            this._log.warn("Successful UP&P discovery :" + result);
            return new DetectedIP[]{result};
        }
        catch (UnknownHostException e) {
            this._log.error("Caught an UnknownHostException resolving " + natAddress, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceAdded(Device dev) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isDisabled) {
                this._log.warn("Plugin has been disabled previously, ignoring new device.");
                return;
            }
        }
        if (!ROUTER_DEVICE.equals(dev.getDeviceType()) || !dev.isRootDevice()) {
            this._log.warn("UP&P non-IGD device found, ignoring : " + dev.getFriendlyName());
            return;
        }
        if (this.isNATPresent()) {
            this._log.warn("UP&P ignoring additional IGD device found: " + dev.getFriendlyName() + " UDN: " + dev.getUDN());
            return;
        }
        this._log.warn("UP&P IGD found : " + dev.getFriendlyName() + " UDN: " + dev.getUDN() + " lease time: " + dev.getLeaseTime());
        object = this.lock;
        synchronized (object) {
            this._router = dev;
        }
        this.discoverService();
        object = this.lock;
        synchronized (object) {
            if (this._service == null) {
                this._log.error("The IGD device we got isn't suiting our needs, let's disable the plugin");
                this.isDisabled = true;
                this._router = null;
                return;
            }
            this.subscribe(this._service);
        }
        this.registerPortMappings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPortMappings() {
        Set<ForwardPort> ports;
        Object object = this.lock;
        synchronized (object) {
            ports = this.portsToForward;
        }
        if (ports == null) {
            return;
        }
        this.registerPorts(ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverService() {
        Object object = this.lock;
        synchronized (object) {
            for (Device current : this._router.getDeviceList()) {
                if (!current.getDeviceType().equals(WAN_DEVICE)) continue;
                DeviceList l = current.getDeviceList();
                for (int i = 0; i < current.getDeviceList().size(); ++i) {
                    Device current2 = l.getDevice(i);
                    if (!current2.getDeviceType().equals(WANCON_DEVICE)) continue;
                    this._service = current2.getService(WAN_PPP_CONNECTION);
                    if (this._service == null) {
                        this._log.warn(this._router.getFriendlyName() + " doesn't seems to be using PPP; we won't be able to extract bandwidth-related informations out of it.");
                        this._service = current2.getService(WAN_IP_CONNECTION);
                        if (this._service == null) {
                            this._log.error(this._router.getFriendlyName() + " doesn't export WAN_IP_CONNECTION either: we won't be able to use it!");
                        }
                    }
                    return;
                }
            }
        }
    }

    public boolean tryAddMapping(String protocol, int port, String description, ForwardPort fp) {
        this._log.warn("Registering a port mapping for " + port + "/" + protocol);
        int nbOfTries = 0;
        boolean isPortForwarded = false;
        while (nbOfTries++ < 5 && !(isPortForwarded = this.addMapping(protocol, port, "I2P " + description, fp))) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {}
        }
        this._log.warn((isPortForwarded ? "Mapping is successful!" : "Mapping has failed!") + " (" + nbOfTries + " tries)");
        return isPortForwarded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPortMappings() {
        HashSet<ForwardPort> ports;
        Object object = this.lock;
        synchronized (object) {
            ports = new HashSet<ForwardPort>(this.portsForwarded);
        }
        this.unregisterPorts(ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceRemoved(Device dev) {
        this._log.warn("UP&P device removed : " + dev.getFriendlyName() + " UDN: " + dev.getUDN());
        Object object = this.lock;
        synchronized (object) {
            if (this._router == null) {
                return;
            }
            if (ROUTER_DEVICE.equals(dev.getDeviceType()) && dev.isRootDevice() && UPnP.stringEquals(this._router.getFriendlyName(), dev.getFriendlyName()) && UPnP.stringEquals(this._router.getUDN(), dev.getUDN())) {
                this._log.warn("UP&P IGD device removed : " + dev.getFriendlyName());
                this._router = null;
                this._service = null;
            }
        }
    }

    @Override
    public void eventNotifyReceived(String uuid, long seq, String varName, String value) {
        if (this._log.shouldLog(30)) {
            this._log.error("Event: " + uuid + ' ' + seq + ' ' + varName + '=' + value);
        }
    }

    private static boolean stringEquals(String a, String b) {
        if (a != null) {
            return a.equals(b);
        }
        return b == null;
    }

    public boolean isNATPresent() {
        return this._router != null && this._service != null;
    }

    public String getNATAddress() {
        if (!this.isNATPresent()) {
            return null;
        }
        Action getIP = this._service.getAction("GetExternalIPAddress");
        if (getIP == null || !getIP.postControlAction()) {
            return null;
        }
        String rv = getIP.getOutputArgumentList().getArgument("NewExternalIPAddress").getValue();
        if ("0.0.0.0".equals(rv)) {
            return null;
        }
        return rv;
    }

    public int getUpstreamMaxBitRate() {
        if (!this.isNATPresent() || this.thinksWeAreDoubleNatted) {
            return -1;
        }
        Action getIP = this._service.getAction("GetLinkLayerMaxBitRates");
        if (getIP == null || !getIP.postControlAction()) {
            return -1;
        }
        return Integer.valueOf(getIP.getOutputArgumentList().getArgument("NewUpstreamMaxBitRate").getValue());
    }

    public int getDownstreamMaxBitRate() {
        if (!this.isNATPresent() || this.thinksWeAreDoubleNatted) {
            return -1;
        }
        Action getIP = this._service.getAction("GetLinkLayerMaxBitRates");
        if (getIP == null || !getIP.postControlAction()) {
            return -1;
        }
        return Integer.valueOf(getIP.getOutputArgumentList().getArgument("NewDownstreamMaxBitRate").getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(String action, String arg, Service serv) {
        Object object = this.toStringLock;
        synchronized (object) {
            if (!action.equals(this._lastAction) || !serv.equals(this._lastService) || this._lastArgumentList == null) {
                Action getIP = serv.getAction(action);
                if (getIP == null || !getIP.postControlAction()) {
                    this._lastAction = null;
                    return null;
                }
                this._lastAction = action;
                this._lastService = serv;
                this._lastArgumentList = getIP.getOutputArgumentList();
            }
            return this._lastArgumentList.getArgument(arg).getValue();
        }
    }

    private void listSubServices(Device dev, StringBuilder sb) {
        ServiceList sl = dev.getServiceList();
        if (sl.isEmpty()) {
            return;
        }
        sb.append("<ul>\n");
        for (int i = 0; i < sl.size(); ++i) {
            Service serv = sl.getService(i);
            if (serv == null) continue;
            sb.append("<li>Service: ");
            if ("urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1".equals(serv.getServiceType())) {
                sb.append("WAN Common Interface Config<ul>");
                sb.append("<li>Status: " + this.toString("GetCommonLinkProperties", "NewPhysicalLinkStatus", serv));
                sb.append("<li>Type: " + this.toString("GetCommonLinkProperties", "NewWANAccessType", serv));
                sb.append("<li>Upstream: " + this.toString("GetCommonLinkProperties", "NewLayer1UpstreamMaxBitRate", serv));
                sb.append("<li>Downstream: " + this.toString("GetCommonLinkProperties", "NewLayer1DownstreamMaxBitRate", serv) + "<br>");
            } else if (WAN_PPP_CONNECTION.equals(serv.getServiceType())) {
                sb.append("WAN PPP Connection<ul>");
                sb.append("<li>Status: " + this.toString("GetStatusInfo", "NewConnectionStatus", serv));
                sb.append("<li>Type: " + this.toString("GetConnectionTypeInfo", "NewConnectionType", serv));
                sb.append("<li>Upstream: " + this.toString("GetLinkLayerMaxBitRates", "NewUpstreamMaxBitRate", serv));
                sb.append("<li>Downstream: " + this.toString("GetLinkLayerMaxBitRates", "NewDownstreamMaxBitRate", serv) + "<br>");
                sb.append("<li>External IP: " + this.toString("GetExternalIPAddress", "NewExternalIPAddress", serv) + "<br>");
            } else if ("urn:schemas-upnp-org:service:Layer3Forwarding:1".equals(serv.getServiceType())) {
                sb.append("Layer 3 Forwarding<ul>");
                sb.append("<li>Default Connection Service: " + this.toString("GetDefaultConnectionService", "NewDefaultConnectionService", serv));
            } else if (WAN_IP_CONNECTION.equals(serv.getServiceType())) {
                sb.append("WAN IP Connection<ul>");
                sb.append("<li>Status: " + this.toString("GetStatusInfo", "NewConnectionStatus", serv));
                sb.append("<li>Type: " + this.toString("GetConnectionTypeInfo", "NewConnectionType", serv));
                sb.append("<li>External IP: " + this.toString("GetExternalIPAddress", "NewExternalIPAddress", serv) + "<br>");
            } else if ("urn:schemas-upnp-org:service:WANEthernetLinkConfig:1".equals(serv.getServiceType())) {
                sb.append("WAN Ethernet Link Config<ol>");
                sb.append("<li>Status: " + this.toString("GetEthernetLinkStatus", "NewEthernetLinkStatus", serv) + "<br>");
            } else {
                sb.append("~~~~~~~ " + serv.getServiceType() + "<ul>");
            }
            sb.append("</ul>\n");
        }
        sb.append("</ul>\n");
    }

    private void listSubDev(String prefix, Device dev, StringBuilder sb) {
        if (prefix == null) {
            sb.append("Device: ");
        } else {
            sb.append("<li>Subdevice: ");
        }
        sb.append(dev.getFriendlyName());
        this.listSubServices(dev, sb);
        DeviceList dl = dev.getDeviceList();
        if (dl.isEmpty()) {
            return;
        }
        sb.append("<ul>\n");
        for (int j = 0; j < dl.size(); ++j) {
            Device subDev = dl.getDevice(j);
            if (subDev == null) continue;
            this.listSubDev(dev.getFriendlyName(), subDev, sb);
        }
        sb.append("</ul>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderStatusHTML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<h3><a name=\"upnp\"></a>UPnP Status</h3>");
        if (this.isDisabled) {
            sb.append("UPnP has been disabled; Do you have more than one UPnP Internet Gateway Device on your LAN ?");
            return sb.toString();
        }
        if (!this.isNATPresent()) {
            sb.append("UPnP has not found any UPnP-aware, compatible device on your LAN.");
            return sb.toString();
        }
        sb.append("<p>Found ");
        this.listSubDev(null, this._router, sb);
        String addr = this.getNATAddress();
        if (addr != null) {
            sb.append("<br>The current external IP address reported by UPnP is " + addr);
        } else {
            sb.append("<br>The current external IP address is not available.");
        }
        int downstreamMaxBitRate = this.getDownstreamMaxBitRate();
        int upstreamMaxBitRate = this.getUpstreamMaxBitRate();
        if (downstreamMaxBitRate > 0) {
            sb.append("<br>UPnP reports the max downstream bit rate is : " + downstreamMaxBitRate + " bits/sec\n");
        }
        if (upstreamMaxBitRate > 0) {
            sb.append("<br>UPnP reports the max upstream bit rate is : " + upstreamMaxBitRate + " bits/sec\n");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.portsToForward != null) {
                for (ForwardPort port : this.portsToForward) {
                    sb.append("<br>" + UPnP.protoToString(port.protocol) + " port " + port.portNumber + " for " + port.name);
                    if (this.portsForwarded.contains(port)) {
                        sb.append(" has been forwarded successfully by UPnP.\n");
                        continue;
                    }
                    sb.append(" has not been forwarded by UPnP.\n");
                }
            }
        }
        sb.append("</p>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMapping(String protocol, int port, String description, ForwardPort fp) {
        if (this.isDisabled || !this.isNATPresent() || this._router == null) {
            this._log.error("Can't addMapping: " + this.isDisabled + " " + this.isNATPresent() + " " + this._router);
            return false;
        }
        this.removeMapping(protocol, port, fp, true);
        Action add = this._service.getAction("AddPortMapping");
        if (add == null) {
            this._log.error("Couldn't find AddPortMapping action!");
            return false;
        }
        add.setArgumentValue("NewRemoteHost", "");
        add.setArgumentValue("NewExternalPort", port);
        add.setArgumentValue("NewInternalClient", this._router.getInterfaceAddress());
        add.setArgumentValue("NewInternalPort", port);
        add.setArgumentValue("NewProtocol", protocol);
        add.setArgumentValue("NewPortMappingDescription", description);
        add.setArgumentValue("NewEnabled", "1");
        add.setArgumentValue("NewLeaseDuration", 0);
        if (add.postControlAction()) {
            Object object = this.lock;
            synchronized (object) {
                this.portsForwarded.add(fp);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMapping(String protocol, int port, ForwardPort fp, boolean noLog) {
        if (this.isDisabled || !this.isNATPresent()) {
            return false;
        }
        Action remove = this._service.getAction("DeletePortMapping");
        if (remove == null) {
            this._log.error("Couldn't find DeletePortMapping action!");
            return false;
        }
        remove.setArgumentValue("NewExternalPort", port);
        remove.setArgumentValue("NewProtocol", protocol);
        boolean retval = remove.postControlAction();
        Object object = this.lock;
        synchronized (object) {
            this.portsForwarded.remove(fp);
        }
        if (!noLog) {
            this._log.warn("UPnP: Removed mapping for " + fp.name + " " + port + " / " + protocol);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChangePublicPorts(Set<ForwardPort> ports, ForwardPortCallback cb) {
        Set<ForwardPort> portsToDumpNow = null;
        Set<ForwardPort> portsToForwardNow = null;
        this._log.warn("UP&P Forwarding " + ports.size() + " ports...");
        Object object = this.lock;
        synchronized (object) {
            if (this.forwardCallback != null && this.forwardCallback != cb && cb != null) {
                this._log.error("ForwardPortCallback changed from " + this.forwardCallback + " to " + cb + " - using new value, but this is very strange!");
            }
            this.forwardCallback = cb;
            if (this.portsToForward == null || this.portsToForward.isEmpty()) {
                this.portsToForward = ports;
                portsToForwardNow = ports;
                portsToDumpNow = null;
            } else if (ports == null || ports.isEmpty()) {
                portsToDumpNow = this.portsToForward;
                this.portsToForward = ports;
                portsToForwardNow = null;
            } else {
                for (ForwardPort port : ports) {
                    if (this.portsForwarded.contains(port)) continue;
                    if (portsToForwardNow == null) {
                        portsToForwardNow = new HashSet<ForwardPort>();
                    }
                    portsToForwardNow.add(port);
                }
                for (ForwardPort port : this.portsToForward) {
                    if (ports.contains(port)) continue;
                    if (portsToDumpNow == null) {
                        portsToDumpNow = new HashSet<ForwardPort>();
                    }
                    portsToDumpNow.add(port);
                }
                this.portsToForward = ports;
            }
            if (this._router == null) {
                return;
            }
        }
        if (portsToDumpNow != null) {
            this.unregisterPorts(portsToDumpNow);
        }
        if (portsToForwardNow != null) {
            this.registerPorts(portsToForwardNow);
        }
    }

    private static String protoToString(int p) {
        if (p == 17) {
            return "UDP";
        }
        if (p == 6) {
            return "TCP";
        }
        return "?";
    }

    private void registerPorts(Set<ForwardPort> portsToForwardNow) {
        Thread t = new Thread(new RegisterPortsThread(portsToForwardNow));
        t.setName("UPnP Port Opener " + ++__id);
        t.setDaemon(true);
        t.start();
    }

    private void unregisterPorts(Set<ForwardPort> portsToForwardNow) {
        Thread t = new Thread(new UnregisterPortsThread(portsToForwardNow));
        t.setName("UPnP Port Opener " + ++__id);
        t.setDaemon(true);
        t.start();
    }

    public static void main(String[] args) throws Exception {
        UPnP upnp = new UPnP(I2PAppContext.getGlobalContext());
        ControlPoint cp = new ControlPoint();
        System.out.println("Searching for up&p devices:");
        cp.start();
        cp.search();
        while (true) {
            DeviceList list = cp.getDeviceList();
            System.out.println("Found " + list.size() + " devices!");
            StringBuilder sb = new StringBuilder();
            for (Device device : list) {
                upnp.listSubDev(device.toString(), device, sb);
                System.out.println("Here is the listing for " + device.toString() + " :");
                System.out.println(sb.toString());
                sb = new StringBuilder();
            }
            System.out.println("End");
            Thread.sleep(2000L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnregisterPortsThread
    implements Runnable {
        private Set<ForwardPort> portsToForwardNow;

        public UnregisterPortsThread(Set<ForwardPort> ports) {
            this.portsToForwardNow = ports;
        }

        @Override
        public void run() {
            for (ForwardPort port : this.portsToForwardNow) {
                String proto = UPnP.protoToString(port.protocol);
                if (proto.length() <= 1) continue;
                UPnP.this.removeMapping(proto, port.portNumber, port, false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RegisterPortsThread
    implements Runnable {
        private Set<ForwardPort> portsToForwardNow;

        public RegisterPortsThread(Set<ForwardPort> ports) {
            this.portsToForwardNow = ports;
        }

        @Override
        public void run() {
            HashMap<ForwardPort, ForwardPortStatus> map = new HashMap<ForwardPort, ForwardPortStatus>(1);
            for (ForwardPort port : this.portsToForwardNow) {
                String proto = UPnP.protoToString(port.protocol);
                map.clear();
                ForwardPortStatus fps = proto.length() <= 1 ? new ForwardPortStatus(-2, "Protocol not supported", port.portNumber) : (UPnP.this.tryAddMapping(proto, port.portNumber, port.name, port) ? new ForwardPortStatus(1, "Port apparently forwarded by UPnP", port.portNumber) : new ForwardPortStatus(-1, "UPnP port forwarding apparently failed", port.portNumber));
                map.put(port, fps);
                UPnP.this.forwardCallback.portForwardStatus(map);
            }
        }
    }
}

