/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

public class GeoIP {
    private Log _log;
    private RouterContext _context;
    private final Map<String, String> _codeToName;
    private final Map<Long, String> _IPToCountry;
    private final Set<Long> _pendingSearch;
    private final Set<Long> _notFound;
    private final AtomicBoolean _lock;
    private int _lookupRunCount;
    static final String PROP_GEOIP_ENABLED = "routerconsole.geoip.enable";
    static final String GEOIP_DIR_DEFAULT = "geoip";
    static final String GEOIP_FILE_DEFAULT = "geoip.txt";
    static final String COUNTRY_FILE_DEFAULT = "countries.txt";
    public static final String PROP_IP_COUNTRY = "i2np.lastCountry";

    public GeoIP(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(GeoIP.class);
        this._codeToName = new ConcurrentHashMap<String, String>();
        this._IPToCountry = new ConcurrentHashMap<Long, String>();
        this._pendingSearch = new ConcurrentHashSet();
        this._notFound = new ConcurrentHashSet();
        this._lock = new AtomicBoolean();
        this.readCountryFile();
    }

    public void blockingLookup() {
        if (!Boolean.valueOf(this._context.getProperty(PROP_GEOIP_ENABLED, "true")).booleanValue()) {
            this._pendingSearch.clear();
            return;
        }
        LookupJob j = new LookupJob();
        j.run();
        this.updateOurCountry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCountryFile() {
        File GeoFile = new File(this._context.getBaseDir(), GEOIP_DIR_DEFAULT);
        if ((GeoFile = new File(GeoFile, COUNTRY_FILE_DEFAULT)) == null || !GeoFile.exists()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Country file not found: " + GeoFile.getAbsolutePath());
            }
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(GeoFile);
            StringBuilder buf = new StringBuilder(128);
            while (DataHelper.readLine((InputStream)in, (StringBuilder)buf)) {
                try {
                    if (buf.charAt(0) == '#') {
                        buf.setLength(0);
                        continue;
                    }
                    String[] s = buf.toString().split(",");
                    this._codeToName.put(s[0].toLowerCase(), s[1]);
                }
                catch (IndexOutOfBoundsException ioobe) {
                    // empty catch block
                }
                buf.setLength(0);
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the Country File", (Throwable)ioe);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] readGeoIPFile(Long[] search) {
        File GeoFile = new File(this._context.getBaseDir(), GEOIP_DIR_DEFAULT);
        if ((GeoFile = new File(GeoFile, GEOIP_FILE_DEFAULT)) == null || !GeoFile.exists()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("GeoIP file not found: " + GeoFile.getAbsolutePath());
            }
            return new String[0];
        }
        String[] rv = new String[search.length];
        int idx = 0;
        long start = this._context.clock().now();
        FileInputStream in = null;
        try {
            in = new FileInputStream(GeoFile);
            StringBuilder buf = new StringBuilder(128);
            while (DataHelper.readLine((InputStream)in, (StringBuilder)buf) && idx < search.length) {
                try {
                    if (buf.charAt(0) == '#') {
                        buf.setLength(0);
                        continue;
                    }
                    String[] s = buf.toString().split(",");
                    long ip1 = Long.parseLong(s[0]);
                    long ip2 = Long.parseLong(s[1]);
                    while (idx < search.length && search[idx] < ip1) {
                        ++idx;
                    }
                    while (idx < search.length && search[idx] >= ip1 && search[idx] <= ip2) {
                        rv[idx++] = s[2].toLowerCase();
                    }
                }
                catch (IndexOutOfBoundsException ioobe) {
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                buf.setLength(0);
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the GeoFile", (Throwable)ioe);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("GeoIP processing finished, time: " + (this._context.clock().now() - start));
        }
        return rv;
    }

    private void updateOurCountry() {
        String oldCountry = this._context.router().getConfigSetting(PROP_IP_COUNTRY);
        String country = this._context.commSystem().getCountry(this._context.routerHash());
        if (country != null && !country.equals(oldCountry)) {
            this._context.router().setConfigSetting(PROP_IP_COUNTRY, country);
            this._context.router().saveConfig();
        }
    }

    public void add(String ip) {
        InetAddress pi;
        try {
            pi = InetAddress.getByName(ip);
        }
        catch (UnknownHostException uhe) {
            return;
        }
        if (pi == null) {
            return;
        }
        byte[] pib = pi.getAddress();
        this.add(pib);
    }

    public void add(byte[] ip) {
        if (ip.length != 4) {
            return;
        }
        this.add(GeoIP.toLong(ip));
    }

    private void add(long ip) {
        Long li = ip;
        if (!this._IPToCountry.containsKey(li) && !this._notFound.contains(li)) {
            this._pendingSearch.add(li);
        }
    }

    public String get(String ip) {
        InetAddress pi;
        try {
            pi = InetAddress.getByName(ip);
        }
        catch (UnknownHostException uhe) {
            return null;
        }
        if (pi == null) {
            return null;
        }
        byte[] pib = pi.getAddress();
        return this.get(pib);
    }

    public String get(byte[] ip) {
        if (ip.length != 4) {
            return null;
        }
        return this.get(GeoIP.toLong(ip));
    }

    private String get(long ip) {
        return this._IPToCountry.get(ip);
    }

    private static long toLong(byte[] ip) {
        int rv = 0;
        for (int i = 0; i < 4; ++i) {
            rv |= (ip[i] & 0xFF) << (3 - i) * 8;
        }
        return (long)rv & 0xFFFFFFFFL;
    }

    public String fullName(String code) {
        return this._codeToName.get(code);
    }

    private class LookupJob
    implements Runnable {
        private static final int CLEAR = 8;

        private LookupJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (GeoIP.this._lock.getAndSet(true)) {
                return;
            }
            try {
                Object[] search;
                if (++GeoIP.this._lookupRunCount % 8 == 0) {
                    GeoIP.this._notFound.clear();
                }
                if ((search = GeoIP.this._pendingSearch.toArray(new Long[GeoIP.this._pendingSearch.size()])).length <= 0) {
                    return;
                }
                GeoIP.this._pendingSearch.clear();
                Arrays.sort(search);
                String[] countries = GeoIP.this.readGeoIPFile((Long[])search);
                for (int i = 0; i < countries.length; ++i) {
                    if (countries[i] != null) {
                        GeoIP.this._IPToCountry.put(search[i], countries[i]);
                        continue;
                    }
                    GeoIP.this._notFound.add(search[i]);
                }
            }
            finally {
                GeoIP.this._lock.set(false);
            }
        }
    }
}

