/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.util.ArrayList;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIFOBandwidthRefiller
implements Runnable {
    private Log _log;
    private I2PAppContext _context;
    private FIFOBandwidthLimiter _limiter;
    private int _inboundKBytesPerSecond;
    private int _outboundKBytesPerSecond;
    private int _inboundBurstKBytesPerSecond;
    private int _outboundBurstKBytesPerSecond;
    private long _lastRefillTime;
    private long _lastCheckConfigTime;
    private long _configCheckPeriodMs = 60000L;
    public static final String PROP_INBOUND_BANDWIDTH = "i2np.bandwidth.inboundKBytesPerSecond";
    public static final String PROP_OUTBOUND_BANDWIDTH = "i2np.bandwidth.outboundKBytesPerSecond";
    public static final String PROP_INBOUND_BURST_BANDWIDTH = "i2np.bandwidth.inboundBurstKBytesPerSecond";
    public static final String PROP_OUTBOUND_BURST_BANDWIDTH = "i2np.bandwidth.outboundBurstKBytesPerSecond";
    public static final String PROP_INBOUND_BANDWIDTH_PEAK = "i2np.bandwidth.inboundBurstKBytes";
    public static final String PROP_OUTBOUND_BANDWIDTH_PEAK = "i2np.bandwidth.outboundBurstKBytes";
    public static final int DEFAULT_INBOUND_BANDWIDTH = 96;
    public static final int DEFAULT_OUTBOUND_BANDWIDTH = 40;
    public static final int DEFAULT_INBOUND_BURST_BANDWIDTH = 96;
    public static final int DEFAULT_OUTBOUND_BURST_BANDWIDTH = 40;
    public static final int DEFAULT_BURST_SECONDS = 60;
    public static final int MIN_INBOUND_BANDWIDTH = 3;
    public static final int MIN_OUTBOUND_BANDWIDTH = 3;
    public static final int MIN_INBOUND_BANDWIDTH_PEAK = 3;
    public static final int MIN_OUTBOUND_BANDWIDTH_PEAK = 3;
    private static final long REPLENISH_FREQUENCY = 100L;

    public FIFOBandwidthRefiller(I2PAppContext context, FIFOBandwidthLimiter limiter) {
        this._limiter = limiter;
        this._context = context;
        this._log = context.logManager().getLog(FIFOBandwidthRefiller.class);
        this.reinitialize();
    }

    @Override
    public void run() {
        this._lastRefillTime = this._limiter.now();
        ArrayList<FIFOBandwidthLimiter.Request> buffer = new ArrayList<FIFOBandwidthLimiter.Request>(2);
        while (true) {
            boolean updated;
            long now;
            if ((now = this._limiter.now()) >= this._lastCheckConfigTime + this._configCheckPeriodMs) {
                this.checkConfig();
                this._lastCheckConfigTime = now = this._limiter.now();
            }
            if (updated = this.updateQueues(buffer, now)) {
                this._lastRefillTime = now;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
            }
        }
    }

    public void reinitialize() {
        this._lastRefillTime = this._limiter.now();
        this.checkConfig();
        this._lastCheckConfigTime = this._lastRefillTime;
    }

    private boolean updateQueues(List<FIFOBandwidthLimiter.Request> buffer, long now) {
        long numMs = now - this._lastRefillTime;
        if (this._log.shouldLog(20)) {
            this._log.info("Updating bandwidth after " + numMs + " (status: " + this._limiter.getStatus().toString() + " rate in=" + this._inboundKBytesPerSecond + ", out=" + this._outboundKBytesPerSecond + ")");
        }
        if (numMs >= 100L) {
            long inboundToAdd = (long)(1024 * this._inboundKBytesPerSecond) * numMs / 1000L;
            long outboundToAdd = (long)(1024 * this._outboundKBytesPerSecond) * numMs / 1000L;
            if (inboundToAdd < 0L) {
                inboundToAdd = 0L;
            }
            if (outboundToAdd < 0L) {
                outboundToAdd = 0L;
            }
            if (this._inboundKBytesPerSecond <= 0) {
                this._limiter.setInboundUnlimited(true);
                inboundToAdd = 0L;
            } else {
                this._limiter.setInboundUnlimited(false);
            }
            if (this._outboundKBytesPerSecond <= 0) {
                this._limiter.setOutboundUnlimited(true);
                outboundToAdd = 0L;
            } else {
                this._limiter.setOutboundUnlimited(false);
            }
            long maxBurstIn = (long)((this._inboundBurstKBytesPerSecond - this._inboundKBytesPerSecond) * 1024) * numMs / 1000L;
            long maxBurstOut = (long)((this._outboundBurstKBytesPerSecond - this._outboundKBytesPerSecond) * 1024) * numMs / 1000L;
            this._limiter.refillBandwidthQueues(buffer, inboundToAdd, outboundToAdd, maxBurstIn, maxBurstOut);
            if (this._log.shouldLog(10)) {
                this._log.debug("Adding " + inboundToAdd + " bytes to inboundAvailable");
                this._log.debug("Adding " + outboundToAdd + " bytes to outboundAvailable");
            }
            return true;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Refresh delay too fast (" + numMs + ")");
        }
        return false;
    }

    private void checkConfig() {
        this.updateInboundRate();
        this.updateOutboundRate();
        this.updateInboundBurstRate();
        this.updateOutboundBurstRate();
        this.updateInboundPeak();
        this.updateOutboundPeak();
        if (this._inboundKBytesPerSecond <= 0) {
            this._limiter.setInboundUnlimited(true);
        } else {
            this._limiter.setInboundUnlimited(false);
        }
        if (this._outboundKBytesPerSecond <= 0) {
            this._limiter.setOutboundUnlimited(true);
        } else {
            this._limiter.setOutboundUnlimited(false);
        }
    }

    private void updateInboundRate() {
        int in = this._context.getProperty(PROP_INBOUND_BANDWIDTH, 96);
        if (in != this._inboundKBytesPerSecond) {
            this._inboundKBytesPerSecond = in <= 0 || in > 3 ? in : 3;
            if (this._log.shouldLog(10)) {
                this._log.debug("Updating inbound rate to " + this._inboundKBytesPerSecond);
            }
        }
        if (this._inboundKBytesPerSecond <= 0) {
            this._inboundKBytesPerSecond = 96;
        }
    }

    private void updateOutboundRate() {
        int out = this._context.getProperty(PROP_OUTBOUND_BANDWIDTH, 40);
        if (out != this._outboundKBytesPerSecond) {
            this._outboundKBytesPerSecond = out <= 0 || out >= 3 ? out : 3;
            if (this._log.shouldLog(10)) {
                this._log.debug("Updating outbound rate to " + this._outboundKBytesPerSecond);
            }
        }
        if (this._outboundKBytesPerSecond <= 0) {
            this._outboundKBytesPerSecond = 40;
        }
    }

    private void updateInboundBurstRate() {
        int in = this._context.getProperty(PROP_INBOUND_BURST_BANDWIDTH, 96);
        if (in != this._inboundBurstKBytesPerSecond) {
            this._inboundBurstKBytesPerSecond = in <= 0 || in >= this._inboundKBytesPerSecond ? in : this._inboundKBytesPerSecond;
            if (this._log.shouldLog(10)) {
                this._log.debug("Updating inbound burst rate to " + this._inboundBurstKBytesPerSecond);
            }
        }
        if (this._inboundBurstKBytesPerSecond <= 0) {
            this._inboundBurstKBytesPerSecond = 96;
        }
        this._limiter.setInboundBurstKBps(this._inboundBurstKBytesPerSecond);
    }

    private void updateOutboundBurstRate() {
        int out = this._context.getProperty(PROP_OUTBOUND_BURST_BANDWIDTH, 40);
        if (out != this._outboundBurstKBytesPerSecond) {
            this._outboundBurstKBytesPerSecond = out <= 0 || out >= this._outboundKBytesPerSecond ? out : this._outboundKBytesPerSecond;
            if (this._log.shouldLog(10)) {
                this._log.debug("Updating outbound burst rate to " + this._outboundBurstKBytesPerSecond);
            }
        }
        if (this._outboundBurstKBytesPerSecond <= 0) {
            this._outboundBurstKBytesPerSecond = 40;
        }
        this._limiter.setOutboundBurstKBps(this._outboundBurstKBytesPerSecond);
    }

    private void updateInboundPeak() {
        int in = this._context.getProperty(PROP_INBOUND_BANDWIDTH_PEAK, 60 * this._inboundBurstKBytesPerSecond);
        if (in != this._limiter.getInboundBurstBytes()) {
            if (in >= 3) {
                if (in < this._inboundBurstKBytesPerSecond) {
                    this._limiter.setInboundBurstBytes(this._inboundBurstKBytesPerSecond * 1024);
                } else {
                    this._limiter.setInboundBurstBytes(in * 1024);
                }
            } else if (3 < this._inboundBurstKBytesPerSecond) {
                this._limiter.setInboundBurstBytes(this._inboundBurstKBytesPerSecond * 1024);
            } else {
                this._limiter.setInboundBurstBytes(3072);
            }
        }
    }

    private void updateOutboundPeak() {
        int in = this._context.getProperty(PROP_OUTBOUND_BANDWIDTH_PEAK, 60 * this._outboundBurstKBytesPerSecond);
        if (in != this._limiter.getOutboundBurstBytes()) {
            if (in >= 3) {
                if (in < this._outboundBurstKBytesPerSecond) {
                    this._limiter.setOutboundBurstBytes(this._outboundBurstKBytesPerSecond * 1024);
                } else {
                    this._limiter.setOutboundBurstBytes(in * 1024);
                }
            } else if (3 < this._outboundBurstKBytesPerSecond) {
                this._limiter.setOutboundBurstBytes(this._outboundBurstKBytesPerSecond * 1024);
            } else {
                this._limiter.setOutboundBurstBytes(3072);
            }
        }
    }

    int getOutboundKBytesPerSecond() {
        return this._outboundKBytesPerSecond;
    }

    int getInboundKBytesPerSecond() {
        return this._inboundKBytesPerSecond;
    }

    int getOutboundBurstKBytesPerSecond() {
        return this._outboundBurstKBytesPerSecond;
    }

    int getInboundBurstKBytesPerSecond() {
        return this._inboundBurstKBytesPerSecond;
    }
}

