/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Addresses {
    public static String getAnyAddress() {
        String[] a = Addresses.getAddresses();
        if (a.length > 0) {
            return a[0];
        }
        return null;
    }

    public static String[] getAddresses() {
        HashSet<String> rv = new HashSet<String>(4);
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            InetAddress[] allMyIps = InetAddress.getAllByName(localhost.getCanonicalHostName());
            if (allMyIps != null) {
                for (int i = 0; i < allMyIps.length; ++i) {
                    Addresses.add(rv, allMyIps[i]);
                }
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        try {
            Enumeration<NetworkInterface> ifcs = NetworkInterface.getNetworkInterfaces();
            while (ifcs.hasMoreElements()) {
                NetworkInterface ifc = ifcs.nextElement();
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    Addresses.add(rv, addr);
                }
            }
        }
        catch (SocketException e) {
            // empty catch block
        }
        Object[] rva = rv.toArray(new String[rv.size()]);
        Arrays.sort(rva);
        return rva;
    }

    private static void add(Set<String> set, InetAddress ia) {
        if (ia.isAnyLocalAddress() || ia.isLinkLocalAddress() || ia.isLoopbackAddress() || ia.isMulticastAddress() || ia.isSiteLocalAddress() || !(ia instanceof Inet4Address)) {
            return;
        }
        String ip = ia.getHostAddress();
        set.add(ip);
    }

    public static void main(String[] args) {
        String[] a;
        for (String s : a = Addresses.getAddresses()) {
            System.err.println("Address: " + s);
        }
    }
}

