/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.RouterInfo;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.BootCommSystemJob;
import net.i2p.router.startup.RebuildRouterInfoJob;
import net.i2p.util.Log;

public class LoadRouterInfoJob
extends JobImpl {
    private Log _log;
    private boolean _keysExist;
    private boolean _infoExists;
    private RouterInfo _us;

    public LoadRouterInfoJob(RouterContext ctx) {
        super(ctx);
        this._log = ctx.logManager().getLog(LoadRouterInfoJob.class);
    }

    public String getName() {
        return "Load Router Info";
    }

    public void runJob() {
        this.loadRouterInfo();
        if (this._us == null) {
            RebuildRouterInfoJob r = new RebuildRouterInfoJob(this.getContext());
            r.rebuildRouterInfo(false);
            this.getContext().jobQueue().addJob(this);
            return;
        }
        this.getContext().router().setRouterInfo(this._us);
        this.getContext().messageHistory().initialize(true);
        this.getContext().jobQueue().addJob(new BootCommSystemJob(this.getContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRouterInfo() {
        File rkf;
        String routerInfoFile = this.getContext().getProperty("router.info.location", "router.info");
        RouterInfo info = null;
        boolean failedRead = false;
        String keyFilename = this.getContext().getProperty("router.keys.location", "router.keys");
        File rif = new File(this.getContext().getRouterDir(), routerInfoFile);
        if (rif.exists()) {
            this._infoExists = true;
        }
        if ((rkf = new File(this.getContext().getRouterDir(), keyFilename)).exists()) {
            this._keysExist = true;
        }
        FileInputStream fis1 = null;
        FileInputStream fis2 = null;
        try {
            if (this._infoExists && this._keysExist) {
                fis1 = new FileInputStream(rif);
                info = new RouterInfo();
                info.readBytes((InputStream)fis1);
                this._log.debug("Reading in routerInfo from " + rif.getAbsolutePath() + " and it has " + info.getAddresses().size() + " addresses");
                this._us = info;
            }
            if (this._keysExist) {
                fis2 = new FileInputStream(rkf);
                PrivateKey privkey = new PrivateKey();
                privkey.readBytes((InputStream)fis2);
                SigningPrivateKey signingPrivKey = new SigningPrivateKey();
                signingPrivKey.readBytes((InputStream)fis2);
                PublicKey pubkey = new PublicKey();
                pubkey.readBytes((InputStream)fis2);
                SigningPublicKey signingPubKey = new SigningPublicKey();
                signingPubKey.readBytes((InputStream)fis2);
                this.getContext().keyManager().setPrivateKey(privkey);
                this.getContext().keyManager().setSigningPrivateKey(signingPrivKey);
                this.getContext().keyManager().setPublicKey(pubkey);
                this.getContext().keyManager().setSigningPublicKey(signingPubKey);
            }
        }
        catch (IOException ioe) {
            this._log.log(50, "Error reading the router info from " + rif.getAbsolutePath() + " and the keys from " + rkf.getAbsolutePath(), (Throwable)ioe);
            this._us = null;
            rif.delete();
            rkf.delete();
            this._infoExists = false;
            this._keysExist = false;
        }
        catch (DataFormatException dfe) {
            this._log.log(50, "Corrupt router info or keys at " + rif.getAbsolutePath() + " / " + rkf.getAbsolutePath(), (Throwable)dfe);
            this._us = null;
            rif.delete();
            rkf.delete();
            this._infoExists = false;
            this._keysExist = false;
        }
        finally {
            if (fis1 != null) {
                try {
                    fis1.close();
                }
                catch (IOException ioe) {}
            }
            if (fis2 != null) {
                try {
                    fis2.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

