/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class LoadClientAppsJob
extends JobImpl {
    private Log _log;
    private static boolean _loaded = false;

    public LoadClientAppsJob(RouterContext ctx) {
        super(ctx);
        this._log = ctx.logManager().getLog(LoadClientAppsJob.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJob() {
        Class<LoadClientAppsJob> clazz = LoadClientAppsJob.class;
        synchronized (LoadClientAppsJob.class) {
            if (_loaded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            _loaded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            List<ClientAppConfig> apps = ClientAppConfig.getClientApps(this.getContext());
            if (apps.isEmpty()) {
                this._log.error("Warning - No client apps or router console configured - we are just a router");
                System.err.println("Warning - No client apps or router console configured - we are just a router");
                return;
            }
            for (int i = 0; i < apps.size(); ++i) {
                ClientAppConfig app = apps.get(i);
                if (app.disabled) continue;
                String[] argVal = LoadClientAppsJob.parseArgs(app.args);
                if (app.delay <= 0L) {
                    LoadClientAppsJob.runClient(app.className, app.clientName, argVal, this._log);
                    continue;
                }
                this.getContext().jobQueue().addJob(new DelayedRunClient(this.getContext(), app.className, app.clientName, argVal, app.delay));
            }
            return;
        }
    }

    public static String[] parseArgs(String args) {
        ArrayList<String> argList = new ArrayList<String>(4);
        if (args != null) {
            String str;
            char[] data = args.toCharArray();
            StringBuilder buf = new StringBuilder(32);
            boolean isQuoted = false;
            block4: for (int i = 0; i < data.length; ++i) {
                switch (data[i]) {
                    case '\"': 
                    case '\'': {
                        String str2;
                        if (isQuoted) {
                            str2 = buf.toString().trim();
                            if (str2.length() > 0) {
                                argList.add(str2);
                            }
                            buf = new StringBuilder(32);
                        }
                        isQuoted = !isQuoted;
                        continue block4;
                    }
                    case '\t': 
                    case ' ': {
                        if (isQuoted) {
                            buf.append(data[i]);
                            continue block4;
                        }
                        String str2 = buf.toString().trim();
                        if (str2.length() > 0) {
                            argList.add(str2);
                        }
                        buf = new StringBuilder(32);
                        continue block4;
                    }
                    default: {
                        buf.append(data[i]);
                    }
                }
            }
            if (buf.length() > 0 && (str = buf.toString().trim()).length() > 0) {
                argList.add(str);
            }
        }
        String[] rv = new String[argList.size()];
        for (int i = 0; i < argList.size(); ++i) {
            rv[i] = (String)argList.get(i);
        }
        return rv;
    }

    public static void testClient(String className, ClassLoader cl) throws ClassNotFoundException {
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        Class.forName(className, false, cl);
    }

    public static void runClientInline(String className, String clientName, String[] args, Log log) throws Exception {
        LoadClientAppsJob.runClientInline(className, clientName, args, log, null);
    }

    public static void runClientInline(String className, String clientName, String[] args, Log log, ClassLoader cl) throws Exception {
        if (log.shouldLog(20)) {
            log.info("Loading up the client application " + clientName + ": " + className + " " + Arrays.toString(args));
        }
        if (args == null) {
            args = new String[]{};
        }
        Class<?> cls = Class.forName(className, true, cl);
        Method method = cls.getMethod("main", String[].class);
        method.invoke(cls, new Object[]{args});
    }

    public static void runClient(String className, String clientName, String[] args, Log log) {
        LoadClientAppsJob.runClient(className, clientName, args, log, null, null);
    }

    public static void runClient(String className, String clientName, String[] args, Log log, ThreadGroup threadGroup, ClassLoader cl) {
        if (log.shouldLog(20)) {
            log.info("Loading up the client application " + clientName + ": " + className + " " + Arrays.toString(args));
        }
        I2PThread t = threadGroup != null ? new I2PThread(threadGroup, (Runnable)new RunApp(className, clientName, args, log, cl)) : new I2PThread((Runnable)new RunApp(className, clientName, args, log, cl));
        if (clientName == null) {
            clientName = className + " client";
        }
        t.setName(clientName);
        t.setDaemon(true);
        if (cl != null) {
            t.setContextClassLoader(cl);
        }
        t.start();
    }

    public String getName() {
        return "Load up any client applications";
    }

    public static void main(String[] args) {
        LoadClientAppsJob.test(null);
        LoadClientAppsJob.test("hi how are you?");
        LoadClientAppsJob.test("hi how are you? ");
        LoadClientAppsJob.test(" hi how are you? ");
        LoadClientAppsJob.test(" hi how are \"y\"ou? ");
        LoadClientAppsJob.test("-nogui -e \"config localhost 17654\" -e \"httpclient 4544\"");
        LoadClientAppsJob.test("-nogui -e 'config localhost 17654' -e 'httpclient 4544'");
    }

    private static void test(String args) {
        String[] parsed = LoadClientAppsJob.parseArgs(args);
        System.out.print("Parsed [" + args + "] into " + parsed.length + " elements: ");
        for (int i = 0; i < parsed.length; ++i) {
            System.out.print("[" + parsed[i] + "] ");
        }
        System.out.println();
    }

    private static final class RunApp
    implements Runnable {
        private String _className;
        private String _appName;
        private String[] _args;
        private Log _log;
        private ClassLoader _cl;

        public RunApp(String className, String appName, String[] args, Log log, ClassLoader cl) {
            this._className = className;
            this._appName = appName;
            this._args = args == null ? new String[0] : args;
            this._log = log;
            this._cl = cl == null ? ClassLoader.getSystemClassLoader() : cl;
        }

        public void run() {
            try {
                Class<?> cls = Class.forName(this._className, true, this._cl);
                Method method = cls.getMethod("main", String[].class);
                method.invoke(cls, new Object[]{this._args});
            }
            catch (Throwable t) {
                this._log.log(50, "Error starting up the client class " + this._className, t);
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Done running client application " + this._appName);
            }
        }
    }

    public static class DelayedRunClient
    extends JobImpl {
        private String _className;
        private String _clientName;
        private String[] _args;
        private Log _log;
        private ThreadGroup _threadGroup;
        private ClassLoader _cl;

        public DelayedRunClient(RouterContext enclosingContext, String className, String clientName, String[] args, long delay) {
            this(enclosingContext, className, clientName, args, delay, null, null);
        }

        public DelayedRunClient(RouterContext enclosingContext, String className, String clientName, String[] args, long delay, ThreadGroup threadGroup, ClassLoader cl) {
            super(enclosingContext);
            this._className = className;
            this._clientName = clientName;
            this._args = args;
            this._log = enclosingContext.logManager().getLog(LoadClientAppsJob.class);
            this._threadGroup = threadGroup;
            this._cl = cl;
            this.getTiming().setStartAfter(this.getContext().clock().now() + delay);
        }

        public String getName() {
            return "Delayed client job";
        }

        public void runJob() {
            LoadClientAppsJob.runClient(this._className, this._clientName, this._args, this._log, this._threadGroup, this._cl);
        }
    }
}

