/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import net.i2p.data.Hash;
import net.i2p.router.ProfileManager;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.DBHistory;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.util.Log;

public class ProfileManagerImpl
implements ProfileManager {
    private Log _log;
    private RouterContext _context;
    private static final DecimalFormat _fmt = new DecimalFormat("##0.00", new DecimalFormatSymbols(Locale.UK));

    public ProfileManagerImpl(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(ProfileManagerImpl.class);
    }

    public void messageSent(Hash peer, String transport, long msToSend, long bytesSent) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        data.setLastSendSuccessful(this._context.clock().now());
    }

    public void messageFailed(Hash peer, String transport) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        data.setLastSendFailed(this._context.clock().now());
    }

    public void messageFailed(Hash peer) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        data.setLastSendFailed(this._context.clock().now());
    }

    public void commErrorOccurred(Hash peer) {
        PeerProfile data;
        if (this._log.shouldLog(20)) {
            this._log.info("Comm error occurred for peer " + peer.toBase64(), (Throwable)new Exception("Comm error"));
        }
        if ((data = this.getProfile(peer)) == null) {
            return;
        }
        data.setLastSendFailed(this._context.clock().now());
    }

    public void tunnelJoined(Hash peer, long responseTimeMs) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        data.getTunnelCreateResponseTime().addData(responseTimeMs, responseTimeMs);
        data.setLastHeardFrom(this._context.clock().now());
        data.getTunnelHistory().incrementAgreedTo();
    }

    public void tunnelRejected(Hash peer, long responseTimeMs, int severity) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        data.setLastHeardFrom(this._context.clock().now());
        data.getTunnelHistory().incrementRejected(severity);
    }

    public void tunnelTimedOut(Hash peer) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        data.getTunnelHistory().incrementRejected(30);
    }

    public void tunnelTestSucceeded(Hash peer, long responseTimeMs) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        data.updateTunnelTestTimeAverage(responseTimeMs);
        data.getTunnelTestResponseTime().addData(responseTimeMs, responseTimeMs);
    }

    public void tunnelDataPushed(Hash peer, long rtt, int size) {
        if (this._context.routerHash().equals((Object)peer)) {
            return;
        }
        PeerProfile data = this.getProfile(peer);
        if (data != null) {
            data.dataPushed(size);
        }
    }

    public void tunnelDataPushed1m(Hash peer, int size) {
        if (this._context.routerHash().equals((Object)peer)) {
            return;
        }
        PeerProfile data = this.getProfile(peer);
        if (data != null) {
            data.dataPushed1m(size);
        }
    }

    public void tunnelLifetimePushed(Hash peer, long lifetime, long size) {
        if (this._context.routerHash().equals((Object)peer)) {
            return;
        }
        PeerProfile data = this.getProfile(peer);
        if (data != null) {
            data.tunnelDataTransferred(size);
        }
    }

    private int getSlowThreshold() {
        return 5000;
    }

    public void tunnelFailed(Hash peer, int pct) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        data.setLastHeardFrom(this._context.clock().now());
        data.getTunnelHistory().incrementFailed(pct);
    }

    public void dbLookupSuccessful(Hash peer, long responseTimeMs) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        data.setLastHeardFrom(this._context.clock().now());
        if (!data.getIsExpandedDB()) {
            data.expandDBProfile();
        }
        data.getDbResponseTime().addData(responseTimeMs, responseTimeMs);
        DBHistory hist = data.getDBHistory();
        hist.lookupSuccessful();
    }

    public void dbLookupFailed(Hash peer) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        if (!data.getIsExpandedDB()) {
            data.expandDBProfile();
        }
        DBHistory hist = data.getDBHistory();
        hist.lookupFailed();
    }

    public void dbLookupReply(Hash peer, int newPeers, int oldPeers, int invalid, int duplicate, long responseTimeMs) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        data.setLastHeardFrom(this._context.clock().now());
        if (!data.getIsExpandedDB()) {
            return;
        }
        data.getDbResponseTime().addData(responseTimeMs, responseTimeMs);
        data.getDbIntroduction().addData((long)newPeers, responseTimeMs);
        DBHistory hist = data.getDBHistory();
        hist.lookupReply(newPeers, oldPeers, invalid, duplicate);
    }

    public void dbLookupReceived(Hash peer) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        data.setLastHeardFrom(this._context.clock().now());
        if (!data.getIsExpandedDB()) {
            return;
        }
        DBHistory hist = data.getDBHistory();
        hist.lookupReceived();
    }

    public void dbStoreReceived(Hash peer, boolean wasNewKey) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        data.setLastHeardFrom(this._context.clock().now());
        if (!data.getIsExpandedDB()) {
            return;
        }
        DBHistory hist = data.getDBHistory();
        hist.unpromptedStoreReceived(wasNewKey);
    }

    public void dbStoreSent(Hash peer, long responseTimeMs) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        long now = this._context.clock().now();
        data.setLastHeardFrom(now);
        data.setLastSendSuccessful(now);
    }

    public void dbStoreSuccessful(Hash peer) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        long now = this._context.clock().now();
        data.setLastHeardFrom(now);
        data.setLastSendSuccessful(now);
        if (!data.getIsExpandedDB()) {
            data.expandDBProfile();
        }
        DBHistory hist = data.getDBHistory();
        hist.storeSuccessful();
    }

    public void dbStoreFailed(Hash peer) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        if (!data.getIsExpandedDB()) {
            data.expandDBProfile();
        }
        DBHistory hist = data.getDBHistory();
        hist.storeFailed();
    }

    public void heardAbout(Hash peer) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        data.setLastHeardAbout(this._context.clock().now());
    }

    public void heardAbout(Hash peer, long when) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        if (when > data.getLastHeardAbout()) {
            data.setLastHeardAbout(when);
        }
    }

    public void messageReceived(Hash peer, String style, long msToReceive, int bytesRead) {
        PeerProfile data = this.getProfile(peer);
        if (data == null) {
            return;
        }
        data.setLastHeardFrom(this._context.clock().now());
    }

    private PeerProfile getProfile(Hash peer) {
        PeerProfile prof = this._context.profileOrganizer().getProfile(peer);
        if (prof == null) {
            prof = new PeerProfile(this._context, peer);
            this._context.profileOrganizer().addProfile(prof);
        }
        return prof;
    }

    public Properties summarizePeers(int numPeers) {
        HashSet<Hash> peers = new HashSet<Hash>(numPeers);
        this._context.profileOrganizer().selectFastPeers(numPeers, null, peers);
        Properties props = new Properties();
        for (Hash peer : peers) {
            PeerProfile prof = this.getProfile(peer);
            if (prof == null) continue;
            StringBuilder buf = new StringBuilder(64);
            buf.append("status: ");
            if (this._context.profileOrganizer().isFast(peer)) {
                buf.append("fast");
            } else if (this._context.profileOrganizer().isHighCapacity(peer)) {
                buf.append("highCapacity");
            } else if (this._context.profileOrganizer().isFailing(peer)) {
                buf.append("failing");
            } else {
                buf.append("notFailing");
            }
            if (this._context.profileOrganizer().isWellIntegrated(peer)) {
                buf.append("Integrated ");
            } else {
                buf.append(" ");
            }
            buf.append("capacity: ").append(ProfileManagerImpl.num(prof.getCapacityValue())).append(" ");
            buf.append("speed: ").append(ProfileManagerImpl.num(prof.getSpeedValue())).append(" ");
            buf.append("integration: ").append(ProfileManagerImpl.num(prof.getIntegrationValue()));
            props.setProperty("profile." + peer.toBase64().replace('=', '_'), buf.toString());
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String num(double val) {
        DecimalFormat decimalFormat = _fmt;
        synchronized (decimalFormat) {
            return _fmt.format(val);
        }
    }
}

