/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.File;
import java.text.DecimalFormat;
import net.i2p.data.Hash;
import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.DBHistory;
import net.i2p.router.peermanager.ProfilePersistenceHelper;
import net.i2p.router.peermanager.TunnelHistory;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class PeerProfile {
    private Log _log;
    private RouterContext _context;
    private Hash _peer;
    private long _firstHeardAbout;
    private long _lastHeardAbout;
    private long _lastSentToSuccessfully;
    private long _lastFailedSend;
    private long _lastHeardFrom;
    private double _tunnelTestResponseTimeAvg;
    private RateStat _dbResponseTime = null;
    private RateStat _tunnelCreateResponseTime = null;
    private RateStat _tunnelTestResponseTime = null;
    private RateStat _dbIntroduction = null;
    private long _speedBonus;
    private long _capacityBonus;
    private long _integrationBonus;
    private double _speedValue;
    private double _capacityValue;
    private double _integrationValue;
    private boolean _isFailing;
    private TunnelHistory _tunnelHistory;
    private DBHistory _dbHistory;
    private boolean _expanded;
    private boolean _expandedDB;
    private int _consecutiveShitlists;
    private static final int THROUGHPUT_COUNT = 3;
    private final double[] _peakThroughput = new double[3];
    private volatile long _peakThroughputCurrentTotal;
    private final double[] _peakTunnelThroughput = new double[3];
    private final double[] _peakTunnel1mThroughput = new double[3];
    private static final int DROP_PERIOD_MINUTES = 60;
    private static final double DEGRADE_FACTOR = 0.75;
    private long _lastCoalesceDate = System.currentTimeMillis();

    public PeerProfile(RouterContext context, Hash peer) {
        this(context, peer, true);
    }

    public PeerProfile(RouterContext context, Hash peer, boolean expand) {
        this._context = context;
        this._log = context.logManager().getLog(PeerProfile.class);
        this._expanded = false;
        this._speedValue = 0.0;
        this._capacityValue = 0.0;
        this._integrationValue = 0.0;
        this._isFailing = false;
        this._consecutiveShitlists = 0;
        this._tunnelTestResponseTimeAvg = 0.0;
        this._peer = peer;
        if (expand) {
            this.expandProfile();
        }
    }

    public Hash getPeer() {
        return this._peer;
    }

    public void setPeer(Hash peer) {
        this._peer = peer;
    }

    public boolean getIsExpanded() {
        return this._expanded;
    }

    public boolean getIsExpandedDB() {
        return this._expandedDB;
    }

    public int incrementShitlists() {
        return this._consecutiveShitlists++;
    }

    public void unshitlist() {
        this._consecutiveShitlists = 0;
    }

    public boolean getIsActive() {
        return this.getIsActive(300000L);
    }

    public boolean getIsActive(long period) {
        long before = this._context.clock().now() - period;
        return this.getLastHeardFrom() < before || this.getLastSendSuccessful() < before || this._context.commSystem().isEstablished(this._peer);
    }

    public long getFirstHeardAbout() {
        return this._firstHeardAbout;
    }

    public void setFirstHeardAbout(long when) {
        this._firstHeardAbout = when;
    }

    public long getLastHeardAbout() {
        return this._lastHeardAbout;
    }

    public void setLastHeardAbout(long when) {
        this._lastHeardAbout = when;
    }

    public long getLastSendSuccessful() {
        return this._lastSentToSuccessfully;
    }

    public void setLastSendSuccessful(long when) {
        this._lastSentToSuccessfully = when;
    }

    public long getLastSendFailed() {
        return this._lastFailedSend;
    }

    public void setLastSendFailed(long when) {
        this._lastFailedSend = when;
    }

    public long getLastHeardFrom() {
        return this._lastHeardFrom;
    }

    public void setLastHeardFrom(long when) {
        this._lastHeardFrom = when;
    }

    public TunnelHistory getTunnelHistory() {
        return this._tunnelHistory;
    }

    public void setTunnelHistory(TunnelHistory history) {
        this._tunnelHistory = history;
    }

    public DBHistory getDBHistory() {
        return this._dbHistory;
    }

    public void setDBHistory(DBHistory hist) {
        this._dbHistory = hist;
    }

    public RateStat getDbResponseTime() {
        return this._dbResponseTime;
    }

    public RateStat getTunnelCreateResponseTime() {
        return this._tunnelCreateResponseTime;
    }

    public RateStat getTunnelTestResponseTime() {
        return this._tunnelTestResponseTime;
    }

    public RateStat getDbIntroduction() {
        return this._dbIntroduction;
    }

    public long getSpeedBonus() {
        return this._speedBonus;
    }

    public void setSpeedBonus(long bonus) {
        this._speedBonus = bonus;
    }

    public long getCapacityBonus() {
        return this._capacityBonus;
    }

    public void setCapacityBonus(long bonus) {
        this._capacityBonus = bonus;
    }

    public long getIntegrationBonus() {
        return this._integrationBonus;
    }

    public void setIntegrationBonus(long bonus) {
        this._integrationBonus = bonus;
    }

    public double getSpeedValue() {
        return this._speedValue;
    }

    public double getCapacityValue() {
        return this._capacityValue;
    }

    public double getIntegrationValue() {
        return this._integrationValue;
    }

    public boolean getIsFailing() {
        return this._isFailing;
    }

    public double getTunnelTestTimeAverage() {
        return this._tunnelTestResponseTimeAvg;
    }

    void setTunnelTestTimeAverage(double avg) {
        this._tunnelTestResponseTimeAvg = avg;
    }

    void updateTunnelTestTimeAverage(long ms) {
        if (this._tunnelTestResponseTimeAvg <= 0.0) {
            this._tunnelTestResponseTimeAvg = 30000.0;
        }
        this._tunnelTestResponseTimeAvg = (double)ms < this._tunnelTestResponseTimeAvg ? 0.95 * this._tunnelTestResponseTimeAvg + 0.05 * (double)ms : 0.75 * this._tunnelTestResponseTimeAvg + 0.25 * (double)ms;
        if (this._peer != null && this._log.shouldLog(20)) {
            this._log.info("Updating tunnel test time for " + this._peer.toBase64().substring(0, 6) + " to " + this._tunnelTestResponseTimeAvg + " via " + ms);
        }
    }

    public double getPeakThroughputKBps() {
        double rv = 0.0;
        for (int i = 0; i < 3; ++i) {
            rv += this._peakThroughput[i];
        }
        return rv /= 184320.0;
    }

    public void setPeakThroughputKBps(double kBps) {
        this._peakThroughput[0] = kBps * 60.0 * 1024.0;
    }

    void dataPushed(int size) {
        this._peakThroughputCurrentTotal += (long)size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void tunnelDataTransferred(long tunnelByteLifetime) {
        double lowPeak = this._peakTunnelThroughput[2];
        if (!((double)tunnelByteLifetime > lowPeak)) return;
        double[] dArray = this._peakTunnelThroughput;
        synchronized (this._peakTunnelThroughput) {
            for (int i = 0; i < 3; ++i) {
                if (!((double)tunnelByteLifetime > this._peakTunnelThroughput[i])) continue;
                for (int j = 2; j > i; --j) {
                    this._peakTunnelThroughput[j] = this._peakTunnelThroughput[j - 1];
                }
                this._peakTunnelThroughput[i] = tunnelByteLifetime;
                break;
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            return;
        }
    }

    public double getPeakTunnelThroughputKBps() {
        double rv = 0.0;
        for (int i = 0; i < 3; ++i) {
            rv += this._peakTunnelThroughput[i];
        }
        return rv /= 1843200.0;
    }

    public void setPeakTunnelThroughputKBps(double kBps) {
        this._peakTunnelThroughput[0] = kBps * 60.0 * 10.0 * 1024.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void dataPushed1m(int size) {
        double lowPeak = this._peakTunnel1mThroughput[2];
        if (!((double)size > lowPeak)) return;
        double[] dArray = this._peakTunnel1mThroughput;
        synchronized (this._peakTunnel1mThroughput) {
            int i;
            for (i = 0; i < 3; ++i) {
                if (!((double)size > this._peakTunnel1mThroughput[i])) continue;
                for (int j = 2; j > i; --j) {
                    this._peakTunnel1mThroughput[j] = this._peakTunnel1mThroughput[j - 1];
                }
                this._peakTunnel1mThroughput[i] = size;
                break;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (!this._log.shouldLog(10)) return;
            StringBuilder buf = new StringBuilder(128);
            buf.append("Updating 1m throughput after ").append(size).append(" to ");
            for (i = 0; i < 3; ++i) {
                buf.append(this._peakTunnel1mThroughput[i]).append(',');
            }
            buf.append(" for ").append(this._peer.toBase64());
            this._log.debug(buf.toString());
            return;
        }
    }

    public double getPeakTunnel1mThroughputKBps() {
        double rv = 0.0;
        for (int i = 0; i < 3; ++i) {
            rv += this._peakTunnel1mThroughput[i];
        }
        return rv /= 184320.0;
    }

    public void setPeakTunnel1mThroughputKBps(double kBps) {
        this._peakTunnel1mThroughput[0] = kBps * 60.0 * 1024.0;
    }

    public void expandProfile() {
        String group;
        String string = group = null == this._peer ? "profileUnknown" : this._peer.toBase64().substring(0, 6);
        if (this._tunnelCreateResponseTime == null) {
            this._tunnelCreateResponseTime = new RateStat("tunnelCreateResponseTime", "how long it takes to get a tunnel create response from the peer (in milliseconds)", group, new long[]{600000L, 1800000L, 3600000L, 86400000L});
        }
        if (this._tunnelTestResponseTime == null) {
            this._tunnelTestResponseTime = new RateStat("tunnelTestResponseTime", "how long it takes to successfully test a tunnel this peer participates in (in milliseconds)", group, new long[]{600000L, 1800000L, 3600000L, 10800000L, 86400000L});
        }
        if (this._tunnelHistory == null) {
            this._tunnelHistory = new TunnelHistory(this._context, group);
        }
        this._tunnelCreateResponseTime.setStatLog(this._context.statManager().getStatLog());
        this._tunnelTestResponseTime.setStatLog(this._context.statManager().getStatLog());
        this._expanded = true;
    }

    public synchronized void expandDBProfile() {
        String group;
        String string = group = null == this._peer ? "profileUnknown" : this._peer.toBase64().substring(0, 6);
        if (this._dbResponseTime == null) {
            this._dbResponseTime = new RateStat("dbResponseTime", "how long it takes to get a db response from the peer (in milliseconds)", group, new long[]{600000L, 3600000L, 86400000L});
        }
        if (this._dbIntroduction == null) {
            this._dbIntroduction = new RateStat("dbIntroduction", "how many new peers we get from dbSearchReplyMessages or dbStore messages", group, new long[]{3600000L, 21600000L, 86400000L});
        }
        if (this._dbHistory == null) {
            this._dbHistory = new DBHistory(this._context, group);
        }
        this._dbResponseTime.setStatLog(this._context.statManager().getStatLog());
        this._dbIntroduction.setStatLog(this._context.statManager().getStatLog());
        this._expandedDB = true;
    }

    private void coalesceThroughput() {
        long now = System.currentTimeMillis();
        long measuredPeriod = now - this._lastCoalesceDate;
        if (measuredPeriod >= 60000L) {
            int i;
            long tot = this._peakThroughputCurrentTotal;
            double lowPeak = this._peakThroughput[2];
            if ((double)tot > lowPeak) {
                for (i = 0; i < 3; ++i) {
                    if (!((double)tot > this._peakThroughput[i])) continue;
                    for (int j = 2; j > i; --j) {
                        this._peakThroughput[j] = this._peakThroughput[j - 1];
                    }
                    this._peakThroughput[i] = tot;
                    break;
                }
            } else if (this._context.random().nextInt(120) <= 0) {
                i = 0;
                while (i < 3) {
                    int n = i++;
                    this._peakThroughput[n] = this._peakThroughput[n] * 0.75;
                }
            }
            if (this._context.random().nextInt(120) <= 0) {
                i = 0;
                while (i < 3) {
                    int n = i;
                    this._peakTunnelThroughput[n] = this._peakTunnelThroughput[n] * 0.75;
                    int n2 = i++;
                    this._peakTunnel1mThroughput[n2] = this._peakTunnel1mThroughput[n2] * 0.75;
                }
            }
            this._peakThroughputCurrentTotal = 0L;
            this._lastCoalesceDate = now;
        }
    }

    public void coalesceStats() {
        if (!this._expanded) {
            return;
        }
        this._tunnelCreateResponseTime.coalesceStats();
        this._tunnelTestResponseTime.coalesceStats();
        this._tunnelHistory.coalesceStats();
        if (this._expandedDB) {
            this._dbIntroduction.coalesceStats();
            this._dbResponseTime.coalesceStats();
            this._dbHistory.coalesceStats();
        }
        this.coalesceThroughput();
        this._speedValue = this.calculateSpeed();
        this._capacityValue = this.calculateCapacity();
        this._integrationValue = this.calculateIntegration();
        this._isFailing = this.calculateIsFailing();
        if (this._log.shouldLog(10)) {
            this._log.debug("Coalesced: speed [" + this._speedValue + "] capacity [" + this._capacityValue + "] integration [" + this._integrationValue + "] failing? [" + this._isFailing + "]");
        }
    }

    private double calculateSpeed() {
        return this._context.speedCalculator().calc(this);
    }

    private double calculateCapacity() {
        return this._context.capacityCalculator().calc(this);
    }

    private double calculateIntegration() {
        return this._context.integrationCalculator().calc(this);
    }

    private boolean calculateIsFailing() {
        return false;
    }

    void setIsFailing(boolean val) {
        this._isFailing = val;
    }

    public int hashCode() {
        return this._peer == null ? 0 : this._peer.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != PeerProfile.class) {
            return false;
        }
        if (this._peer == null) {
            return false;
        }
        PeerProfile prof = (PeerProfile)obj;
        return this._peer.equals((Object)prof.getPeer());
    }

    public String toString() {
        return "Profile: " + this.getPeer().toBase64();
    }

    public static void main(String[] args) {
        RouterContext ctx = new RouterContext(new Router());
        PeerProfile.testProfileSize(ctx, 100, 0);
        PeerProfile.testProfileSize(ctx, 1000, 0);
        PeerProfile.testProfileSize(ctx, 10000, 0);
        PeerProfile.testProfileSize(ctx, 0, 10000);
        PeerProfile.testProfileSize(ctx, 0, 100000);
        PeerProfile.testProfileSize(ctx, 0, 300000);
    }

    public static void main2(String[] args) {
        RouterContext ctx = new RouterContext(new Router());
        DecimalFormat fmt = new DecimalFormat("0,000.0");
        fmt.setPositivePrefix("+");
        ProfilePersistenceHelper helper = new ProfilePersistenceHelper(ctx);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        StringBuilder buf = new StringBuilder(1024);
        for (int i = 0; i < args.length; ++i) {
            PeerProfile profile = helper.readProfile(new File(args[i]));
            if (profile == null) {
                buf.append("Could not load profile ").append(args[i]).append('\n');
                continue;
            }
            buf.append("Peer " + profile.getPeer().toBase64() + ":\t Speed:\t" + fmt.format(profile.calculateSpeed()) + " Capacity:\t" + fmt.format(profile.calculateCapacity()) + " Integration:\t" + fmt.format(profile.calculateIntegration()) + " Active?\t" + profile.getIsActive() + " Failing?\t" + profile.calculateIsFailing() + '\n');
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        System.out.println(buf.toString());
    }

    private static void testProfileSize(RouterContext ctx, int numExpanded, int numCompact) {
        int i;
        Runtime.getRuntime().gc();
        PeerProfile[] profs = new PeerProfile[numExpanded];
        PeerProfile[] profsCompact = new PeerProfile[numCompact];
        long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long usedPer = used / (long)(numExpanded + numCompact);
        System.out.println(numExpanded + "/" + numCompact + ": create array - Used: " + used + " bytes (or " + usedPer + " bytes per array entry)");
        boolean j = false;
        try {
            for (i = 0; i < numExpanded; ++i) {
                profs[i] = new PeerProfile(ctx, new Hash(new byte[32]));
            }
        }
        catch (OutOfMemoryError oom) {
            profs = null;
            profsCompact = null;
            Runtime.getRuntime().gc();
            System.out.println("Ran out of memory when creating profile " + i);
            return;
        }
        try {
            while (i < numCompact) {
                profsCompact[i] = new PeerProfile(ctx, new Hash(new byte[32]), false);
                ++i;
            }
        }
        catch (OutOfMemoryError oom) {
            profs = null;
            profsCompact = null;
            Runtime.getRuntime().gc();
            System.out.println("Ran out of memory when creating compacted profile " + i);
            return;
        }
        Runtime.getRuntime().gc();
        long usedObjects = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        usedPer = usedObjects / (long)(numExpanded + numCompact);
        System.out.println(numExpanded + "/" + numCompact + ": create objects - Used: " + usedObjects + " bytes (or " + usedPer + " bytes per profile)");
        profs = null;
        profsCompact = null;
        Runtime.getRuntime().gc();
    }
}

