/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Hash;
import net.i2p.router.PeerSelectionCriteria;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.peermanager.ProfileOrganizer;
import net.i2p.router.peermanager.ProfilePersistenceHelper;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PeerManager {
    private Log _log;
    private RouterContext _context;
    private ProfileOrganizer _organizer;
    private ProfilePersistenceHelper _persistenceHelper;
    private Set<Hash>[] _peersByCapability;
    private final Map<Hash, String> _capabilitiesByPeer;

    public PeerManager(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(PeerManager.class);
        this._persistenceHelper = new ProfilePersistenceHelper(context);
        this._organizer = context.profileOrganizer();
        this._organizer.setUs(context.routerHash());
        this._capabilitiesByPeer = new ConcurrentHashMap<Hash, String>(128);
        this._peersByCapability = new Set[26];
        for (int i = 0; i < this._peersByCapability.length; ++i) {
            this._peersByCapability[i] = new ConcurrentHashSet();
        }
        this.loadProfiles();
        SimpleScheduler.getInstance().addPeriodicEvent((SimpleTimer.TimedEvent)new Reorg(), 0L, 45000L);
    }

    void storeProfiles() {
        Set peers = this.selectPeers();
        for (Hash peer : peers) {
            this.storeProfile(peer);
        }
    }

    Set selectPeers() {
        return this._organizer.selectAllPeers();
    }

    void storeProfile(Hash peer) {
        if (peer == null) {
            return;
        }
        PeerProfile prof = this._organizer.getProfile(peer);
        if (prof == null) {
            return;
        }
        this._persistenceHelper.writeProfile(prof);
    }

    void loadProfiles() {
        Set profiles = this._persistenceHelper.readProfiles();
        for (PeerProfile prof : profiles) {
            if (prof == null) continue;
            this._organizer.addProfile(prof);
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Profile for " + prof.getPeer().toBase64() + " loaded");
        }
    }

    List<Hash> selectPeers(PeerSelectionCriteria criteria) {
        HashSet<Hash> peers = new HashSet<Hash>(criteria.getMinimumRequired());
        HashSet<Hash> exclude = new HashSet<Hash>(1);
        exclude.add(this._context.routerHash());
        switch (criteria.getPurpose()) {
            case 4: {
                this._organizer.selectActiveNotFailingPeers(criteria.getMinimumRequired(), exclude, peers);
                break;
            }
            case 1: {
                this._organizer.selectFastPeers(criteria.getMaximumRequired(), exclude, peers);
                break;
            }
            case 3: {
                this._organizer.selectHighCapacityPeers(criteria.getMinimumRequired(), exclude, peers);
                break;
            }
            case 2: {
                this._organizer.selectHighCapacityPeers(criteria.getMinimumRequired(), exclude, peers);
                break;
            }
        }
        if (peers.isEmpty() && this._log.shouldLog(30)) {
            this._log.warn("We ran out of peers when looking for reachable ones after finding 0 with " + this._organizer.countWellIntegratedPeers() + "/" + this._organizer.countHighCapacityPeers() + "/" + this._organizer.countFastPeers() + " integrated/high capacity/fast peers");
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Peers selected: " + peers);
        }
        return new ArrayList<Hash>(peers);
    }

    public void setCapabilities(Hash peer, String caps) {
        Set<Hash> peers;
        char c;
        int i;
        if (this._log.shouldLog(10)) {
            this._log.debug("Setting capabilities for " + peer.toBase64() + " to " + caps);
        }
        if (caps != null) {
            caps = caps.toLowerCase();
        }
        String oldCaps = null;
        oldCaps = caps != null ? this._capabilitiesByPeer.put(peer, caps) : this._capabilitiesByPeer.remove(peer);
        if (oldCaps != null) {
            for (i = 0; i < oldCaps.length(); ++i) {
                c = oldCaps.charAt(i);
                if (caps != null && caps.indexOf(c) >= 0 || (peers = this.locked_getPeers(c)) == null) continue;
                peers.remove(peer);
            }
        }
        if (caps != null) {
            for (i = 0; i < caps.length(); ++i) {
                c = caps.charAt(i);
                if (oldCaps != null && oldCaps.indexOf(c) >= 0 || (peers = this.locked_getPeers(c)) == null) continue;
                peers.add(peer);
            }
        }
    }

    private Set<Hash> locked_getPeers(char c) {
        int i = (c = Character.toLowerCase(c)) - 97;
        if (i < 0 || i >= this._peersByCapability.length) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Invalid capability " + c + " (" + i + ")");
            }
            return null;
        }
        return this._peersByCapability[i];
    }

    public void removeCapabilities(Hash peer) {
        String oldCaps;
        if (this._log.shouldLog(10)) {
            this._log.debug("Removing capabilities from " + peer.toBase64());
        }
        if ((oldCaps = this._capabilitiesByPeer.remove(peer)) != null) {
            for (int i = 0; i < oldCaps.length(); ++i) {
                char c = oldCaps.charAt(i);
                Set<Hash> peers = this.locked_getPeers(c);
                if (peers == null) continue;
                peers.remove(peer);
            }
        }
    }

    public List<Hash> getPeersByCapability(char capability) {
        Set<Hash> peers = this.locked_getPeers(capability);
        if (peers != null) {
            return new ArrayList<Hash>(peers);
        }
        return null;
    }

    private class Reorg
    implements SimpleTimer.TimedEvent {
        private Reorg() {
        }

        public void timeReached() {
            try {
                PeerManager.this._organizer.reorganize(true);
            }
            catch (Throwable t) {
                PeerManager.this._log.log(50, "Error evaluating profiles", t);
            }
        }
    }
}

