/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import net.i2p.router.RouterContext;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class DBHistory {
    private Log _log;
    private RouterContext _context;
    private long _successfulLookups;
    private long _failedLookups;
    private RateStat _failedLookupRate;
    private RateStat _invalidReplyRate;
    private long _lookupReplyNew;
    private long _lookupReplyOld;
    private long _lookupReplyDuplicate;
    private long _lookupReplyInvalid;
    private long _lookupsReceived;
    private long _avgDelayBetweenLookupsReceived;
    private long _lastLookupReceived;
    private long _lastLookupSuccessful;
    private long _lastLookupFailed;
    private long _lastStoreSuccessful;
    private long _lastStoreFailed;
    private long _unpromptedDbStoreNew;
    private long _unpromptedDbStoreOld;
    private String _statGroup;
    private static final String NL = System.getProperty("line.separator");

    public DBHistory(RouterContext context, String statGroup) {
        this._context = context;
        this._log = context.logManager().getLog(DBHistory.class);
        this._statGroup = statGroup;
        this._successfulLookups = 0L;
        this._failedLookups = 0L;
        this._failedLookupRate = null;
        this._invalidReplyRate = null;
        this._lookupReplyNew = 0L;
        this._lookupReplyOld = 0L;
        this._lookupReplyDuplicate = 0L;
        this._lookupReplyInvalid = 0L;
        this._lookupsReceived = 0L;
        this._avgDelayBetweenLookupsReceived = 0L;
        this._lastLookupReceived = -1L;
        this._unpromptedDbStoreNew = 0L;
        this._unpromptedDbStoreOld = 0L;
        this.createRates(statGroup);
    }

    public long getSuccessfulLookups() {
        return this._successfulLookups;
    }

    public long getFailedLookups() {
        return this._failedLookups;
    }

    public long getLookupReplyNew() {
        return this._lookupReplyNew;
    }

    public long getLookupReplyOld() {
        return this._lookupReplyOld;
    }

    public long getLookupReplyDuplicate() {
        return this._lookupReplyDuplicate;
    }

    public long getLookupReplyInvalid() {
        return this._lookupReplyInvalid;
    }

    public long getLookupsReceived() {
        return this._lookupsReceived;
    }

    public long getAvgDelayBetweenLookupsReceived() {
        return this._avgDelayBetweenLookupsReceived;
    }

    public long getLastLookupReceived() {
        return this._lastLookupReceived;
    }

    public long getLastLookupSuccessful() {
        return this._lastLookupSuccessful;
    }

    public long getLastLookupFailed() {
        return this._lastLookupFailed;
    }

    public long getLastStoreSuccessful() {
        return this._lastStoreSuccessful;
    }

    public long getLastStoreFailed() {
        return this._lastStoreFailed;
    }

    public long getUnpromptedDbStoreNew() {
        return this._unpromptedDbStoreNew;
    }

    public long getUnpromptedDbStoreOld() {
        return this._unpromptedDbStoreOld;
    }

    public RateStat getFailedLookupRate() {
        return this._failedLookupRate;
    }

    public RateStat getInvalidReplyRate() {
        return this._invalidReplyRate;
    }

    public void lookupSuccessful() {
        ++this._successfulLookups;
        this._failedLookupRate.addData(0L, 0L);
        this._context.statManager().addRateData("peer.failedLookupRate", 0L, 0L);
        this._lastLookupSuccessful = this._context.clock().now();
    }

    public void lookupFailed() {
        ++this._failedLookups;
        this._failedLookupRate.addData(1L, 0L);
        this._context.statManager().addRateData("peer.failedLookupRate", 1L, 0L);
        this._lastLookupFailed = this._context.clock().now();
    }

    public void storeSuccessful() {
        this._failedLookupRate.addData(0L, 0L);
        this._context.statManager().addRateData("peer.failedLookupRate", 0L, 0L);
        this._lastStoreSuccessful = this._context.clock().now();
    }

    public void storeFailed() {
        this._failedLookupRate.addData(1L, 0L);
        this._lastStoreFailed = this._context.clock().now();
    }

    public void lookupReply(int newPeers, int oldPeers, int invalid, int duplicate) {
        this._lookupReplyNew += (long)newPeers;
        this._lookupReplyOld += (long)oldPeers;
        this._lookupReplyInvalid += (long)invalid;
        this._lookupReplyDuplicate += (long)duplicate;
        if (invalid > 0) {
            this._invalidReplyRate.addData((long)invalid, 0L);
        }
    }

    public void lookupReceived() {
        long now = this._context.clock().now();
        long delay = now - this._lastLookupReceived;
        this._lastLookupReceived = now;
        ++this._lookupsReceived;
        this._avgDelayBetweenLookupsReceived = this._avgDelayBetweenLookupsReceived <= 0L ? delay : (delay > this._avgDelayBetweenLookupsReceived ? (this._avgDelayBetweenLookupsReceived += delay / this._lookupsReceived) : (this._avgDelayBetweenLookupsReceived -= delay / this._lookupsReceived));
    }

    public void unpromptedStoreReceived(boolean wasNew) {
        if (wasNew) {
            ++this._unpromptedDbStoreNew;
        } else {
            ++this._unpromptedDbStoreOld;
        }
    }

    public void setSuccessfulLookups(long num) {
        this._successfulLookups = num;
    }

    public void setFailedLookups(long num) {
        this._failedLookups = num;
    }

    public void setLookupReplyNew(long num) {
        this._lookupReplyNew = num;
    }

    public void setLookupReplyOld(long num) {
        this._lookupReplyOld = num;
    }

    public void setLookupReplyInvalid(long num) {
        this._lookupReplyInvalid = num;
    }

    public void setLookupReplyDuplicate(long num) {
        this._lookupReplyDuplicate = num;
    }

    public void setLookupsReceived(long num) {
        this._lookupsReceived = num;
    }

    public void setAvgDelayBetweenLookupsReceived(long ms) {
        this._avgDelayBetweenLookupsReceived = ms;
    }

    public void setLastLookupReceived(long when) {
        this._lastLookupReceived = when;
    }

    public void setUnpromptedDbStoreNew(long num) {
        this._unpromptedDbStoreNew = num;
    }

    public void setUnpromptedDbStoreOld(long num) {
        this._unpromptedDbStoreOld = num;
    }

    public void coalesceStats() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Coallescing stats");
        }
        this._failedLookupRate.coalesceStats();
        this._invalidReplyRate.coalesceStats();
    }

    public void store(OutputStream out) throws IOException {
        StringBuilder buf = new StringBuilder(512);
        buf.append(NL);
        buf.append("#################").append(NL);
        buf.append("# DB history").append(NL);
        buf.append("###").append(NL);
        DBHistory.add(buf, "successfulLookups", this._successfulLookups, "How many times have they successfully given us what we wanted when looking for it?");
        DBHistory.add(buf, "failedLookups", this._failedLookups, "How many times have we sent them a db lookup and they didn't reply?");
        DBHistory.add(buf, "lookupsReceived", this._lookupsReceived, "How many lookups have they sent us?");
        DBHistory.add(buf, "lookupReplyDuplicate", this._lookupReplyDuplicate, "How many of their reply values to our lookups were something we asked them not to send us?");
        DBHistory.add(buf, "lookupReplyInvalid", this._lookupReplyInvalid, "How many of their reply values to our lookups were invalid (expired, forged, corrupted)?");
        DBHistory.add(buf, "lookupReplyNew", this._lookupReplyNew, "How many of their reply values to our lookups were brand new to us?");
        DBHistory.add(buf, "lookupReplyOld", this._lookupReplyOld, "How many of their reply values to our lookups were something we had seen before?");
        DBHistory.add(buf, "unpromptedDbStoreNew", this._unpromptedDbStoreNew, "How times have they sent us something we didn't ask for and hadn't seen before?");
        DBHistory.add(buf, "unpromptedDbStoreOld", this._unpromptedDbStoreOld, "How times have they sent us something we didn't ask for but have seen before?");
        DBHistory.add(buf, "lastLookupReceived", this._lastLookupReceived, "When was the last time they send us a lookup?  (milliseconds since the epoch)");
        DBHistory.add(buf, "avgDelayBetweenLookupsReceived", this._avgDelayBetweenLookupsReceived, "How long is it typically between each db lookup they send us?  (in milliseconds)");
        out.write(buf.toString().getBytes());
        this._failedLookupRate.store(out, "dbHistory.failedLookupRate");
        this._invalidReplyRate.store(out, "dbHistory.invalidReplyRate");
    }

    private static void add(StringBuilder buf, String name, long val, String description) {
        buf.append("# ").append(name.toUpperCase()).append(NL).append("# ").append(description).append(NL);
        buf.append("dbHistory.").append(name).append('=').append(val).append(NL).append(NL);
    }

    public void load(Properties props) {
        this._successfulLookups = DBHistory.getLong(props, "dbHistory.successfulLookups");
        this._failedLookups = DBHistory.getLong(props, "dbHistory.failedLookups");
        this._lookupsReceived = DBHistory.getLong(props, "dbHistory.lookupsReceived");
        this._lookupReplyDuplicate = DBHistory.getLong(props, "dbHistory.lookupReplyDuplicate");
        this._lookupReplyInvalid = DBHistory.getLong(props, "dbHistory.lookupReplyInvalid");
        this._lookupReplyNew = DBHistory.getLong(props, "dbHistory.lookupReplyNew");
        this._lookupReplyOld = DBHistory.getLong(props, "dbHistory.lookupReplyOld");
        this._unpromptedDbStoreNew = DBHistory.getLong(props, "dbHistory.unpromptedDbStoreNew");
        this._unpromptedDbStoreOld = DBHistory.getLong(props, "dbHistory.unpromptedDbStoreOld");
        this._lastLookupReceived = DBHistory.getLong(props, "dbHistory.lastLookupReceived");
        this._avgDelayBetweenLookupsReceived = DBHistory.getLong(props, "dbHistory.avgDelayBetweenLookupsReceived");
        try {
            this._failedLookupRate.load(props, "dbHistory.failedLookupRate", true);
            this._log.debug("Loading dbHistory.failedLookupRate");
        }
        catch (IllegalArgumentException iae) {
            this._log.warn("DB History failed lookup rate is corrupt, resetting", (Throwable)iae);
        }
        try {
            this._invalidReplyRate.load(props, "dbHistory.invalidReplyRate", true);
        }
        catch (IllegalArgumentException iae) {
            this._log.warn("DB History invalid reply rate is corrupt, resetting", (Throwable)iae);
            this.createRates(this._statGroup);
        }
    }

    private void createRates(String statGroup) {
        if (this._failedLookupRate == null) {
            this._failedLookupRate = new RateStat("dbHistory.failedLookupRate", "How often does this peer to respond to a lookup?", statGroup, new long[]{600000L, 3600000L, 86400000L});
        }
        if (this._invalidReplyRate == null) {
            this._invalidReplyRate = new RateStat("dbHistory.invalidReplyRate", "How often does this peer give us a bad (nonexistant, forged, etc) peer?", statGroup, new long[]{1800000L});
        }
        this._failedLookupRate.setStatLog(this._context.statManager().getStatLog());
        this._invalidReplyRate.setStatLog(this._context.statManager().getStatLog());
    }

    private static final long getLong(Properties props, String key) {
        String val = props.getProperty(key);
        if (val != null) {
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException nfe) {
                return 0L;
            }
        }
        return 0L;
    }
}

