/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.Calculator;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class CapacityCalculator
extends Calculator {
    private Log _log;
    private RouterContext _context;
    static long GROWTH_FACTOR = 5L;
    private static long ESTIMATE_PERIOD = 3600000L;

    public CapacityCalculator(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(CapacityCalculator.class);
    }

    public double calc(PeerProfile profile) {
        double capacity;
        if (CapacityCalculator.tooOld(profile)) {
            capacity = 1.0;
        } else {
            RateStat failedStat;
            RateStat rejectStat;
            RateStat acceptStat = profile.getTunnelCreateResponseTime();
            double capacity10m = CapacityCalculator.estimateCapacity(acceptStat, rejectStat = profile.getTunnelHistory().getRejectionRate(), failedStat = profile.getTunnelHistory().getFailedRate(), 600000);
            if (capacity10m <= 0.0) {
                capacity = 0.0;
            } else {
                double capacity30m = CapacityCalculator.estimateCapacity(acceptStat, rejectStat, failedStat, 1800000);
                double capacity60m = CapacityCalculator.estimateCapacity(acceptStat, rejectStat, failedStat, 3600000);
                double capacity1d = CapacityCalculator.estimateCapacity(acceptStat, rejectStat, failedStat, 86400000);
                capacity = capacity10m * CapacityCalculator.periodWeight(600000) + capacity30m * CapacityCalculator.periodWeight(1800000) + capacity60m * CapacityCalculator.periodWeight(3600000) + capacity1d * CapacityCalculator.periodWeight(86400000);
            }
        }
        long now = this._context.clock().now();
        if (profile.getTunnelHistory().getLastRejectedTransient() > now - 300000L) {
            capacity = 1.0;
        } else if (profile.getTunnelHistory().getLastRejectedProbabalistic() > now - 300000L) {
            capacity -= (double)this._context.random().nextInt(5);
        }
        capacity += (double)profile.getCapacityBonus();
        if (capacity < 0.0) {
            capacity = 0.0;
        }
        return capacity;
    }

    private static boolean tooOld(PeerProfile profile) {
        return !profile.getIsActive(3600000L);
    }

    private static double estimateCapacity(RateStat acceptStat, RateStat rejectStat, RateStat failedStat, int period) {
        Rate curAccepted = acceptStat.getRate((long)period);
        Rate curRejected = rejectStat.getRate((long)period);
        Rate curFailed = failedStat.getRate((long)period);
        long eventCount = 0L;
        if (curAccepted != null) {
            eventCount = curAccepted.getCurrentEventCount() + curAccepted.getLastEventCount();
        }
        if (eventCount > 0L) {
            long rejected = curRejected.getCurrentEventCount() + curRejected.getLastEventCount();
            eventCount = eventCount * eventCount / (eventCount + rejected);
        }
        double stretch = (double)ESTIMATE_PERIOD / (double)period;
        double val = (double)eventCount * stretch;
        long failed = 0L;
        if (curFailed != null) {
            failed = (long)(0.5 + 4.0 * (curFailed.getCurrentTotalValue() + curFailed.getLastTotalValue()) / 100.0);
        }
        if (failed > 0L) {
            val -= (double)failed * stretch;
        }
        if ((val += (double)GROWTH_FACTOR) >= 0.0) {
            return val;
        }
        return 0.0;
    }

    private static double periodWeight(int period) {
        switch (period) {
            case 600000: {
                return 0.4;
            }
            case 1800000: {
                return 0.3;
            }
            case 3600000: {
                return 0.2;
            }
            case 86400000: {
                return 0.1;
            }
        }
        throw new IllegalArgumentException("wtf, period [" + period + "]???");
    }
}

