/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.reseed;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.router.RouterContext;
import net.i2p.util.EepGet;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.SSLEepGet;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.Translate;

public class Reseeder {
    private static ReseedRunner _reseedRunner;
    private RouterContext _context;
    private Log _log;
    private static final long MAX_RESEED_RESPONSE_SIZE = 0x100000L;
    private static final String DEFAULT_SEED_URL = "http://a.netdb.i2p2.de/,http://b.netdb.i2p2.de/,http://c.netdb.i2p2.de/,http://reseed.i2p-projekt.de/,http://i2pbote.net/netDb/,http://r31453.ovh.net/static_media/netDb/";
    private static final String PROP_INPROGRESS = "net.i2p.router.web.ReseedHandler.reseedInProgress";
    private static final String PROP_ERROR = "net.i2p.router.web.ReseedHandler.errorMessage";
    private static final String PROP_STATUS = "net.i2p.router.web.ReseedHandler.statusMessage";
    public static final String PROP_PROXY_HOST = "router.reseedProxyHost";
    public static final String PROP_PROXY_PORT = "router.reseedProxyPort";
    private static final String RESEED_TIPS;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    public Reseeder(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(Reseeder.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestReseed() {
        Class<Reseeder> clazz = Reseeder.class;
        synchronized (Reseeder.class) {
            if (_reseedRunner == null) {
                _reseedRunner = new ReseedRunner();
            }
            if (_reseedRunner.isRunning()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            System.setProperty(PROP_INPROGRESS, "true");
            I2PAppThread reseed = new I2PAppThread((Runnable)_reseedRunner, "Reseed", true);
            reseed.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static final String _x(String s) {
        return s;
    }

    private String _(String key) {
        return Translate.getString((String)key, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    private String _(String s, Object o, Object o2) {
        return Translate.getString((String)s, (Object)o, (Object)o2, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    static {
        RESEED_TIPS = Reseeder._x("Ensure that nothing blocks outbound HTTP, check <a target=\"_top\" href=\"logs.jsp\">logs</a> and if nothing helps, read the <a target=\"_top\" href=\"http://www.i2p2.de/faq.html\">FAQ</a> about reseeding manually.");
    }

    public class ReseedRunner
    implements Runnable,
    EepGet.StatusListener {
        private boolean _isRunning = false;
        private String _proxyHost;
        private int _proxyPort;

        public ReseedRunner() {
            System.setProperty(Reseeder.PROP_STATUS, Reseeder.this._("Reseeding"));
        }

        public boolean isRunning() {
            return this._isRunning;
        }

        public void run() {
            this._isRunning = true;
            this._proxyHost = Reseeder.this._context.getProperty(Reseeder.PROP_PROXY_HOST);
            this._proxyPort = Reseeder.this._context.getProperty(Reseeder.PROP_PROXY_PORT, -1);
            System.out.println("Reseed start");
            this.reseed(false);
            System.out.println("Reseed complete");
            System.setProperty(Reseeder.PROP_INPROGRESS, "false");
            this._isRunning = false;
        }

        public void attemptFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt, int numRetries, Exception cause) {
            if (Reseeder.this._log.shouldLog(40)) {
                Reseeder.this._log.error("EepGet failed on " + url, (Throwable)cause);
            }
        }

        public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
        }

        public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        }

        public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
        }

        public void headerReceived(String url, int attemptNum, String key, String val) {
        }

        public void attempting(String url) {
        }

        private void reseed(boolean echoStatus) {
            ArrayList<String> URLList = new ArrayList<String>();
            String URLs = Reseeder.this._context.getProperty("i2p.reseedURL", Reseeder.DEFAULT_SEED_URL);
            StringTokenizer tok = new StringTokenizer(URLs, " ,");
            while (tok.hasMoreTokens()) {
                URLList.add(tok.nextToken().trim());
            }
            Collections.shuffle(URLList);
            for (int i = 0; i < URLList.size() && this._isRunning; ++i) {
                this.reseedOne((String)URLList.get(i), echoStatus);
            }
        }

        private void reseedOne(String seedURL, boolean echoStatus) {
            try {
                int start;
                System.setProperty(Reseeder.PROP_ERROR, "");
                System.setProperty(Reseeder.PROP_STATUS, Reseeder.this._("Reseeding: fetching seed URL."));
                System.err.println("Reseed from " + seedURL);
                URL dir = new URL(seedURL);
                byte[] contentRaw = this.readURL(dir);
                if (contentRaw == null) {
                    System.setProperty(Reseeder.PROP_ERROR, Reseeder.this._("Last reseed failed fully (failed reading seed URL).") + ' ' + Reseeder.this._(RESEED_TIPS));
                    Reseeder.this._log.debug("Failed reading seed URL: " + seedURL);
                    return;
                }
                String content = new String(contentRaw);
                HashSet<String> urls = new HashSet<String>(1024);
                int cur = 0;
                int total = 0;
                while (total++ < 1000 && ((start = content.indexOf("href=\"routerInfo-", cur)) >= 0 || (start = content.indexOf("HREF=\"routerInfo-", cur)) >= 0)) {
                    int end = content.indexOf(".dat\">", start);
                    String name = content.substring(start + "href=\"routerInfo-".length(), end);
                    urls.add(name);
                    cur = end + 1;
                }
                if (total <= 0) {
                    Reseeder.this._log.error("Read " + contentRaw.length + " bytes from seed " + seedURL + ", but found no routerInfo URLs.");
                    System.setProperty(Reseeder.PROP_ERROR, Reseeder.this._("Last reseed failed fully (no routerInfo URLs at seed URL).") + ' ' + Reseeder.this._(RESEED_TIPS));
                    return;
                }
                ArrayList urlList = new ArrayList(urls);
                Collections.shuffle(urlList);
                int fetched = 0;
                int errors = 0;
                Iterator iter = urlList.iterator();
                while (iter.hasNext() && fetched < 200) {
                    try {
                        System.setProperty(Reseeder.PROP_STATUS, Reseeder.this._("Reseeding: fetching router info from seed URL ({0} successful, {1} errors).", fetched, errors));
                        this.fetchSeed(seedURL, (String)iter.next());
                        ++fetched;
                        if (!echoStatus) continue;
                        System.out.print(".");
                        if (fetched % 60 != 0) continue;
                        System.out.println();
                    }
                    catch (Exception e) {
                        ++errors;
                    }
                }
                System.err.println("Reseed got " + fetched + " router infos from " + seedURL);
                int failPercent = 100 * errors / total;
                if (failPercent >= 10 && failPercent < 90) {
                    System.setProperty(Reseeder.PROP_ERROR, Reseeder.this._("Last reseed failed partly ({0}% of {1}).", failPercent, total) + ' ' + Reseeder.this._(RESEED_TIPS));
                }
                if (failPercent >= 90) {
                    System.setProperty(Reseeder.PROP_ERROR, Reseeder.this._("Last reseed failed ({0}% of {1}).", failPercent, total) + ' ' + Reseeder.this._(RESEED_TIPS));
                }
                if (fetched > 0) {
                    Reseeder.this._context.netDb().rescan();
                }
                if (fetched >= 100) {
                    this._isRunning = false;
                }
            }
            catch (Throwable t) {
                System.setProperty(Reseeder.PROP_ERROR, Reseeder.this._("Last reseed failed fully (exception caught).") + ' ' + Reseeder.this._(RESEED_TIPS));
                Reseeder.this._log.error("Error reseeding", t);
            }
        }

        private void fetchSeed(String seedURL, String peer) throws Exception {
            URL url = new URL(seedURL + (seedURL.endsWith("/") ? "" : "/") + "routerInfo-" + peer + ".dat");
            byte[] data = this.readURL(url);
            if (data == null) {
                Reseeder.this._log.debug("Failed fetching seed: " + url.toString());
                throw new Exception("Failed fetching seed.");
            }
            this.writeSeed(peer, data);
        }

        private byte[] readURL(URL url) throws Exception {
            SSLEepGet get;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            if (url.toString().startsWith("https")) {
                get = new SSLEepGet(I2PAppContext.getGlobalContext(), (OutputStream)baos, url.toString());
            } else {
                boolean shouldProxy = this._proxyHost != null && this._proxyHost.length() > 0 && this._proxyPort > 0;
                get = new EepGet(I2PAppContext.getGlobalContext(), shouldProxy, this._proxyHost, this._proxyPort, 0, 0L, 0x100000L, null, (OutputStream)baos, url.toString(), false, null, null);
            }
            get.addStatusListener((EepGet.StatusListener)this);
            if (get.fetch()) {
                return baos.toByteArray();
            }
            return null;
        }

        private void writeSeed(String name, byte[] data) throws Exception {
            String dirName = "netDb";
            SecureDirectory netDbDir = new SecureDirectory(Reseeder.this._context.getRouterDir(), dirName);
            if (!netDbDir.exists()) {
                boolean ok = netDbDir.mkdirs();
            }
            SecureFileOutputStream fos = new SecureFileOutputStream(new File((File)netDbDir, "routerInfo-" + name + ".dat"));
            fos.write(data);
            fos.close();
        }
    }
}

