/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructure;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.DataStore;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransientDataStore
implements DataStore {
    private Log _log;
    private ConcurrentHashMap<Hash, DataStructure> _data;
    protected RouterContext _context;

    public TransientDataStore(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TransientDataStore.class);
        this._data = new ConcurrentHashMap(1024);
        if (this._log.shouldLog(20)) {
            this._log.info("Data Store initialized");
        }
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public void stop() {
        this._data.clear();
    }

    @Override
    public void restart() {
        this.stop();
    }

    @Override
    public void rescan() {
    }

    @Override
    public Set<Hash> getKeys() {
        return new HashSet<Hash>(this._data.keySet());
    }

    @Override
    public DataStructure get(Hash key, boolean persist) {
        throw new IllegalArgumentException("no");
    }

    @Override
    public DataStructure get(Hash key) {
        return this._data.get(key);
    }

    @Override
    public boolean isKnown(Hash key) {
        return this._data.containsKey(key);
    }

    @Override
    public int countLeaseSets() {
        int count = 0;
        for (DataStructure d : this._data.values()) {
            if (!(d instanceof LeaseSet)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean put(Hash key, DataStructure data, boolean persist) {
        throw new IllegalArgumentException("no");
    }

    @Override
    public boolean put(Hash key, DataStructure data) {
        if (data == null) {
            return false;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Storing key " + key);
        }
        DataStructure old = null;
        old = this._data.putIfAbsent(key, data);
        boolean rv = false;
        if (data instanceof RouterInfo) {
            RouterInfo ri = (RouterInfo)data;
            if (old != null) {
                RouterInfo ori = (RouterInfo)old;
                if (ri.getPublished() < ori.getPublished()) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Almost clobbered an old router! " + key + ": [old published on " + new Date(ori.getPublished()) + " new on " + new Date(ri.getPublished()) + "]");
                    }
                } else if (ri.getPublished() == ori.getPublished()) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Duplicate " + key);
                    }
                } else {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Updated the old router for " + key + ": [old published on " + new Date(ori.getPublished()) + " new on " + new Date(ri.getPublished()) + "]");
                    }
                    this._data.put(key, data);
                    rv = true;
                }
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("New router for " + key + ": published on " + new Date(ri.getPublished()));
                }
                rv = true;
            }
        } else if (data instanceof LeaseSet) {
            LeaseSet ls = (LeaseSet)data;
            if (old != null) {
                LeaseSet ols = (LeaseSet)old;
                if (ls.getEarliestLeaseDate() < ols.getEarliestLeaseDate()) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Almost clobbered an old leaseSet! " + key + ": [old published on " + new Date(ols.getEarliestLeaseDate()) + " new on " + new Date(ls.getEarliestLeaseDate()) + "]");
                    }
                } else if (ls.getEarliestLeaseDate() == ols.getEarliestLeaseDate()) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Duplicate " + key);
                    }
                } else {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Updated old leaseSet " + key + ": [old published on " + new Date(ols.getEarliestLeaseDate()) + " new on " + new Date(ls.getEarliestLeaseDate()) + "]");
                        if (this._log.shouldLog(10)) {
                            this._log.debug("RAP? " + ls.getReceivedAsPublished() + " RAR? " + ls.getReceivedAsReply());
                        }
                    }
                    this._data.put(key, data);
                    rv = true;
                }
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("New leaseset for " + key + ": published on " + new Date(ls.getEarliestLeaseDate()));
                    if (this._log.shouldLog(10)) {
                        this._log.debug("RAP? " + ls.getReceivedAsPublished() + " RAR? " + ls.getReceivedAsReply());
                    }
                }
                rv = true;
            }
        }
        return rv;
    }

    public int hashCode() {
        return DataHelper.hashCode(this._data);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TransientDataStore ds = (TransientDataStore)obj;
        return DataHelper.eq(ds._data, this._data);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Transient DataStore: ").append(this._data.size()).append("\nKeys: ");
        for (Map.Entry<Hash, DataStructure> e : this._data.entrySet()) {
            Hash key = e.getKey();
            DataStructure dp = e.getValue();
            buf.append("\n\t*Key:   ").append(key.toString()).append("\n\tContent: ").append(dp.toString());
        }
        buf.append("\n");
        return buf.toString();
    }

    @Override
    public DataStructure remove(Hash key, boolean persist) {
        throw new IllegalArgumentException("no");
    }

    @Override
    public DataStructure remove(Hash key) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Removing key " + key.toBase64());
        }
        return this._data.remove(key);
    }
}

