/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.i2p.data.DataStructure;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.router.networkdb.kademlia.KBucketSet;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.StoreMessageSelector;
import net.i2p.router.networkdb.kademlia.StoreState;
import net.i2p.util.Log;
import net.i2p.util.VersionComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StoreJob
extends JobImpl {
    protected Log _log;
    private KademliaNetworkDatabaseFacade _facade;
    protected StoreState _state;
    private Job _onSuccess;
    private Job _onFailure;
    private long _timeoutMs;
    private long _expiration;
    private PeerSelector _peerSelector;
    private static final int PARALLELIZATION = 4;
    private static final int REDUNDANCY = 4;
    private static final int EXPLORATORY_REDUNDANCY = 1;
    private static final int STORE_PRIORITY = 100;
    private static final int MAX_PEERS_SENT = 10;
    private static final int MAX_DIRECT_EXPIRATION = 15000;
    private static final String MIN_ENCRYPTION_VERSION = "0.7.10";

    public StoreJob(RouterContext context, KademliaNetworkDatabaseFacade facade, Hash key, DataStructure data, Job onSuccess, Job onFailure, long timeoutMs) {
        this(context, facade, key, data, onSuccess, onFailure, timeoutMs, null);
    }

    public StoreJob(RouterContext context, KademliaNetworkDatabaseFacade facade, Hash key, DataStructure data, Job onSuccess, Job onFailure, long timeoutMs, Set<Hash> toSkip) {
        super(context);
        this._log = context.logManager().getLog(StoreJob.class);
        this._facade = facade;
        this._state = new StoreState(this.getContext(), key, data, toSkip);
        this._onSuccess = onSuccess;
        this._onFailure = onFailure;
        this._timeoutMs = timeoutMs;
        this._expiration = context.clock().now() + timeoutMs;
        this._peerSelector = facade.getPeerSelector();
    }

    @Override
    public String getName() {
        return "Kademlia NetDb Store";
    }

    @Override
    public void runJob() {
        this.sendNext();
    }

    private boolean isExpired() {
        return this.getContext().clock().now() >= this._expiration;
    }

    private void sendNext() {
        if (this._state.completed()) {
            if (this._log.shouldLog(20)) {
                this._log.info("Already completed");
            }
            return;
        }
        if (this.isExpired()) {
            this._state.complete(true);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Expired: " + this._timeoutMs);
            }
            this.fail();
        } else if (this._state.getAttempted().size() > 10) {
            this._state.complete(true);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Max sent");
            }
            this.fail();
        } else {
            this.continueSending();
        }
    }

    protected int getParallelization() {
        return 4;
    }

    protected int getRedundancy() {
        return 4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void continueSending() {
        List<Hash> closestHashes;
        if (this._state.completed()) {
            return;
        }
        int toCheck = this.getParallelization() - this._state.getPending().size();
        if (toCheck <= 0) {
            if (!this._log.shouldLog(10)) return;
            this._log.debug(this.getJobId() + ": Too many store messages pending");
            return;
        }
        if (toCheck > this.getParallelization()) {
            toCheck = this.getParallelization();
        }
        if ((closestHashes = this.getClosestFloodfillRouters(this._state.getTarget(), toCheck, this._state.getAttempted())) == null || closestHashes.isEmpty()) {
            if (!this._state.getPending().isEmpty()) {
                if (!this._log.shouldLog(20)) return;
                this._log.info(this.getJobId() + ": No more peers left but some are pending, so keep waiting");
                return;
            }
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": No more peers left and none pending");
            }
            this.fail();
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Continue sending key " + this._state.getTarget() + " after " + this._state.getAttempted().size() + " tries to " + closestHashes);
        }
        Iterator<Hash> iter = closestHashes.iterator();
        while (iter.hasNext()) {
            Hash peer = iter.next();
            DataStructure ds = this._facade.getDataStore().get(peer);
            if (ds == null || !(ds instanceof RouterInfo)) {
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getJobId() + ": Error selecting closest hash that wasnt a router! " + peer + " : " + ds);
                }
                this._state.addSkipped(peer);
                continue;
            }
            int peerTimeout = this._facade.getPeerTimeout(peer);
            this._state.addPending(peer);
            this.sendStore((RouterInfo)ds, peerTimeout);
        }
    }

    private List<Hash> getClosestFloodfillRouters(Hash key, int numClosest, Set<Hash> alreadyChecked) {
        Hash rkey = this.getContext().routingKeyGenerator().getRoutingKey(key);
        KBucketSet ks = this._facade.getKBuckets();
        if (ks == null) {
            return new ArrayList<Hash>();
        }
        return ((FloodfillPeerSelector)this._peerSelector).selectFloodfillParticipants(rkey, numClosest, alreadyChecked, ks);
    }

    private void sendStore(RouterInfo router, int responseTime) {
        DatabaseStoreMessage msg = new DatabaseStoreMessage(this.getContext());
        msg.setKey(this._state.getTarget());
        if (this._state.getData() instanceof RouterInfo) {
            msg.setRouterInfo((RouterInfo)this._state.getData());
            if (responseTime > 15000) {
                responseTime = 15000;
            }
        } else if (this._state.getData() instanceof LeaseSet) {
            msg.setLeaseSet((LeaseSet)this._state.getData());
        } else {
            throw new IllegalArgumentException("Storing an unknown data type! " + this._state.getData());
        }
        msg.setMessageExpiration(this.getContext().clock().now() + this._timeoutMs);
        if (router.getIdentity().equals((Object)this.getContext().router().getRouterInfo().getIdentity())) {
            if (this._log.shouldLog(40)) {
                this._log.error(this.getJobId() + ": Dont send store to ourselves - why did we try?");
            }
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": Send store timeout is " + responseTime);
        }
        this.sendStore(msg, router, this.getContext().clock().now() + (long)responseTime);
    }

    private void sendStore(DatabaseStoreMessage msg, RouterInfo peer, long expiration) {
        if (msg.getValueType() == 1) {
            this.getContext().statManager().addRateData("netDb.storeLeaseSetSent", 1L, 0L);
            if (this.getContext().keyRing().get((Object)msg.getKey()) != null) {
                this.sendStoreThroughGarlic(msg, peer, expiration);
            } else {
                this.sendStoreThroughClient(msg, peer, expiration);
            }
        } else {
            this.getContext().statManager().addRateData("netDb.storeRouterInfoSent", 1L, 0L);
            this.sendDirect(msg, peer, expiration);
        }
    }

    private void sendDirect(DatabaseStoreMessage msg, RouterInfo peer, long expiration) {
        long token = this.getContext().random().nextLong(0xFFFFFFFFL);
        msg.setReplyToken(token);
        msg.setReplyGateway(this.getContext().routerHash());
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": send(dbStore) w/ token expected " + token);
        }
        this._state.addPending(peer.getIdentity().getHash());
        SendSuccessJob onReply = new SendSuccessJob(this.getContext(), peer);
        FailedJob onFail = new FailedJob(this.getContext(), peer, this.getContext().clock().now());
        StoreMessageSelector selector = new StoreMessageSelector(this.getContext(), this.getJobId(), peer, token, expiration);
        if (this._log.shouldLog(10)) {
            this._log.debug("sending store directly to " + peer.getIdentity().getHash());
        }
        OutNetMessage m = new OutNetMessage(this.getContext());
        m.setExpiration(expiration);
        m.setMessage(msg);
        m.setOnFailedReplyJob(onFail);
        m.setOnFailedSendJob(onFail);
        m.setOnReplyJob(onReply);
        m.setPriority(100);
        m.setReplySelector(selector);
        m.setTarget(peer);
        this.getContext().messageRegistry().registerPending(m);
        this.getContext().commSystem().processMessage(m);
    }

    private void sendStoreThroughGarlic(DatabaseStoreMessage msg, RouterInfo peer, long expiration) {
        long token = this.getContext().random().nextLong(0xFFFFFFFFL);
        TunnelInfo replyTunnel = this.selectInboundTunnel();
        if (replyTunnel == null) {
            this._log.warn("No reply inbound tunnels available!");
            return;
        }
        TunnelId replyTunnelId = replyTunnel.getReceiveTunnelId(0);
        msg.setReplyToken(token);
        msg.setReplyTunnel(replyTunnelId);
        msg.setReplyGateway(replyTunnel.getPeer(0));
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": send(dbStore) w/ token expected " + token);
        }
        this._state.addPending(peer.getIdentity().getHash());
        TunnelInfo outTunnel = this.selectOutboundTunnel();
        if (outTunnel != null) {
            SendSuccessJob onReply = new SendSuccessJob(this.getContext(), peer, outTunnel, msg.getMessageSize());
            FailedJob onFail = new FailedJob(this.getContext(), peer, this.getContext().clock().now());
            StoreMessageSelector selector = new StoreMessageSelector(this.getContext(), this.getJobId(), peer, token, expiration);
            if (this._log.shouldLog(10)) {
                this._log.debug("sending store to " + peer.getIdentity().getHash() + " through " + outTunnel + ": " + msg);
            }
            this.getContext().messageRegistry().registerPending(selector, onReply, onFail, (int)(expiration - this.getContext().clock().now()));
            this.getContext().tunnelDispatcher().dispatchOutbound(msg, outTunnel.getSendTunnelId(0), null, peer.getIdentity().getHash());
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn("No outbound tunnels to send a dbStore out!");
            }
            this.fail();
        }
    }

    private TunnelInfo selectOutboundTunnel() {
        return this.getContext().tunnelManager().selectOutboundTunnel();
    }

    private TunnelInfo selectInboundTunnel() {
        return this.getContext().tunnelManager().selectInboundTunnel();
    }

    private void sendStoreThroughClient(DatabaseStoreMessage msg, RouterInfo peer, long expiration) {
        long token = this.getContext().random().nextLong(0xFFFFFFFFL);
        Hash client = msg.getKey();
        TunnelInfo replyTunnel = this.getContext().tunnelManager().selectInboundTunnel(client);
        if (replyTunnel == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No reply inbound tunnels available!");
            }
            this.fail();
            return;
        }
        TunnelId replyTunnelId = replyTunnel.getReceiveTunnelId(0);
        msg.setReplyToken(token);
        msg.setReplyTunnel(replyTunnelId);
        msg.setReplyGateway(replyTunnel.getPeer(0));
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": send(dbStore) w/ token expected " + token);
        }
        Hash to = peer.getIdentity().getHash();
        TunnelInfo outTunnel = this.getContext().tunnelManager().selectOutboundTunnel(client);
        if (outTunnel != null) {
            MessageWrapper.WrappedMessage wm;
            boolean shouldEncrypt = StoreJob.supportsEncryption(peer);
            if (shouldEncrypt) {
                wm = MessageWrapper.wrap(this.getContext(), msg, client, peer);
                if (wm == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Fail garlic encrypting from: " + client);
                    }
                    this.fail();
                    return;
                }
            } else {
                DatabaseStoreMessage sent = msg;
                this._state.addPending(to);
                this._state.replyTimeout(to);
                this.getContext().jobQueue().addJob(new WaitJob(this.getContext()));
                return;
            }
            GarlicMessage sent = wm.getMessage();
            this._state.addPending(to, wm);
            SendSuccessJob onReply = new SendSuccessJob(this.getContext(), peer, outTunnel, sent.getMessageSize());
            FailedJob onFail = new FailedJob(this.getContext(), peer, this.getContext().clock().now());
            StoreMessageSelector selector = new StoreMessageSelector(this.getContext(), this.getJobId(), peer, token, expiration);
            if (this._log.shouldLog(10)) {
                if (shouldEncrypt) {
                    this._log.debug("sending encrypted store to " + peer.getIdentity().getHash() + " through " + outTunnel + ": " + sent);
                } else {
                    this._log.debug("sending store to " + peer.getIdentity().getHash() + " through " + outTunnel + ": " + sent);
                }
            }
            this.getContext().messageRegistry().registerPending(selector, onReply, onFail, (int)(expiration - this.getContext().clock().now()));
            this.getContext().tunnelDispatcher().dispatchOutbound(sent, outTunnel.getSendTunnelId(0), null, to);
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn("No outbound tunnels to send a dbStore out - delaying...");
            }
            this._state.replyTimeout(to);
            WaitJob waiter = new WaitJob(this.getContext());
            waiter.getTiming().setStartAfter(this.getContext().clock().now() + 3000L);
            this.getContext().jobQueue().addJob(waiter);
        }
    }

    private static boolean supportsEncryption(RouterInfo ri) {
        String v = ri.getOption("router.version");
        if (v == null) {
            return false;
        }
        return new VersionComparator().compare(v, MIN_ENCRYPTION_VERSION) >= 0;
    }

    protected void succeed() {
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Succeeded sending key " + this._state.getTarget());
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": State of successful send: " + this._state);
        }
        if (this._onSuccess != null) {
            this.getContext().jobQueue().addJob(this._onSuccess);
        }
        this._state.complete(true);
        this.getContext().statManager().addRateData("netDb.storePeers", (long)this._state.getAttempted().size(), this._state.getWhenCompleted() - this._state.getWhenStarted());
    }

    protected void fail() {
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Failed sending key " + this._state.getTarget());
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": State of failed send: " + this._state, (Throwable)new Exception("Who failed me?"));
        }
        if (this._onFailure != null) {
            this.getContext().jobQueue().addJob(this._onFailure);
        }
        this._state.complete(true);
        this.getContext().statManager().addRateData("netDb.storeFailedPeers", (long)this._state.getAttempted().size(), this._state.getWhenCompleted() - this._state.getWhenStarted());
    }

    private class FailedJob
    extends JobImpl {
        private RouterInfo _peer;
        private long _sendOn;

        public FailedJob(RouterContext enclosingContext, RouterInfo peer, long sendOn) {
            super(enclosingContext);
            this._peer = peer;
            this._sendOn = sendOn;
        }

        public void runJob() {
            MessageWrapper.WrappedMessage wm;
            Hash hash = this._peer.getIdentity().getHash();
            if (StoreJob.this._log.shouldLog(20)) {
                StoreJob.this._log.info(StoreJob.this.getJobId() + ": Peer " + hash.toBase64() + " timed out sending " + StoreJob.this._state.getTarget());
            }
            if ((wm = StoreJob.this._state.getPendingMessage(hash)) != null) {
                wm.fail();
            }
            StoreJob.this._state.replyTimeout(hash);
            this.getContext().profileManager().dbStoreFailed(hash);
            this.getContext().statManager().addRateData("netDb.replyTimeout", this.getContext().clock().now() - this._sendOn, 0L);
            StoreJob.this.sendNext();
        }

        public String getName() {
            return "Kademlia Store Send Failed";
        }
    }

    private class SendSuccessJob
    extends JobImpl
    implements ReplyJob {
        private RouterInfo _peer;
        private TunnelInfo _sendThrough;
        private int _msgSize;

        public SendSuccessJob(RouterContext enclosingContext, RouterInfo peer) {
            this(enclosingContext, peer, null, 0);
        }

        public SendSuccessJob(RouterContext enclosingContext, RouterInfo peer, TunnelInfo sendThrough, int size) {
            super(enclosingContext);
            this._peer = peer;
            this._sendThrough = sendThrough;
            this._msgSize = size <= 0 ? 0 : (size + 1023) / 1024 * 1024;
        }

        public String getName() {
            return "Kademlia Store Send Success";
        }

        public void runJob() {
            Hash hash = this._peer.getIdentity().getHash();
            MessageWrapper.WrappedMessage wm = StoreJob.this._state.getPendingMessage(hash);
            if (wm != null) {
                wm.acked();
            }
            long howLong = StoreJob.this._state.confirmed(hash);
            if (StoreJob.this._log.shouldLog(20)) {
                StoreJob.this._log.info(StoreJob.this.getJobId() + ": Marking store of " + StoreJob.this._state.getTarget() + " to " + hash.toBase64() + " successful after " + howLong);
            }
            this.getContext().profileManager().dbStoreSent(hash, howLong);
            this.getContext().statManager().addRateData("netDb.ackTime", howLong, howLong);
            if (this._sendThrough != null && this._msgSize > 0) {
                if (StoreJob.this._log.shouldLog(30)) {
                    StoreJob.this._log.warn("sent a " + this._msgSize + "byte netDb message through tunnel " + this._sendThrough + " after " + howLong);
                }
                for (int i = 0; i < this._sendThrough.getLength(); ++i) {
                    this.getContext().profileManager().tunnelDataPushed(this._sendThrough.getPeer(i), howLong, this._msgSize);
                }
                this._sendThrough.incrementVerifiedBytesTransferred(this._msgSize);
            }
            if (StoreJob.this._state.getCompleteCount() >= StoreJob.this.getRedundancy()) {
                StoreJob.this.succeed();
            } else {
                StoreJob.this.sendNext();
            }
        }

        public void setMessage(I2NPMessage message) {
        }
    }

    private class WaitJob
    extends JobImpl {
        public WaitJob(RouterContext enclosingContext) {
            super(enclosingContext);
        }

        public void runJob() {
            StoreJob.this.sendNext();
        }

        public String getName() {
            return "Kademlia Store Send Delay";
        }
    }
}

