/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.ExploreJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;

class StartExplorersJob
extends JobImpl {
    private Log _log;
    private KademliaNetworkDatabaseFacade _facade;
    private static final int MAX_PER_RUN = 1;
    private static final int MIN_RERUN_DELAY_MS = 300000;
    private static final int MAX_RERUN_DELAY_MS = 1800000;

    public StartExplorersJob(RouterContext context, KademliaNetworkDatabaseFacade facade) {
        super(context);
        this._log = context.logManager().getLog(StartExplorersJob.class);
        this._facade = facade;
    }

    public String getName() {
        return "Start Explorers Job";
    }

    public void runJob() {
        if (!((FloodfillNetworkDatabaseFacade)this._facade).floodfillEnabled() && !this.getContext().router().gracefulShutdownInProgress()) {
            Set toExplore = this.selectKeysToExplore();
            if (this._log.shouldLog(10)) {
                this._log.debug("Keys to explore during this run: " + toExplore);
            }
            this._facade.removeFromExploreKeys(toExplore);
            for (Hash key : toExplore) {
                this.getContext().jobQueue().addJob(new ExploreJob(this.getContext(), this._facade, key));
            }
        }
        long delay = this.getNextRunDelay();
        if (this._log.shouldLog(10)) {
            this._log.debug("Reenqueueing the exploration with a delay of " + delay);
        }
        this.requeue(delay);
    }

    public void updateExploreSchedule() {
        long delay = this.getNextRunDelay();
        if (this._log.shouldLog(10)) {
            this._log.debug("Updating exploration schedule with a delay of " + delay);
        }
        this.getTiming().setStartAfter(this.getContext().clock().now() + delay);
    }

    private long getNextRunDelay() {
        long delay = this.getContext().clock().now() - this._facade.getLastExploreNewDate();
        if (delay < 300000L) {
            return 300000L;
        }
        if (delay > 1800000L) {
            return 1800000L;
        }
        return delay;
    }

    private Set selectKeysToExplore() {
        Set<Hash> queued = this._facade.getExploreKeys();
        if (this._log.shouldLog(10)) {
            this._log.debug("Keys waiting for exploration: " + queued.size());
        }
        HashSet<Hash> rv = new HashSet<Hash>(1);
        Iterator<Hash> iter = queued.iterator();
        while (iter.hasNext() && rv.size() < 1) {
            rv.add(iter.next());
        }
        for (int i = rv.size(); i < 1; ++i) {
            byte[] hash = new byte[32];
            this.getContext().random().nextBytes(hash);
            Hash key = new Hash(hash);
            rv.add(key);
        }
        return rv;
    }
}

