/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.SingleSearchJob;
import net.i2p.util.Log;

class SingleLookupJob
extends JobImpl {
    private Log _log;
    private DatabaseSearchReplyMessage _dsrm;

    public SingleLookupJob(RouterContext ctx, DatabaseSearchReplyMessage dsrm) {
        super(ctx);
        this._log = ctx.logManager().getLog(this.getClass());
        this._dsrm = dsrm;
    }

    public void runJob() {
        Hash from = this._dsrm.getFromHash();
        for (int i = 0; i < this._dsrm.getNumReplies(); ++i) {
            Hash peer = this._dsrm.getReply(i);
            if (peer.equals((Object)this.getContext().routerHash()) || peer.equals((Object)from)) continue;
            RouterInfo ri = this.getContext().netDb().lookupRouterInfoLocally(peer);
            if (ri == null) {
                this.getContext().jobQueue().addJob(new SingleSearchJob(this.getContext(), peer, from));
                continue;
            }
            if (ri.getPublished() >= this.getContext().clock().now() - 3600000L && FloodfillNetworkDatabaseFacade.isFloodfill(ri)) continue;
            this.getContext().jobQueue().addJob(new SingleSearchJob(this.getContext(), peer, peer));
        }
    }

    public String getName() {
        return "NetDb process DSRM";
    }
}

