/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.NoSuchElementException;
import java.util.Set;
import net.i2p.data.DataStructure;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterInfo;
import net.i2p.router.Job;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.FloodfillVerifyStoreJob;
import net.i2p.router.networkdb.kademlia.StoreJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FloodfillStoreJob
extends StoreJob {
    private FloodfillNetworkDatabaseFacade _facade;

    public FloodfillStoreJob(RouterContext context, FloodfillNetworkDatabaseFacade facade, Hash key, DataStructure data, Job onSuccess, Job onFailure, long timeoutMs) {
        this(context, facade, key, data, onSuccess, onFailure, timeoutMs, null);
    }

    public FloodfillStoreJob(RouterContext context, FloodfillNetworkDatabaseFacade facade, Hash key, DataStructure data, Job onSuccess, Job onFailure, long timeoutMs, Set<Hash> toSkip) {
        super(context, facade, key, data, onSuccess, onFailure, timeoutMs, toSkip);
        this._facade = facade;
    }

    @Override
    protected int getParallelization() {
        return 1;
    }

    @Override
    protected int getRedundancy() {
        return 1;
    }

    @Override
    protected void succeed() {
        super.succeed();
        if (this._state != null) {
            if (this._facade.isVerifyInProgress(this._state.getTarget())) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Skipping verify, one already in progress for: " + this._state.getTarget());
                }
                return;
            }
            long published = 0L;
            DataStructure data = this._state.getData();
            boolean isRouterInfo = data instanceof RouterInfo;
            if (isRouterInfo) {
                published = ((RouterInfo)data).getPublished();
                return;
            }
            if (data instanceof LeaseSet) {
                published = ((LeaseSet)data).getEarliestLeaseDate();
            }
            Hash sentTo = null;
            try {
                sentTo = this._state.getSuccessful().iterator().next();
            }
            catch (NoSuchElementException nsee) {
                // empty catch block
            }
            this.getContext().jobQueue().addJob(new FloodfillVerifyStoreJob(this.getContext(), this._state.getTarget(), published, isRouterInfo, sentTo, this._facade));
        }
    }

    @Override
    public String getName() {
        return "Floodfill netDb store";
    }
}

