/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.MessageSelector;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodOnlySearchJob;
import net.i2p.util.Log;

class FloodOnlyLookupSelector
implements MessageSelector {
    private RouterContext _context;
    private FloodOnlySearchJob _search;
    private boolean _matchFound;
    private Log _log;

    public FloodOnlyLookupSelector(RouterContext ctx, FloodOnlySearchJob search) {
        this._context = ctx;
        this._search = search;
        this._log = ctx.logManager().getLog(this.getClass());
        this._matchFound = false;
    }

    public boolean continueMatching() {
        return this._search.getLookupsRemaining() > 0 && !this._matchFound && this._context.clock().now() < this.getExpiration();
    }

    public long getExpiration() {
        return this._matchFound ? -1L : this._search.getExpiration();
    }

    public boolean isMatch(I2NPMessage message) {
        if (message == null) {
            return false;
        }
        if (message instanceof DatabaseStoreMessage) {
            DatabaseStoreMessage dsm = (DatabaseStoreMessage)message;
            if (this._search.getKey().equals((Object)dsm.getKey())) {
                this._search.decrementRemaining();
                this._matchFound = true;
                return true;
            }
        } else if (message instanceof DatabaseSearchReplyMessage) {
            DatabaseSearchReplyMessage dsrm = (DatabaseSearchReplyMessage)message;
            if (this._search.getKey().equals((Object)dsrm.getSearchKey())) {
                this._search.decrementRemaining(dsrm.getFromHash());
                this._context.profileManager().dbLookupReply(dsrm.getFromHash(), 0, dsrm.getNumReplies(), 0, 0, System.currentTimeMillis() - this._search.getCreated());
                return this._search.getLookupsRemaining() <= 0;
            }
        }
        return false;
    }
}

