/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.HashSet;
import java.util.Set;
import net.i2p.data.DataStructure;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;

class ExpireLeasesJob
extends JobImpl {
    private Log _log;
    private KademliaNetworkDatabaseFacade _facade;
    private static final long RERUN_DELAY_MS = 60000L;

    public ExpireLeasesJob(RouterContext ctx, KademliaNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(ExpireLeasesJob.class);
        this._facade = facade;
    }

    public String getName() {
        return "Expire Lease Sets Job";
    }

    public void runJob() {
        Set toExpire = this.selectKeysToExpire();
        this._log.info("Leases to expire: " + toExpire);
        for (Hash key : toExpire) {
            this._facade.fail(key);
        }
        this.requeue(60000L);
    }

    private Set selectKeysToExpire() {
        Set<Hash> keys = this._facade.getDataStore().getKeys();
        HashSet<Hash> toExpire = new HashSet<Hash>(128);
        for (Hash key : keys) {
            DataStructure obj = this._facade.getDataStore().get(key);
            if (!(obj instanceof LeaseSet)) continue;
            LeaseSet ls = (LeaseSet)obj;
            if (!ls.isCurrent(60000L)) {
                toExpire.add(key);
                continue;
            }
            this._log.debug("Lease " + ls.getDestination().calculateHash() + " is current, no need to expire");
        }
        return toExpire;
    }
}

