/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb;

import java.util.Date;
import java.util.Properties;
import net.i2p.data.DataFormatException;
import net.i2p.data.RouterInfo;
import net.i2p.data.SigningPrivateKey;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class PublishLocalRouterInfoJob
extends JobImpl {
    private Log _log;
    static final long PUBLISH_DELAY = 1200000L;
    static final long FIRST_TIME_DELAY = 480000L;
    boolean _notFirstTime;

    public PublishLocalRouterInfoJob(RouterContext ctx) {
        super(ctx);
        this._log = ctx.logManager().getLog(PublishLocalRouterInfoJob.class);
    }

    public String getName() {
        return "Publish Local Router Info";
    }

    public void runJob() {
        RouterInfo ri = new RouterInfo(this.getContext().router().getRouterInfo());
        if (this._log.shouldLog(10)) {
            this._log.debug("Old routerInfo contains " + ri.getAddresses().size() + " addresses and " + ri.getOptions().size() + " options");
        }
        Properties stats = this.getContext().statPublisher().publishStatistics();
        stats.setProperty("netId", "2");
        try {
            ri.setPublished(this.getContext().clock().now());
            ri.setOptions(stats);
            ri.setAddresses(this.getContext().commSystem().createAddresses());
            this.getContext().router().addCapabilities(ri);
            SigningPrivateKey key = this.getContext().keyManager().getSigningPrivateKey();
            if (key == null) {
                this._log.log(50, "Internal error - signing private key not known?  rescheduling publish for 30s");
                this.requeue(30000L);
                return;
            }
            ri.sign(key);
            this.getContext().router().setRouterInfo(ri);
            if (this._log.shouldLog(20)) {
                this._log.info("Newly updated routerInfo is published with " + stats.size() + "/" + ri.getOptions().size() + " options on " + new Date(ri.getPublished()));
            }
            try {
                this.getContext().netDb().publish(ri);
            }
            catch (IllegalArgumentException iae) {
                this._log.log(50, "Error publishing our identity - corrupt?", (Throwable)iae);
                this.getContext().router().rebuildNewIdentity();
            }
        }
        catch (DataFormatException dfe) {
            this._log.error("Error signing the updated local router info!", (Throwable)dfe);
        }
        if (this._notFirstTime) {
            this.requeue(600000L + (long)this.getContext().random().nextInt(1200000));
        } else {
            this.requeue(480000L);
            this._notFirstTime = true;
        }
    }
}

