/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb;

import java.util.Date;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.util.Log;

public class HandleDatabaseStoreMessageJob
extends JobImpl {
    private Log _log;
    private DatabaseStoreMessage _message;
    private RouterIdentity _from;
    private Hash _fromHash;
    private static final int ACK_TIMEOUT = 15000;
    private static final int ACK_PRIORITY = 100;

    public HandleDatabaseStoreMessageJob(RouterContext ctx, DatabaseStoreMessage receivedMessage, RouterIdentity from, Hash fromHash) {
        super(ctx);
        this._log = ctx.logManager().getLog(HandleDatabaseStoreMessageJob.class);
        ctx.statManager().createRateStat("netDb.storeHandled", "How many netDb store messages have we handled?", "NetworkDatabase", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("netDb.storeLeaseSetHandled", "How many leaseSet store messages have we handled?", "NetworkDatabase", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("netDb.storeRouterInfoHandled", "How many routerInfo store messages have we handled?", "NetworkDatabase", new long[]{300000L, 3600000L, 86400000L});
        this._message = receivedMessage;
        this._from = from;
        this._fromHash = fromHash;
    }

    public void runJob() {
        boolean wasNew;
        String invalidMessage;
        block18: {
            if (this._log.shouldLog(10)) {
                this._log.debug("Handling database store message");
            }
            invalidMessage = null;
            wasNew = false;
            if (this._message.getValueType() == 1) {
                this.getContext().statManager().addRateData("netDb.storeLeaseSetHandled", 1L, 0L);
                try {
                    LeaseSet ls = this._message.getLeaseSet();
                    ls.setReceivedAsPublished(true);
                    LeaseSet match = this.getContext().netDb().store(this._message.getKey(), this._message.getLeaseSet());
                    if (match == null) {
                        wasNew = true;
                        break block18;
                    }
                    wasNew = false;
                    match.setReceivedAsPublished(true);
                }
                catch (IllegalArgumentException iae) {
                    invalidMessage = iae.getMessage();
                }
            } else if (this._message.getValueType() == 0) {
                this.getContext().statManager().addRateData("netDb.storeRouterInfoHandled", 1L, 0L);
                if (this._log.shouldLog(20)) {
                    this._log.info("Handling dbStore of router " + this._message.getKey() + " with publishDate of " + new Date(this._message.getRouterInfo().getPublished()));
                }
                try {
                    RouterInfo match = this.getContext().netDb().store(this._message.getKey(), this._message.getRouterInfo());
                    wasNew = null == match;
                    this.getContext().profileManager().heardAbout(this._message.getKey());
                }
                catch (IllegalArgumentException iae) {
                    invalidMessage = iae.getMessage();
                }
            } else if (this._log.shouldLog(40)) {
                this._log.error("Invalid DatabaseStoreMessage data type - " + this._message.getValueType() + ": " + this._message);
            }
        }
        if (this._message.getReplyToken() > 0L) {
            this.sendAck();
        }
        if (this._from != null) {
            this._fromHash = this._from.getHash();
        }
        if (this._fromHash != null) {
            if (invalidMessage == null) {
                this.getContext().profileManager().dbStoreReceived(this._fromHash, wasNew);
                this.getContext().statManager().addRateData("netDb.storeHandled", 1L, 0L);
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Peer " + this._fromHash.toBase64() + " sent bad data: " + invalidMessage);
            }
        }
    }

    private void sendAck() {
        DeliveryStatusMessage msg = new DeliveryStatusMessage(this.getContext());
        msg.setMessageId(this._message.getReplyToken());
        msg.setArrival(this.getContext().clock().now());
        TunnelInfo outTunnel = this.selectOutboundTunnel();
        if (outTunnel == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No outbound tunnel could be found");
            }
            return;
        }
        this.getContext().tunnelDispatcher().dispatchOutbound(msg, outTunnel.getSendTunnelId(0), this._message.getReplyTunnel(), this._message.getReplyGateway());
    }

    private TunnelInfo selectOutboundTunnel() {
        return this.getContext().tunnelManager().selectOutboundTunnel();
    }

    public String getName() {
        return "Handle Database Store Message";
    }

    public void dropped() {
        this.getContext().messageHistory().messageProcessingError(this._message.getUniqueId(), this._message.getClass().getName(), "Dropped due to overload");
    }
}

