/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb;

import java.util.HashSet;
import java.util.Set;
import net.i2p.data.DataStructure;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.message.SendMessageDirectJob;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleDatabaseLookupMessageJob
extends JobImpl {
    private Log _log = this.getContext().logManager().getLog(HandleDatabaseLookupMessageJob.class);
    private DatabaseLookupMessage _message;
    private RouterIdentity _from;
    private Hash _fromHash;
    private static final int MAX_ROUTERS_RETURNED = 3;
    private static final int CLOSENESS_THRESHOLD = 8;
    private static final int REPLY_TIMEOUT = 60000;
    private static final int MESSAGE_PRIORITY = 300;
    public static final long EXPIRE_DELAY = 3600000L;
    public static final String PROP_PUBLISH_UNREACHABLE = "router.publishUnreachableRouters";
    public static final boolean DEFAULT_PUBLISH_UNREACHABLE = true;

    public HandleDatabaseLookupMessageJob(RouterContext ctx, DatabaseLookupMessage receivedMessage, RouterIdentity from, Hash fromHash) {
        super(ctx);
        this._message = receivedMessage;
        this._from = from;
        this._fromHash = fromHash;
    }

    protected boolean answerAllQueries() {
        return false;
    }

    @Override
    public void runJob() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Handling database lookup message for " + this._message.getSearchKey());
        }
        Hash fromKey = this._message.getFrom();
        if (this._log.shouldLog(10) && this._message.getReplyTunnel() != null) {
            this._log.debug("dbLookup received with replies going to " + fromKey + " (tunnel " + this._message.getReplyTunnel() + ")");
        }
        if (this.getContext().router().isHidden()) {
            if (this._log.shouldLog(40)) {
                this._log.error("Uninvited dbLookup received with replies going to " + fromKey + " (tunnel " + this._message.getReplyTunnel() + ")");
            }
            return;
        }
        LeaseSet ls = this.getContext().netDb().lookupLeaseSetLocally(this._message.getSearchKey());
        if (ls != null) {
            boolean shouldPublishLocal;
            boolean isLocal = this.getContext().clientManager().isLocal(ls.getDestination());
            boolean bl = shouldPublishLocal = isLocal && this.getContext().clientManager().shouldPublishLeaseSet(this._message.getSearchKey());
            if (ls.getReceivedAsPublished()) {
                if (this._log.shouldLog(20)) {
                    this._log.info("We have the published LS " + this._message.getSearchKey().toBase64() + ", answering query");
                }
                this.getContext().statManager().addRateData("netDb.lookupsMatchedReceivedPublished", 1L, 0L);
                this.sendData(this._message.getSearchKey(), (DataStructure)ls, fromKey, this._message.getReplyTunnel());
            } else if (shouldPublishLocal && this.answerAllQueries()) {
                Set<Hash> closestHashes = this.getContext().netDb().findNearestRouters(this._message.getSearchKey(), 8, null);
                if (this.weAreClosest(closestHashes)) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("We have local LS " + this._message.getSearchKey().toBase64() + ", answering query, in our keyspace");
                    }
                    this.getContext().statManager().addRateData("netDb.lookupsMatchedLocalClosest", 1L, 0L);
                    this.sendData(this._message.getSearchKey(), (DataStructure)ls, fromKey, this._message.getReplyTunnel());
                } else {
                    if (this._log.shouldLog(20)) {
                        this._log.info("We have local LS " + this._message.getSearchKey().toBase64() + ", NOT answering query, out of our keyspace");
                    }
                    this.getContext().statManager().addRateData("netDb.lookupsMatchedLocalNotClosest", 1L, 0L);
                    Set<Hash> routerHashSet = this.getNearestRouters();
                    this.sendClosest(this._message.getSearchKey(), routerHashSet, fromKey, this._message.getReplyTunnel());
                }
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("We have LS " + this._message.getSearchKey().toBase64() + ", NOT answering query - local? " + isLocal + " shouldPublish? " + shouldPublishLocal + " RAP? " + ls.getReceivedAsPublished() + " RAR? " + ls.getReceivedAsReply());
                }
                this.getContext().statManager().addRateData("netDb.lookupsMatchedRemoteNotClosest", 1L, 0L);
                Set<Hash> routerHashSet = this.getNearestRouters();
                this.sendClosest(this._message.getSearchKey(), routerHashSet, fromKey, this._message.getReplyTunnel());
            }
        } else {
            RouterInfo info = this.getContext().netDb().lookupRouterInfoLocally(this._message.getSearchKey());
            if (info != null && info.isCurrent(3600000L)) {
                if (info.getIdentity().isHidden() || HandleDatabaseLookupMessageJob.isUnreachable(info) && !this.publishUnreachable()) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Not answering a query for a netDb peer who isn't reachable");
                    }
                    HashSet<Hash> us = new HashSet<Hash>(1);
                    us.add(this.getContext().routerHash());
                    this.sendClosest(this._message.getSearchKey(), us, fromKey, this._message.getReplyTunnel());
                } else {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("We do have key " + this._message.getSearchKey().toBase64() + " locally as a router info.  sending to " + fromKey.toBase64());
                    }
                    this.sendData(this._message.getSearchKey(), (DataStructure)info, fromKey, this._message.getReplyTunnel());
                }
            } else {
                Set<Hash> routerHashSet = this.getNearestRouters();
                if (this._log.shouldLog(10)) {
                    this._log.debug("We do not have key " + this._message.getSearchKey().toBase64() + " locally.  sending back " + routerHashSet.size() + " peers to " + fromKey.toBase64());
                }
                this.sendClosest(this._message.getSearchKey(), routerHashSet, fromKey, this._message.getReplyTunnel());
            }
        }
    }

    private Set<Hash> getNearestRouters() {
        Set<Hash> dontInclude = this._message.getDontIncludePeers();
        if (dontInclude == null) {
            dontInclude = new HashSet<Hash>(1);
        }
        dontInclude.add(this.getContext().routerHash());
        return this.getContext().netDb().findNearestRouters(this._message.getSearchKey(), 3, dontInclude);
    }

    private static boolean isUnreachable(RouterInfo info) {
        if (info == null) {
            return true;
        }
        String cap = info.getCapabilities();
        if (cap == null) {
            return false;
        }
        return cap.indexOf(82) >= 0;
    }

    private boolean publishUnreachable() {
        return this.getContext().getProperty(PROP_PUBLISH_UNREACHABLE, true);
    }

    private boolean weAreClosest(Set<Hash> routerHashSet) {
        return routerHashSet.contains(this.getContext().routerHash());
    }

    private void sendData(Hash key, DataStructure data, Hash toPeer, TunnelId replyTunnel) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending data matching key " + key.toBase64() + " to peer " + toPeer.toBase64() + " tunnel " + replyTunnel);
        }
        DatabaseStoreMessage msg = new DatabaseStoreMessage(this.getContext());
        msg.setKey(key);
        if (data instanceof LeaseSet) {
            msg.setLeaseSet((LeaseSet)data);
            msg.setValueType(1);
            this.getContext().statManager().addRateData("netDb.lookupsMatchedLeaseSet", 1L, 0L);
        } else if (data instanceof RouterInfo) {
            msg.setRouterInfo((RouterInfo)data);
            msg.setValueType(0);
        }
        this.getContext().statManager().addRateData("netDb.lookupsMatched", 1L, 0L);
        this.getContext().statManager().addRateData("netDb.lookupsHandled", 1L, 0L);
        this.sendMessage(msg, toPeer, replyTunnel);
    }

    protected void sendClosest(Hash key, Set<Hash> routerHashes, Hash toPeer, TunnelId replyTunnel) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending closest routers to key " + key.toBase64() + ": # peers = " + routerHashes.size() + " tunnel " + replyTunnel);
        }
        DatabaseSearchReplyMessage msg = new DatabaseSearchReplyMessage(this.getContext());
        msg.setFromHash(this.getContext().routerHash());
        msg.setSearchKey(key);
        int i = 0;
        for (Hash h : routerHashes) {
            msg.addReply(h);
            if (++i < 3) continue;
            break;
        }
        this.getContext().statManager().addRateData("netDb.lookupsHandled", 1L, 0L);
        this.sendMessage(msg, toPeer, replyTunnel);
    }

    protected void sendMessage(I2NPMessage message, Hash toPeer, TunnelId replyTunnel) {
        if (replyTunnel != null) {
            this.sendThroughTunnel(message, toPeer, replyTunnel);
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending reply directly to " + toPeer);
            }
            SendMessageDirectJob send = new SendMessageDirectJob(this.getContext(), message, toPeer, 60000, 300);
            send.runJob();
        }
    }

    private void sendThroughTunnel(I2NPMessage message, Hash toPeer, TunnelId replyTunnel) {
        if (this.getContext().routerHash().equals((Object)toPeer)) {
            TunnelGatewayMessage m = new TunnelGatewayMessage(this.getContext());
            m.setMessage(message);
            m.setTunnelId(replyTunnel);
            m.setMessageExpiration(message.getMessageExpiration());
            this.getContext().tunnelDispatcher().dispatch(m);
        } else {
            TunnelGatewayMessage m = new TunnelGatewayMessage(this.getContext());
            m.setMessage(message);
            m.setMessageExpiration(message.getMessageExpiration());
            m.setTunnelId(replyTunnel);
            SendMessageDirectJob j = new SendMessageDirectJob(this.getContext(), m, toPeer, 10000, 100);
            j.runJob();
        }
    }

    @Override
    public String getName() {
        return "Handle Database Lookup Message";
    }

    @Override
    public void dropped() {
        this.getContext().messageHistory().messageProcessingError(this._message.getUniqueId(), this._message.getClass().getName(), "Dropped due to overload");
    }
}

