/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.util.Log;

class ClientWriterRunner
implements Runnable {
    private BlockingQueue<I2CPMessage> _messagesToWrite;
    private ClientConnectionRunner _runner;
    private Log _log;
    private long _id;
    private static long __id = 0L;

    public ClientWriterRunner(RouterContext context, ClientConnectionRunner runner) {
        this._log = context.logManager().getLog(ClientWriterRunner.class);
        this._messagesToWrite = new LinkedBlockingQueue<I2CPMessage>();
        this._runner = runner;
        this._id = ++__id;
    }

    public void addMessage(I2CPMessage msg) {
        try {
            this._messagesToWrite.put(msg);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("[" + this._id + "] addMessage completed for " + msg.getClass().getName());
        }
    }

    public void stopWriting() {
        this._messagesToWrite.clear();
        try {
            this._messagesToWrite.put((I2CPMessage)new PoisonMessage());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        while (!this._runner.getIsDead()) {
            I2CPMessage msg;
            try {
                msg = this._messagesToWrite.take();
            }
            catch (InterruptedException ie) {
                continue;
            }
            if (msg.getType() == 999999) break;
            this._runner.writeMessage(msg);
        }
    }

    private static class PoisonMessage
    extends I2CPMessageImpl {
        public static final int MESSAGE_TYPE = 999999;

        private PoisonMessage() {
        }

        public int getType() {
            return 999999;
        }

        public void doReadMessage(InputStream buf, int size) throws I2CPMessageException, IOException {
        }

        public byte[] doWriteMessage() throws I2CPMessageException, IOException {
            return null;
        }
    }
}

