/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.TunnelId;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.router.ClientMessage;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.router.client.ClientListenerRunner;
import net.i2p.router.client.InternalClientListenerRunner;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientManager {
    private Log _log;
    private ClientListenerRunner _listener;
    private ClientListenerRunner _internalListener;
    private final HashMap<Destination, ClientConnectionRunner> _runners;
    private final Set<ClientConnectionRunner> _pendingRunners;
    private RouterContext _ctx;
    private static final int INBOUND_POLL_INTERVAL = 300;
    private static final int REQUEST_LEASESET_TIMEOUT = 120000;

    public ClientManager(RouterContext context, int port) {
        this._ctx = context;
        this._log = context.logManager().getLog(ClientManager.class);
        this._ctx.statManager().createRateStat("client.receiveMessageSize", "How large are messages received by the client?", "ClientMessages", new long[]{60000L, 3600000L, 86400000L});
        this._runners = new HashMap();
        this._pendingRunners = new HashSet<ClientConnectionRunner>();
        this.startListeners(port);
    }

    private void startListeners(int port) {
        this._listener = new ClientListenerRunner(this._ctx, this, port);
        I2PThread t = new I2PThread((Runnable)this._listener);
        t.setName("ClientListener:" + port);
        t.setDaemon(true);
        t.start();
        this._internalListener = new InternalClientListenerRunner(this._ctx, this, port);
        t = new I2PThread((Runnable)this._internalListener);
        t.setName("ClientListener:" + port + "-i");
        t.setDaemon(true);
        t.start();
    }

    public void restart() {
        this.shutdown();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        int port = 7654;
        String portStr = this._ctx.router().getConfigSetting("i2cp.port");
        if (portStr != null) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException nfe) {
                this._log.error("Error setting the port: " + portStr + " is not valid", (Throwable)nfe);
            }
        }
        this.startListeners(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this._log.info("Shutting down the ClientManager");
        this._listener.stopListening();
        this._internalListener.stopListening();
        HashSet<ClientConnectionRunner> runners = new HashSet<ClientConnectionRunner>();
        Object object = this._runners;
        synchronized (object) {
            for (ClientConnectionRunner runner : this._runners.values()) {
                runners.add(runner);
            }
        }
        object = this._pendingRunners;
        synchronized (object) {
            for (ClientConnectionRunner runner : this._pendingRunners) {
                runners.add(runner);
            }
        }
        for (ClientConnectionRunner runner : runners) {
            runner.stopRunning();
        }
    }

    public boolean isAlive() {
        return this._listener.isListening();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnection(ClientConnectionRunner runner) {
        Set<ClientConnectionRunner> set = this._pendingRunners;
        synchronized (set) {
            this._pendingRunners.add(runner);
        }
        runner.startRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnection(ClientConnectionRunner runner) {
        this._log.warn("Unregistering (dropping) a client connection");
        Object object = this._pendingRunners;
        synchronized (object) {
            this._pendingRunners.remove(runner);
        }
        if (runner.getConfig() != null && runner.getConfig().getDestination() != null) {
            object = this._runners;
            synchronized (object) {
                this._runners.remove(runner.getConfig().getDestination());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destinationEstablished(ClientConnectionRunner runner) {
        Destination dest = runner.getConfig().getDestination();
        if (this._log.shouldLog(10)) {
            this._log.debug("DestinationEstablished called for destination " + dest.calculateHash().toBase64());
        }
        Set<ClientConnectionRunner> set = this._pendingRunners;
        synchronized (set) {
            this._pendingRunners.remove(runner);
        }
        boolean fail = false;
        HashMap<Destination, ClientConnectionRunner> hashMap = this._runners;
        synchronized (hashMap) {
            fail = this._runners.containsKey(dest);
            if (!fail) {
                this._runners.put(dest, runner);
            }
        }
        if (fail) {
            this._log.log(50, "Client attempted to register duplicate destination " + dest.calculateHash().toBase64());
            runner.disconnectClient("Duplicate destination");
        }
    }

    void distributeMessage(Destination fromDest, Destination toDest, Payload payload, MessageId msgId, long expiration) {
        ClientConnectionRunner runner = this.getRunner(toDest);
        if (runner != null) {
            ClientConnectionRunner sender;
            if (this._log.shouldLog(10)) {
                this._log.debug("Message " + msgId + " is targeting a local destination.  distribute it as such");
            }
            if ((sender = this.getRunner(fromDest)) == null) {
                return;
            }
            this._ctx.jobQueue().addJob(new DistributeLocal(toDest, runner, sender, fromDest, payload, msgId));
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Message " + msgId + " is targeting a REMOTE destination!  Added to the client message pool");
            }
            if ((runner = this.getRunner(fromDest)) == null) {
                return;
            }
            ClientMessage msg = new ClientMessage();
            msg.setDestination(toDest);
            msg.setPayload(payload);
            msg.setReceptionInfo(null);
            msg.setSenderConfig(runner.getConfig());
            msg.setFromDestination(runner.getConfig().getDestination());
            msg.setMessageId(msgId);
            msg.setExpiration(expiration);
            this._ctx.clientMessagePool().add(msg, true);
        }
    }

    public void requestLeaseSet(Destination dest, LeaseSet set, long timeout, Job onCreateJob, Job onFailedJob) {
        ClientConnectionRunner runner = this.getRunner(dest);
        if (runner == null) {
            if (this._log.shouldLog(40)) {
                this._log.warn("Cannot request the lease set, as we can't find a client runner for " + dest.calculateHash().toBase64() + ".  disconnected?");
            }
            this._ctx.jobQueue().addJob(onFailedJob);
        } else {
            runner.requestLeaseSet(set, this._ctx.clock().now() + timeout, onCreateJob, onFailedJob);
        }
    }

    public void requestLeaseSet(Hash dest, LeaseSet ls) {
        ClientConnectionRunner runner = this.getRunner(dest);
        if (runner != null) {
            runner.requestLeaseSet(ls, 120000L, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocal(Destination dest) {
        boolean rv = false;
        long beforeLock = this._ctx.clock().now();
        long inLock = 0L;
        HashMap<Destination, ClientConnectionRunner> hashMap = this._runners;
        synchronized (hashMap) {
            inLock = this._ctx.clock().now();
            rv = this._runners.containsKey(dest);
        }
        long afterLock = this._ctx.clock().now();
        if (afterLock - beforeLock > 50L) {
            this._log.warn("isLocal(Destination).locking took too long: " + (afterLock - beforeLock) + " overall, synchronized took " + (inLock - beforeLock));
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocal(Hash destHash) {
        if (destHash == null) {
            return false;
        }
        HashMap<Destination, ClientConnectionRunner> hashMap = this._runners;
        synchronized (hashMap) {
            for (ClientConnectionRunner cur : this._runners.values()) {
                if (!destHash.equals((Object)cur.getDestHash())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldPublishLeaseSet(Hash destHash) {
        if (destHash == null) {
            return true;
        }
        ClientConnectionRunner runner = this.getRunner(destHash);
        if (runner == null) {
            return true;
        }
        return Boolean.valueOf(runner.getConfig().getOptions().getProperty("i2cp.dontPublishLeaseSet")) == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Destination> listClients() {
        HashSet<Destination> rv = new HashSet<Destination>();
        HashMap<Destination, ClientConnectionRunner> hashMap = this._runners;
        synchronized (hashMap) {
            rv.addAll(this._runners.keySet());
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientConnectionRunner getRunner(Destination dest) {
        ClientConnectionRunner rv = null;
        long beforeLock = this._ctx.clock().now();
        long inLock = 0L;
        HashMap<Destination, ClientConnectionRunner> hashMap = this._runners;
        synchronized (hashMap) {
            inLock = this._ctx.clock().now();
            rv = this._runners.get(dest);
        }
        long afterLock = this._ctx.clock().now();
        if (afterLock - beforeLock > 50L) {
            this._log.warn("getRunner(Dest).locking took too long: " + (afterLock - beforeLock) + " overall, synchronized took " + (inLock - beforeLock));
        }
        return rv;
    }

    public SessionConfig getClientSessionConfig(Destination dest) {
        ClientConnectionRunner runner = this.getRunner(dest);
        if (runner != null) {
            return runner.getConfig();
        }
        return null;
    }

    public SessionKeyManager getClientSessionKeyManager(Hash dest) {
        ClientConnectionRunner runner = this.getRunner(dest);
        if (runner != null) {
            return runner.getSessionKeyManager();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConnectionRunner getRunner(Hash destHash) {
        if (destHash == null) {
            return null;
        }
        HashMap<Destination, ClientConnectionRunner> hashMap = this._runners;
        synchronized (hashMap) {
            for (ClientConnectionRunner cur : this._runners.values()) {
                if (!cur.getDestHash().equals((Object)destHash)) continue;
                return cur;
            }
        }
        return null;
    }

    public void messageDeliveryStatusUpdate(Destination fromDest, MessageId id, boolean delivered) {
        ClientConnectionRunner runner = this.getRunner(fromDest);
        if (runner != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Delivering status [" + (delivered ? "success" : "failure") + "] to " + fromDest.calculateHash().toBase64() + " for message " + id);
            }
            runner.updateMessageDeliveryStatus(id, delivered);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Cannot deliver status [" + (delivered ? "success" : "failure") + "] to " + fromDest.calculateHash().toBase64() + " for message " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Destination> getRunnerDestinations() {
        HashSet<Destination> dests = new HashSet<Destination>();
        long beforeLock = this._ctx.clock().now();
        long inLock = 0L;
        HashMap<Destination, ClientConnectionRunner> hashMap = this._runners;
        synchronized (hashMap) {
            inLock = this._ctx.clock().now();
            dests.addAll(this._runners.keySet());
        }
        long afterLock = this._ctx.clock().now();
        if (afterLock - beforeLock > 50L) {
            this._log.warn("getRunnerDestinations().locking took too long: " + (afterLock - beforeLock) + " overall, synchronized took " + (inLock - beforeLock));
        }
        return dests;
    }

    public void reportAbuse(Destination dest, String reason, int severity) {
        if (dest != null) {
            ClientConnectionRunner runner = this.getRunner(dest);
            if (runner != null) {
                runner.reportAbuse(reason, severity);
            }
        } else {
            Set<Destination> dests = this.getRunnerDestinations();
            for (Destination d : dests) {
                this.reportAbuse(d, reason, severity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderStatusHTML(Writer out) throws IOException {
        StringBuilder buf = new StringBuilder(8192);
        buf.append("<u><b>Local destinations</b></u><br>");
        Map runners = null;
        HashMap<Destination, ClientConnectionRunner> hashMap = this._runners;
        synchronized (hashMap) {
            runners = (Map)this._runners.clone();
        }
        for (Destination dest : runners.keySet()) {
            ClientConnectionRunner runner = (ClientConnectionRunner)runners.get(dest);
            buf.append("<b>*</b> ").append(dest.calculateHash().toBase64().substring(0, 6)).append("<br>\n");
            LeaseSet ls = runner.getLeaseSet();
            if (ls == null) {
                buf.append("<font color=\"red\"><i>No lease</i></font><br>\n");
                continue;
            }
            long leaseAge = ls.getEarliestLeaseDate() - this._ctx.clock().now();
            if (leaseAge <= 0L) {
                buf.append("<font color=\"red\"><i>Lease expired ");
                buf.append(DataHelper.formatDuration((long)(0L - leaseAge))).append(" ago</i></font><br>\n");
                continue;
            }
            int count = ls.getLeaseCount();
            if (count <= 0) {
                buf.append("<font color=\"red\"><i>No tunnels</i></font><br>\n");
                continue;
            }
            TunnelId id = ls.getLease(0).getTunnelId();
            TunnelInfo info = this._ctx.tunnelManager().getTunnelInfo(id);
            if (info == null) {
                buf.append("<font color=\"red\"><i>Failed tunnels</i></font><br>\n");
                continue;
            }
            buf.append(count).append(" x ");
            buf.append(info.getLength() - 1).append(" hop tunnel");
            if (count != 1) {
                buf.append('s');
            }
            buf.append("<br>\n");
            buf.append("Expiring in ").append(DataHelper.formatDuration((long)leaseAge));
            buf.append("<br>\n");
        }
        buf.append("\n<hr>\n");
        out.write(buf.toString());
        out.flush();
    }

    public void messageReceived(ClientMessage msg) {
        this._ctx.jobQueue().addJob(new HandleJob(msg));
    }

    private class HandleJob
    extends JobImpl {
        private ClientMessage _msg;

        public HandleJob(ClientMessage msg) {
            super(ClientManager.this._ctx);
            this._msg = msg;
        }

        public String getName() {
            return "Handle Inbound Client Messages";
        }

        public void runJob() {
            ClientConnectionRunner runner = null;
            runner = this._msg.getDestination() != null ? ClientManager.this.getRunner(this._msg.getDestination()) : ClientManager.this.getRunner(this._msg.getDestinationHash());
            if (runner != null) {
                ClientManager.this._ctx.statManager().addRateData("client.receiveMessageSize", (long)this._msg.getPayload().getSize(), 0L);
                runner.receiveMessage(this._msg.getDestination(), null, this._msg.getPayload());
            } else if (ClientManager.this._log.shouldLog(30)) {
                ClientManager.this._log.warn("Message received but we don't have a connection to " + this._msg.getDestination() + "/" + this._msg.getDestinationHash() + " currently.  DROPPED");
            }
        }
    }

    private class DistributeLocal
    extends JobImpl {
        private Destination _toDest;
        private ClientConnectionRunner _to;
        private ClientConnectionRunner _from;
        private Destination _fromDest;
        private Payload _payload;
        private MessageId _msgId;

        public DistributeLocal(Destination toDest, ClientConnectionRunner to, ClientConnectionRunner from, Destination fromDest, Payload payload, MessageId id) {
            super(ClientManager.this._ctx);
            this._toDest = toDest;
            this._to = to;
            this._from = from;
            this._fromDest = fromDest;
            this._payload = payload;
            this._msgId = id;
        }

        public String getName() {
            return "Distribute local message";
        }

        public void runJob() {
            this._to.receiveMessage(this._toDest, this._fromDest, this._payload);
            if (this._from != null) {
                this._from.updateMessageDeliveryStatus(this._msgId, true);
            }
        }
    }
}

