/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.I2PAppContext;
import net.i2p.router.RouterContext;
import net.i2p.util.Clock;

public class RouterClock
extends Clock {
    private static final long MAX_SLEW = 50L;
    private static final int DEFAULT_STRATUM = 8;
    private static final int WORST_STRATUM = 16;
    private static final long MIN_DELAY_FOR_WORSE_STRATUM = 2700000L;
    private volatile long _desiredOffset;
    private volatile long _lastSlewed;
    private long _lastChanged;
    private int _lastStratum;
    RouterContext _contextRC;

    public RouterClock(RouterContext context) {
        super((I2PAppContext)context);
        this._contextRC = context;
        this._lastStratum = 16;
    }

    public void setOffset(long offsetMs, boolean force) {
        this.setOffset(offsetMs, force, 8);
    }

    private void setOffset(long offsetMs, int stratum) {
        this.setOffset(offsetMs, false, stratum);
    }

    private void setOffset(long offsetMs, boolean force, int stratum) {
        long delta = offsetMs - this._offset;
        if (!force) {
            if (offsetMs > 259200000L || offsetMs < -259200000L) {
                this.getLog().error("Maximum offset shift exceeded [" + offsetMs + "], NOT HONORING IT");
                return;
            }
            if (this._alreadyChanged && System.currentTimeMillis() - this._startedOn > 600000L && (delta > 600000L || delta < -600000L)) {
                this.getLog().log(50, "The clock has already been updated, but you want to change it by " + delta + " to " + offsetMs + "?  Did something break?");
                return;
            }
            if (delta == 0L) {
                this.getLog().debug("Not changing offset, delta=0");
                this._alreadyChanged = true;
                return;
            }
            if (this._alreadyChanged && stratum > this._lastStratum && System.currentTimeMillis() - this._lastChanged < 2700000L) {
                this.getLog().warn("Ignoring update from a stratum " + stratum + " clock, we recently had an update from a stratum " + this._lastStratum + " clock");
                return;
            }
            if (Boolean.valueOf(this._contextRC.getProperty("router.clockOffsetSanityCheck", "true")).booleanValue() && this._alreadyChanged) {
                long currentPeerClockSkew = this._contextRC.commSystem().getFramedAveragePeerClockSkew(50);
                long predictedPeerClockSkew = currentPeerClockSkew + delta;
                if (Math.abs(predictedPeerClockSkew) > Math.abs(currentPeerClockSkew) + 5000L || Math.abs(predictedPeerClockSkew) > 20000L) {
                    this.getLog().error("Ignoring clock offset " + offsetMs + "ms (current " + this._offset + "ms) since it would increase peer clock skew from " + currentPeerClockSkew + "ms to " + predictedPeerClockSkew + "ms. Bad time server?");
                    return;
                }
                this.getLog().debug("Approving clock offset " + offsetMs + "ms (current " + this._offset + "ms) since it would decrease peer clock skew from " + currentPeerClockSkew + "ms to " + predictedPeerClockSkew + "ms.");
            }
        }
        if (this._alreadyChanged) {
            if (delta > 15000L) {
                this.getLog().error("Warning - Updating target clock offset to " + offsetMs + "ms from " + this._offset + "ms, Stratum " + stratum);
            } else if (this.getLog().shouldLog(20)) {
                this.getLog().info("Updating target clock offset to " + offsetMs + "ms from " + this._offset + "ms, Stratum " + stratum);
            }
            if (!this._statCreated) {
                this._contextRC.statManager().createRateStat("clock.skew", "How far is the already adjusted clock being skewed?", "Clock", new long[]{600000L, 10800000L, 5184000L});
                this._statCreated = true;
            }
            this._contextRC.statManager().addRateData("clock.skew", delta, 0L);
            this._desiredOffset = offsetMs;
        } else {
            this.getLog().log(20, "Initializing clock offset to " + offsetMs + "ms, Stratum " + stratum);
            this._alreadyChanged = true;
            this._offset = offsetMs;
            this._desiredOffset = offsetMs;
            this.fireOffsetChanged(delta);
        }
        this._lastChanged = System.currentTimeMillis();
        this._lastStratum = stratum;
    }

    public void setNow(long realTime, int stratum) {
        long diff = realTime - System.currentTimeMillis();
        this.setOffset(diff, stratum);
    }

    public long now() {
        long systemNow = System.currentTimeMillis();
        long offset = this._offset;
        if (systemNow >= this._lastSlewed + 50L) {
            long desiredOffset = this._desiredOffset;
            if (desiredOffset > offset) {
                this._offset = ++offset;
            } else if (desiredOffset < offset) {
                this._offset = --offset;
            }
            this._lastSlewed = systemNow;
        }
        return offset + systemNow;
    }

    public long getDeltaOffset() {
        return this._desiredOffset - this._offset;
    }
}

