/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.util.Log;

public class MessageHistory {
    private Log _log;
    private RouterContext _context;
    private final List _unwrittenEntries = new ArrayList(64);
    private String _historyFile;
    private String _localIdent;
    private boolean _doLog;
    private boolean _doPause;
    private ReinitializeJob _reinitializeJob;
    private WriteJob _writeJob;
    private volatile boolean _firstPass;
    private static final byte[] NL = System.getProperty("line.separator").getBytes();
    private static final int FLUSH_SIZE = 1000;
    public static final String PROP_KEEP_MESSAGE_HISTORY = "router.keepHistory";
    public static final String PROP_MESSAGE_HISTORY_FILENAME = "router.historyFilename";
    public static final String DEFAULT_MESSAGE_HISTORY_FILENAME = "messageHistory.txt";
    private final SimpleDateFormat _fmt;
    private static final long WRITE_DELAY = 60000L;

    public MessageHistory(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(this.getClass());
        this._fmt = new SimpleDateFormat("yy/MM/dd.HH:mm:ss.SSS");
        this._fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        this._reinitializeJob = new ReinitializeJob();
        this._writeJob = new WriteJob();
        this._firstPass = true;
        this.initialize(true);
    }

    void setDoLog(boolean log) {
        this._doLog = log;
    }

    public boolean getDoLog() {
        return this._doLog;
    }

    void setPauseFlushes(boolean doPause) {
        this._doPause = doPause;
    }

    String getFilename() {
        return this._historyFile;
    }

    private void updateSettings() {
        this._doLog = Boolean.valueOf(this._context.getProperty(PROP_KEEP_MESSAGE_HISTORY));
        this._historyFile = this._context.getProperty(PROP_MESSAGE_HISTORY_FILENAME, DEFAULT_MESSAGE_HISTORY_FILENAME);
    }

    public void initialize(boolean forceReinitialize) {
        if (!forceReinitialize) {
            return;
        }
        if (this._context.router() == null) {
            return;
        }
        if (this._context.router().getRouterInfo() == null) {
            this._reinitializeJob.getTiming().setStartAfter(this._context.clock().now() + 5000L);
            this._context.jobQueue().addJob(this._reinitializeJob);
        } else {
            this._localIdent = MessageHistory.getName(this._context.routerHash());
            this.updateSettings();
            if (this._firstPass) {
                File f = new File(this._historyFile);
                f.delete();
            }
            this._firstPass = false;
            this.addEntry(this.getPrefix() + "** Router initialized (started up or changed identities)");
            this._context.jobQueue().addJob(this._writeJob);
        }
    }

    public void tunnelJoined(String state, TunnelInfo tunnel) {
        if (!this._doLog) {
            return;
        }
        if (tunnel == null) {
            return;
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.getPrefix());
        buf.append("joining as [").append(state);
        buf.append("] to tunnel: ").append(tunnel.toString());
        this.addEntry(buf.toString());
    }

    public void tunnelJoined(String state, HopConfig tunnel) {
        if (!this._doLog) {
            return;
        }
        if (tunnel == null) {
            return;
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.getPrefix());
        buf.append("joining as [").append(state);
        buf.append("] to tunnel: ").append(tunnel.toString());
        this.addEntry(buf.toString());
    }

    public void tunnelDispatched(String info) {
        if (!this._doLog) {
            return;
        }
        if (info == null) {
            return;
        }
        this.addEntry(this.getPrefix() + "tunnel dispatched: " + info);
    }

    public void tunnelDispatched(long messageId, long tunnelId, String type) {
        if (!this._doLog) {
            return;
        }
        this.addEntry(this.getPrefix() + "message " + messageId + " on tunnel " + tunnelId + " as " + type);
    }

    public void tunnelDispatched(long messageId, long tunnelId, long toTunnel, Hash toPeer, String type) {
        if (!this._doLog) {
            return;
        }
        if (toPeer != null) {
            this.addEntry(this.getPrefix() + "message " + messageId + " on tunnel " + tunnelId + " / " + toTunnel + " to " + toPeer.toBase64() + " as " + type);
        } else {
            this.addEntry(this.getPrefix() + "message " + messageId + " on tunnel " + tunnelId + " / " + toTunnel + " as " + type);
        }
    }

    public void tunnelDispatched(long messageId, long innerMessageId, long tunnelId, String type) {
        if (!this._doLog) {
            return;
        }
        this.addEntry(this.getPrefix() + "message " + messageId + "/" + innerMessageId + " on " + tunnelId + " as " + type);
    }

    public void tunnelFailed(TunnelId tunnel) {
        if (!this._doLog) {
            return;
        }
        if (tunnel == null) {
            return;
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.getPrefix());
        buf.append("failing tunnel [").append(tunnel.getTunnelId()).append("]");
        this.addEntry(buf.toString());
    }

    public void tunnelValid(TunnelInfo tunnel, long timeToTest) {
        if (!this._doLog) {
            return;
        }
        if (tunnel == null) {
            return;
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.getPrefix());
        buf.append("tunnel ").append(tunnel).append(" tested ok after ").append(timeToTest).append("ms");
        this.addEntry(buf.toString());
    }

    public void tunnelRejected(Hash peer, TunnelId tunnel, Hash replyThrough, String reason) {
        if (!this._doLog) {
            return;
        }
        if (tunnel == null || peer == null) {
            return;
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.getPrefix());
        buf.append("tunnel [").append(tunnel.getTunnelId()).append("] was rejected by [");
        buf.append(MessageHistory.getName(peer)).append("] for [").append(reason).append("]");
        if (replyThrough != null) {
            buf.append(" with their reply intended to come through [").append(MessageHistory.getName(replyThrough)).append("]");
        }
        this.addEntry(buf.toString());
    }

    public void tunnelParticipantRejected(Hash peer, String msg) {
        if (!this._doLog) {
            return;
        }
        if (peer == null) {
            return;
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.getPrefix());
        buf.append("tunnel participation rejected by [");
        buf.append(MessageHistory.getName(peer)).append("]: ").append(msg);
        this.addEntry(buf.toString());
    }

    public void tunnelRequestTimedOut(Hash peer, TunnelId tunnel) {
        if (!this._doLog) {
            return;
        }
        if (tunnel == null || peer == null) {
            return;
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.getPrefix());
        buf.append("tunnel [").append(tunnel.getTunnelId()).append("] timed out on [");
        buf.append(MessageHistory.getName(peer)).append("]");
        this.addEntry(buf.toString());
    }

    public void droppedTunnelMessage(TunnelId id, long msgId, Date expiration, Hash from) {
        if (!this._doLog) {
            return;
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.getPrefix());
        buf.append("dropped message ").append(msgId).append(" for unknown tunnel [").append(id.getTunnelId());
        buf.append("] from [").append(MessageHistory.getName(from)).append("]").append(" expiring on ");
        buf.append(this.getTime(expiration.getTime()));
        this.addEntry(buf.toString());
    }

    public void droppedOtherMessage(I2NPMessage message, Hash from) {
        if (!this._doLog) {
            return;
        }
        if (message == null) {
            return;
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append(this.getPrefix());
        buf.append("dropped [").append(message.getClass().getName()).append("] ").append(message.getUniqueId());
        buf.append(" [").append(message.toString()).append("] from [");
        if (from != null) {
            buf.append(from.toBase64());
        } else {
            buf.append("unknown");
        }
        buf.append("] expiring in ").append(message.getMessageExpiration() - this._context.clock().now()).append("ms");
        this.addEntry(buf.toString());
    }

    public void droppedInboundMessage(long messageId, Hash from, String info) {
        if (!this._doLog) {
            return;
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append(this.getPrefix());
        buf.append("dropped inbound message ").append(messageId);
        buf.append(" from ");
        if (from != null) {
            buf.append(from.toBase64());
        } else {
            buf.append("unknown");
        }
        buf.append(": ").append(info);
        this.addEntry(buf.toString());
    }

    public void replyTimedOut(OutNetMessage sentMessage) {
        if (!this._doLog) {
            return;
        }
        if (sentMessage == null) {
            return;
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append(this.getPrefix());
        buf.append("timed out waiting for a reply to [").append(sentMessage.getMessageType());
        buf.append("] [").append(sentMessage.getMessageId()).append("] expiring on [");
        if (sentMessage != null) {
            buf.append(this.getTime(sentMessage.getReplySelector().getExpiration()));
        }
        buf.append("] ").append(sentMessage.getReplySelector().toString());
        this.addEntry(buf.toString());
    }

    public void messageProcessingError(long messageId, String messageType, String error) {
        if (!this._doLog) {
            return;
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.getPrefix());
        buf.append("Error processing [").append(messageType).append("] [").append(messageId).append("] failed with [").append(error).append("]");
        this.addEntry(buf.toString());
    }

    public void shitlist(Hash peer, String reason) {
        if (!this._doLog) {
            return;
        }
        if (peer == null) {
            return;
        }
        this.addEntry("Shitlist " + peer.toBase64() + ": " + reason);
    }

    public void unshitlist(Hash peer) {
        if (!this._doLog) {
            return;
        }
        if (peer == null) {
            return;
        }
        this.addEntry("Unshitlist " + peer.toBase64());
    }

    public void sendMessage(String messageType, long messageId, long expiration, Hash peer, boolean sentOk, String info) {
        if (!this._doLog) {
            return;
        }
        StringBuilder buf = new StringBuilder(256);
        buf.append(this.getPrefix());
        buf.append("send [").append(messageType).append("] message [").append(messageId).append("] ");
        buf.append("to [").append(MessageHistory.getName(peer)).append("] ");
        buf.append("expiring on [").append(this.getTime(expiration)).append("] ");
        if (sentOk) {
            buf.append("successfully");
        } else {
            buf.append("failed");
        }
        if (info != null) {
            buf.append(info);
        }
        this.addEntry(buf.toString());
    }

    public void receiveMessage(String messageType, long messageId, long expiration, Hash from, boolean isValid) {
        if (!this._doLog) {
            return;
        }
        StringBuilder buf = new StringBuilder(256);
        buf.append(this.getPrefix());
        buf.append("receive [").append(messageType).append("] with id [").append(messageId).append("] ");
        if (from != null) {
            buf.append("from [").append(MessageHistory.getName(from)).append("] ");
        }
        buf.append("expiring on [").append(this.getTime(expiration)).append("] valid? ").append(isValid);
        this.addEntry(buf.toString());
    }

    public void receiveMessage(String messageType, long messageId, long expiration, boolean isValid) {
        this.receiveMessage(messageType, messageId, expiration, null, isValid);
    }

    public void wrap(String bodyMessageType, long bodyMessageId, String containerMessageType, long containerMessageId) {
        if (!this._doLog) {
            return;
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.getPrefix());
        buf.append("Wrap message [").append(bodyMessageType).append("] id [").append(bodyMessageId).append("] ");
        buf.append("in [").append(containerMessageType).append("] id [").append(containerMessageId).append("]");
        this.addEntry(buf.toString());
    }

    public void receivePayloadMessage(long messageId) {
        if (!this._doLog) {
            return;
        }
        StringBuilder buf = new StringBuilder(64);
        buf.append(this.getPrefix());
        buf.append("Receive payload message [").append(messageId).append("]");
        this.addEntry(buf.toString());
    }

    public void sendPayloadMessage(long messageId, boolean successfullySent, long timeToSend) {
        if (!this._doLog) {
            return;
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.getPrefix());
        buf.append("Send payload message in [").append(messageId).append("] in [").append(timeToSend).append("] successfully? ").append(successfullySent);
        this.addEntry(buf.toString());
    }

    public void receiveTunnelFragment(long messageId, int fragmentId, Object status) {
        if (!this._doLog) {
            return;
        }
        if (messageId == -1L) {
            throw new IllegalArgumentException("why are you -1?");
        }
        StringBuilder buf = new StringBuilder(48);
        buf.append(this.getPrefix());
        buf.append("Receive fragment ").append(fragmentId).append(" in ").append(messageId);
        buf.append(" status: ").append(status.toString());
        this.addEntry(buf.toString());
    }

    public void receiveTunnelFragmentComplete(long messageId) {
        if (!this._doLog) {
            return;
        }
        if (messageId == -1L) {
            throw new IllegalArgumentException("why are you -1?");
        }
        StringBuilder buf = new StringBuilder(48);
        buf.append(this.getPrefix());
        buf.append("Receive fragmented message completely: ").append(messageId);
        this.addEntry(buf.toString());
    }

    public void droppedFragmentedMessage(long messageId, String status) {
        if (!this._doLog) {
            return;
        }
        if (messageId == -1L) {
            throw new IllegalArgumentException("why are you -1?");
        }
        StringBuilder buf = new StringBuilder(48);
        buf.append(this.getPrefix());
        buf.append("Fragmented message dropped: ").append(messageId);
        buf.append(" ").append(status);
        this.addEntry(buf.toString());
    }

    public void fragmentMessage(long messageId, int numFragments, int totalLength, List messageIds, String msg) {
        if (!this._doLog) {
            return;
        }
        StringBuilder buf = new StringBuilder(48);
        buf.append(this.getPrefix());
        buf.append("Break message ").append(messageId).append(" into fragments: ").append(numFragments);
        buf.append(" total size ").append(totalLength);
        buf.append(" contained in ").append(messageIds);
        if (msg != null) {
            buf.append(": ").append(msg);
        }
        this.addEntry(buf.toString());
    }

    public void fragmentMessage(long messageId, int numFragments, int totalLength, List messageIds, Object tunnel, String msg) {
        if (!this._doLog) {
            return;
        }
        StringBuilder buf = new StringBuilder(48);
        buf.append(this.getPrefix());
        buf.append("Break message ").append(messageId).append(" into fragments: ").append(numFragments);
        buf.append(" total size ").append(totalLength);
        buf.append(" contained in ").append(messageIds);
        if (tunnel != null) {
            buf.append(" on ").append(tunnel.toString());
        }
        if (msg != null) {
            buf.append(": ").append(msg);
        }
        this.addEntry(buf.toString());
    }

    public void droppedTunnelDataMessageUnknown(long msgId, long tunnelId) {
        if (!this._doLog) {
            return;
        }
        if (msgId == -1L) {
            throw new IllegalArgumentException("why are you -1?");
        }
        StringBuilder buf = new StringBuilder(48);
        buf.append(this.getPrefix());
        buf.append("Dropped data message ").append(msgId).append(" for unknown tunnel ").append(tunnelId);
        this.addEntry(buf.toString());
    }

    public void droppedTunnelGatewayMessageUnknown(long msgId, long tunnelId) {
        if (!this._doLog) {
            return;
        }
        if (msgId == -1L) {
            throw new IllegalArgumentException("why are you -1?");
        }
        StringBuilder buf = new StringBuilder(48);
        buf.append(this.getPrefix());
        buf.append("Dropped gateway message ").append(msgId).append(" for unknown tunnel ").append(tunnelId);
        this.addEntry(buf.toString());
    }

    private static final String getName(Hash router) {
        if (router == null) {
            return "unknown";
        }
        String str = router.toBase64();
        if (str == null || str.length() < 6) {
            return "invalid";
        }
        return str.substring(0, 6);
    }

    private final String getPrefix() {
        StringBuilder buf = new StringBuilder(48);
        buf.append(this.getTime(this._context.clock().now()));
        buf.append(' ').append(this._localIdent).append(": ");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getTime(long when) {
        SimpleDateFormat simpleDateFormat = this._fmt;
        synchronized (simpleDateFormat) {
            return this._fmt.format(new Date(when));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(String entry) {
        if (entry == null) {
            return;
        }
        int sz = 0;
        List list = this._unwrittenEntries;
        synchronized (list) {
            this._unwrittenEntries.add(entry);
            sz = this._unwrittenEntries.size();
        }
        if (sz > 1000) {
            this.flushEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushEntries() {
        if (this._doPause) {
            return;
        }
        ArrayList entries = null;
        List list = this._unwrittenEntries;
        synchronized (list) {
            entries = new ArrayList(this._unwrittenEntries);
            this._unwrittenEntries.clear();
        }
        this.writeEntries(entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEntries(List entries) {
        if (!this._doLog) {
            return;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this._historyFile, true);
            for (String entry : entries) {
                fos.write(entry.getBytes());
                fos.write(NL);
            }
        }
        catch (IOException ioe) {
            this._log.error("Error writing trace entries", (Throwable)ioe);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void main(String[] args) {
        RouterContext ctx = new RouterContext(null);
        MessageHistory hist = new MessageHistory(ctx);
        hist.setDoLog(false);
        hist.addEntry("you smell before");
        hist.setDoLog(true);
        hist.addEntry("you smell after");
        hist.setDoLog(false);
        hist.addEntry("you smell finished");
        hist.flushEntries();
    }

    private class WriteJob
    extends JobImpl {
        public WriteJob() {
            super(MessageHistory.this._context);
        }

        public String getName() {
            return "Write History Entries";
        }

        public void runJob() {
            MessageHistory.this.flushEntries();
            MessageHistory.this.updateSettings();
            this.requeue(60000L);
        }
    }

    private final class ReinitializeJob
    extends JobImpl {
        private ReinitializeJob() {
            super(MessageHistory.this._context);
        }

        public void runJob() {
            MessageHistory.this.initialize(true);
        }

        public String getName() {
            return "Reinitialize message history";
        }
    }
}

