/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataStructure;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.router.JobImpl;
import net.i2p.router.JobQueue;
import net.i2p.router.LeaseSetKeys;
import net.i2p.router.RouterContext;
import net.i2p.util.Clock;
import net.i2p.util.Log;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyManager {
    private Log _log;
    private RouterContext _context;
    private PrivateKey _privateKey;
    private PublicKey _publicKey;
    private SigningPrivateKey _signingPrivateKey;
    private SigningPublicKey _signingPublicKey;
    private final Map<Hash, LeaseSetKeys> _leaseSetKeys;
    private SynchronizeKeysJob _synchronizeJob;
    public static final String PROP_KEYDIR = "router.keyBackupDir";
    public static final String DEFAULT_KEYDIR = "keyBackup";
    private static final String KEYFILE_PRIVATE_ENC = "privateEncryption.key";
    private static final String KEYFILE_PUBLIC_ENC = "publicEncryption.key";
    private static final String KEYFILE_PRIVATE_SIGNING = "privateSigning.key";
    private static final String KEYFILE_PUBLIC_SIGNING = "publicSigning.key";
    private static final long DELAY = 604800000L;

    public KeyManager(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(KeyManager.class);
        this._synchronizeJob = new SynchronizeKeysJob();
        this.setPrivateKey(null);
        this.setPublicKey(null);
        this.setSigningPrivateKey(null);
        this.setSigningPublicKey(null);
        this._leaseSetKeys = new ConcurrentHashMap<Hash, LeaseSetKeys>();
    }

    public void startup() {
        this.queueWrite();
    }

    public void setPrivateKey(PrivateKey key) {
        this._privateKey = key;
        if (key != null) {
            this.queueWrite();
        }
    }

    public PrivateKey getPrivateKey() {
        return this._privateKey;
    }

    public void setPublicKey(PublicKey key) {
        this._publicKey = key;
        if (key != null) {
            this.queueWrite();
        }
    }

    public PublicKey getPublicKey() {
        return this._publicKey;
    }

    public void setSigningPrivateKey(SigningPrivateKey key) {
        this._signingPrivateKey = key;
        if (key != null) {
            this.queueWrite();
        }
    }

    public SigningPrivateKey getSigningPrivateKey() {
        return this._signingPrivateKey;
    }

    public void setSigningPublicKey(SigningPublicKey key) {
        this._signingPublicKey = key;
        if (key != null) {
            this.queueWrite();
        }
    }

    public SigningPublicKey getSigningPublicKey() {
        return this._signingPublicKey;
    }

    public void registerKeys(Destination dest, SigningPrivateKey leaseRevocationPrivateKey, PrivateKey endpointDecryptionKey) {
        this._log.info("Registering keys for destination " + dest.calculateHash().toBase64());
        LeaseSetKeys keys = new LeaseSetKeys(dest, leaseRevocationPrivateKey, endpointDecryptionKey);
        this._leaseSetKeys.put(dest.calculateHash(), keys);
    }

    private void queueWrite() {
        Clock cl = this._context.clock();
        JobQueue q = this._context.jobQueue();
        if (cl == null || q == null) {
            return;
        }
        this._synchronizeJob.getTiming().setStartAfter(cl.now() + 1000L);
        q.addJob(this._synchronizeJob);
    }

    public LeaseSetKeys unregisterKeys(Destination dest) {
        if (this._log.shouldLog(20)) {
            this._log.info("Unregistering keys for destination " + dest.calculateHash().toBase64());
        }
        return this._leaseSetKeys.remove(dest.calculateHash());
    }

    public LeaseSetKeys getKeys(Destination dest) {
        return this.getKeys(dest.calculateHash());
    }

    public LeaseSetKeys getKeys(Hash dest) {
        return this._leaseSetKeys.get(dest);
    }

    public Set<LeaseSetKeys> getAllKeys() {
        HashSet<LeaseSetKeys> keys = new HashSet<LeaseSetKeys>();
        keys.addAll(this._leaseSetKeys.values());
        return keys;
    }

    private class SynchronizeKeysJob
    extends JobImpl {
        public SynchronizeKeysJob() {
            super(KeyManager.this._context);
        }

        public void runJob() {
            String keyDir = this.getContext().getProperty(KeyManager.PROP_KEYDIR, KeyManager.DEFAULT_KEYDIR);
            SecureDirectory dir = new SecureDirectory(this.getContext().getRouterDir(), keyDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (dir.exists() && dir.isDirectory() && dir.canRead() && dir.canWrite()) {
                this.syncKeys((File)dir);
            } else {
                KeyManager.this._log.log(50, "Unable to synchronize keys in " + keyDir + " - permissions problem?");
            }
            this.getTiming().setStartAfter(KeyManager.this._context.clock().now() + 604800000L);
            KeyManager.this._context.jobQueue().addJob(this);
        }

        private void syncKeys(File keyDir) {
            this.syncPrivateKey(keyDir);
            this.syncPublicKey(keyDir);
            this.syncSigningKey(keyDir);
            this.syncVerificationKey(keyDir);
        }

        private synchronized void syncPrivateKey(File keyDir) {
            File keyFile = new File(keyDir, KeyManager.KEYFILE_PRIVATE_ENC);
            boolean exists = KeyManager.this._privateKey != null;
            PrivateKey ds = exists ? KeyManager.this._privateKey : new PrivateKey();
            DataStructure readin = this.syncKey(keyFile, (DataStructure)ds, exists);
            if (readin != null && !exists) {
                KeyManager.this._privateKey = (PrivateKey)readin;
            }
        }

        private synchronized void syncPublicKey(File keyDir) {
            File keyFile = new File(keyDir, KeyManager.KEYFILE_PUBLIC_ENC);
            boolean exists = KeyManager.this._publicKey != null;
            PublicKey ds = exists ? KeyManager.this._publicKey : new PublicKey();
            DataStructure readin = this.syncKey(keyFile, (DataStructure)ds, exists);
            if (readin != null && !exists) {
                KeyManager.this._publicKey = (PublicKey)readin;
            }
        }

        private synchronized void syncSigningKey(File keyDir) {
            File keyFile = new File(keyDir, KeyManager.KEYFILE_PRIVATE_SIGNING);
            boolean exists = KeyManager.this._signingPrivateKey != null;
            SigningPrivateKey ds = exists ? KeyManager.this._signingPrivateKey : new SigningPrivateKey();
            DataStructure readin = this.syncKey(keyFile, (DataStructure)ds, exists);
            if (readin != null && !exists) {
                KeyManager.this._signingPrivateKey = (SigningPrivateKey)readin;
            }
        }

        private synchronized void syncVerificationKey(File keyDir) {
            File keyFile = new File(keyDir, KeyManager.KEYFILE_PUBLIC_SIGNING);
            boolean exists = KeyManager.this._signingPublicKey != null;
            SigningPublicKey ds = exists ? KeyManager.this._signingPublicKey : new SigningPublicKey();
            DataStructure readin = this.syncKey(keyFile, (DataStructure)ds, exists);
            if (readin != null && !exists) {
                KeyManager.this._signingPublicKey = (SigningPublicKey)readin;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private DataStructure syncKey(File keyFile, DataStructure structure, boolean exists) {
            SecureFileOutputStream out = null;
            FileInputStream in = null;
            try {
                if (exists) {
                    out = new SecureFileOutputStream(keyFile);
                    structure.writeBytes((OutputStream)out);
                    DataStructure dataStructure = structure;
                    return dataStructure;
                }
                if (keyFile.exists()) {
                    in = new FileInputStream(keyFile);
                    structure.readBytes((InputStream)in);
                    DataStructure dataStructure = structure;
                    return dataStructure;
                }
                DataStructure dataStructure = null;
                return dataStructure;
            }
            catch (IOException ioe) {
                KeyManager.this._log.error("Error syncing the structure to " + keyFile.getAbsolutePath(), (Throwable)ioe);
            }
            catch (DataFormatException dfe) {
                KeyManager.this._log.error("Error syncing the structure with " + keyFile.getAbsolutePath(), (Throwable)dfe);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {}
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            if (!exists) return null;
            return structure;
        }

        public String getName() {
            return "Synchronize Keys to Disk";
        }
    }
}

