/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

class JobQueueRunner
implements Runnable {
    private Log _log;
    private RouterContext _context;
    private boolean _keepRunning;
    private int _id;
    private long _numJobs;
    private Job _currentJob;
    private Job _lastJob;
    private long _lastBegin;
    private long _lastEnd;
    private int _state;

    public JobQueueRunner(RouterContext context, int id) {
        this._context = context;
        this._id = id;
        this._keepRunning = true;
        this._numJobs = 0L;
        this._currentJob = null;
        this._lastJob = null;
        this._log = this._context.logManager().getLog(JobQueueRunner.class);
        this._context.statManager().createRateStat("jobQueue.jobRun", "How long jobs take", "JobQueue", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("jobQueue.jobRunSlow", "How long jobs that take over a second take", "JobQueue", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("jobQueue.jobLag", "How long jobs have to wait before running", "JobQueue", new long[]{60000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("jobQueue.jobWait", "How long does a job sit on the job queue?", "JobQueue", new long[]{3600000L, 86400000L});
    }

    final int getState() {
        return this._state;
    }

    public Job getCurrentJob() {
        return this._currentJob;
    }

    public Job getLastJob() {
        return this._lastJob;
    }

    public int getRunnerId() {
        return this._id;
    }

    public void stopRunning() {
        this._keepRunning = false;
    }

    public void startRunning() {
        this._keepRunning = true;
    }

    public long getLastBegin() {
        return this._lastBegin;
    }

    public long getLastEnd() {
        return this._lastEnd;
    }

    public void run() {
        long lastActive = this._context.clock().now();
        long jobNum = 0L;
        while (this._keepRunning && this._context.jobQueue().isAlive()) {
            try {
                Job job = this._context.jobQueue().getNext();
                if (job == null) {
                    if (!this._context.router().isAlive() || !this._log.shouldLog(40)) continue;
                    this._log.error("getNext returned null - dead?");
                    continue;
                }
                long now = this._context.clock().now();
                long enqueuedTime = 0L;
                if (job instanceof JobImpl) {
                    long when = ((JobImpl)job).getMadeReadyOn();
                    if (when <= 0L) {
                        this._log.error("Job was not made ready?! " + job, (Throwable)new Exception("Not made ready?!"));
                    } else {
                        enqueuedTime = now - when;
                    }
                }
                long betweenJobs = now - lastActive;
                this._currentJob = job;
                this._lastJob = null;
                if (this._log.shouldLog(10)) {
                    this._log.debug("Runner " + this._id + " running job " + job.getJobId() + ": " + job.getName());
                }
                long origStartAfter = job.getTiming().getStartAfter();
                long doStart = this._context.clock().now();
                job.getTiming().start();
                this.runCurrentJob();
                job.getTiming().end();
                long duration = job.getTiming().getActualEnd() - job.getTiming().getActualStart();
                long beforeUpdate = this._context.clock().now();
                this._context.jobQueue().updateStats(job, doStart, origStartAfter, duration);
                long diff = this._context.clock().now() - beforeUpdate;
                long lag = doStart - origStartAfter;
                if (lag < 0L) {
                    lag = 0L;
                }
                this._context.statManager().addRateData("jobQueue.jobRun", duration, duration);
                this._context.statManager().addRateData("jobQueue.jobLag", lag, 0L);
                this._context.statManager().addRateData("jobQueue.jobWait", enqueuedTime, enqueuedTime);
                if (duration > 1000L) {
                    this._context.statManager().addRateData("jobQueue.jobRunSlow", duration, duration);
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Duration of " + duration + " (lag " + (doStart - origStartAfter) + ") on job " + this._currentJob);
                    }
                }
                if (diff > 100L && this._log.shouldLog(30)) {
                    this._log.warn("Updating statistics for the job took too long [" + diff + "ms]");
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("Job duration " + duration + "ms for " + job.getName() + " with lag of " + (doStart - origStartAfter) + "ms");
                }
                lastActive = this._context.clock().now();
                this._lastJob = this._currentJob;
                this._currentJob = null;
                this._lastEnd = lastActive;
                ++jobNum;
            }
            catch (Throwable t) {
                if (!this._log.shouldLog(50)) continue;
                this._log.log(50, "WTF, error running?", t);
            }
        }
        if (this._context.router().isAlive() && this._log.shouldLog(50)) {
            this._log.log(50, "Queue runner " + this._id + " exiting");
        }
        this._context.jobQueue().removeRunner(this._id);
    }

    private void runCurrentJob() {
        block9: {
            try {
                this._lastBegin = this._context.clock().now();
                this._currentJob.runJob();
            }
            catch (OutOfMemoryError oom) {
                try {
                    if (this._log.shouldLog(50)) {
                        this._log.log(50, "Router ran out of memory, shutting down", (Throwable)oom);
                    }
                    this._log.log(50, this._currentJob.getClass().getName());
                    this._context.router().shutdown(10);
                }
                catch (Throwable t) {
                    System.err.println("***Router ran out of memory, shutting down hard");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(-1);
            }
            catch (Throwable t) {
                if (this._log.shouldLog(50)) {
                    this._log.log(50, "Error processing job [" + this._currentJob.getName() + "] on thread " + this._id + ": " + t.getMessage(), t);
                }
                if (!this._log.shouldLog(40)) break block9;
                this._log.error("The above job was enqueued by: ", (Throwable)this._currentJob.getAddedBy());
            }
        }
    }
}

