/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.TunnelBuildReplyMessage;

public class VariableTunnelBuildReplyMessage
extends TunnelBuildReplyMessage {
    public static final int MESSAGE_TYPE = 24;

    public VariableTunnelBuildReplyMessage(I2PAppContext context) {
        super(context, 0);
    }

    public VariableTunnelBuildReplyMessage(I2PAppContext context, int records) {
        super(context, records);
    }

    protected int calculateWrittenLength() {
        return 1 + super.calculateWrittenLength();
    }

    public int getType() {
        return 24;
    }

    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException, IOException {
        if (type != 24) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int r = (int)DataHelper.fromLong((byte[])data, (int)offset, (int)1);
        if (r <= 0 || r > 8) {
            throw new I2NPMessageException("Bad record count " + r);
        }
        this.RECORD_COUNT = r;
        if (dataSize != this.calculateWrittenLength()) {
            throw new I2NPMessageException("Wrong length (expects " + this.calculateWrittenLength() + ", recv " + dataSize + ")");
        }
        this._records = new ByteArray[this.RECORD_COUNT];
        super.readMessage(data, offset + 1, dataSize, 22);
    }

    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        int remaining = out.length - (curIndex + this.calculateWrittenLength());
        if (remaining < 0) {
            throw new I2NPMessageException("Not large enough (too short by " + remaining + ")");
        }
        if (this.RECORD_COUNT <= 0 || this.RECORD_COUNT > 8) {
            throw new I2NPMessageException("Bad record count " + this.RECORD_COUNT);
        }
        DataHelper.toLong((byte[])out, (int)curIndex++, (int)1, (long)this.RECORD_COUNT);
        for (int i = 0; i < this.RECORD_COUNT; ++i) {
            System.arraycopy(this._records[i].getData(), this._records[i].getOffset(), out, curIndex, 528);
            curIndex += 528;
        }
        return curIndex;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[VariableTunnelBuildReplyMessage: \n\tRecords: ").append(this.getRecordCount()).append(']');
        return buf.toString();
    }
}

