/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;

public class UnknownI2NPMessage
extends I2NPMessageImpl {
    private byte[] _data;
    private int _type;

    public UnknownI2NPMessage(I2PAppContext context, int type) {
        super(context);
        this._type = type;
    }

    public byte[] getData() {
        this.verifyUnwritten();
        return this._data;
    }

    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException, IOException {
        if (type != this._type) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        long size = DataHelper.fromLong((byte[])data, (int)curIndex, (int)4);
        curIndex += 4;
        if (size > 65536L) {
            throw new I2NPMessageException("wtf, size=" + size);
        }
        this._data = new byte[(int)size];
        System.arraycopy(data, curIndex, this._data, 0, (int)size);
    }

    protected int calculateWrittenLength() {
        if (this._data == null) {
            return 4;
        }
        return 4 + this._data.length;
    }

    protected int writeMessageBody(byte[] out, int curIndex) {
        this.verifyUnwritten();
        if (this._data == null) {
            out[curIndex++] = 0;
            out[curIndex++] = 0;
            out[curIndex++] = 0;
            out[curIndex++] = 0;
        } else {
            byte[] len = DataHelper.toLong((int)4, (long)this._data.length);
            System.arraycopy(len, 0, out, curIndex, 4);
            System.arraycopy(this._data, 0, out, curIndex += 4, this._data.length);
            curIndex += this._data.length;
        }
        return curIndex;
    }

    protected void written() {
        super.written();
        this._data = null;
    }

    public int getType() {
        return this._type;
    }

    public int hashCode() {
        return this._type + DataHelper.hashCode((byte[])this.getData());
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof UnknownI2NPMessage) {
            UnknownI2NPMessage msg = (UnknownI2NPMessage)object;
            return this._type == msg.getType() && DataHelper.eq((byte[])this.getData(), (byte[])msg.getData());
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[UnknownI2NPMessage: ");
        buf.append("\n\tType: ").append(this._type);
        buf.append("\n\tLength: ").append(this.calculateWrittenLength() - 4);
        buf.append("]");
        return buf.toString();
    }
}

