/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.util.Log;

public class TunnelGatewayMessage
extends I2NPMessageImpl {
    private Log _log;
    private TunnelId _tunnelId;
    private I2NPMessage _msg;
    private byte[] _msgData;
    private Exception _creator;
    public static final int MESSAGE_TYPE = 19;
    private static final int EXPIRATION_PERIOD = 10000;

    public TunnelGatewayMessage(I2PAppContext context) {
        super(context);
        this._log = context.logManager().getLog(TunnelGatewayMessage.class);
        this.setMessageExpiration(context.clock().now() + 10000L);
    }

    public TunnelId getTunnelId() {
        return this._tunnelId;
    }

    public void setTunnelId(TunnelId id) {
        this._tunnelId = id;
    }

    public I2NPMessage getMessage() {
        return this._msg;
    }

    public void setMessage(I2NPMessage msg) {
        if (msg == null) {
            throw new IllegalArgumentException("wtf, dont set me to null");
        }
        this._msg = msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int calculateWrittenLength() {
        TunnelGatewayMessage tunnelGatewayMessage = this;
        synchronized (tunnelGatewayMessage) {
            if (this._msgData == null) {
                this._msgData = this._msg.toByteArray();
                this._msg = null;
            }
        }
        return this._msgData.length + 4 + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        if (this._tunnelId == null || this._msg == null && this._msgData == null) {
            this._log.log(50, "failing to write out gateway message, created by: ", (Throwable)this._creator);
            throw new I2NPMessageException("Not enough data to write out (id=" + this._tunnelId + " data=" + this._msg + ")");
        }
        DataHelper.toLong((byte[])out, (int)curIndex, (int)4, (long)this._tunnelId.getTunnelId());
        curIndex += 4;
        TunnelGatewayMessage tunnelGatewayMessage = this;
        synchronized (tunnelGatewayMessage) {
            if (this._msgData == null) {
                this._msgData = this._msg.toByteArray();
                this._msg = null;
            }
        }
        DataHelper.toLong((byte[])out, (int)curIndex, (int)2, (long)this._msgData.length);
        if ((curIndex += 2) + this._msgData.length > out.length) {
            this._log.log(40, "output buffer too small idx: " + curIndex + " len: " + this._msgData.length + " outlen: " + out.length);
            throw new I2NPMessageException("Too much data to write out (id=" + this._tunnelId + " data=" + this._msg + ")");
        }
        System.arraycopy(this._msgData, 0, out, curIndex, this._msgData.length);
        return curIndex += this._msgData.length;
    }

    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException, IOException {
        I2NPMessageHandler h = new I2NPMessageHandler(this._context);
        this.readMessage(data, offset, dataSize, type, h);
    }

    public void readMessage(byte[] data, int offset, int dataSize, int type, I2NPMessageHandler handler) throws I2NPMessageException, IOException {
        if (type != 19) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        this._tunnelId = new TunnelId(DataHelper.fromLong((byte[])data, (int)curIndex, (int)4));
        curIndex += 4;
        if (this._tunnelId.getTunnelId() <= 0L) {
            throw new I2NPMessageException("Invalid tunnel Id " + this._tunnelId);
        }
        DataHelper.fromLong((byte[])data, (int)curIndex, (int)2);
        curIndex += 2;
        curIndex = handler.readMessage(data, curIndex);
        this._msg = handler.lastRead();
        if (this._msg == null) {
            throw new I2NPMessageException("wtf, message read has no payload?");
        }
    }

    public int getType() {
        return 19;
    }

    public int hashCode() {
        return DataHelper.hashCode((Object)this.getTunnelId()) + DataHelper.hashCode((Object)this._msg);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof TunnelGatewayMessage) {
            TunnelGatewayMessage msg = (TunnelGatewayMessage)object;
            return DataHelper.eq((Object)this.getTunnelId(), (Object)msg.getTunnelId()) && DataHelper.eq((byte[])this._msgData, (byte[])msg._msgData) && DataHelper.eq((Object)this.getMessage(), (Object)msg.getMessage());
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[TunnelGatewayMessage:");
        buf.append(" Tunnel ID: ").append(this.getTunnelId());
        buf.append(" Message: ").append(this._msg);
        buf.append("]");
        return buf.toString();
    }
}

