/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;

public class TunnelDataMessage
extends I2NPMessageImpl {
    private Log _log;
    private long _tunnelId;
    private TunnelId _tunnelIdObj;
    private byte[] _data;
    private ByteArray _dataBuf;
    public static final int MESSAGE_TYPE = 18;
    private static final int DATA_SIZE = 1024;
    private static final int EXPIRATION_PERIOD = 10000;
    private static final ByteCache _cache = ByteCache.getInstance((int)512, (int)1024);
    private static final boolean PIPELINED_CACHE = true;
    private boolean _hadCache;

    public TunnelDataMessage(I2PAppContext context) {
        super(context);
        this._log = context.logManager().getLog(TunnelDataMessage.class);
        this.setMessageExpiration(context.clock().now() + 10000L);
    }

    public long getTunnelId() {
        return this._tunnelId;
    }

    public void setTunnelId(long id) {
        this._tunnelId = id;
    }

    public TunnelId getTunnelIdObj() {
        if (this._tunnelIdObj == null) {
            this._tunnelIdObj = new TunnelId(this._tunnelId);
        }
        return this._tunnelIdObj;
    }

    public void setTunnelId(TunnelId id) {
        this._tunnelIdObj = id;
        this._tunnelId = id.getTunnelId();
    }

    public byte[] getData() {
        if (this._hadCache && this._dataBuf == null) {
            RuntimeException e = new RuntimeException("TDM data buf use after free");
            this._log.error("TDM boom", (Throwable)e);
            throw e;
        }
        return this._data;
    }

    public void setData(byte[] data) {
        if (data == null || data.length <= 0) {
            throw new IllegalArgumentException("Empty tunnel payload?");
        }
        this._data = data;
    }

    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException, IOException {
        if (type != 18) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        this._tunnelId = DataHelper.fromLong((byte[])data, (int)curIndex, (int)4);
        curIndex += 4;
        if (this._tunnelId <= 0L) {
            throw new I2NPMessageException("Invalid tunnel Id " + this._tunnelId);
        }
        this._dataBuf = _cache.acquire();
        this._data = this._dataBuf.getData();
        this._hadCache = true;
        System.arraycopy(data, curIndex, this._data, 0, 1024);
    }

    protected int calculateWrittenLength() {
        return 1028;
    }

    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        if (this._tunnelId <= 0L || this._data == null) {
            throw new I2NPMessageException("Not enough data to write out (id=" + this._tunnelId + " data=" + this._data + ")");
        }
        if (this._data.length <= 0) {
            throw new I2NPMessageException("Not enough data to write out (data.length=" + this._data.length + ")");
        }
        if (this._hadCache && this._dataBuf == null) {
            I2NPMessageException e = new I2NPMessageException("TDM data buf use after free");
            this._log.error("TDM boom", (Throwable)((Object)e));
            throw e;
        }
        DataHelper.toLong((byte[])out, (int)curIndex, (int)4, (long)this._tunnelId);
        System.arraycopy(this._data, 0, out, curIndex += 4, 1024);
        return curIndex += this._data.length;
    }

    public int getType() {
        return 18;
    }

    public int hashCode() {
        return (int)this._tunnelId + DataHelper.hashCode((byte[])this._data);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof TunnelDataMessage) {
            TunnelDataMessage msg = (TunnelDataMessage)object;
            return this._tunnelId == msg.getTunnelId() && DataHelper.eq((byte[])this.getData(), (byte[])msg.getData());
        }
        return false;
    }

    public byte[] toByteArray() {
        byte[] rv = super.toByteArray();
        if (rv == null) {
            throw new RuntimeException("unable to toByteArray(): " + this.toString());
        }
        return rv;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[TunnelDataMessage:");
        buf.append(" MessageId: ").append(this.getUniqueId());
        buf.append(" Tunnel ID: ").append(this.getTunnelId());
        buf.append("]");
        return buf.toString();
    }
}

