/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.util.Log;

public class I2NPMessageHandler {
    private Log _log;
    private I2PAppContext _context;
    private long _lastReadBegin;
    private long _lastReadEnd;
    private int _lastSize;
    private byte[] _messageBuffer;
    private I2NPMessage _lastRead;

    public I2NPMessageHandler(I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(I2NPMessageHandler.class);
        this._lastSize = -1;
    }

    public I2NPMessage readMessage(InputStream in) throws IOException, I2NPMessageException {
        if (this._messageBuffer == null) {
            this._messageBuffer = new byte[38912];
        }
        try {
            int type = (int)DataHelper.readLong((InputStream)in, (int)1);
            this._lastReadBegin = System.currentTimeMillis();
            I2NPMessage msg = I2NPMessageImpl.createMessage(this._context, type);
            if (msg == null) {
                throw new I2NPMessageException("The type " + type + " is an unknown I2NP message");
            }
            try {
                this._lastSize = msg.readBytes(in, type, this._messageBuffer);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (I2NPMessageException ime) {
                throw ime;
            }
            catch (Exception e) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Error reading the stream", (Throwable)e);
                }
                throw new IOException("Unknown error reading the " + msg.getClass().getName() + ": " + e.getMessage());
            }
            this._lastReadEnd = System.currentTimeMillis();
            return msg;
        }
        catch (DataFormatException dfe) {
            throw new I2NPMessageException("Error reading the message", dfe);
        }
    }

    public I2NPMessage lastRead() {
        I2NPMessage rv = this._lastRead;
        this._lastRead = null;
        return rv;
    }

    public I2NPMessage readMessage(byte[] data) throws IOException, I2NPMessageException {
        this.readMessage(data, 0);
        return this.lastRead();
    }

    public int readMessage(byte[] data, int offset) throws IOException, I2NPMessageException {
        int cur = offset;
        int type = (int)DataHelper.fromLong((byte[])data, (int)cur, (int)1);
        ++cur;
        this._lastReadBegin = System.currentTimeMillis();
        I2NPMessage msg = I2NPMessageImpl.createMessage(this._context, type);
        if (msg == null) {
            int sz = data.length - offset;
            boolean allZero = false;
            for (int i = offset; i < data.length; ++i) {
                if (data[i] == 0) continue;
                allZero = false;
                break;
            }
            throw new I2NPMessageException("The type " + type + " is an unknown I2NP message (remaining sz=" + sz + " all zeros? " + allZero + ")");
        }
        try {
            this._lastSize = msg.readBytes(data, type, cur);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (I2NPMessageException ime) {
            throw ime;
        }
        catch (Exception e) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error reading the stream", (Throwable)e);
            }
            throw new IOException("Unknown error reading the " + msg.getClass().getName() + ": " + e.getMessage());
        }
        this._lastReadEnd = System.currentTimeMillis();
        this._lastRead = msg;
        return (cur += this._lastSize) - offset;
    }

    public long getLastReadTime() {
        return this._lastReadEnd - this._lastReadBegin;
    }

    public int getLastSize() {
        return this._lastSize;
    }

    public static void main(String[] args) {
        try {
            I2NPMessage msg = new I2NPMessageHandler(I2PAppContext.getGlobalContext()).readMessage(new FileInputStream(args[0]));
            System.out.println(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

