/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.util.Log;

public class GarlicMessage
extends I2NPMessageImpl {
    private static final Log _log = new Log(GarlicMessage.class);
    public static final int MESSAGE_TYPE = 11;
    private byte[] _data;

    public GarlicMessage(I2PAppContext context) {
        super(context);
    }

    public byte[] getData() {
        this.verifyUnwritten();
        return this._data;
    }

    public void setData(byte[] data) {
        this.verifyUnwritten();
        this._data = data;
    }

    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException, IOException {
        if (type != 11) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        long len = DataHelper.fromLong((byte[])data, (int)curIndex, (int)4);
        curIndex += 4;
        if (len <= 0L || len > 65536L) {
            throw new I2NPMessageException("size=" + len);
        }
        this._data = new byte[(int)len];
        System.arraycopy(data, curIndex, this._data, 0, (int)len);
    }

    protected int calculateWrittenLength() {
        this.verifyUnwritten();
        return 4 + this._data.length;
    }

    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        this.verifyUnwritten();
        byte[] len = DataHelper.toLong((int)4, (long)this._data.length);
        System.arraycopy(len, 0, out, curIndex, 4);
        System.arraycopy(this._data, 0, out, curIndex += 4, this._data.length);
        return curIndex += this._data.length;
    }

    public int getType() {
        return 11;
    }

    public int hashCode() {
        return DataHelper.hashCode((byte[])this.getData());
    }

    protected void written() {
        super.written();
        this._data = null;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof GarlicMessage) {
            GarlicMessage msg = (GarlicMessage)object;
            return DataHelper.eq((byte[])this.getData(), (byte[])msg.getData());
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[GarlicMessage: ");
        buf.append("\n\tData length: ").append(this.getData().length).append(" bytes");
        buf.append("]");
        return buf.toString();
    }
}

