/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.TunnelId;
import net.i2p.util.Log;

public class DeliveryInstructions
extends DataStructureImpl {
    private static final Log _log = new Log(DeliveryInstructions.class);
    private boolean _encrypted;
    private SessionKey _encryptionKey;
    private int _deliveryMode;
    public static final int DELIVERY_MODE_LOCAL = 0;
    public static final int DELIVERY_MODE_DESTINATION = 1;
    public static final int DELIVERY_MODE_ROUTER = 2;
    public static final int DELIVERY_MODE_TUNNEL = 3;
    private Hash _destinationHash;
    private Hash _routerHash;
    private TunnelId _tunnelId;
    private boolean _delayRequested;
    private long _delaySeconds;
    private static final int FLAG_MODE_LOCAL = 0;
    private static final int FLAG_MODE_DESTINATION = 1;
    private static final int FLAG_MODE_ROUTER = 2;
    private static final int FLAG_MODE_TUNNEL = 3;
    private static final long FLAG_ENCRYPTED = 128L;
    private static final long FLAG_MODE = 96L;
    private static final long FLAG_DELAY = 16L;

    public DeliveryInstructions() {
        this.setDeliveryMode(-1);
    }

    public boolean getEncrypted() {
        return this._encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this._encrypted = encrypted;
    }

    public SessionKey getEncryptionKey() {
        return this._encryptionKey;
    }

    public void setEncryptionKey(SessionKey key) {
        this._encryptionKey = key;
    }

    public int getDeliveryMode() {
        return this._deliveryMode;
    }

    public void setDeliveryMode(int mode) {
        this._deliveryMode = mode;
    }

    public Hash getDestination() {
        return this._destinationHash;
    }

    public void setDestination(Hash dest) {
        this._destinationHash = dest;
    }

    public Hash getRouter() {
        return this._routerHash;
    }

    public void setRouter(Hash router) {
        this._routerHash = router;
    }

    public TunnelId getTunnelId() {
        return this._tunnelId;
    }

    public void setTunnelId(TunnelId id) {
        this._tunnelId = id;
    }

    public boolean getDelayRequested() {
        return this._delayRequested;
    }

    public void setDelayRequested(boolean req) {
        this._delayRequested = req;
    }

    public long getDelaySeconds() {
        return this._delaySeconds;
    }

    public void setDelaySeconds(long seconds) {
        this._delaySeconds = seconds;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        long flags = DataHelper.readLong((InputStream)in, (int)1);
        if (_log.shouldLog(10)) {
            _log.debug("Read flags: " + flags + " mode: " + this.flagMode(flags));
        }
        if (this.flagEncrypted(flags)) {
            SessionKey k = new SessionKey();
            k.readBytes(in);
            this.setEncryptionKey(k);
            this.setEncrypted(true);
        } else {
            this.setEncrypted(false);
        }
        this.setDeliveryMode(this.flagMode(flags));
        switch (this.flagMode(flags)) {
            case 0: {
                break;
            }
            case 1: {
                Hash destHash = new Hash();
                destHash.readBytes(in);
                this.setDestination(destHash);
                break;
            }
            case 2: {
                Hash routerHash = new Hash();
                routerHash.readBytes(in);
                this.setRouter(routerHash);
                break;
            }
            case 3: {
                Hash tunnelRouterHash = new Hash();
                tunnelRouterHash.readBytes(in);
                this.setRouter(tunnelRouterHash);
                TunnelId id = new TunnelId();
                id.readBytes(in);
                this.setTunnelId(id);
            }
        }
        if (this.flagDelay(flags)) {
            long delay = DataHelper.readLong((InputStream)in, (int)4);
            this.setDelayRequested(true);
            this.setDelaySeconds(delay);
        } else {
            this.setDelayRequested(false);
        }
    }

    public int readBytes(byte[] data, int offset) throws DataFormatException {
        int cur = offset;
        long flags = DataHelper.fromLong((byte[])data, (int)cur, (int)1);
        ++cur;
        if (_log.shouldLog(10)) {
            _log.debug("Read flags: " + flags + " mode: " + this.flagMode(flags));
        }
        if (this.flagEncrypted(flags)) {
            byte[] kd = new byte[32];
            System.arraycopy(data, cur, kd, 0, 32);
            cur += 32;
            this.setEncryptionKey(new SessionKey(kd));
            this.setEncrypted(true);
        } else {
            this.setEncrypted(false);
        }
        this.setDeliveryMode(this.flagMode(flags));
        switch (this.flagMode(flags)) {
            case 0: {
                break;
            }
            case 1: {
                byte[] destHash = new byte[32];
                System.arraycopy(data, cur, destHash, 0, 32);
                cur += 32;
                this.setDestination(new Hash(destHash));
                break;
            }
            case 2: {
                byte[] routerHash = new byte[32];
                System.arraycopy(data, cur, routerHash, 0, 32);
                cur += 32;
                this.setRouter(new Hash(routerHash));
                break;
            }
            case 3: {
                byte[] tunnelRouterHash = new byte[32];
                System.arraycopy(data, cur, tunnelRouterHash, 0, 32);
                this.setRouter(new Hash(tunnelRouterHash));
                this.setTunnelId(new TunnelId(DataHelper.fromLong((byte[])data, (int)(cur += 32), (int)4)));
                cur += 4;
            }
        }
        if (this.flagDelay(flags)) {
            long delay = DataHelper.fromLong((byte[])data, (int)cur, (int)4);
            cur += 4;
            this.setDelayRequested(true);
            this.setDelaySeconds(delay);
        } else {
            this.setDelayRequested(false);
        }
        return cur - offset;
    }

    private boolean flagEncrypted(long flags) {
        return 0L != (flags & 0x80L);
    }

    private int flagMode(long flags) {
        long v = flags & 0x60L;
        return (int)(v >>>= 5);
    }

    private boolean flagDelay(long flags) {
        return 0L != (flags & 0x10L);
    }

    private long getFlags() {
        long val = 0L;
        if (this.getEncrypted()) {
            val |= 0x80L;
        }
        long fmode = 0L;
        switch (this.getDeliveryMode()) {
            case 0: {
                break;
            }
            case 1: {
                fmode = 32L;
                break;
            }
            case 2: {
                fmode = 64L;
                break;
            }
            case 3: {
                fmode = 96L;
            }
        }
        val |= fmode;
        if (this.getDelayRequested()) {
            val |= 0x10L;
        }
        if (_log.shouldLog(10)) {
            _log.debug("getFlags() = " + val);
        }
        return val;
    }

    private int getAdditionalInfoSize() {
        int additionalSize = 0;
        if (this.getEncrypted()) {
            if (this._encryptionKey == null) {
                throw new IllegalStateException("Encryption key is not set");
            }
            additionalSize += 32;
        }
        switch (this.getDeliveryMode()) {
            case 0: {
                if (!_log.shouldLog(10)) break;
                _log.debug("mode = local");
                break;
            }
            case 1: {
                if (this._destinationHash == null) {
                    throw new IllegalStateException("Destination hash is not set");
                }
                additionalSize += 32;
                break;
            }
            case 2: {
                if (this._routerHash == null) {
                    throw new IllegalStateException("Router hash is not set");
                }
                additionalSize += 32;
                break;
            }
            case 3: {
                if (this._routerHash == null || this._tunnelId == null) {
                    throw new IllegalStateException("Router hash or tunnel ID is not set");
                }
                additionalSize += 32;
                additionalSize += 4;
            }
        }
        if (this.getDelayRequested()) {
            additionalSize += 4;
        }
        return additionalSize;
    }

    private byte[] getAdditionalInfo() {
        int additionalSize = this.getAdditionalInfoSize();
        byte[] rv = new byte[additionalSize];
        int offset = 0;
        if ((offset += this.getAdditionalInfo(rv, offset)) != additionalSize) {
            _log.log(50, "wtf, additionalSize = " + additionalSize + ", offset = " + offset);
        }
        return rv;
    }

    private int getAdditionalInfo(byte[] rv, int offset) {
        int origOffset = offset;
        if (this.getEncrypted()) {
            if (this._encryptionKey == null) {
                throw new IllegalStateException("Encryption key is not set");
            }
            System.arraycopy(this._encryptionKey.getData(), 0, rv, offset, 32);
            offset += 32;
            if (_log.shouldLog(10)) {
                _log.debug("IsEncrypted");
            }
        } else if (_log.shouldLog(10)) {
            _log.debug("Is NOT Encrypted");
        }
        switch (this.getDeliveryMode()) {
            case 0: {
                if (!_log.shouldLog(10)) break;
                _log.debug("mode = local");
                break;
            }
            case 1: {
                if (this._destinationHash == null) {
                    throw new IllegalStateException("Destination hash is not set");
                }
                System.arraycopy(this._destinationHash.getData(), 0, rv, offset, 32);
                offset += 32;
                if (!_log.shouldLog(10)) break;
                _log.debug("mode = destination, hash = " + this._destinationHash);
                break;
            }
            case 2: {
                if (this._routerHash == null) {
                    throw new IllegalStateException("Router hash is not set");
                }
                System.arraycopy(this._routerHash.getData(), 0, rv, offset, 32);
                offset += 32;
                if (!_log.shouldLog(10)) break;
                _log.debug("mode = router, routerHash = " + this._routerHash);
                break;
            }
            case 3: {
                if (this._routerHash == null || this._tunnelId == null) {
                    throw new IllegalStateException("Router hash or tunnel ID is not set");
                }
                System.arraycopy(this._routerHash.getData(), 0, rv, offset, 32);
                DataHelper.toLong((byte[])rv, (int)(offset += 32), (int)4, (long)this._tunnelId.getTunnelId());
                offset += 4;
                if (!_log.shouldLog(10)) break;
                _log.debug("mode = tunnel, tunnelId = " + this._tunnelId.getTunnelId() + ", routerHash = " + this._routerHash);
            }
        }
        if (this.getDelayRequested()) {
            if (_log.shouldLog(10)) {
                _log.debug("delay requested: " + this.getDelaySeconds());
            }
            DataHelper.toLong((byte[])rv, (int)offset, (int)4, (long)this.getDelaySeconds());
            offset += 4;
        } else if (_log.shouldLog(10)) {
            _log.debug("delay NOT requested");
        }
        return offset - origOffset;
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._deliveryMode < 0 || this._deliveryMode > 3) {
            throw new DataFormatException("Invalid data: mode = " + this._deliveryMode);
        }
        long flags = this.getFlags();
        if (_log.shouldLog(10)) {
            _log.debug("Write flags: " + flags + " mode: " + this.getDeliveryMode() + " =?= " + this.flagMode(flags));
        }
        byte[] additionalInfo = this.getAdditionalInfo();
        DataHelper.writeLong((OutputStream)out, (int)1, (long)flags);
        if (additionalInfo != null) {
            out.write(additionalInfo);
            out.flush();
        }
    }

    public int writeBytes(byte[] target, int offset) {
        if (this._deliveryMode < 0 || this._deliveryMode > 3) {
            throw new IllegalStateException("Invalid data: mode = " + this._deliveryMode);
        }
        long flags = this.getFlags();
        if (_log.shouldLog(10)) {
            _log.debug("Write flags: " + flags + " mode: " + this.getDeliveryMode() + " =?= " + this.flagMode(flags));
        }
        int origOffset = offset;
        DataHelper.toLong((byte[])target, (int)offset, (int)1, (long)flags);
        ++offset;
        offset += this.getAdditionalInfo(target, offset);
        return offset - origOffset;
    }

    public int getSize() {
        return 1 + this.getAdditionalInfoSize();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DeliveryInstructions)) {
            return false;
        }
        DeliveryInstructions instr = (DeliveryInstructions)((Object)obj);
        return this.getDelayRequested() == instr.getDelayRequested() && this.getDelaySeconds() == instr.getDelaySeconds() && this.getDeliveryMode() == instr.getDeliveryMode() && this.getEncrypted() == instr.getEncrypted() && DataHelper.eq((Object)this.getDestination(), (Object)instr.getDestination()) && DataHelper.eq((Object)this.getEncryptionKey(), (Object)instr.getEncryptionKey()) && DataHelper.eq((Object)this.getRouter(), (Object)instr.getRouter()) && DataHelper.eq((Object)this.getTunnelId(), (Object)instr.getTunnelId());
    }

    public int hashCode() {
        return (int)this.getDelaySeconds() + this.getDeliveryMode() + DataHelper.hashCode((Object)this.getDestination()) + DataHelper.hashCode((Object)this.getEncryptionKey()) + DataHelper.hashCode((Object)this.getRouter()) + DataHelper.hashCode((Object)this.getTunnelId());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[DeliveryInstructions: ");
        buf.append("\n\tDelivery mode: ");
        switch (this.getDeliveryMode()) {
            case 0: {
                buf.append("local");
                break;
            }
            case 1: {
                buf.append("destination");
                break;
            }
            case 2: {
                buf.append("router");
                break;
            }
            case 3: {
                buf.append("tunnel");
            }
        }
        buf.append("\n\tDelay requested: ").append(this.getDelayRequested());
        buf.append("\n\tDelay seconds: ").append(this.getDelaySeconds());
        buf.append("\n\tDestination: ").append(this.getDestination());
        buf.append("\n\tEncrypted: ").append(this.getEncrypted());
        buf.append("\n\tEncryption key: ").append(this.getEncryptionKey());
        buf.append("\n\tRouter: ").append(this.getRouter());
        buf.append("\n\tTunnelId: ").append(this.getTunnelId());
        return buf.toString();
    }
}

