/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;

public class DatabaseSearchReplyMessage
extends I2NPMessageImpl {
    public static final int MESSAGE_TYPE = 3;
    private Hash _key;
    private List<Hash> _peerHashes = new ArrayList<Hash>(3);
    private Hash _from;

    public DatabaseSearchReplyMessage(I2PAppContext context) {
        super(context);
    }

    public Hash getSearchKey() {
        return this._key;
    }

    public void setSearchKey(Hash key) {
        this._key = key;
    }

    public int getNumReplies() {
        return this._peerHashes.size();
    }

    public Hash getReply(int index) {
        return this._peerHashes.get(index);
    }

    public void addReply(Hash peer) {
        this._peerHashes.add(peer);
    }

    public Hash getFromHash() {
        return this._from;
    }

    public void setFromHash(Hash from) {
        this._from = from;
    }

    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException, IOException {
        if (type != 3) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        byte[] keyData = new byte[32];
        System.arraycopy(data, curIndex, keyData, 0, 32);
        this._key = new Hash(keyData);
        int num = (int)DataHelper.fromLong((byte[])data, (int)(curIndex += 32), (int)1);
        ++curIndex;
        this._peerHashes.clear();
        for (int i = 0; i < num; ++i) {
            byte[] peer = new byte[32];
            System.arraycopy(data, curIndex, peer, 0, 32);
            curIndex += 32;
            this.addReply(new Hash(peer));
        }
        byte[] from = new byte[32];
        System.arraycopy(data, curIndex, from, 0, 32);
        curIndex += 32;
        this._from = new Hash(from);
    }

    protected int calculateWrittenLength() {
        return 33 + this.getNumReplies() * 32 + 32;
    }

    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        if (this._key == null) {
            throw new I2NPMessageException("Key in reply to not specified");
        }
        if (this._peerHashes == null) {
            throw new I2NPMessageException("Peer replies are null");
        }
        if (this._from == null) {
            throw new I2NPMessageException("No 'from' address specified!");
        }
        System.arraycopy(this._key.getData(), 0, out, curIndex, 32);
        curIndex += 32;
        byte[] len = DataHelper.toLong((int)1, (long)this._peerHashes.size());
        out[curIndex++] = len[0];
        for (int i = 0; i < this.getNumReplies(); ++i) {
            System.arraycopy(this.getReply(i).getData(), 0, out, curIndex, 32);
            curIndex += 32;
        }
        System.arraycopy(this._from.getData(), 0, out, curIndex, 32);
        return curIndex += 32;
    }

    public int getType() {
        return 3;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DatabaseSearchReplyMessage) {
            DatabaseSearchReplyMessage msg = (DatabaseSearchReplyMessage)object;
            return DataHelper.eq((Object)this.getSearchKey(), (Object)msg.getSearchKey()) && DataHelper.eq((Object)this.getFromHash(), (Object)msg.getFromHash()) && DataHelper.eq(this._peerHashes, msg._peerHashes);
        }
        return false;
    }

    public int hashCode() {
        return DataHelper.hashCode((Object)this.getSearchKey()) + DataHelper.hashCode((Object)this.getFromHash()) + DataHelper.hashCode(this._peerHashes);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[DatabaseSearchReplyMessage: ");
        buf.append("\n\tSearch Key: ").append(this.getSearchKey());
        buf.append("\n\tReplies: # = ").append(this.getNumReplies());
        for (int i = 0; i < this.getNumReplies(); ++i) {
            buf.append("\n\t\tReply [").append(i).append("]: ").append(this.getReply(i));
        }
        buf.append("\n\tFrom: ").append(this.getFromHash());
        buf.append("]");
        return buf.toString();
    }
}

