/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseLookupMessage
extends I2NPMessageImpl {
    public static final int MESSAGE_TYPE = 2;
    private Hash _key;
    private Hash _fromHash;
    private TunnelId _replyTunnel;
    private Set<Hash> _dontIncludePeers;
    private static final int MAX_NUM_PEERS = 512;

    public DatabaseLookupMessage(I2PAppContext context) {
        this(context, false);
    }

    public DatabaseLookupMessage(I2PAppContext context, boolean locallyCreated) {
        super(context);
    }

    public Hash getSearchKey() {
        return this._key;
    }

    public void setSearchKey(Hash key) {
        this._key = key;
    }

    public Hash getFrom() {
        return this._fromHash;
    }

    public void setFrom(Hash from) {
        this._fromHash = from;
    }

    public TunnelId getReplyTunnel() {
        return this._replyTunnel;
    }

    public void setReplyTunnel(TunnelId replyTunnel) {
        this._replyTunnel = replyTunnel;
    }

    public Set<Hash> getDontIncludePeers() {
        return this._dontIncludePeers;
    }

    public void setDontIncludePeers(Set peers) {
        this._dontIncludePeers = peers != null ? new HashSet<Hash>(peers) : null;
    }

    @Override
    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException, IOException {
        if (type != 2) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        byte[] keyData = new byte[32];
        System.arraycopy(data, curIndex, keyData, 0, 32);
        this._key = new Hash(keyData);
        byte[] fromData = new byte[32];
        System.arraycopy(data, curIndex += 32, fromData, 0, 32);
        this._fromHash = new Hash(fromData);
        boolean tunnelSpecified = false;
        switch (data[curIndex += 32]) {
            case 1: {
                tunnelSpecified = true;
                break;
            }
            case 0: {
                tunnelSpecified = false;
                break;
            }
            default: {
                throw new I2NPMessageException("Tunnel must be explicitly specified (or not)");
            }
        }
        ++curIndex;
        if (tunnelSpecified) {
            this._replyTunnel = new TunnelId(DataHelper.fromLong((byte[])data, (int)curIndex, (int)4));
            curIndex += 4;
        }
        int numPeers = (int)DataHelper.fromLong((byte[])data, (int)curIndex, (int)2);
        curIndex += 2;
        if (numPeers < 0 || numPeers > 512) {
            throw new I2NPMessageException("Invalid number of peers - " + numPeers);
        }
        HashSet<Hash> peers = new HashSet<Hash>(numPeers);
        for (int i = 0; i < numPeers; ++i) {
            byte[] peer = new byte[32];
            System.arraycopy(data, curIndex, peer, 0, 32);
            curIndex += 32;
            peers.add(new Hash(peer));
        }
        this._dontIncludePeers = peers;
    }

    @Override
    protected int calculateWrittenLength() {
        int totalLength = 0;
        totalLength += 64;
        ++totalLength;
        if (this._replyTunnel != null) {
            totalLength += 4;
        }
        totalLength += 2;
        if (this._dontIncludePeers != null) {
            totalLength += 32 * this._dontIncludePeers.size();
        }
        return totalLength;
    }

    @Override
    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        if (this._key == null) {
            throw new I2NPMessageException("Key being searched for not specified");
        }
        if (this._fromHash == null) {
            throw new I2NPMessageException("From address not specified");
        }
        System.arraycopy(this._key.getData(), 0, out, curIndex, 32);
        System.arraycopy(this._fromHash.getData(), 0, out, curIndex += 32, 32);
        curIndex += 32;
        if (this._replyTunnel != null) {
            out[curIndex++] = 1;
            byte[] id = DataHelper.toLong((int)4, (long)this._replyTunnel.getTunnelId());
            System.arraycopy(id, 0, out, curIndex, 4);
            curIndex += 4;
        } else {
            out[curIndex++] = 0;
        }
        if (this._dontIncludePeers == null || this._dontIncludePeers.isEmpty()) {
            out[curIndex++] = 0;
            out[curIndex++] = 0;
        } else {
            int size = this._dontIncludePeers.size();
            if (size > 512) {
                throw new I2NPMessageException("Too many peers: " + size);
            }
            byte[] len = DataHelper.toLong((int)2, (long)size);
            out[curIndex++] = len[0];
            out[curIndex++] = len[1];
            for (Hash peer : this._dontIncludePeers) {
                System.arraycopy(peer.getData(), 0, out, curIndex, 32);
                curIndex += 32;
            }
        }
        return curIndex;
    }

    @Override
    public int getType() {
        return 2;
    }

    public int hashCode() {
        return DataHelper.hashCode((Object)this.getSearchKey()) + DataHelper.hashCode((Object)this.getFrom()) + DataHelper.hashCode((Object)this.getReplyTunnel()) + DataHelper.hashCode(this._dontIncludePeers);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DatabaseLookupMessage) {
            DatabaseLookupMessage msg = (DatabaseLookupMessage)object;
            return DataHelper.eq((Object)this.getSearchKey(), (Object)msg.getSearchKey()) && DataHelper.eq((Object)this.getFrom(), (Object)msg.getFrom()) && DataHelper.eq((Object)this.getReplyTunnel(), (Object)msg.getReplyTunnel()) && DataHelper.eq(this._dontIncludePeers, msg.getDontIncludePeers());
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[DatabaseLookupMessage: ");
        buf.append("\n\tSearch Key: ").append(this.getSearchKey());
        buf.append("\n\tFrom: ").append(this.getFrom());
        buf.append("\n\tReply Tunnel: ").append(this.getReplyTunnel());
        buf.append("\n\tDont Include Peers: ");
        if (this._dontIncludePeers != null) {
            buf.append(this._dontIncludePeers.size());
        }
        buf.append("]");
        return buf.toString();
    }
}

