/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;

public class BuildRequestRecord {
    private ByteArray _data;
    private static final int FLAG_UNRESTRICTED_PREV = 128;
    private static final int FLAG_OUTBOUND_ENDPOINT = 64;
    public static final int IV_SIZE = 16;
    public static final int PEER_SIZE = 16;
    private static final int OFF_RECV_TUNNEL = 0;
    private static final int OFF_OUR_IDENT = 4;
    private static final int OFF_SEND_TUNNEL = 36;
    private static final int OFF_SEND_IDENT = 40;
    private static final int OFF_LAYER_KEY = 72;
    private static final int OFF_IV_KEY = 104;
    private static final int OFF_REPLY_KEY = 136;
    private static final int OFF_REPLY_IV = 168;
    private static final int OFF_FLAG = 184;
    private static final int OFF_REQ_TIME = 185;
    private static final int OFF_SEND_MSG_ID = 189;
    private static final int PADDING_SIZE = 29;

    public BuildRequestRecord(ByteArray data) {
        this._data = data;
    }

    public BuildRequestRecord() {
    }

    public ByteArray getData() {
        return this._data;
    }

    public void setData(ByteArray data) {
        this._data = data;
    }

    public long readReceiveTunnelId() {
        return DataHelper.fromLong((byte[])this._data.getData(), (int)(this._data.getOffset() + 0), (int)4);
    }

    public boolean readOurIdentityMatches(Hash ourIdentity) {
        return DataHelper.eq((byte[])ourIdentity.getData(), (int)0, (byte[])this._data.getData(), (int)(this._data.getOffset() + 4), (int)32);
    }

    public long readNextTunnelId() {
        return DataHelper.fromLong((byte[])this._data.getData(), (int)(this._data.getOffset() + 36), (int)4);
    }

    public Hash readNextIdentity() {
        byte[] rv = new byte[32];
        System.arraycopy(this._data.getData(), this._data.getOffset() + 40, rv, 0, 32);
        return new Hash(rv);
    }

    public SessionKey readLayerKey() {
        byte[] key = new byte[32];
        System.arraycopy(this._data.getData(), this._data.getOffset() + 72, key, 0, 32);
        return new SessionKey(key);
    }

    public SessionKey readIVKey() {
        byte[] key = new byte[32];
        System.arraycopy(this._data.getData(), this._data.getOffset() + 104, key, 0, 32);
        return new SessionKey(key);
    }

    public SessionKey readReplyKey() {
        byte[] key = new byte[32];
        System.arraycopy(this._data.getData(), this._data.getOffset() + 136, key, 0, 32);
        return new SessionKey(key);
    }

    public byte[] readReplyIV() {
        byte[] iv = new byte[16];
        System.arraycopy(this._data.getData(), this._data.getOffset() + 168, iv, 0, 16);
        return iv;
    }

    public boolean readIsInboundGateway() {
        return (this._data.getData()[this._data.getOffset() + 184] & 0x80) != 0;
    }

    public boolean readIsOutboundEndpoint() {
        return (this._data.getData()[this._data.getOffset() + 184] & 0x40) != 0;
    }

    public long readRequestTime() {
        return DataHelper.fromLong((byte[])this._data.getData(), (int)(this._data.getOffset() + 185), (int)4) * 60L * 60L * 1000L;
    }

    public long readReplyMessageId() {
        return DataHelper.fromLong((byte[])this._data.getData(), (int)(this._data.getOffset() + 189), (int)4);
    }

    public void encryptRecord(I2PAppContext ctx, PublicKey toKey, Hash toPeer, byte[] out, int outOffset) {
        System.arraycopy(toPeer.getData(), 0, out, outOffset, 16);
        byte[] preEncr = new byte[222];
        System.arraycopy(this._data.getData(), this._data.getOffset(), preEncr, 0, preEncr.length);
        byte[] encrypted = ctx.elGamalEngine().encrypt(preEncr, toKey);
        System.arraycopy(encrypted, 1, out, outOffset + 16, 256);
        System.arraycopy(encrypted, 258, out, outOffset + 256 + 16, 256);
    }

    public boolean decryptRecord(I2PAppContext ctx, PrivateKey ourKey, Hash ourIdent, ByteArray encryptedRecord) {
        if (DataHelper.eq((byte[])ourIdent.getData(), (int)0, (byte[])encryptedRecord.getData(), (int)encryptedRecord.getOffset(), (int)16)) {
            byte[] preDecrypt = new byte[514];
            System.arraycopy(encryptedRecord.getData(), encryptedRecord.getOffset() + 16, preDecrypt, 1, 256);
            System.arraycopy(encryptedRecord.getData(), encryptedRecord.getOffset() + 16 + 256, preDecrypt, 258, 256);
            byte[] decrypted = ctx.elGamalEngine().decrypt(preDecrypt, ourKey);
            if (decrypted != null) {
                this._data = new ByteArray(decrypted);
                this._data.setOffset(0);
                return true;
            }
            return false;
        }
        return false;
    }

    public void createRecord(I2PAppContext ctx, long receiveTunnelId, Hash peer, long nextTunnelId, Hash nextHop, long nextMsgId, SessionKey layerKey, SessionKey ivKey, SessionKey replyKey, byte[] iv, boolean isInGateway, boolean isOutEndpoint) {
        if (this._data == null || this._data.getData() != null) {
            this._data = new ByteArray();
        }
        byte[] buf = new byte[222];
        this._data.setData(buf);
        DataHelper.toLong((byte[])buf, (int)0, (int)4, (long)receiveTunnelId);
        System.arraycopy(peer.getData(), 0, buf, 4, 32);
        DataHelper.toLong((byte[])buf, (int)36, (int)4, (long)nextTunnelId);
        System.arraycopy(nextHop.getData(), 0, buf, 40, 32);
        System.arraycopy(layerKey.getData(), 0, buf, 72, 32);
        System.arraycopy(ivKey.getData(), 0, buf, 104, 32);
        System.arraycopy(replyKey.getData(), 0, buf, 136, 32);
        System.arraycopy(iv, 0, buf, 168, 16);
        if (isInGateway) {
            buf[184] = (byte)(buf[184] | 0x80);
        } else if (isOutEndpoint) {
            buf[184] = (byte)(buf[184] | 0x40);
        }
        long truncatedHour = ctx.clock().now();
        DataHelper.toLong((byte[])buf, (int)185, (int)4, (long)(truncatedHour /= 3600000L));
        DataHelper.toLong((byte[])buf, (int)189, (int)4, (long)nextMsgId);
        byte[] rnd = new byte[29];
        ctx.random().nextBytes(rnd);
        System.arraycopy(rnd, 0, buf, 193, rnd.length);
        byte[] wroteIV = this.readReplyIV();
        if (!DataHelper.eq((byte[])iv, (byte[])wroteIV)) {
            throw new RuntimeException("foo");
        }
    }
}

