/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.tool.wrappers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.neodatis.tool.wrappers.OdbDateFormat;

public class OdbString {
    public static OdbDateFormat format = new OdbDateFormat("dd/MM/yyyy HH:mm:ss:SSS");

    public static String[] split(String source, String separators) {
        return source.split(separators);
    }

    public static String replaceToken(String source, String tokenToReplace, String newToken) {
        return OdbString.replaceToken(source, tokenToReplace, newToken, -1);
    }

    public static String replaceToken(String source, String tokenToReplace, String newToken, int numberOfTimes) {
        int index = 0;
        boolean hasToken = true;
        StringBuffer result = new StringBuffer(source);
        String tmp = result.toString();
        int oldTokenLength = tokenToReplace.length();
        int times = 0;
        if (numberOfTimes == -1 && newToken.indexOf(tokenToReplace) != -1) {
            throw new RuntimeException("Can not replace by this new token because it contains token to be replaced");
        }
        while (hasToken) {
            boolean bl = hasToken = (index = tmp.indexOf(tokenToReplace, index)) != -1;
            if (hasToken) {
                if (numberOfTimes != -1) {
                    if (times >= numberOfTimes) break;
                    ++times;
                }
                result.replace(index, index + oldTokenLength, newToken);
                tmp = result.toString();
            }
            index = 0;
        }
        return result.toString();
    }

    public static String exceptionToString(Throwable e, boolean escape) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String s = sw.getBuffer().toString();
        if (escape) {
            s = s.replaceAll("\\$", "-");
        }
        return s;
    }

    public static String substring(String s, int beginIndex) {
        return OdbString.substring(s, beginIndex, s.length());
    }

    public static String substring(String s, int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > s.length()) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException(endIndex - beginIndex);
        }
        if (beginIndex == 0 && endIndex == s.length()) {
            return s;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = beginIndex; i < endIndex; ++i) {
            buffer.append(s.charAt(i));
        }
        return buffer.toString();
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean matches(String regExp, String value) {
        return value.matches(regExp);
    }

    public static String dateToString(Date dateTime) {
        if (dateTime == null) {
            return "null";
        }
        return format.format(dateTime);
    }
}

